/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BuildToolId;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import java.util.Objects;
import java.util.Optional;

public class BuildTool {
    private final BuildToolId id;
    private PackageOrg org;
    private PackageName name;
    private PackageVersion version;
    private final String repository;
    private final TomlNodeLocation location;

    private BuildTool(BuildToolId id, PackageOrg org, PackageName name, PackageVersion version, TomlNodeLocation location, String repository) {
        this.id = id;
        this.org = org;
        this.name = name;
        this.version = version;
        this.location = location;
        this.repository = repository;
    }

    public static BuildTool from(BuildToolId id, PackageOrg org, PackageName name, PackageVersion version, TomlNodeLocation location) {
        return new BuildTool(id, org, name, version, location, null);
    }

    public static BuildTool from(BuildToolId id, PackageOrg org, PackageName name, PackageVersion version, TomlNodeLocation location, String repository) {
        return new BuildTool(id, org, name, version, location, repository);
    }

    public BuildToolId id() {
        return this.id;
    }

    public PackageVersion version() {
        return this.version;
    }

    public PackageName name() {
        return this.name;
    }

    public PackageOrg org() {
        return this.org;
    }

    public TomlNodeLocation location() {
        return this.location;
    }

    public Optional<String> repository() {
        return Optional.ofNullable(this.repository);
    }

    public void setVersion(PackageVersion version) {
        this.version = version;
    }

    public void setName(PackageName name) {
        this.name = name;
    }

    public void setOrg(PackageOrg org) {
        this.org = org;
    }

    public String toString() {
        return this.id.toString() + (String)(this.version != null ? ":" + String.valueOf(this.version) : "");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BuildTool that = (BuildTool)other;
        return this.id.equals(that.id) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(Objects.hashCode(this.id), Objects.hashCode(this.org), Objects.hashCode(this.name), Objects.hashCode(this.version));
    }
}

