/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BuildTool;
import io.ballerina.projects.BuildToolId;
import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.DependencyManifest;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.buildtools.ToolContext;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.environment.ToolResolutionRequest;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.util.BalToolsUtil;
import io.ballerina.projects.util.BuildToolsUtil;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.model.ToolResolutionCentralRequest;
import org.ballerinalang.central.client.model.ToolResolutionCentralResponse;
import org.wso2.ballerinalang.util.RepoUtils;

public class BuildToolResolution {
    private final PackageContext packageContext;
    private final List<BuildTool> resolvedTools = new ArrayList<BuildTool>();
    private final List<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();
    private final boolean offline;

    private BuildToolResolution(PackageContext packageContext, boolean offline) {
        this.packageContext = packageContext;
        this.offline = offline;
        this.resolveToolDependencies();
    }

    static BuildToolResolution from(PackageContext packageContext) {
        return new BuildToolResolution(packageContext, packageContext.project().buildOptions().offlineBuild());
    }

    static BuildToolResolution from(PackageContext packageContext, CompilationOptions compilationOptions) {
        return new BuildToolResolution(packageContext, compilationOptions.offlineBuild());
    }

    public List<Diagnostic> getDiagnosticList() {
        return this.diagnosticList;
    }

    public List<BuildTool> getResolvedTools() {
        return this.resolvedTools;
    }

    private void resolveToolDependencies() {
        Project currentProject = this.packageContext.project();
        Map<PackageManifest.Tool.Field, ToolContext> toolContextMap = currentProject.getToolContextMap();
        if (toolContextMap == null || toolContextMap.isEmpty()) {
            return;
        }
        ArrayList<BuildTool> buildTools = new ArrayList<BuildTool>();
        HashSet<String> toolIds = new HashSet<String>();
        for (ToolContext toolContext : toolContextMap.values()) {
            BuildToolId toolId = BuildToolId.from(toolContext.type().split("\\.")[0]);
            TomlNodeLocation location = BuildToolsUtil.getFirstToolEntryLocation(toolId.value(), this.packageContext.packageManifest().tools());
            if (!toolIds.add(toolId.value())) continue;
            buildTools.add(BuildTool.from(toolId, null, null, null, location));
        }
        PackageLockingMode packageLockingMode = this.getPackageLockingMode(currentProject);
        this.updateLockedToolDependencyVersions(buildTools, currentProject);
        List<BuildTool> resolvedTools = this.resolveToolVersions(packageLockingMode, buildTools);
        this.resolvedTools.addAll(resolvedTools);
    }

    private List<BuildTool> resolveToolVersions(PackageLockingMode packageLockingMode, List<BuildTool> unresolvedTools) {
        List<BuildTool> toolResolutionResponse;
        List<BuildTool> toolResolutionResponseOffline = this.getToolResolutionResponseOffline(unresolvedTools, packageLockingMode);
        if (this.offline) {
            this.reportDiagnosticsForUnresolvedTools(unresolvedTools, toolResolutionResponseOffline);
            return toolResolutionResponseOffline;
        }
        Set<ToolResolutionRequest> resolutionRequests = this.getToolResolutionRequests(unresolvedTools, packageLockingMode);
        ToolResolutionCentralRequest toolResolutionRequest = this.createToolResolutionRequests(resolutionRequests);
        try {
            toolResolutionResponse = this.getToolResolutionResponse(toolResolutionRequest);
        }
        catch (CentralClientException e) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.CENTRAL_CONNECTION_ERROR.diagnosticId(), "connection to central failed. Continuing the tool resolution offline, reason: '" + e.getMessage() + "'", DiagnosticSeverity.WARNING);
            PackageDiagnostic diagnostic = new PackageDiagnostic(diagnosticInfo, this.packageContext.descriptor().name().toString());
            this.diagnosticList.add(diagnostic);
            return toolResolutionResponseOffline;
        }
        ArrayList<BuildTool> resolvedTools = new ArrayList<BuildTool>(Stream.of(toolResolutionResponseOffline, toolResolutionResponse).flatMap(Collection::stream).collect(Collectors.toMap(BuildTool::id, Function.identity(), (tool1, tool2) -> {
            SemanticVersion.VersionCompatibilityResult versionCompatibilityResult = tool1.version().compareTo(tool2.version());
            if (versionCompatibilityResult.equals((Object)SemanticVersion.VersionCompatibilityResult.EQUAL)) {
                return tool1;
            }
            return tool2;
        })).values());
        this.reportDiagnosticsForUnresolvedTools(unresolvedTools, resolvedTools);
        return resolvedTools;
    }

    private void reportDiagnosticsForUnresolvedTools(List<BuildTool> unresolvedTools, List<BuildTool> toolResolutionResponseOffline) {
        unresolvedTools.stream().filter(tool -> toolResolutionResponseOffline.stream().noneMatch(resolvedTool -> resolvedTool.id().equals(tool.id()))).forEach(tool -> {
            Object toolIdWithVersion = tool.id().toString();
            if (tool.version() != null && !tool.version().toString().isEmpty()) {
                toolIdWithVersion = (String)toolIdWithVersion + ":" + tool.version().toString();
            }
            TomlNodeLocation location = BuildToolsUtil.getFirstToolEntryLocation(tool.id().toString(), this.packageContext.packageManifest().tools());
            TomlDiagnostic diagnostic = BuildToolsUtil.getCannotResolveBuildToolDiagnostic((String)toolIdWithVersion, location);
            this.diagnosticList.add((Diagnostic)diagnostic);
        });
    }

    private PackageLockingMode getPackageLockingMode(Project project) {
        boolean sticky = ProjectUtils.getSticky(project);
        if (project.currentPackage().dependenciesToml().isEmpty()) {
            if (sticky) {
                return PackageLockingMode.MEDIUM;
            }
            return PackageLockingMode.SOFT;
        }
        if (sticky) {
            return PackageLockingMode.HARD;
        }
        SemanticVersion prevDistributionVersion = project.currentPackage().dependencyManifest().distributionVersion();
        SemanticVersion currentDistributionVersion = SemanticVersion.from(RepoUtils.getBallerinaShortVersion());
        if (prevDistributionVersion == null || currentDistributionVersion.greaterThan(prevDistributionVersion)) {
            return PackageLockingMode.SOFT;
        }
        return PackageLockingMode.MEDIUM;
    }

    private List<BuildTool> getToolResolutionResponseOffline(List<BuildTool> unresolvedTools, PackageLockingMode packageLockingMode) {
        ArrayList<BuildTool> resolvedTools = new ArrayList<BuildTool>();
        for (BuildTool tool : unresolvedTools) {
            PackageVersion version;
            Optional<BalToolsManifest.Tool> latestCompatibleVersion = BuildToolsUtil.getCompatibleToolVersionsAvailableLocally(tool, version = tool.version(), packageLockingMode);
            if (latestCompatibleVersion.isEmpty()) continue;
            BalToolsManifest.Tool latestTool = latestCompatibleVersion.get();
            resolvedTools.add(BuildTool.from(tool.id(), PackageOrg.from(latestTool.org()), PackageName.from(latestTool.name()), PackageVersion.from(latestTool.version()), tool.location(), latestTool.repository()));
        }
        return resolvedTools;
    }

    private Set<ToolResolutionRequest> getToolResolutionRequests(List<BuildTool> unresolvedTools, PackageLockingMode packageLockingMode) {
        HashSet<ToolResolutionRequest> resolutionRequests = new HashSet<ToolResolutionRequest>();
        for (BuildTool tool : unresolvedTools) {
            resolutionRequests.add(ToolResolutionRequest.from(tool, packageLockingMode));
        }
        return resolutionRequests;
    }

    private ToolResolutionCentralRequest createToolResolutionRequests(Set<ToolResolutionRequest> resolutionRequests) {
        ToolResolutionCentralRequest toolResolutionRequest = new ToolResolutionCentralRequest();
        for (ToolResolutionRequest resolutionRequest : resolutionRequests) {
            ToolResolutionCentralRequest.Mode mode = switch (resolutionRequest.packageLockingMode()) {
                default -> throw new MatchException(null, null);
                case PackageLockingMode.HARD, PackageLockingMode.LOCKED -> ToolResolutionCentralRequest.Mode.HARD;
                case PackageLockingMode.MEDIUM -> ToolResolutionCentralRequest.Mode.MEDIUM;
                case PackageLockingMode.SOFT -> ToolResolutionCentralRequest.Mode.SOFT;
            };
            String version = resolutionRequest.version().map(v -> v.value().toString()).orElse("");
            toolResolutionRequest.addTool(resolutionRequest.id().toString(), version, mode);
        }
        return toolResolutionRequest;
    }

    private List<BuildTool> getToolResolutionResponse(ToolResolutionCentralRequest toolResolutionRequest) throws CentralClientException {
        ToolResolutionCentralResponse packageResolutionResponse = BalToolsUtil.getLatestVersionsInCentral(toolResolutionRequest);
        List resolved = packageResolutionResponse.resolved();
        ArrayList<BuildTool> resolvedTools = new ArrayList<BuildTool>();
        for (ToolResolutionCentralResponse.ResolvedTool tool : resolved) {
            String toolId = tool.id();
            String version = tool.version();
            TomlNodeLocation location = BuildToolsUtil.getFirstToolEntryLocation(toolId, this.packageContext.packageManifest().tools());
            if (version == null || tool.name() == null || tool.org() == null) {
                TomlDiagnostic diagnostic = BuildToolsUtil.getCannotResolveBuildToolDiagnostic(toolId, location);
                this.diagnosticList.add((Diagnostic)diagnostic);
                continue;
            }
            try {
                PackageVersion.from(version);
            }
            catch (ProjectException ignore) {
                TomlDiagnostic diagnostic = BuildToolsUtil.getCannotResolveBuildToolDiagnostic(toolId, location);
                this.diagnosticList.add((Diagnostic)diagnostic);
                continue;
            }
            try {
                BalToolsUtil.pullToolPackageFromRemote(toolId, version);
            }
            catch (CentralClientException e) {
                String message = "failed to pull build tool '" + toolId + ":" + version + "' from Ballerina Central: " + e.getMessage();
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND.diagnosticId(), ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND.messageKey(), DiagnosticSeverity.WARNING);
                TomlDiagnostic diagnostic = new TomlDiagnostic(location, diagnosticInfo, message);
                this.diagnosticList.add((Diagnostic)diagnostic);
            }
            BuildTool buildTool = BuildTool.from(BuildToolId.from(toolId), PackageOrg.from(tool.org()), PackageName.from(tool.name()), PackageVersion.from(version), location);
            resolvedTools.add(buildTool);
            BuildToolsUtil.addToolToBalToolsToml(buildTool);
        }
        return resolvedTools;
    }

    private void updateLockedToolDependencyVersions(List<BuildTool> unresolvedTools, Project project) {
        DependencyManifest dependencyManifest = project.currentPackage().dependencyManifest();
        if (dependencyManifest == null || dependencyManifest.tools() == null) {
            return;
        }
        block0: for (BuildTool tool : unresolvedTools) {
            for (DependencyManifest.Tool toolDependency : dependencyManifest.tools()) {
                if (!toolDependency.id().equals(tool.id())) continue;
                tool.setOrg(toolDependency.org());
                tool.setName(toolDependency.name());
                tool.setVersion(toolDependency.version());
                continue block0;
            }
        }
    }
}

