/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.CodeGeneratorResult;
import io.ballerina.projects.CompilerPluginContextIml;
import io.ballerina.projects.CompilerPluginInfo;
import io.ballerina.projects.CompilerPluginKind;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageProvidedCompilerPluginInfo;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ResourceConfig;
import io.ballerina.projects.SyntaxNodeAnalysisTask;
import io.ballerina.projects.SyntaxNodeAnalysisTaskRunner;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CodeGenerator;
import io.ballerina.projects.plugins.CodeGeneratorContext;
import io.ballerina.projects.plugins.GeneratorTask;
import io.ballerina.projects.plugins.SourceGeneratorContext;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class CodeGeneratorManager {
    private final Package currentPackage;
    private final PackageCompilation compilation;
    private final CodeGeneratorTasks codeGeneratorTasks;

    private CodeGeneratorManager(PackageCompilation compilation, CodeGeneratorTasks codeGeneratorTasks) {
        this.currentPackage = compilation.packageContext().project().currentPackage();
        this.compilation = compilation;
        this.codeGeneratorTasks = codeGeneratorTasks;
    }

    static CodeGeneratorManager from(PackageCompilation compilation, List<CompilerPluginContextIml> compilerPluginContexts) {
        CodeGeneratorTasks codeGeneratorTasks = CodeGeneratorManager.initCodeGenerators(compilerPluginContexts);
        return new CodeGeneratorManager(compilation, codeGeneratorTasks);
    }

    CodeGeneratorResult runCodeGenerators(Package currentPackage) {
        CodeGenTaskResult codeGenTaskResult = this.getCodeGenTaskResult();
        if (codeGenTaskResult.containsSourceFile() || codeGenTaskResult.containsTestSourceFile() || codeGenTaskResult.containsResourceFile() || codeGenTaskResult.containsTestResourceFile()) {
            Package packageWithGenSources = new PackageModifier().modifyPackage(currentPackage, codeGenTaskResult);
            return new CodeGeneratorResult(packageWithGenSources, codeGenTaskResult.reportedDiagnostics());
        }
        return new CodeGeneratorResult(null, codeGenTaskResult.reportedDiagnostics());
    }

    private static CodeGeneratorTasks initCodeGenerators(List<CompilerPluginContextIml> compilerPluginContexts) {
        CodeGeneratorTasks codeGeneratorTasks = new CodeGeneratorTasks();
        for (CompilerPluginContextIml compilerPluginContext : compilerPluginContexts) {
            for (CodeGeneratorInfo codeGeneratorInfo : compilerPluginContext.codeGenerators()) {
                CodeGeneratorContextImpl codeGeneratorContext = new CodeGeneratorContextImpl(codeGeneratorInfo, codeGeneratorTasks);
                codeGeneratorInfo.codeGenerator().init(codeGeneratorContext);
            }
        }
        return codeGeneratorTasks;
    }

    private CodeGenTaskResult getCodeGenTaskResult() {
        List<Diagnostic> reportedDiagnostics = this.runSyntaxNodeAnalysisTasks();
        CodeGeneratorTaskResultBuilder resultBuilder = new CodeGeneratorTaskResultBuilder();
        resultBuilder.addDiagnostics(reportedDiagnostics);
        this.runSourceGeneratorTasks(resultBuilder);
        return resultBuilder.build();
    }

    private void runSourceGeneratorTasks(CodeGeneratorTaskResultBuilder resultBuilder) {
        for (Map.Entry<CodeGeneratorInfo, List<SourceGeneratorTask>> codeGeneratorListEntry : this.codeGeneratorTasks.sourceGenTaskMap.entrySet()) {
            this.runSourceGeneratorTask(codeGeneratorListEntry.getValue(), resultBuilder);
        }
    }

    private void runSourceGeneratorTask(List<SourceGeneratorTask> sourceGeneratorTasks, CodeGeneratorTaskResultBuilder resultBuilder) {
        for (SourceGeneratorTask sourceGeneratorTask : sourceGeneratorTasks) {
            SourceGeneratorContextImpl sourceGenContext = new SourceGeneratorContextImpl(this.currentPackage, this.compilation);
            sourceGeneratorTask.perform(sourceGenContext);
            resultBuilder.addDiagnostics(sourceGenContext.reportedDiagnostics());
            resultBuilder.addSourceFiles(sourceGenContext.generatedSourceFiles());
            resultBuilder.addTestSourceFiles(sourceGenContext.generatedTestSourceFiles());
            resultBuilder.addResourceFiles(sourceGenContext.generatedResourceFiles());
            resultBuilder.addTestResourceFiles(sourceGenContext.generatedTestResourceFiles());
        }
    }

    private List<Diagnostic> runSyntaxNodeAnalysisTasks() {
        ArrayList<Diagnostic> reportedDiagnostics = new ArrayList<Diagnostic>();
        Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap = this.populateSyntaxNodeTaskMap();
        if (syntaxNodeAnalysisTaskMap.isEmpty()) {
            return reportedDiagnostics;
        }
        SyntaxNodeAnalysisTaskRunner taskRunner = new SyntaxNodeAnalysisTaskRunner(syntaxNodeAnalysisTaskMap, this.currentPackage, this.compilation);
        reportedDiagnostics.addAll(taskRunner.runTasks());
        return reportedDiagnostics;
    }

    private Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> populateSyntaxNodeTaskMap() {
        HashMap<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap = new HashMap<SyntaxKind, List<SyntaxNodeAnalysisTask>>();
        for (List<SyntaxNodeAnalysisTask> syntaxNodeAnalysisTasks : this.codeGeneratorTasks.syntaxNodeAnalysisTaskMap.values()) {
            this.populateSyntaxNodeTaskMap(syntaxNodeAnalysisTaskMap, syntaxNodeAnalysisTasks);
        }
        return syntaxNodeAnalysisTaskMap;
    }

    private void populateSyntaxNodeTaskMap(Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap, List<SyntaxNodeAnalysisTask> syntaxNodeAnalysisTasks) {
        for (SyntaxNodeAnalysisTask syntaxNodeTask : syntaxNodeAnalysisTasks) {
            this.populateSyntaxNodeTaskMap(syntaxNodeAnalysisTaskMap, syntaxNodeTask);
        }
    }

    private void populateSyntaxNodeTaskMap(Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap, SyntaxNodeAnalysisTask syntaxNodeAnalysisTask) {
        for (SyntaxKind syntaxKind : syntaxNodeAnalysisTask.syntaxKinds()) {
            List syntaxNodeAnalysisTasks = syntaxNodeAnalysisTaskMap.computeIfAbsent(syntaxKind, syntaxKind1 -> new ArrayList());
            syntaxNodeAnalysisTasks.add(syntaxNodeAnalysisTask);
        }
    }

    private static class CodeGeneratorTasks {
        private final Map<CodeGeneratorInfo, List<SourceGeneratorTask>> sourceGenTaskMap = new HashMap<CodeGeneratorInfo, List<SourceGeneratorTask>>();
        private final Map<CodeGeneratorInfo, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap = new HashMap<CodeGeneratorInfo, List<SyntaxNodeAnalysisTask>>();

        private CodeGeneratorTasks() {
        }

        void addSourceGeneratorTask(CodeGeneratorInfo codeGeneratorInfo, SourceGeneratorTask generatorTask) {
            this.addTask(codeGeneratorInfo, this.sourceGenTaskMap, generatorTask);
        }

        void addSyntaxNodeAnalysisTask(CodeGeneratorInfo codeGeneratorInfo, SyntaxNodeAnalysisTask analysisTask) {
            this.addTask(codeGeneratorInfo, this.syntaxNodeAnalysisTaskMap, analysisTask);
        }

        <T> void addTask(CodeGeneratorInfo codeGeneratorInfo, Map<CodeGeneratorInfo, List<T>> map, T task) {
            List tasks = map.computeIfAbsent(codeGeneratorInfo, key -> new ArrayList());
            tasks.add(task);
        }
    }

    private static class CodeGenTaskResult {
        private final List<Diagnostic> reportedDiagnostics;
        private final Map<ModuleId, List<GeneratedSourceFile>> sourceFilesMap;
        private final Map<ModuleId, List<GeneratedTestFile>> testSourceFilesMap;
        private final Map<ModuleId, List<GeneratedResourceFile>> resourceFilesMap;
        private final Map<ModuleId, List<GeneratedTestResourceFile>> testResourceFilesMap;

        public CodeGenTaskResult(List<Diagnostic> reportedDiagnostics, Map<ModuleId, List<GeneratedSourceFile>> sourceFilesMap, Map<ModuleId, List<GeneratedTestFile>> testSourceFilesMap, Map<ModuleId, List<GeneratedResourceFile>> resourceFilesMap, Map<ModuleId, List<GeneratedTestResourceFile>> testResourceFilesMap) {
            this.reportedDiagnostics = reportedDiagnostics;
            this.sourceFilesMap = sourceFilesMap;
            this.testSourceFilesMap = testSourceFilesMap;
            this.resourceFilesMap = resourceFilesMap;
            this.testResourceFilesMap = testResourceFilesMap;
        }

        Collection<Diagnostic> reportedDiagnostics() {
            return this.reportedDiagnostics;
        }

        Collection<GeneratedSourceFile> sourceFiles(ModuleId moduleId) {
            if (this.sourceFilesMap.get(moduleId) == null) {
                return Collections.emptyList();
            }
            return this.sourceFilesMap.get(moduleId);
        }

        Collection<GeneratedTestFile> testSourceFiles(ModuleId moduleId) {
            if (this.testSourceFilesMap.get(moduleId) == null) {
                return Collections.emptyList();
            }
            return this.testSourceFilesMap.get(moduleId);
        }

        Collection<GeneratedResourceFile> resourceFiles(ModuleId moduleId) {
            if (this.resourceFilesMap.get(moduleId) == null) {
                return Collections.emptyList();
            }
            return this.resourceFilesMap.get(moduleId);
        }

        Collection<GeneratedTestResourceFile> testResourceFiles(ModuleId moduleId) {
            if (this.testResourceFilesMap.get(moduleId) == null) {
                return Collections.emptyList();
            }
            return this.testResourceFilesMap.get(moduleId);
        }

        boolean containsSourceFile() {
            return !this.sourceFilesMap.isEmpty();
        }

        boolean containsTestSourceFile() {
            return !this.testSourceFilesMap.isEmpty();
        }

        boolean containsResourceFile() {
            return !this.resourceFilesMap.isEmpty();
        }

        boolean containsTestResourceFile() {
            return !this.testResourceFilesMap.isEmpty();
        }
    }

    private static class PackageModifier {
        private int filenameCounter = 0;

        private PackageModifier() {
        }

        Package modifyPackage(Package currentPackage, CodeGenTaskResult codeGenTaskResult) {
            Collection<ModuleId> moduleIds = currentPackage.moduleIds();
            Package newPackage = currentPackage;
            for (ModuleId moduleId : moduleIds) {
                newPackage = this.modifyModule(moduleId, newPackage, codeGenTaskResult);
            }
            return newPackage;
        }

        private Package modifyModule(ModuleId moduleId, Package pkg, CodeGenTaskResult codeGenTaskResult) {
            String uniqueFilename;
            Module module = pkg.module(moduleId);
            List<String> docNames = this.getDocNamesInModule(module);
            Module.Modifier modifier = module.modify();
            for (GeneratedSourceFile sourceFile : codeGenTaskResult.sourceFiles(moduleId)) {
                uniqueFilename = this.getUniqueFilename(sourceFile, docNames);
                docNames.add(uniqueFilename);
                this.addGeneratedDocument(uniqueFilename, sourceFile.textDocument, modifier, moduleId);
            }
            for (GeneratedTestFile testSourceFile : codeGenTaskResult.testSourceFiles(moduleId)) {
                uniqueFilename = this.getUniqueFilename(testSourceFile, docNames);
                docNames.add(uniqueFilename);
                this.addGeneratedTestDocument(uniqueFilename, testSourceFile.textDocument, modifier, moduleId);
            }
            for (GeneratedResourceFile resourceFile : codeGenTaskResult.resourceFiles(moduleId)) {
                docNames.add(resourceFile.filename());
                this.addGeneratedResource(resourceFile.filename(), resourceFile.content, modifier, moduleId);
            }
            for (GeneratedTestResourceFile testResourceFile : codeGenTaskResult.testResourceFiles(moduleId)) {
                docNames.add(testResourceFile.filename());
                this.addGeneratedTestResource(testResourceFile.filename(), testResourceFile.content, modifier, moduleId);
            }
            return modifier.apply().packageInstance();
        }

        @Deprecated(since="2201.10.0", forRemoval=true)
        private void addGeneratedResource(String newResourceFilename, byte[] content, Module.Modifier modifier, ModuleId moduleId) {
            DocumentId documentId = DocumentId.create(newResourceFilename, moduleId);
            ResourceConfig resourceConfig = ResourceConfig.from(documentId, newResourceFilename, content);
            modifier.addResource(resourceConfig);
        }

        @Deprecated(since="2201.10.0", forRemoval=true)
        private void addGeneratedTestResource(String newTestResourceFilename, byte[] content, Module.Modifier modifier, ModuleId moduleId) {
            DocumentId documentId = DocumentId.create(newTestResourceFilename, moduleId);
            ResourceConfig resourceConfig = ResourceConfig.from(documentId, newTestResourceFilename, content);
            modifier.addTestResource(resourceConfig);
        }

        private void addGeneratedDocument(String newDocFilename, TextDocument textDocument, Module.Modifier modifier, ModuleId moduleId) {
            DocumentId documentId = DocumentId.create(newDocFilename, moduleId);
            DocumentConfig documentConfig = DocumentConfig.from(documentId, textDocument::toString, newDocFilename);
            modifier.addDocument(documentConfig);
        }

        private void addGeneratedTestDocument(String newDocFilename, TextDocument textDocument, Module.Modifier modifier, ModuleId moduleId) {
            DocumentId documentId = DocumentId.create(newDocFilename, moduleId);
            DocumentConfig documentConfig = DocumentConfig.from(documentId, textDocument::toString, newDocFilename);
            modifier.addTestDocument(documentConfig);
        }

        private String getUniqueFilename(GeneratedSourceFile sourceFile, List<String> docNames) {
            GeneratedFilename genFileName = new GeneratedFilename(sourceFile.filenamePrefix(), this.getNextFilenameCounter());
            while (!this.uniqueFileName(genFileName.toString(), docNames)) {
                genFileName.updateUniqueCounter(this.getNextFilenameCounter());
            }
            return genFileName.toString();
        }

        private String getUniqueFilename(GeneratedTestFile testSourceFile, List<String> docNames) {
            GeneratedFilename genFileName = new GeneratedFilename(testSourceFile.filenamePrefix(), this.getNextFilenameCounter());
            while (!this.uniqueFileName(genFileName.toString(), docNames)) {
                genFileName.updateUniqueCounter(this.getNextFilenameCounter());
            }
            return genFileName.toString();
        }

        private List<String> getDocNamesInModule(Module module) {
            ArrayList<String> docNames = new ArrayList<String>();
            for (DocumentId documentId : module.documentIds()) {
                docNames.add(module.document(documentId).name());
            }
            return docNames;
        }

        private int getNextFilenameCounter() {
            return ++this.filenameCounter;
        }

        private boolean uniqueFileName(String filename, List<String> existingFilenames) {
            return !existingFilenames.contains(filename);
        }
    }

    static class CodeGeneratorInfo {
        private final CodeGenerator codeGenerator;
        private final CompilerPluginInfo compilerPluginInfo;

        CodeGeneratorInfo(CodeGenerator codeGenerator, CompilerPluginInfo compilerPluginInfo) {
            this.codeGenerator = codeGenerator;
            this.compilerPluginInfo = compilerPluginInfo;
        }

        CodeGenerator codeGenerator() {
            return this.codeGenerator;
        }

        CompilerPluginInfo compilerPluginInfo() {
            return this.compilerPluginInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CodeGeneratorInfo that = (CodeGeneratorInfo)o;
            return Objects.equals(this.codeGenerator, that.codeGenerator) && Objects.equals(this.compilerPluginInfo, that.compilerPluginInfo);
        }

        public int hashCode() {
            return Objects.hash(this.codeGenerator, this.compilerPluginInfo);
        }
    }

    private static class CodeGeneratorContextImpl
    implements CodeGeneratorContext {
        private final CodeGeneratorTasks codeGeneratorTasks;
        private final CodeGeneratorInfo codeGeneratorInfo;

        CodeGeneratorContextImpl(CodeGeneratorInfo codeGeneratorInfo, CodeGeneratorTasks codeGeneratorTasks) {
            this.codeGeneratorInfo = codeGeneratorInfo;
            this.codeGeneratorTasks = codeGeneratorTasks;
        }

        @Override
        public void addSourceGeneratorTask(GeneratorTask<SourceGeneratorContext> generatorTask) {
            this.codeGeneratorTasks.addSourceGeneratorTask(this.codeGeneratorInfo, new SourceGeneratorTask(generatorTask, this.codeGeneratorInfo.compilerPluginInfo));
        }

        @Override
        public void addSyntaxNodeAnalysisTask(AnalysisTask<SyntaxNodeAnalysisContext> analysisTask, SyntaxKind syntaxKind) {
            this.addSyntaxNodeAnalysisTask(analysisTask, Collections.singletonList(syntaxKind));
        }

        @Override
        public void addSyntaxNodeAnalysisTask(AnalysisTask<SyntaxNodeAnalysisContext> analysisTask, Collection<SyntaxKind> syntaxKinds) {
            this.codeGeneratorTasks.addSyntaxNodeAnalysisTask(this.codeGeneratorInfo, new SyntaxNodeAnalysisTask(analysisTask, syntaxKinds, this.codeGeneratorInfo.compilerPluginInfo));
        }
    }

    private static class CodeGeneratorTaskResultBuilder {
        private final List<Diagnostic> reportedDiagnostics = new ArrayList<Diagnostic>();
        private final List<GeneratedSourceFile> generatedSourceFiles = new ArrayList<GeneratedSourceFile>();
        private final List<GeneratedTestFile> generatedTestSourceFiles = new ArrayList<GeneratedTestFile>();
        private final List<GeneratedResourceFile> generatedResourceFiles = new ArrayList<GeneratedResourceFile>();
        private final List<GeneratedTestResourceFile> generatedTestResourceFiles = new ArrayList<GeneratedTestResourceFile>();

        CodeGeneratorTaskResultBuilder() {
        }

        CodeGeneratorTaskResultBuilder addDiagnostics(Collection<Diagnostic> diagnostics) {
            this.reportedDiagnostics.addAll(diagnostics);
            return this;
        }

        CodeGeneratorTaskResultBuilder addSourceFiles(Collection<GeneratedSourceFile> sourceFiles) {
            this.generatedSourceFiles.addAll(sourceFiles);
            return this;
        }

        CodeGeneratorTaskResultBuilder addTestSourceFiles(Collection<GeneratedTestFile> testSourceFiles) {
            this.generatedTestSourceFiles.addAll(testSourceFiles);
            return this;
        }

        @Deprecated(since="2201.10.0", forRemoval=true)
        CodeGeneratorTaskResultBuilder addResourceFiles(Collection<GeneratedResourceFile> resourceFiles) {
            this.generatedResourceFiles.addAll(resourceFiles);
            return this;
        }

        @Deprecated(since="2201.10.0", forRemoval=true)
        CodeGeneratorTaskResultBuilder addTestResourceFiles(Collection<GeneratedTestResourceFile> testResourceFiles) {
            this.generatedTestResourceFiles.addAll(testResourceFiles);
            return this;
        }

        CodeGenTaskResult build() {
            HashMap<ModuleId, List<GeneratedSourceFile>> sourceFilesMap = new HashMap<ModuleId, List<GeneratedSourceFile>>();
            for (GeneratedSourceFile generatedSourceFile : this.generatedSourceFiles) {
                sourceFilesMap.computeIfAbsent(generatedSourceFile.moduleId(), key -> new ArrayList()).add(generatedSourceFile);
            }
            HashMap<ModuleId, List<GeneratedTestFile>> testSourceFilesMap = new HashMap<ModuleId, List<GeneratedTestFile>>();
            for (GeneratedTestFile generatedTestFile : this.generatedTestSourceFiles) {
                testSourceFilesMap.computeIfAbsent(generatedTestFile.moduleId(), key -> new ArrayList()).add(generatedTestFile);
            }
            HashMap<ModuleId, List<GeneratedResourceFile>> hashMap = new HashMap<ModuleId, List<GeneratedResourceFile>>();
            for (GeneratedResourceFile resourceFile : this.generatedResourceFiles) {
                hashMap.computeIfAbsent(resourceFile.moduleId(), key -> new ArrayList()).add(resourceFile);
            }
            HashMap<ModuleId, List<GeneratedTestResourceFile>> hashMap2 = new HashMap<ModuleId, List<GeneratedTestResourceFile>>();
            for (GeneratedTestResourceFile testResourceFile : this.generatedTestResourceFiles) {
                hashMap2.computeIfAbsent(testResourceFile.moduleId(), key -> new ArrayList()).add(testResourceFile);
            }
            return new CodeGenTaskResult(this.reportedDiagnostics, sourceFilesMap, testSourceFilesMap, hashMap, hashMap2);
        }
    }

    private static class SourceGeneratorTask {
        private final GeneratorTask<SourceGeneratorContext> generatorTask;
        private final CompilerPluginInfo compilerPluginInfo;

        SourceGeneratorTask(GeneratorTask<SourceGeneratorContext> generatorTask, CompilerPluginInfo compilerPluginInfo) {
            this.generatorTask = generatorTask;
            this.compilerPluginInfo = compilerPluginInfo;
        }

        void perform(SourceGeneratorContext sourceGeneratorContext) {
            try {
                this.generatorTask.generate(sourceGeneratorContext);
            }
            catch (Throwable e) {
                String message;
                if (this.compilerPluginInfo.kind().equals((Object)CompilerPluginKind.PACKAGE_PROVIDED)) {
                    PackageProvidedCompilerPluginInfo pkgProvidedCompilerPluginInfo = (PackageProvidedCompilerPluginInfo)this.compilerPluginInfo;
                    PackageDescriptor pkgDesc = pkgProvidedCompilerPluginInfo.packageDesc();
                    message = "The compiler extension in package '" + String.valueOf(pkgDesc.org()) + ":" + String.valueOf(pkgDesc.name()) + ":" + String.valueOf(pkgDesc.version()) + "' failed to complete. ";
                } else {
                    message = "The compiler extension '" + this.compilerPluginInfo.compilerPlugin().getClass().getName() + "' failed to complete. ";
                }
                throw new ProjectException(message + e.getMessage(), e);
            }
        }
    }

    private static class SourceGeneratorContextImpl
    implements SourceGeneratorContext {
        private final Package currentPackage;
        private final PackageCompilation compilation;
        private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        private final List<GeneratedSourceFile> sourceFiles = new ArrayList<GeneratedSourceFile>();
        private final List<GeneratedTestFile> testSourceFiles = new ArrayList<GeneratedTestFile>();
        private final List<GeneratedResourceFile> resourceFiles = new ArrayList<GeneratedResourceFile>();
        private final List<GeneratedTestResourceFile> testResourceFiles = new ArrayList<GeneratedTestResourceFile>();
        private final ModuleId defaultModuleId;

        public SourceGeneratorContextImpl(Package currentPackage, PackageCompilation compilation) {
            this.currentPackage = currentPackage;
            this.compilation = compilation;
            this.defaultModuleId = currentPackage.getDefaultModule().moduleId();
        }

        @Override
        public Package currentPackage() {
            return this.currentPackage;
        }

        @Override
        public PackageCompilation compilation() {
            return this.compilation;
        }

        @Override
        public void addSourceFile(TextDocument textDocument, String filenamePrefix, ModuleId moduleId) {
            if (this.currentPackage.project().kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT)) {
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.UNSUPPORTED_COMPILER_PLUGIN_TYPE.diagnosticId(), "Skipped adding the generated source file with prefix \"" + filenamePrefix + "\". Source file generation is not supported with standalone bal files", DiagnosticSeverity.WARNING);
                this.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)new NullLocation(), (Object[])new Object[0]));
                return;
            }
            if (!this.currentPackage.moduleIds().contains(moduleId)) {
                throw new IllegalArgumentException("There is no such module in the current package with the given identifier: " + String.valueOf(moduleId));
            }
            this.sourceFiles.add(new GeneratedSourceFile(textDocument, filenamePrefix, moduleId));
        }

        @Override
        public void addSourceFile(TextDocument textDocument, String filenamePrefix) {
            this.addSourceFile(textDocument, filenamePrefix, this.defaultModuleId);
        }

        @Override
        public void addTestSourceFile(TextDocument textDocument, String filenamePrefix, ModuleId moduleId) {
            if (this.currentPackage.project().kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT)) {
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.UNSUPPORTED_COMPILER_PLUGIN_TYPE.diagnosticId(), "Skipped adding the generated test source file with prefix \"" + (String)filenamePrefix + "\". Test source file generation is not supported with standalone bal files", DiagnosticSeverity.WARNING);
                this.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)new NullLocation(), (Object[])new Object[0]));
                return;
            }
            if (!((String)filenamePrefix).startsWith("tests/")) {
                filenamePrefix = "tests/" + (String)filenamePrefix;
            }
            if (!this.currentPackage.moduleIds().contains(moduleId)) {
                throw new IllegalArgumentException("There is no such module in the current package with the given identifier: " + String.valueOf(moduleId));
            }
            this.testSourceFiles.add(new GeneratedTestFile(textDocument, (String)filenamePrefix, moduleId));
        }

        @Override
        public void addTestSourceFile(TextDocument textDocument, String filenamePrefix) {
            this.addTestSourceFile(textDocument, filenamePrefix, this.defaultModuleId);
        }

        @Override
        @Deprecated(since="2201.10.0", forRemoval=true)
        public void addResourceFile(byte[] content, String fileName, ModuleId moduleId) {
            if (!this.currentPackage.moduleIds().contains(moduleId)) {
                throw new IllegalArgumentException("There is no such module in the current package with the given identifier: " + String.valueOf(moduleId));
            }
            this.resourceFiles.add(new GeneratedResourceFile(content, fileName, moduleId));
        }

        @Override
        @Deprecated(since="2201.10.0", forRemoval=true)
        public void addResourceFile(byte[] content, String fileName) {
            this.addResourceFile(content, fileName, this.defaultModuleId);
        }

        @Override
        @Deprecated(since="2201.10.0", forRemoval=true)
        public void addTestResourceFile(byte[] content, String fileName, ModuleId moduleId) {
            if (!this.currentPackage.moduleIds().contains(moduleId)) {
                throw new IllegalArgumentException("There is no such module in the current package with the given identifier: " + String.valueOf(moduleId));
            }
            this.testResourceFiles.add(new GeneratedTestResourceFile(content, fileName, moduleId));
        }

        @Override
        @Deprecated(since="2201.10.0", forRemoval=true)
        public void addTestResourceFile(byte[] content, String fileName) {
            this.addTestResourceFile(content, fileName, this.defaultModuleId);
        }

        @Override
        public void reportDiagnostic(Diagnostic diagnostic) {
            this.diagnostics.add(diagnostic);
        }

        Collection<Diagnostic> reportedDiagnostics() {
            return this.diagnostics;
        }

        Collection<GeneratedSourceFile> generatedSourceFiles() {
            return this.sourceFiles;
        }

        Collection<GeneratedTestFile> generatedTestSourceFiles() {
            return this.testSourceFiles;
        }

        Collection<GeneratedResourceFile> generatedResourceFiles() {
            return this.resourceFiles;
        }

        Collection<GeneratedTestResourceFile> generatedTestResourceFiles() {
            return this.testResourceFiles;
        }
    }

    private static class GeneratedFilename {
        private static final String GENERATED_INDICATOR = "generated";
        private static final String EXTENSION = ".bal";
        private final String prefix;
        private int uniqueCounter;

        GeneratedFilename(String prefix, int uniqueCounter) {
            String filenamePrefix = prefix;
            if (filenamePrefix == null || filenamePrefix.isEmpty()) {
                filenamePrefix = "0";
            }
            if (filenamePrefix.endsWith(EXTENSION)) {
                filenamePrefix = filenamePrefix.substring(0, filenamePrefix.length() - 4);
            }
            this.prefix = filenamePrefix;
            this.uniqueCounter = uniqueCounter;
        }

        void updateUniqueCounter(int value) {
            this.uniqueCounter = value;
        }

        public String toString() {
            return this.prefix + "-generated_" + this.uniqueCounter + EXTENSION;
        }
    }

    private static class GeneratedTestResourceFile {
        private final byte[] content;
        private final String filename;
        private final ModuleId moduleId;

        public GeneratedTestResourceFile(byte[] content, String filename, ModuleId moduleId) {
            this.content = content;
            this.filename = filename;
            this.moduleId = moduleId;
        }

        public byte[] content() {
            return this.content;
        }

        public String filename() {
            return this.filename;
        }

        public ModuleId moduleId() {
            return this.moduleId;
        }
    }

    private static class GeneratedResourceFile {
        private final byte[] content;
        private final String filename;
        private final ModuleId moduleId;

        public GeneratedResourceFile(byte[] content, String filename, ModuleId moduleId) {
            this.content = content;
            this.filename = filename;
            this.moduleId = moduleId;
        }

        public byte[] content() {
            return this.content;
        }

        public String filename() {
            return this.filename;
        }

        public ModuleId moduleId() {
            return this.moduleId;
        }
    }

    private static class GeneratedTestFile {
        private final TextDocument textDocument;
        private final String filenamePrefix;
        private final ModuleId moduleId;

        public GeneratedTestFile(TextDocument textDocument, String filenamePrefix, ModuleId moduleId) {
            this.textDocument = textDocument;
            this.filenamePrefix = filenamePrefix;
            this.moduleId = moduleId;
        }

        public TextDocument textDocument() {
            return this.textDocument;
        }

        public String filenamePrefix() {
            return this.filenamePrefix;
        }

        public ModuleId moduleId() {
            return this.moduleId;
        }
    }

    private static class GeneratedSourceFile {
        private final TextDocument textDocument;
        private final String filenamePrefix;
        private final ModuleId moduleId;

        public GeneratedSourceFile(TextDocument textDocument, String filenamePrefix, ModuleId moduleId) {
            this.textDocument = textDocument;
            this.filenamePrefix = filenamePrefix;
            this.moduleId = moduleId;
        }

        public TextDocument textDocument() {
            return this.textDocument;
        }

        public String filenamePrefix() {
            return this.filenamePrefix;
        }

        public ModuleId moduleId() {
            return this.moduleId;
        }
    }

    private static class NullLocation
    implements Location {
        private NullLocation() {
        }

        public LineRange lineRange() {
            LinePosition from = LinePosition.from((int)0, (int)0);
            return LineRange.from((String)"", (LinePosition)from, (LinePosition)from);
        }

        public TextRange textRange() {
            return TextRange.from((int)0, (int)0);
        }
    }
}

