/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.environment.PackageLockingMode;

public class CompilationOptions {
    Boolean offlineBuild;
    Boolean experimental;
    Boolean observabilityIncluded;
    Boolean dumpBir;
    Boolean dumpBirFile;
    String cloud;
    Boolean listConflictedClasses;
    Boolean sticky;
    Boolean dumpGraph;
    Boolean dumpRawGraphs;
    Boolean withCodeGenerators;
    Boolean withCodeModifiers;
    Boolean configSchemaGen;
    Boolean exportOpenAPI;
    Boolean exportComponentModel;
    Boolean disableSyntaxTree;
    Boolean remoteManagement;
    Boolean optimizeDependencyCompilation;
    PackageLockingMode lockingMode;

    CompilationOptions(Boolean offlineBuild, Boolean experimental, Boolean observabilityIncluded, Boolean dumpBir, Boolean dumpBirFile, String cloud, Boolean listConflictedClasses, Boolean sticky, Boolean dumpGraph, Boolean dumpRawGraphs, Boolean withCodeGenerators, Boolean withCodeModifiers, Boolean configSchemaGen, Boolean exportOpenAPI, Boolean exportComponentModel, Boolean disableSyntaxTree, Boolean remoteManagement, Boolean optimizeDependencyCompilation, PackageLockingMode lockingMode) {
        this.offlineBuild = offlineBuild;
        this.experimental = experimental;
        this.observabilityIncluded = observabilityIncluded;
        this.dumpBir = dumpBir;
        this.dumpBirFile = dumpBirFile;
        this.cloud = cloud;
        this.listConflictedClasses = listConflictedClasses;
        this.sticky = sticky;
        this.dumpGraph = dumpGraph;
        this.dumpRawGraphs = dumpRawGraphs;
        this.withCodeGenerators = withCodeGenerators;
        this.withCodeModifiers = withCodeModifiers;
        this.configSchemaGen = configSchemaGen;
        this.exportOpenAPI = exportOpenAPI;
        this.exportComponentModel = exportComponentModel;
        this.disableSyntaxTree = disableSyntaxTree;
        this.remoteManagement = remoteManagement;
        this.optimizeDependencyCompilation = optimizeDependencyCompilation;
        this.lockingMode = lockingMode;
    }

    public boolean offlineBuild() {
        return this.toBooleanDefaultIfNull(this.offlineBuild);
    }

    boolean sticky() {
        return this.toBooleanDefaultIfNull(this.sticky);
    }

    boolean experimental() {
        return this.toBooleanDefaultIfNull(this.experimental);
    }

    boolean observabilityIncluded() {
        return this.toBooleanDefaultIfNull(this.observabilityIncluded);
    }

    public Boolean dumpBir() {
        return this.toBooleanDefaultIfNull(this.dumpBir);
    }

    public Boolean dumpBirFile() {
        return this.toBooleanDefaultIfNull(this.dumpBirFile);
    }

    public Boolean dumpGraph() {
        return this.toBooleanDefaultIfNull(this.dumpGraph);
    }

    public Boolean dumpRawGraphs() {
        return this.toBooleanDefaultIfNull(this.dumpRawGraphs);
    }

    public String getCloud() {
        return this.toStringDefaultIfNull(this.cloud);
    }

    public boolean listConflictedClasses() {
        return this.toBooleanDefaultIfNull(this.listConflictedClasses);
    }

    public boolean withCodeGenerators() {
        return this.toBooleanDefaultIfNull(this.withCodeGenerators);
    }

    public boolean withCodeModifiers() {
        return this.toBooleanDefaultIfNull(this.withCodeModifiers);
    }

    public Boolean configSchemaGen() {
        return this.toBooleanDefaultIfNull(this.configSchemaGen);
    }

    public boolean exportOpenAPI() {
        return this.toBooleanDefaultIfNull(this.exportOpenAPI);
    }

    public boolean exportComponentModel() {
        return this.toBooleanDefaultIfNull(this.exportComponentModel);
    }

    boolean remoteManagement() {
        return this.toBooleanDefaultIfNull(this.remoteManagement);
    }

    boolean optimizeDependencyCompilation() {
        return this.toBooleanDefaultIfNull(this.optimizeDependencyCompilation);
    }

    PackageLockingMode lockingMode() {
        return this.lockingMode;
    }

    CompilationOptions acceptTheirs(CompilationOptions theirOptions) {
        CompilationOptionsBuilder compilationOptionsBuilder = new CompilationOptionsBuilder();
        if (theirOptions.offlineBuild != null) {
            compilationOptionsBuilder.setOffline(theirOptions.offlineBuild);
        } else {
            compilationOptionsBuilder.setOffline(this.offlineBuild);
        }
        if (theirOptions.experimental != null) {
            compilationOptionsBuilder.setExperimental(theirOptions.experimental);
        } else {
            compilationOptionsBuilder.setExperimental(this.experimental);
        }
        if (theirOptions.observabilityIncluded != null) {
            compilationOptionsBuilder.setObservabilityIncluded(theirOptions.observabilityIncluded);
        } else {
            compilationOptionsBuilder.setObservabilityIncluded(this.observabilityIncluded);
        }
        if (theirOptions.dumpBir != null) {
            compilationOptionsBuilder.setDumpBir(theirOptions.dumpBir);
        } else {
            compilationOptionsBuilder.setDumpBir(this.dumpBir);
        }
        if (theirOptions.dumpBirFile != null) {
            compilationOptionsBuilder.setDumpBirFile(theirOptions.dumpBirFile);
        } else {
            compilationOptionsBuilder.setDumpBirFile(this.dumpBirFile);
        }
        if (theirOptions.dumpGraph != null) {
            compilationOptionsBuilder.setDumpGraph(theirOptions.dumpGraph);
        } else {
            compilationOptionsBuilder.setDumpGraph(this.dumpGraph);
        }
        if (theirOptions.dumpRawGraphs != null) {
            compilationOptionsBuilder.setDumpRawGraphs(theirOptions.dumpRawGraphs);
        } else {
            compilationOptionsBuilder.setDumpRawGraphs(this.dumpRawGraphs);
        }
        if (theirOptions.cloud != null) {
            compilationOptionsBuilder.setCloud(theirOptions.cloud);
        } else {
            compilationOptionsBuilder.setCloud(this.cloud);
        }
        if (theirOptions.listConflictedClasses != null) {
            compilationOptionsBuilder.setListConflictedClasses(theirOptions.listConflictedClasses);
        } else {
            compilationOptionsBuilder.setListConflictedClasses(this.listConflictedClasses);
        }
        if (theirOptions.sticky != null) {
            compilationOptionsBuilder.setSticky(theirOptions.sticky);
        } else {
            compilationOptionsBuilder.setSticky(this.sticky);
        }
        if (theirOptions.withCodeGenerators != null) {
            compilationOptionsBuilder.withCodeGenerators(theirOptions.withCodeGenerators);
        } else {
            compilationOptionsBuilder.withCodeGenerators(this.withCodeGenerators);
        }
        if (theirOptions.withCodeModifiers != null) {
            compilationOptionsBuilder.withCodeModifiers(theirOptions.withCodeModifiers);
        } else {
            compilationOptionsBuilder.withCodeModifiers(this.withCodeModifiers);
        }
        if (theirOptions.configSchemaGen != null) {
            compilationOptionsBuilder.setConfigSchemaGen(theirOptions.configSchemaGen);
        } else {
            compilationOptionsBuilder.setConfigSchemaGen(this.configSchemaGen);
        }
        if (theirOptions.exportOpenAPI != null) {
            compilationOptionsBuilder.setExportOpenAPI(theirOptions.exportOpenAPI);
        } else {
            compilationOptionsBuilder.setExportOpenAPI(this.exportOpenAPI);
        }
        if (theirOptions.exportComponentModel != null) {
            compilationOptionsBuilder.setExportComponentModel(theirOptions.exportComponentModel);
        } else {
            compilationOptionsBuilder.setExportComponentModel(this.exportComponentModel);
        }
        if (theirOptions.remoteManagement != null) {
            compilationOptionsBuilder.setRemoteManagement(theirOptions.remoteManagement);
        } else {
            compilationOptionsBuilder.setRemoteManagement(this.remoteManagement);
        }
        if (theirOptions.optimizeDependencyCompilation != null) {
            compilationOptionsBuilder.setOptimizeDependencyCompilation(theirOptions.optimizeDependencyCompilation);
        } else {
            compilationOptionsBuilder.setOptimizeDependencyCompilation(this.optimizeDependencyCompilation);
        }
        if (theirOptions.lockingMode != null) {
            compilationOptionsBuilder.setLockingMode(theirOptions.lockingMode);
        } else if (compilationOptionsBuilder.sticky != null && compilationOptionsBuilder.sticky.booleanValue()) {
            compilationOptionsBuilder.setLockingMode(PackageLockingMode.HARD);
        } else {
            compilationOptionsBuilder.setLockingMode(this.lockingMode);
        }
        return compilationOptionsBuilder.build();
    }

    public static CompilationOptionsBuilder builder() {
        return new CompilationOptionsBuilder();
    }

    private boolean toBooleanDefaultIfNull(Boolean bool) {
        if (bool == null) {
            return false;
        }
        return bool;
    }

    private String toStringDefaultIfNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public boolean disableSyntaxTree() {
        return this.toBooleanDefaultIfNull(this.disableSyntaxTree);
    }

    public static class CompilationOptionsBuilder {
        private Boolean offline;
        private Boolean experimental;
        private Boolean observabilityIncluded;
        private Boolean dumpBir;
        private Boolean dumpBirFile;
        private String cloud;
        private Boolean listConflictedClasses;
        private Boolean sticky;
        private Boolean dumpGraph;
        private Boolean dumpRawGraph;
        private Boolean withCodeGenerators;
        private Boolean withCodeModifiers;
        private Boolean configSchemaGen;
        private Boolean exportOpenAPI;
        private Boolean exportComponentModel;
        private Boolean disableSyntaxTree;
        private Boolean remoteManagement;
        private Boolean optimizeDependencyCompilation;
        private PackageLockingMode lockingMode;

        public CompilationOptionsBuilder setOffline(Boolean value) {
            this.offline = value;
            return this;
        }

        public CompilationOptionsBuilder setSticky(Boolean value) {
            this.sticky = value;
            return this;
        }

        CompilationOptionsBuilder setExperimental(Boolean value) {
            this.experimental = value;
            return this;
        }

        CompilationOptionsBuilder setObservabilityIncluded(Boolean value) {
            this.observabilityIncluded = value;
            return this;
        }

        CompilationOptionsBuilder disableSyntaxTree(Boolean value) {
            this.disableSyntaxTree = value;
            return this;
        }

        CompilationOptionsBuilder setDumpBir(Boolean value) {
            this.dumpBir = value;
            return this;
        }

        CompilationOptionsBuilder setCloud(String value) {
            this.cloud = value;
            return this;
        }

        CompilationOptionsBuilder setDumpBirFile(Boolean value) {
            this.dumpBirFile = value;
            return this;
        }

        CompilationOptionsBuilder setDumpGraph(Boolean value) {
            this.dumpGraph = value;
            return this;
        }

        CompilationOptionsBuilder setDumpRawGraphs(Boolean value) {
            this.dumpRawGraph = value;
            return this;
        }

        public CompilationOptionsBuilder setConfigSchemaGen(Boolean value) {
            this.configSchemaGen = value;
            return this;
        }

        CompilationOptionsBuilder setListConflictedClasses(Boolean value) {
            this.listConflictedClasses = value;
            return this;
        }

        CompilationOptionsBuilder withCodeGenerators(Boolean value) {
            this.withCodeGenerators = value;
            return this;
        }

        CompilationOptionsBuilder withCodeModifiers(Boolean value) {
            this.withCodeModifiers = value;
            return this;
        }

        CompilationOptionsBuilder setExportOpenAPI(Boolean value) {
            this.exportOpenAPI = value;
            return this;
        }

        CompilationOptionsBuilder setExportComponentModel(Boolean value) {
            this.exportComponentModel = value;
            return this;
        }

        public CompilationOptionsBuilder setRemoteManagement(Boolean value) {
            this.remoteManagement = value;
            return this;
        }

        public CompilationOptionsBuilder setOptimizeDependencyCompilation(Boolean value) {
            this.optimizeDependencyCompilation = value;
            return this;
        }

        public CompilationOptionsBuilder setLockingMode(PackageLockingMode value) {
            this.lockingMode = value;
            return this;
        }

        public CompilationOptions build() {
            return new CompilationOptions(this.offline, this.experimental, this.observabilityIncluded, this.dumpBir, this.dumpBirFile, this.cloud, this.listConflictedClasses, this.sticky, this.dumpGraph, this.dumpRawGraph, this.withCodeGenerators, this.withCodeModifiers, this.configSchemaGen, this.exportOpenAPI, this.exportComponentModel, this.disableSyntaxTree, this.remoteManagement, this.optimizeDependencyCompilation, this.lockingMode);
        }
    }
}

