/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.CompilerPluginContextIml;
import io.ballerina.projects.CompilerPluginInfo;
import io.ballerina.projects.CompilerPluginKind;
import io.ballerina.projects.CompletionResult;
import io.ballerina.projects.PackageProvidedCompilerPluginInfo;
import io.ballerina.projects.plugins.completion.CompletionContext;
import io.ballerina.projects.plugins.completion.CompletionException;
import io.ballerina.projects.plugins.completion.CompletionProvider;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CompletionManager {
    Map<Class<?>, List<CompletionProviderDescriptor>> completionProviders = new HashMap();

    private CompletionManager(List<CompilerPluginContextIml> compilerPluginContexts) {
        compilerPluginContexts.forEach(compilerPluginContextIml -> {
            for (CompletionProvider<Node> completionProvider : compilerPluginContextIml.completionProviders()) {
                for (Class<? extends Node> attachmentPoint : completionProvider.getSupportedNodes()) {
                    List completionProviderList = this.completionProviders.computeIfAbsent(attachmentPoint, k -> new ArrayList());
                    completionProviderList.add(new CompletionProviderDescriptor(completionProvider, compilerPluginContextIml.compilerPluginInfo()));
                }
            }
        });
    }

    public static CompletionManager from(List<CompilerPluginContextIml> compilerPluginContexts) {
        return new CompletionManager(compilerPluginContexts);
    }

    public CompletionResult completions(CompletionContext context) {
        Node referenceNode;
        CompletionResult result = new CompletionResult();
        List<Object> completionProviderDescriptors = new ArrayList();
        ArrayList<Node> resolverChain = new ArrayList<Node>();
        for (referenceNode = context.nodeAtCursor(); referenceNode != null && ((completionProviderDescriptors = this.completionProviders.getOrDefault(referenceNode.getClass(), Collections.emptyList())).isEmpty() || resolverChain.contains(referenceNode)); referenceNode = referenceNode.parent()) {
            resolverChain.add(referenceNode);
        }
        if (referenceNode == null || !this.isInServiceBodyNodeContext(context, referenceNode)) {
            return result;
        }
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)referenceNode;
        List<ModuleSymbol> moduleSymbols = this.getModulesOfActiveListeners(context, serviceDeclarationNode);
        completionProviderDescriptors.stream().filter(descriptor -> {
            if (descriptor.compilerPluginInfo.kind() == CompilerPluginKind.PACKAGE_PROVIDED) {
                PackageProvidedCompilerPluginInfo compilerPluginInfo = (PackageProvidedCompilerPluginInfo)descriptor.compilerPluginInfo();
                return moduleSymbols.stream().anyMatch(moduleSymbol -> moduleSymbol.id().orgName().equals(compilerPluginInfo.packageDesc().org().value()) && moduleSymbol.id().packageName().equals(compilerPluginInfo.packageDesc().name().value()));
            }
            return moduleSymbols.stream().anyMatch(moduleSymbol -> moduleSymbol.id().orgName().equals(context.currentDocument().module().descriptor().org().value()) && moduleSymbol.id().packageName().equals(context.currentDocument().module().descriptor().packageName().value()));
        }).forEach(descriptor -> {
            try {
                result.addCompletionItems(descriptor.completionProvider().getCompletions(context, (Node)serviceDeclarationNode));
            }
            catch (Throwable t) {
                Object name;
                if (descriptor.compilerPluginInfo.kind() == CompilerPluginKind.PACKAGE_PROVIDED) {
                    PackageProvidedCompilerPluginInfo compilerPluginInfo = (PackageProvidedCompilerPluginInfo)descriptor.compilerPluginInfo();
                    name = compilerPluginInfo.packageDesc().org().value() + "/" + compilerPluginInfo.packageDesc().name().value() + ":" + String.valueOf(compilerPluginInfo.packageDesc().version().value()) + ":" + descriptor.completionProvider().name();
                } else {
                    name = descriptor.completionProvider().name();
                }
                CompletionException ex = new CompletionException(t, (String)name);
                result.addError(ex);
            }
        });
        return result;
    }

    private List<ModuleSymbol> getModulesOfActiveListeners(CompletionContext context, ServiceDeclarationNode node) {
        Optional<Symbol> serviceSymbol = context.currentSemanticModel().symbol((Node)node);
        Optional<LinePosition> linePosition = context.cursorPosition();
        if (serviceSymbol.isEmpty() && linePosition.isEmpty()) {
            return Collections.emptyList();
        }
        List<TypeSymbol> listenerTypes = ((ServiceDeclarationSymbol)serviceSymbol.get()).listenerTypes();
        return listenerTypes.stream().map(listenerType -> {
            if (listenerType.typeKind() == TypeDescKind.UNION) {
                return ((UnionTypeSymbol)listenerType).memberTypeDescriptors().stream().filter(memberType -> this.getRawType((TypeSymbol)memberType).typeKind() == TypeDescKind.OBJECT).findAny();
            }
            return Optional.of(listenerType);
        }).filter(listenerType -> listenerType.isPresent() && ((TypeSymbol)listenerType.get()).getModule().isPresent()).map(listenerType -> ((TypeSymbol)listenerType.get()).getModule().get()).toList();
    }

    private TypeSymbol getRawType(TypeSymbol typeDescriptor) {
        if (typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)typeDescriptor;
            return typeRef.typeDescriptor();
        }
        return typeDescriptor;
    }

    private boolean isInServiceBodyNodeContext(CompletionContext context, Node referenceNode) {
        Optional<LinePosition> cursorPosition = context.cursorPosition();
        if (referenceNode.kind() != SyntaxKind.SERVICE_DECLARATION || cursorPosition.isEmpty()) {
            return false;
        }
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)referenceNode;
        LinePosition openBrace = serviceDeclarationNode.openBraceToken().lineRange().endLine();
        LinePosition closeBrace = serviceDeclarationNode.closeBraceToken().lineRange().startLine();
        int cursorLine = cursorPosition.get().line();
        int cursorOffset = cursorPosition.get().offset();
        if (cursorLine < openBrace.line() || cursorLine > closeBrace.line() || cursorLine == openBrace.line() && cursorOffset < openBrace.offset() || cursorLine == closeBrace.line() && cursorOffset > closeBrace.offset()) {
            return false;
        }
        ServiceDeclarationContextValidator validator = new ServiceDeclarationContextValidator(context);
        validator.visitNode(context.nodeAtCursor());
        return validator.isValidContext();
    }

    static class ServiceDeclarationContextValidator
    extends NodeVisitor {
        private final CompletionContext context;
        private boolean isValidContext = false;

        public ServiceDeclarationContextValidator(CompletionContext context) {
            this.context = context;
        }

        public void visit(ServiceDeclarationNode serviceDeclarationNode) {
            this.isValidContext = true;
        }

        public void visit(SimpleNameReferenceNode simpleNameReferenceNode) {
            simpleNameReferenceNode.parent().accept((NodeVisitor)this);
        }

        public void visit(ObjectFieldNode objectFieldNode) {
            int cursorPosition = this.context.cursorPosInTree();
            this.isValidContext = objectFieldNode.textRange().startOffset() <= cursorPosition && cursorPosition <= objectFieldNode.textRange().endOffset() && objectFieldNode.fieldName().isMissing() && objectFieldNode.equalsToken().isEmpty();
        }

        public void visit(FunctionDefinitionNode functionDefinitionNode) {
            int cursorLine = this.context.cursorPosition().get().line();
            this.isValidContext = cursorLine < functionDefinitionNode.lineRange().startLine().line() || functionDefinitionNode.lineRange().endLine().line() < cursorLine;
        }

        public void visit(MethodDeclarationNode methodDeclarationNode) {
            int cursorLine = this.context.cursorPosition().get().line();
            this.isValidContext = cursorLine < methodDeclarationNode.lineRange().startLine().line() || methodDeclarationNode.lineRange().endLine().line() < cursorLine;
        }

        protected void visitSyntaxNode(Node node) {
        }

        public Boolean isValidContext() {
            return this.isValidContext;
        }

        public void visitNode(Node node) {
            if (node.kind() == SyntaxKind.LIST) {
                if (node.parent() != null) {
                    node.parent().accept((NodeVisitor)this);
                }
            } else {
                node.accept((NodeVisitor)this);
            }
        }
    }

    static class CompletionProviderDescriptor {
        private final CompletionProvider<Node> completionProvider;
        private final CompilerPluginInfo compilerPluginInfo;

        public CompletionProviderDescriptor(CompletionProvider<Node> completionProvider, CompilerPluginInfo compilerPluginInfo) {
            this.completionProvider = completionProvider;
            this.compilerPluginInfo = compilerPluginInfo;
        }

        public CompletionProvider<Node> completionProvider() {
            return this.completionProvider;
        }

        public CompilerPluginInfo compilerPluginInfo() {
            return this.compilerPluginInfo;
        }
    }
}

