/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BuildToolId;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.PackageContainer;
import io.ballerina.tools.diagnostics.Location;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DependencyManifest {
    private final String dependenciesTomlVersion;
    private final SemanticVersion distributionVersion;
    private final List<Package> packages;
    private final List<Tool> tools;
    private final DiagnosticResult diagnostics;
    private final PackageContainer<Package> pkgContainer;

    private DependencyManifest(String dependenciesTomlVersion, SemanticVersion distributionVersion, List<Package> packages, List<Tool> tools, DiagnosticResult diagnostics) {
        this.dependenciesTomlVersion = dependenciesTomlVersion;
        this.distributionVersion = distributionVersion;
        this.tools = Collections.unmodifiableList(tools);
        this.packages = Collections.unmodifiableList(packages);
        this.diagnostics = diagnostics;
        this.pkgContainer = new PackageContainer();
        for (Package dependency : packages) {
            this.pkgContainer.add(dependency.org(), dependency.name(), dependency);
        }
    }

    public static DependencyManifest from(String dependenciesTomlVersion, SemanticVersion distributionVersion, List<Package> dependencies, List<Tool> tools, DiagnosticResult diagnostics) {
        return new DependencyManifest(dependenciesTomlVersion, distributionVersion, dependencies, tools, diagnostics);
    }

    public static DependencyManifest from(String dependenciesTomlVersion, SemanticVersion distributionVersion, List<Package> dependencies, List<Tool> tools) {
        return new DependencyManifest(dependenciesTomlVersion, distributionVersion, dependencies, tools, new DefaultDiagnosticResult(Collections.emptyList()));
    }

    public String dependenciesTomlVersion() {
        return this.dependenciesTomlVersion;
    }

    public SemanticVersion distributionVersion() {
        return this.distributionVersion;
    }

    public Collection<Package> packages() {
        return this.packages;
    }

    public Collection<Tool> tools() {
        return this.tools;
    }

    public Optional<Package> dependency(PackageOrg org, PackageName name) {
        return this.pkgContainer.get(org, name);
    }

    public Package dependencyOrThrow(PackageOrg org, PackageName name) {
        return this.pkgContainer.get(org, name).orElseThrow(() -> new IllegalStateException("Dependency with org `" + String.valueOf(org) + "` and name `" + String.valueOf(name) + "` must exists."));
    }

    public DiagnosticResult diagnostics() {
        return this.diagnostics;
    }

    public static class Package {
        private final PackageName packageName;
        private final PackageOrg packageOrg;
        private final PackageVersion version;
        private final Location location;
        private final String scope;
        private final boolean transitive;
        private final List<Dependency> dependencies;
        private final List<Module> modules;

        public Package(PackageName packageName, PackageOrg packageOrg, PackageVersion version, Location location) {
            this.packageName = packageName;
            this.packageOrg = packageOrg;
            this.version = version;
            this.location = location;
            this.scope = null;
            this.transitive = false;
            this.dependencies = Collections.emptyList();
            this.modules = Collections.emptyList();
        }

        public Package(PackageName packageName, PackageOrg packageOrg, PackageVersion version, String scope, boolean transitive, List<Dependency> dependencies, List<Module> modules, Location location) {
            this.packageName = packageName;
            this.packageOrg = packageOrg;
            this.version = version;
            this.scope = scope;
            this.transitive = transitive;
            this.dependencies = dependencies;
            this.modules = modules;
            this.location = location;
        }

        public Package(PackageName packageName, PackageOrg packageOrg, PackageVersion version) {
            this.packageName = packageName;
            this.packageOrg = packageOrg;
            this.version = version;
            this.location = null;
            this.scope = null;
            this.transitive = false;
            this.dependencies = Collections.emptyList();
            this.modules = Collections.emptyList();
        }

        public Package(PackageName packageName, PackageOrg packageOrg, PackageVersion version, String scope, boolean transitive, List<Dependency> dependencies, List<Module> modules) {
            this.packageName = packageName;
            this.packageOrg = packageOrg;
            this.version = version;
            this.scope = scope;
            this.transitive = transitive;
            this.dependencies = dependencies;
            this.modules = modules;
            this.location = null;
        }

        public PackageName name() {
            return this.packageName;
        }

        public PackageOrg org() {
            return this.packageOrg;
        }

        public PackageVersion version() {
            return this.version;
        }

        public String scope() {
            return this.scope;
        }

        public boolean isTransitive() {
            return this.transitive;
        }

        public Collection<Dependency> dependencies() {
            return this.dependencies;
        }

        public List<Module> modules() {
            return this.modules;
        }

        public Optional<Location> location() {
            return Optional.ofNullable(this.location);
        }
    }

    public static class Tool {
        private final BuildToolId id;
        private final PackageOrg org;
        private final PackageName name;
        private final PackageVersion version;
        private final Location location;

        public Tool(BuildToolId id, PackageOrg org, PackageName name, PackageVersion version, Location location) {
            this.id = id;
            this.org = org;
            this.name = name;
            this.version = version;
            this.location = location;
        }

        public BuildToolId id() {
            return this.id;
        }

        public PackageOrg org() {
            return this.org;
        }

        public PackageName name() {
            return this.name;
        }

        public PackageVersion version() {
            return this.version;
        }

        public Optional<Location> location() {
            return Optional.ofNullable(this.location);
        }
    }

    public static class Module {
        private final String org;
        private final String packageName;
        private final String moduleName;

        public Module(String org, String packageName, String moduleName) {
            this.org = org;
            this.packageName = packageName;
            this.moduleName = moduleName;
        }

        public String org() {
            return this.org;
        }

        public String packageName() {
            return this.packageName;
        }

        public String moduleName() {
            return this.moduleName;
        }
    }

    public static class Dependency {
        private final PackageName packageName;
        private final PackageOrg packageOrg;

        public Dependency(PackageName packageName, PackageOrg packageOrg) {
            this.packageName = packageName;
            this.packageOrg = packageOrg;
        }

        public PackageName name() {
            return this.packageName;
        }

        public PackageOrg org() {
            return this.packageOrg;
        }
    }
}

