/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.Diagnostics;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class DiagnosticResult {
    protected final Collection<Diagnostic> allDiagnostics;
    protected Collection<Diagnostic> errors;
    protected Collection<Diagnostic> warnings;
    protected Collection<Diagnostic> hints;
    protected Collection<Diagnostic> internalExcluded;

    protected DiagnosticResult(Collection<Diagnostic> allDiagnostics) {
        this.allDiagnostics = Collections.unmodifiableCollection(allDiagnostics);
    }

    public Collection<Diagnostic> diagnostics() {
        return this.diagnostics(true);
    }

    public Collection<Diagnostic> diagnostics(boolean includeInternal) {
        return includeInternal ? this.allDiagnostics : this.getInternalExcluded(this.allDiagnostics);
    }

    public Collection<Diagnostic> diagnostics(boolean includeInternal, boolean hideDependencyDiagnostics) {
        Collection<Diagnostic> diagnostics;
        Collection<Diagnostic> collection = diagnostics = includeInternal ? this.allDiagnostics : this.getInternalExcluded(this.allDiagnostics);
        if (hideDependencyDiagnostics) {
            ArrayList<Diagnostic> filteredDiagnostics = new ArrayList<Diagnostic>();
            for (Diagnostic diagnostic : diagnostics) {
                if (diagnostic.toString().contains("::")) continue;
                filteredDiagnostics.add(diagnostic);
            }
            return filteredDiagnostics;
        }
        return diagnostics;
    }

    public Collection<Diagnostic> errors() {
        return this.getErrors(this.allDiagnostics);
    }

    public Collection<Diagnostic> warnings() {
        return this.getWarnings(this.allDiagnostics);
    }

    public Collection<Diagnostic> hints() {
        return this.getHints(this.allDiagnostics);
    }

    public int diagnosticCount() {
        return this.allDiagnostics.size();
    }

    public int errorCount() {
        return this.getErrors(this.allDiagnostics).size();
    }

    public int warningCount() {
        return this.getWarnings(this.allDiagnostics).size();
    }

    public int hintCount() {
        return this.getHints(this.allDiagnostics).size();
    }

    public boolean hasErrors() {
        return !this.getErrors(this.allDiagnostics).isEmpty();
    }

    public boolean hasWarnings() {
        return !this.getWarnings(this.allDiagnostics).isEmpty();
    }

    private Collection<Diagnostic> getErrors(Collection<Diagnostic> diagnostics) {
        if (this.errors != null) {
            return this.errors;
        }
        this.errors = Diagnostics.filterErrors(diagnostics);
        return this.errors;
    }

    private Collection<Diagnostic> getWarnings(Collection<Diagnostic> diagnostics) {
        if (this.warnings != null) {
            return this.warnings;
        }
        this.warnings = Diagnostics.filterWarnings(diagnostics);
        return this.warnings;
    }

    private Collection<Diagnostic> getHints(Collection<Diagnostic> diagnostics) {
        if (this.hints != null) {
            return this.hints;
        }
        this.hints = Diagnostics.filterHints(diagnostics);
        return this.hints;
    }

    private Collection<Diagnostic> getInternalExcluded(Collection<Diagnostic> diagnostics) {
        if (this.internalExcluded != null) {
            return this.internalExcluded;
        }
        this.internalExcluded = Diagnostics.excludeInternal(diagnostics);
        return this.internalExcluded;
    }
}

