/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.DocumentId;
import java.util.function.Supplier;

public abstract class DocumentConfig {
    private final DocumentId documentId;
    private final String name;

    private DocumentConfig(DocumentId documentId, String name) {
        this.documentId = documentId;
        this.name = name;
    }

    public static DocumentConfig from(DocumentId documentId, String content, String name) {
        return new EagerDocumentConfig(documentId, content, name);
    }

    public static DocumentConfig from(DocumentId documentId, Supplier<String> content, String name) {
        return new LazyDocumentConfig(documentId, content, name);
    }

    public DocumentId documentId() {
        return this.documentId;
    }

    public abstract String content();

    public String name() {
        return this.name;
    }

    private static class EagerDocumentConfig
    extends DocumentConfig {
        private final String content;

        private EagerDocumentConfig(DocumentId documentId, String content, String name) {
            super(documentId, name);
            this.content = content;
        }

        @Override
        public String content() {
            return this.content;
        }
    }

    private static class LazyDocumentConfig
    extends DocumentConfig {
        private final Supplier<String> contentSupplier;

        private LazyDocumentConfig(DocumentId documentId, Supplier<String> contentSupplier, String name) {
            super(documentId, name);
            this.contentSupplier = contentSupplier;
        }

        @Override
        public String content() {
            String s = this.contentSupplier.get();
            assert (s != null) : "LazyDocumentConfig content supplier should not return null";
            return s;
        }
    }
}

