/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentId;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;

class MdDocumentContext {
    private TextDocument textDocument;
    private final DocumentId documentId;
    private final String name;
    private final DocumentConfig documentConfig;

    private MdDocumentContext(DocumentId documentId, String name, DocumentConfig config) {
        this.documentId = documentId;
        this.name = name;
        this.documentConfig = config;
    }

    static MdDocumentContext from(DocumentConfig documentConfig) {
        return new MdDocumentContext(documentConfig.documentId(), documentConfig.name(), documentConfig);
    }

    DocumentId documentId() {
        return this.documentId;
    }

    String name() {
        return this.name;
    }

    public TextDocument textDocument() {
        if (this.textDocument == null) {
            this.textDocument = TextDocuments.from(this.documentConfig::content);
        }
        return this.textDocument;
    }

    String content() {
        return this.documentConfig.content();
    }
}

