/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ResourceConfig;
import java.util.List;
import java.util.Optional;

public class ModuleConfig {
    private final ModuleId moduleId;
    private final ModuleDescriptor moduleDescriptor;
    private final List<DocumentConfig> srcDocs;
    private final List<DocumentConfig> testSrcDocs;
    private final List<ModuleDescriptor> dependencies;
    private final DocumentConfig readmeMd;

    private ModuleConfig(ModuleId moduleId, ModuleDescriptor moduleDescriptor, List<DocumentConfig> srcDocs, List<DocumentConfig> testSrcDocs, DocumentConfig readmeMd, List<ModuleDescriptor> dependencies) {
        this.moduleId = moduleId;
        this.moduleDescriptor = moduleDescriptor;
        this.srcDocs = srcDocs;
        this.testSrcDocs = testSrcDocs;
        this.dependencies = dependencies;
        this.readmeMd = readmeMd;
    }

    public static ModuleConfig from(ModuleId moduleId, ModuleDescriptor moduleDescriptor, List<DocumentConfig> srcDocs, List<DocumentConfig> testSrcDocs, DocumentConfig moduleMd, List<ModuleDescriptor> dependencies) {
        return new ModuleConfig(moduleId, moduleDescriptor, srcDocs, testSrcDocs, moduleMd, dependencies);
    }

    public static ModuleConfig from(ModuleId moduleId, ModuleDescriptor moduleDescriptor, List<DocumentConfig> srcDocs, List<DocumentConfig> testSrcDocs, DocumentConfig moduleMd, List<ModuleDescriptor> dependencies, List<ResourceConfig> resources, List<ResourceConfig> testResources) {
        return new ModuleConfig(moduleId, moduleDescriptor, srcDocs, testSrcDocs, moduleMd, dependencies);
    }

    public ModuleId moduleId() {
        return this.moduleId;
    }

    public ModuleDescriptor moduleDescriptor() {
        return this.moduleDescriptor;
    }

    public boolean isDefaultModule() {
        return this.moduleDescriptor.name().isDefaultModuleName();
    }

    public List<DocumentConfig> sourceDocs() {
        return this.srcDocs;
    }

    public List<DocumentConfig> testSourceDocs() {
        return this.testSrcDocs;
    }

    public List<ModuleDescriptor> dependencies() {
        return this.dependencies;
    }

    @Deprecated(forRemoval=true, since="2.11.0")
    public Optional<DocumentConfig> moduleMd() {
        return Optional.ofNullable(this.readmeMd);
    }

    public Optional<DocumentConfig> readmeMd() {
        return Optional.ofNullable(this.readmeMd);
    }

    @Deprecated(since="2201.10.0", forRemoval=true)
    public List<ResourceConfig> resources() {
        return null;
    }

    @Deprecated(since="2201.10.0", forRemoval=true)
    public List<ResourceConfig> testResources() {
        return null;
    }
}

