/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.impl.BallerinaSemanticModel;
import io.ballerina.projects.BalCommand;
import io.ballerina.projects.CodeActionManager;
import io.ballerina.projects.CodeAnalyzerManager;
import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.CompilerLifecycleManager;
import io.ballerina.projects.CompilerPluginManager;
import io.ballerina.projects.CompletionManager;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.ModuleCompilationState;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.plugins.CompilerPlugin;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class PackageCompilation {
    private final PackageContext rootPackageContext;
    private final PackageResolution packageResolution;
    private final CompilationOptions compilationOptions;
    private CompilerContext compilerContext;
    private Map<CompilerBackend.TargetPlatform, CompilerBackend> compilerBackends;
    private List<Diagnostic> pluginDiagnostics;
    private DiagnosticResult diagnosticResult;
    private volatile boolean compiled;
    private CompilerPluginManager compilerPluginManager;

    private PackageCompilation(PackageContext rootPackageContext, CompilationOptions compilationOptions) {
        this.rootPackageContext = rootPackageContext;
        this.packageResolution = rootPackageContext.getResolution();
        this.compilationOptions = compilationOptions;
        this.setupCompilation(compilationOptions);
    }

    private void setupCompilation(CompilationOptions compilationOptions) {
        ProjectEnvironment projectEnvContext = this.rootPackageContext.project().projectEnvironmentContext();
        this.compilerContext = projectEnvContext.getService(CompilerContext.class);
        this.setCompilerOptions(compilationOptions);
        this.compilerBackends = new HashMap<CompilerBackend.TargetPlatform, CompilerBackend>(1);
        this.pluginDiagnostics = new ArrayList<Diagnostic>();
    }

    private void setCompilerOptions(CompilationOptions compilationOptions) {
        CompilerOptions options = CompilerOptions.getInstance(this.compilerContext);
        options.put(CompilerOptionName.EXPERIMENTAL, Boolean.toString(compilationOptions.experimental()));
    }

    static PackageCompilation from(PackageContext rootPackageContext, CompilationOptions compilationOptions) {
        PackageCompilation compilation = new PackageCompilation(rootPackageContext, compilationOptions);
        return PackageCompilation.compile(compilation);
    }

    private static PackageCompilation compile(PackageCompilation compilation) {
        compilation.compileModules();
        CompilerPluginManager compilerPluginManager = CompilerPluginManager.from(compilation);
        compilation.setCompilerPluginManager(compilerPluginManager);
        if (compilation.packageContext().defaultModuleContext().compilationState() != ModuleCompilationState.COMPILED) {
            return compilation;
        }
        if (compilation.compilationOptions().withCodeGenerators() || compilation.compilationOptions().withCodeModifiers()) {
            return compilation;
        }
        CodeAnalyzerManager codeAnalyzerManager = compilerPluginManager.getCodeAnalyzerManager();
        List<Diagnostic> reportedDiagnostics = codeAnalyzerManager.runCodeAnalyzerTasks();
        PackageCompilation.addCompilerPluginDiagnostics(compilation, reportedDiagnostics);
        return compilation;
    }

    List<Diagnostic> notifyCompilationCompletion(Path filePath, BalCommand balCommand) {
        CompilerLifecycleManager manager = this.compilerPluginManager.getCompilerLifecycleListenerManager();
        List<Diagnostic> diagnostics = manager.runCodeGeneratedTasks(filePath, balCommand);
        this.pluginDiagnostics.addAll(diagnostics);
        return diagnostics;
    }

    CompilationOptions compilationOptions() {
        return this.compilationOptions;
    }

    public PackageResolution getResolution() {
        return this.packageResolution;
    }

    public DiagnosticResult diagnosticResult() {
        return this.diagnosticResult;
    }

    public SemanticModel getSemanticModel(ModuleId moduleId) {
        ModuleContext moduleContext = this.rootPackageContext.moduleContext(moduleId);
        ModuleCompilationState state = moduleContext.compilationState();
        if (state != ModuleCompilationState.COMPILED && state != ModuleCompilationState.PLATFORM_LIBRARY_GENERATED) {
            throw new IllegalStateException("Semantic model cannot be retrieved when the module is in compilation state '" + state.name() + "'. This is an internal error which will be fixed in a later release.");
        }
        return new BallerinaSemanticModel(moduleContext.bLangPackage(), this.compilerContext);
    }

    public CodeActionManager getCodeActionManager() {
        return this.compilerPluginManager.getCodeActionManager();
    }

    public CompletionManager getCompletionManager() {
        return this.compilerPluginManager.getCompletionManager();
    }

    CompilerPluginManager compilerPluginManager() {
        return this.compilerPluginManager;
    }

    public BLangPackage defaultModuleBLangPackage() {
        return this.rootPackageContext.defaultModuleContext().bLangPackage();
    }

    <T extends CompilerBackend> T getCompilerBackend(CompilerBackend.TargetPlatform targetPlatform, Function<CompilerBackend.TargetPlatform, T> backendCreator) {
        return (T)this.compilerBackends.computeIfAbsent(targetPlatform, backendCreator);
    }

    PackageContext packageContext() {
        return this.rootPackageContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileModules() {
        if (this.compiled) {
            return;
        }
        CompilerContext compilerContext = this.compilerContext;
        synchronized (compilerContext) {
            if (this.compiled) {
                return;
            }
            this.compileModulesInternal();
            this.compiled = true;
        }
    }

    private void compileModulesInternal() {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        diagnostics.addAll(this.packageResolution.diagnosticResult().allDiagnostics);
        diagnostics.addAll(this.packageContext().packageManifest().diagnostics().allDiagnostics);
        diagnostics.addAll(this.packageContext().dependencyManifest().diagnostics().allDiagnostics);
        if (!this.packageResolution.diagnosticResult().hasErrors()) {
            for (ModuleContext moduleContext : this.packageResolution.topologicallySortedModuleList()) {
                moduleContext.compile(this.compilerContext);
                for (Diagnostic diagnostic : moduleContext.diagnostics()) {
                    if (ProjectKind.BALA_PROJECT.equals((Object)moduleContext.project().kind()) && diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
                    boolean isWorkspaceDep = !this.packageResolution.dependencyGraph().getRoot().packageInstance().descriptor().equals(moduleContext.project().currentPackage().descriptor());
                    diagnostics.add(new PackageDiagnostic(diagnostic, moduleContext.descriptor(), moduleContext.project(), isWorkspaceDep));
                }
            }
        }
        this.runPluginCodeAnalysis(diagnostics);
        this.diagnosticResult = new DefaultDiagnosticResult(diagnostics);
    }

    private void runPluginCodeAnalysis(List<Diagnostic> diagnostics) {
        if (this.rootPackageContext.project().kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
            ServiceLoader<CompilerPlugin> processorServiceLoader = ServiceLoader.load(CompilerPlugin.class);
            for (CompilerPlugin plugin : processorServiceLoader) {
                List<Diagnostic> pluginDiagnostics = plugin.codeAnalyze(this.rootPackageContext.project());
                diagnostics.addAll(pluginDiagnostics);
                this.pluginDiagnostics.addAll(pluginDiagnostics);
            }
        }
    }

    private void setCompilerPluginManager(CompilerPluginManager compilerPluginManager) {
        this.compilerPluginManager = compilerPluginManager;
    }

    List<Diagnostic> pluginDiagnostics() {
        return this.pluginDiagnostics;
    }

    private static void addCompilerPluginDiagnostics(PackageCompilation compilation, List<Diagnostic> reportedDiagnostics) {
        ArrayList<Diagnostic> allDiagnostics = new ArrayList<Diagnostic>(compilation.diagnosticResult.diagnostics());
        allDiagnostics.addAll(reportedDiagnostics);
        compilation.diagnosticResult = new DefaultDiagnosticResult(allDiagnostics);
        compilation.pluginDiagnostics.addAll(reportedDiagnostics);
    }
}

