/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BuildToolResolution;
import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DependencyManifest;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.MdDocumentContext;
import io.ballerina.projects.ModuleCompilation;
import io.ballerina.projects.ModuleConfig;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.PackageDependency;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import io.ballerina.projects.ResourceConfig;
import io.ballerina.projects.ResourceContext;
import io.ballerina.projects.TomlDocumentContext;
import io.ballerina.projects.internal.model.CompilerPluginDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class PackageContext {
    private final Map<ModuleId, ModuleContext> moduleContextMap;
    private final Collection<ModuleId> moduleIds;
    private final Project project;
    private final PackageId packageId;
    private final PackageManifest packageManifest;
    private final DependencyManifest dependencyManifest;
    private final TomlDocumentContext ballerinaTomlContext;
    private final TomlDocumentContext dependenciesTomlContext;
    private final TomlDocumentContext cloudTomlContext;
    private final TomlDocumentContext compilerPluginTomlContext;
    private final TomlDocumentContext balToolTomlContext;
    private final MdDocumentContext readmeMdContext;
    private final CompilationOptions compilationOptions;
    private ModuleContext defaultModuleContext;
    private final Collection<DocumentId> resourceIds;
    private final Collection<DocumentId> testResourceIds;
    private final Map<DocumentId, ResourceContext> resourceContextMap;
    private final Map<DocumentId, ResourceContext> testResourceContextMap;
    private final DependencyGraph<PackageDescriptor> pkgDescDependencyGraph;
    private Set<PackageDependency> packageDependencies;
    private DependencyGraph<ModuleDescriptor> moduleDependencyGraph;
    private PackageResolution packageResolution;
    private BuildToolResolution buildToolResolution;
    private PackageCompilation packageCompilation;
    private final Map<ModuleId, ModuleCompilation> moduleCompilationMap;

    PackageContext(Project project, PackageId packageId, PackageManifest packageManifest, DependencyManifest dependencyManifest, TomlDocumentContext ballerinaTomlContext, TomlDocumentContext dependenciesTomlContext, TomlDocumentContext cloudTomlContext, TomlDocumentContext compilerPluginTomlContext, TomlDocumentContext balToolTomlContext, MdDocumentContext readmeMdContext, CompilationOptions compilationOptions, Map<ModuleId, ModuleContext> moduleContextMap, DependencyGraph<PackageDescriptor> pkgDescDependencyGraph, Map<DocumentId, ResourceContext> resourceContextMap, Map<DocumentId, ResourceContext> testResourceContextMap) {
        this.project = project;
        this.packageId = packageId;
        this.packageManifest = packageManifest;
        this.dependencyManifest = dependencyManifest;
        this.ballerinaTomlContext = ballerinaTomlContext;
        this.dependenciesTomlContext = dependenciesTomlContext;
        this.cloudTomlContext = cloudTomlContext;
        this.compilerPluginTomlContext = compilerPluginTomlContext;
        this.balToolTomlContext = balToolTomlContext;
        this.readmeMdContext = readmeMdContext;
        this.compilationOptions = compilationOptions;
        this.moduleIds = Collections.unmodifiableCollection(moduleContextMap.keySet());
        this.moduleContextMap = moduleContextMap;
        this.moduleCompilationMap = new HashMap<ModuleId, ModuleCompilation>();
        this.packageDependencies = Collections.emptySet();
        this.pkgDescDependencyGraph = pkgDescDependencyGraph;
        this.resourceContextMap = resourceContextMap;
        this.testResourceContextMap = testResourceContextMap;
        this.resourceIds = Collections.unmodifiableCollection(resourceContextMap.keySet());
        this.testResourceIds = Collections.unmodifiableCollection(testResourceContextMap.keySet());
    }

    static PackageContext from(Project project, PackageConfig packageConfig, CompilationOptions compilationOptions) {
        HashMap<ModuleId, ModuleContext> moduleContextMap = new HashMap<ModuleId, ModuleContext>();
        for (ModuleConfig moduleConfig : packageConfig.otherModules()) {
            moduleContextMap.put(moduleConfig.moduleId(), ModuleContext.from(project, moduleConfig, packageConfig.isSyntaxTreeDisabled()));
        }
        HashMap<DocumentId, ResourceContext> resourceContextMap = new HashMap<DocumentId, ResourceContext>();
        for (ResourceConfig resourceConfig : packageConfig.resources()) {
            resourceContextMap.put(resourceConfig.documentId(), ResourceContext.from(resourceConfig));
        }
        HashMap<DocumentId, ResourceContext> hashMap = new HashMap<DocumentId, ResourceContext>();
        for (ResourceConfig resourceConfig : packageConfig.testResources()) {
            hashMap.put(resourceConfig.documentId(), ResourceContext.from(resourceConfig));
        }
        return new PackageContext(project, packageConfig.packageId(), packageConfig.packageManifest(), packageConfig.dependencyManifest(), packageConfig.ballerinaToml().map(TomlDocumentContext::from).orElse(null), packageConfig.dependenciesToml().map(TomlDocumentContext::from).orElse(null), packageConfig.cloudToml().map(TomlDocumentContext::from).orElse(null), packageConfig.compilerPluginToml().map(TomlDocumentContext::from).orElse(null), packageConfig.balToolToml().map(TomlDocumentContext::from).orElse(null), packageConfig.readmeMd().map(MdDocumentContext::from).orElse(null), compilationOptions, moduleContextMap, packageConfig.packageDescDependencyGraph(), resourceContextMap, hashMap);
    }

    PackageId packageId() {
        return this.packageId;
    }

    PackageName packageName() {
        return this.packageManifest.name();
    }

    PackageOrg packageOrg() {
        return this.packageManifest.org();
    }

    PackageVersion packageVersion() {
        return this.packageManifest.version();
    }

    PackageDescriptor descriptor() {
        return this.packageManifest.descriptor();
    }

    Optional<CompilerPluginDescriptor> compilerPluginDescriptor() {
        return this.packageManifest.compilerPluginDescriptor();
    }

    PackageManifest packageManifest() {
        return this.packageManifest;
    }

    DependencyManifest dependencyManifest() {
        return this.dependencyManifest;
    }

    Optional<TomlDocumentContext> ballerinaTomlContext() {
        return Optional.ofNullable(this.ballerinaTomlContext);
    }

    Optional<TomlDocumentContext> dependenciesTomlContext() {
        return Optional.ofNullable(this.dependenciesTomlContext);
    }

    Optional<TomlDocumentContext> cloudTomlContext() {
        return Optional.ofNullable(this.cloudTomlContext);
    }

    Optional<TomlDocumentContext> compilerPluginTomlContext() {
        return Optional.ofNullable(this.compilerPluginTomlContext);
    }

    Optional<TomlDocumentContext> balToolTomlContext() {
        return Optional.ofNullable(this.balToolTomlContext);
    }

    @Deprecated(forRemoval=true)
    Optional<MdDocumentContext> packageMdContext() {
        return Optional.ofNullable(this.readmeMdContext);
    }

    public Optional<MdDocumentContext> readmeMdContext() {
        return Optional.ofNullable(this.readmeMdContext);
    }

    CompilationOptions compilationOptions() {
        return this.compilationOptions;
    }

    Collection<ModuleId> moduleIds() {
        return this.moduleIds;
    }

    ModuleContext moduleContext(ModuleId moduleId) {
        return this.moduleContextMap.get(moduleId);
    }

    ModuleContext moduleContext(ModuleName moduleName) {
        for (ModuleContext moduleContext : this.moduleContextMap.values()) {
            if (!moduleContext.moduleName().equals(moduleName)) continue;
            return moduleContext;
        }
        return null;
    }

    ModuleContext defaultModuleContext() {
        if (this.defaultModuleContext != null) {
            return this.defaultModuleContext;
        }
        for (ModuleContext moduleContext : this.moduleContextMap.values()) {
            if (!moduleContext.isDefaultModule()) continue;
            this.defaultModuleContext = moduleContext;
            return this.defaultModuleContext;
        }
        throw new IllegalStateException("Default module not found. This is a bug in the Project API");
    }

    DependencyGraph<ModuleDescriptor> moduleDependencyGraph() {
        return this.moduleDependencyGraph;
    }

    ModuleCompilation getModuleCompilation(ModuleContext moduleContext) {
        return this.moduleCompilationMap.computeIfAbsent(moduleContext.moduleId(), moduleId -> new ModuleCompilation(this, moduleContext));
    }

    PackageCompilation getPackageCompilation() {
        if (this.packageCompilation == null) {
            this.packageCompilation = PackageCompilation.from(this, this.compilationOptions());
        }
        return this.packageCompilation;
    }

    PackageCompilation getPackageCompilation(CompilationOptions compilationOptions) {
        CompilationOptions options = CompilationOptions.builder().setOffline(this.compilationOptions.offlineBuild()).setExperimental(this.compilationOptions.experimental()).setObservabilityIncluded(this.compilationOptions.observabilityIncluded()).setDumpBir(this.compilationOptions.dumpBir()).setCloud(this.compilationOptions.getCloud()).setDumpBirFile(this.compilationOptions.dumpBirFile()).setDumpGraph(this.compilationOptions.dumpGraph()).setDumpRawGraphs(this.compilationOptions.dumpRawGraphs()).setListConflictedClasses(this.compilationOptions.listConflictedClasses()).setConfigSchemaGen(this.compilationOptions.configSchemaGen()).setRemoteManagement(this.compilationOptions.remoteManagement()).build();
        CompilationOptions mergedOptions = options.acceptTheirs(compilationOptions);
        return PackageCompilation.from(this, mergedOptions);
    }

    PackageCompilation cachedCompilation() {
        return this.packageCompilation;
    }

    PackageResolution getResolution() {
        if (this.packageResolution == null) {
            this.packageResolution = PackageResolution.from(this, this.compilationOptions);
        }
        return this.packageResolution;
    }

    PackageResolution getResolution(CompilationOptions compilationOptions) {
        this.packageResolution = PackageResolution.from(this, compilationOptions);
        return this.packageResolution;
    }

    PackageResolution getResolution(CompilationOptions compilationOptions, boolean isCacheEnabled) {
        if (!isCacheEnabled || this.packageResolution == null) {
            this.packageResolution = PackageResolution.from(this, compilationOptions);
        }
        return this.packageResolution;
    }

    BuildToolResolution getBuildToolResolution() {
        if (this.buildToolResolution == null) {
            this.buildToolResolution = BuildToolResolution.from(this);
        }
        return this.buildToolResolution;
    }

    BuildToolResolution getBuildToolResolution(CompilationOptions compilationOptions) {
        if (this.buildToolResolution == null) {
            this.buildToolResolution = BuildToolResolution.from(this, compilationOptions);
        }
        return this.buildToolResolution;
    }

    PackageResolution getResolution(PackageResolution oldResolution) {
        if (this.packageResolution == null) {
            this.packageResolution = PackageResolution.from(oldResolution, this, this.compilationOptions);
        }
        return this.packageResolution;
    }

    Collection<PackageDependency> packageDependencies() {
        return this.packageDependencies;
    }

    Project project() {
        return this.project;
    }

    DependencyGraph<PackageDescriptor> dependencyGraph() {
        return this.pkgDescDependencyGraph;
    }

    void resolveDependencies(PackageResolution.DependencyResolution dependencyResolution) {
        DependencyGraph.DependencyGraphBuilder<ModuleDescriptor> moduleDepGraphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder();
        HashSet<PackageDependency> packageDependencies = new HashSet<PackageDependency>();
        for (ModuleContext moduleContext : this.moduleContextMap.values()) {
            moduleDepGraphBuilder.add(moduleContext.descriptor());
            this.resolveModuleDependencies(moduleContext, dependencyResolution, moduleDepGraphBuilder, packageDependencies);
        }
        this.packageDependencies = packageDependencies;
        this.moduleDependencyGraph = moduleDepGraphBuilder.build();
    }

    private void resolveModuleDependencies(ModuleContext moduleContext, PackageResolution.DependencyResolution dependencyResolution, DependencyGraph.DependencyGraphBuilder<ModuleDescriptor> moduleDepGraphBuilder, Set<PackageDependency> packageDependencies) {
        moduleContext.resolveDependencies(dependencyResolution);
        for (ModuleDependency moduleDependency : moduleContext.dependencies()) {
            if (moduleDependency.packageDependency().packageId() == this.packageId()) {
                moduleDepGraphBuilder.addDependency(moduleContext.descriptor(), moduleDependency.descriptor());
                continue;
            }
            packageDependencies.add(moduleDependency.packageDependency());
        }
    }

    Collection<DocumentId> resourceIds() {
        return this.resourceIds;
    }

    Collection<DocumentId> testResourceIds() {
        return this.testResourceIds;
    }

    ResourceContext resourceContext(DocumentId documentId) {
        if (this.resourceIds.contains(documentId)) {
            return this.resourceContextMap.get(documentId);
        }
        return this.testResourceContextMap.get(documentId);
    }

    PackageContext duplicate(Project project) {
        HashMap<ModuleId, ModuleContext> duplicatedModuleContextMap = new HashMap<ModuleId, ModuleContext>();
        for (ModuleId moduleId : this.moduleIds) {
            ModuleContext moduleContext = this.moduleContext(moduleId);
            duplicatedModuleContextMap.put(moduleId, moduleContext.duplicate(project));
        }
        return new PackageContext(project, this.packageId, this.packageManifest, this.dependencyManifest, this.ballerinaTomlContext, this.dependenciesTomlContext, this.cloudTomlContext, this.compilerPluginTomlContext, this.balToolTomlContext, this.readmeMdContext, this.compilationOptions, duplicatedModuleContextMap, this.pkgDescDependencyGraph, this.resourceContextMap, this.testResourceContextMap);
    }
}

