/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.CompilerPluginContextIml;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.buildtools.ToolContext;
import io.ballerina.projects.directory.WorkspaceProject;
import io.ballerina.projects.environment.ProjectEnvironment;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public abstract class Project {
    protected final Path sourceRoot;
    private Package currentPackage;
    private BuildOptions buildOptions;
    protected ProjectEnvironment projectEnvironment;
    private final ProjectKind projectKind;
    private Map<PackageManifest.Tool.Field, ToolContext> toolContextMap;
    private final List<CompilerPluginContextIml> compilerPluginContexts;
    protected WorkspaceProject workspaceProject;

    protected Project(ProjectKind projectKind, Path projectPath, ProjectEnvironmentBuilder projectEnvironmentBuilder, BuildOptions buildOptions, WorkspaceProject workspaceProject) {
        this.projectKind = projectKind;
        this.sourceRoot = projectPath.toAbsolutePath().normalize();
        this.buildOptions = buildOptions;
        this.projectEnvironment = projectEnvironmentBuilder.build(this);
        this.compilerPluginContexts = new ArrayList<CompilerPluginContextIml>();
        this.workspaceProject = workspaceProject;
    }

    protected Project(ProjectKind projectKind, Path projectPath, BuildOptions buildOptions) {
        this.projectKind = projectKind;
        this.sourceRoot = projectPath.toAbsolutePath().normalize();
        this.buildOptions = buildOptions;
        this.compilerPluginContexts = new ArrayList<CompilerPluginContextIml>();
    }

    void setBuildOptions(BuildOptions buildOptions) {
        this.buildOptions = buildOptions;
    }

    public ProjectKind kind() {
        return this.projectKind;
    }

    public Package currentPackage() {
        return this.currentPackage;
    }

    public void addPackage(PackageConfig packageConfig) {
        Package newPackage = Package.from(this, packageConfig, this.buildOptions.compilationOptions());
        this.setCurrentPackage(newPackage);
    }

    public Path sourceRoot() {
        return this.sourceRoot;
    }

    public abstract Path targetDir();

    public abstract Path generatedResourcesDir();

    protected void setCurrentPackage(Package currentPackage) {
        this.currentPackage = currentPackage;
    }

    public ProjectEnvironment projectEnvironmentContext() {
        return this.projectEnvironment;
    }

    public BuildOptions buildOptions() {
        return this.buildOptions;
    }

    public Map<PackageManifest.Tool.Field, ToolContext> getToolContextMap() {
        return this.toolContextMap;
    }

    public void setToolContextMap(Map<PackageManifest.Tool.Field, ToolContext> toolContextMap) {
        this.toolContextMap = toolContextMap;
    }

    protected void populateCompilerContext() {
        CompilerContext compilerContext = this.projectEnvironmentContext().getService(CompilerContext.class);
        CompilerOptions options = CompilerOptions.getInstance(compilerContext);
    }

    public abstract void clearCaches();

    public abstract Project duplicate();

    protected Project resetPackage(Project project) {
        Package clone = this.currentPackage.duplicate(project);
        project.setCurrentPackage(clone);
        return project;
    }

    public abstract DocumentId documentId(Path var1);

    public abstract Optional<Path> documentPath(DocumentId var1);

    public abstract void save();

    List<CompilerPluginContextIml> compilerPluginContexts() {
        return this.compilerPluginContexts;
    }

    public Optional<WorkspaceProject> workspaceProject() {
        return Optional.ofNullable(this.workspaceProject);
    }
}

