/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.ProjectLoadResult;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.TomlDocumentContext;
import io.ballerina.projects.directory.WorkspaceProject;
import io.ballerina.toml.semantic.ast.TomlTableNode;

public class WorkspaceBallerinaToml {
    private final TomlDocumentContext balWorkspaceTomlContext;
    private final WorkspaceProject workspace;

    private WorkspaceBallerinaToml(WorkspaceProject workspace, TomlDocumentContext ballerinaTomlContext) {
        this.workspace = workspace;
        this.balWorkspaceTomlContext = ballerinaTomlContext;
    }

    public static WorkspaceBallerinaToml from(TomlDocument tomlDocument, WorkspaceProject workspace) {
        return new WorkspaceBallerinaToml(workspace, TomlDocumentContext.from(tomlDocument));
    }

    public WorkspaceProject project() {
        return this.workspace;
    }

    public String name() {
        return "Ballerina.toml";
    }

    public TomlTableNode tomlAstNode() {
        return this.tomlDocument().toml().rootNode();
    }

    public TomlDocument tomlDocument() {
        return this.balWorkspaceTomlContext.tomlDocument();
    }

    public Modifier modify() {
        return new Modifier(this);
    }

    public static class Modifier {
        private TomlDocument tomlDocument;
        private final WorkspaceProject workspaceProject;

        private Modifier(WorkspaceBallerinaToml oldDocument) {
            this.tomlDocument = oldDocument.tomlDocument();
            this.workspaceProject = oldDocument.project();
        }

        public Modifier withContent(String content) {
            this.tomlDocument = TomlDocument.from("Ballerina.toml", content);
            return this;
        }

        public WorkspaceBallerinaToml apply() {
            WorkspaceBallerinaToml balWorkspaceToml = WorkspaceBallerinaToml.from(this.tomlDocument, this.workspaceProject);
            ProjectLoadResult projectLoadResult = balWorkspaceToml.project().reload(this.tomlDocument);
            return ((WorkspaceProject)projectLoadResult.project()).ballerinaToml();
        }
    }
}

