/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.WorkspaceProject;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.WorkspaceDependencyGraphBuilder;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WorkspaceResolution {
    private final WorkspaceProject workspaceProject;
    private final DependencyGraph<BuildProject> projectDependencyGraph;
    private final List<Diagnostic> diagnosticList;
    private DefaultDiagnosticResult diagnosticResult;
    private final boolean offline;

    private WorkspaceResolution(WorkspaceProject workspaceProject, ResolutionOptions resolutionOptions) {
        this.workspaceProject = workspaceProject;
        this.offline = resolutionOptions.offline();
        this.projectDependencyGraph = this.buildDependencyGraph();
        this.diagnosticList = new ArrayList<Diagnostic>();
        this.diagnosticList.addAll(workspaceProject.manifest().diagnostics().allDiagnostics);
    }

    public static WorkspaceResolution from(WorkspaceProject workspaceProject) {
        return new WorkspaceResolution(workspaceProject, ResolutionOptions.builder().setOffline(workspaceProject.buildOptions().offlineBuild()).setSticky(workspaceProject.buildOptions().sticky()).build());
    }

    public static WorkspaceResolution from(WorkspaceProject workspaceProject, ResolutionOptions resolutionOptions) {
        return new WorkspaceResolution(workspaceProject, resolutionOptions);
    }

    private DependencyGraph<BuildProject> buildDependencyGraph() {
        WorkspaceDependencyGraphBuilder graphBuilder = new WorkspaceDependencyGraphBuilder();
        for (BuildProject project : this.workspaceProject.projects()) {
            graphBuilder.addPackage(project);
            CompilationOptions compilationOptions = this.workspaceProject.buildOptions().compilationOptions().acceptTheirs(CompilationOptions.builder().setOffline(this.offline).build());
            Collection<ResolvedPackageDependency> directDependencies = project.currentPackage().getResolution(compilationOptions).dependencyGraph().getDirectDependencies(new ResolvedPackageDependency(project.currentPackage(), PackageDependencyScope.DEFAULT));
            WorkspaceResolution.addDependencies(project, directDependencies, graphBuilder);
        }
        return graphBuilder.buildGraph();
    }

    private static void addDependencies(BuildProject project, Collection<ResolvedPackageDependency> directDependencies, WorkspaceDependencyGraphBuilder graphBuilder) {
        graphBuilder.addPackage(project);
        for (ResolvedPackageDependency directDependency : directDependencies) {
            if (directDependency.packageInstance().project().kind() != ProjectKind.BUILD_PROJECT) continue;
            BuildProject buildProject = (BuildProject)directDependency.packageInstance().project();
            graphBuilder.addDependency(project, buildProject);
            WorkspaceResolution.addDependencies(buildProject, directDependency.packageInstance().getResolution().dependencyGraph().getDirectDependencies(directDependency), graphBuilder);
        }
    }

    public DependencyGraph<BuildProject> dependencyGraph() {
        return this.projectDependencyGraph;
    }

    public DiagnosticResult diagnosticResult() {
        if (this.diagnosticResult == null) {
            this.diagnosticResult = new DefaultDiagnosticResult(this.diagnosticList);
        }
        return this.diagnosticResult;
    }
}

