/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.directory;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ProjectLoadResult;
import io.ballerina.projects.internal.BalaFiles;
import io.ballerina.projects.internal.PackageConfigCreator;
import io.ballerina.projects.repos.TempDirCompilationCache;
import io.ballerina.projects.util.ProjectPaths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;

public class BalaProject
extends Project
implements Comparable<Project> {
    private final String platform;
    private final String balaVersion;

    static ProjectLoadResult load(Path projectPath, ProjectEnvironmentBuilder environmentBuilder, BuildOptions buildOptions) {
        PackageConfig packageConfig = PackageConfigCreator.createBalaProjectConfig(projectPath);
        BalaProject balaProject = new BalaProject(environmentBuilder, projectPath, buildOptions);
        balaProject.addPackage(packageConfig);
        return new ProjectLoadResult(balaProject, balaProject.currentPackage().manifest().diagnostics());
    }

    private BalaProject(ProjectEnvironmentBuilder environmentBuilder, Path balaPath, BuildOptions buildOptions) {
        super(ProjectKind.BALA_PROJECT, balaPath, environmentBuilder, buildOptions, null);
        this.platform = BalaFiles.readPackageJson(balaPath).getPlatform();
        this.balaVersion = BalaFiles.readBalaJson(balaPath).getBala_version();
    }

    @Override
    public void clearCaches() {
        this.resetPackage(this);
        ProjectEnvironmentBuilder projectEnvironmentBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        projectEnvironmentBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
        this.projectEnvironment = projectEnvironmentBuilder.build(this);
    }

    @Override
    public Project duplicate() {
        ProjectEnvironmentBuilder projectEnvironmentBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        projectEnvironmentBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
        BuildOptions duplicateBuildOptions = BuildOptions.builder().build().acceptTheirs(this.buildOptions());
        BalaProject balaProject = new BalaProject(projectEnvironmentBuilder, this.sourceRoot, duplicateBuildOptions);
        return this.resetPackage(balaProject);
    }

    @Override
    public DocumentId documentId(Path file) {
        if (file == null) {
            throw new ProjectException("file path cannot be null");
        }
        if (!Files.isDirectory(this.sourceRoot, new LinkOption[0])) {
            throw new UnsupportedOperationException("retrieving the DocumentId from .bala is not supported");
        }
        if (this.isFilePathInProject(file)) {
            Path modulesRoot = this.sourceRoot.resolve("modules");
            for (ModuleId moduleId : this.currentPackage().moduleIds()) {
                Module module = this.currentPackage().module(moduleId);
                Path modulePath = modulesRoot.resolve(module.moduleName().toString());
                for (DocumentId documentId : module.documentIds()) {
                    Document document = module.document(documentId);
                    if (!modulePath.resolve(document.name()).toAbsolutePath().toString().equals(file.toAbsolutePath().toString())) continue;
                    return documentId;
                }
            }
        }
        throw new ProjectException("provided path '" + String.valueOf(file.toAbsolutePath()) + "' does not belong to the bala: " + String.valueOf(this.sourceRoot));
    }

    @Override
    public Optional<Path> documentPath(DocumentId documentId) {
        for (ModuleId moduleId : this.currentPackage().moduleIds()) {
            Module module = this.currentPackage().module(moduleId);
            Path modulePath = this.sourceRoot.resolve("modules").resolve(module.moduleName().toString());
            if (!module.documentIds().contains(documentId)) continue;
            return Optional.of(modulePath.resolve(module.document(documentId).name()));
        }
        return Optional.empty();
    }

    @Override
    public void save() {
    }

    public String platform() {
        return this.platform;
    }

    public String balaVersion() {
        return this.balaVersion;
    }

    private boolean isFilePathInProject(Path filepath) {
        try {
            ProjectPaths.packageRoot(filepath);
        }
        catch (ProjectException e) {
            return false;
        }
        return true;
    }

    @Override
    public Path targetDir() {
        throw new UnsupportedOperationException("target directory is not supported for BalaProject");
    }

    @Override
    public Path generatedResourcesDir() {
        throw new UnsupportedOperationException("generated resources directory is not supported for BalaProject");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BalaProject)) {
            return false;
        }
        BalaProject other = (BalaProject)obj;
        return this.sourceRoot.equals(other.sourceRoot());
    }

    public int hashCode() {
        return this.sourceRoot.hashCode();
    }

    @Override
    public int compareTo(Project other) {
        return this.sourceRoot.compareTo(other.sourceRoot());
    }
}

