/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.directory;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ProjectLoadResult;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.WorkspaceBallerinaToml;
import io.ballerina.projects.WorkspaceManifest;
import io.ballerina.projects.WorkspaceResolution;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.EnvironmentBuilder;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.WorkspaceManifestBuilder;
import io.ballerina.projects.util.ProjectPaths;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class WorkspaceProject
extends Project {
    private final List<BuildProject> projectList;
    private WorkspaceBallerinaToml workspaceBallerinaToml;
    private final BuildOptions buildOptions;
    private WorkspaceManifest workspaceManifest;
    private WorkspaceResolution workspaceResolution;

    private WorkspaceProject(Path projectPath, BuildOptions buildOptions, TomlDocument tomlDocument) {
        super(ProjectKind.WORKSPACE_PROJECT, projectPath, buildOptions);
        this.workspaceBallerinaToml = WorkspaceBallerinaToml.from(tomlDocument, this);
        this.buildOptions = buildOptions;
        this.workspaceManifest = WorkspaceManifestBuilder.from(tomlDocument, projectPath).manifest();
        this.projectList = new ArrayList<BuildProject>();
    }

    private WorkspaceProject(Path projectPath, BuildOptions buildOptions, TomlDocument tomlDocument, List<BuildProject> projects) {
        super(ProjectKind.WORKSPACE_PROJECT, projectPath, buildOptions);
        this.workspaceBallerinaToml = WorkspaceBallerinaToml.from(tomlDocument, this);
        this.buildOptions = buildOptions;
        this.workspaceManifest = WorkspaceManifestBuilder.from(tomlDocument, projectPath).manifest();
        this.projectList = projects;
    }

    static ProjectLoadResult loadProject(Path path, EnvironmentBuilder environmentBuilder, BuildOptions buildOptions) {
        if (ProjectPaths.isWorkspaceProjectRoot(path)) {
            try {
                TomlDocument tomlDocument = TomlDocument.from("Ballerina.toml", Files.readString(path.resolve("Ballerina.toml")));
                WorkspaceProject workspaceProject = new WorkspaceProject(path, buildOptions, tomlDocument);
                Environment environment = environmentBuilder.setWorkspace(workspaceProject).build();
                ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>(workspaceProject.manifest().diagnostics().diagnostics());
                String org = null;
                for (Path pkgPath : workspaceProject.manifest().packages()) {
                    ProjectLoadResult buildProjectLoadResult = WorkspaceProject.loadBuildProject(environment, pkgPath, workspaceProject, org);
                    if (org == null) {
                        org = buildProjectLoadResult.project().currentPackage().packageOrg().toString();
                    }
                    if (buildProjectLoadResult.diagnostics().hasErrors()) {
                        diagnostics.addAll(buildProjectLoadResult.diagnostics().diagnostics());
                        continue;
                    }
                    workspaceProject.projectList.add((BuildProject)buildProjectLoadResult.project());
                }
                return new ProjectLoadResult(workspaceProject, new DefaultDiagnosticResult(diagnostics));
            }
            catch (IOException e) {
                throw new ProjectException("Error reading Ballerina.toml file in workspace: " + String.valueOf(path.toAbsolutePath()), e);
            }
        }
        throw new ProjectException("The specified path is not a valid workspace: " + String.valueOf(path.toAbsolutePath()));
    }

    @Override
    public Path targetDir() {
        if (this.buildOptions().getTargetPath() == null) {
            return this.sourceRoot.resolve("target");
        }
        return Path.of(this.buildOptions().getTargetPath(), new String[0]);
    }

    @Override
    public Path generatedResourcesDir() {
        return this.projectList.iterator().next().generatedResourcesDir();
    }

    @Override
    public void clearCaches() {
        Environment environment = EnvironmentBuilder.getBuilder().setWorkspace(this).build();
        for (BuildProject buildProject : this.projectList) {
            buildProject.setEnvironment(environment);
            buildProject.clearCaches();
        }
        this.workspaceResolution = null;
    }

    @Override
    public Package currentPackage() {
        return this.projectList.iterator().next().currentPackage();
    }

    @Override
    public Project duplicate() {
        ArrayList<BuildProject> projects = new ArrayList<BuildProject>();
        for (Project project : this.projectList) {
            projects.add((BuildProject)project.duplicate());
        }
        return new WorkspaceProject(this.sourceRoot, this.buildOptions, this.workspaceBallerinaToml.tomlDocument(), projects);
    }

    @Override
    public DocumentId documentId(Path file) {
        for (Project project : this.projectList) {
            try {
                return project.documentId(file);
            }
            catch (ProjectException projectException) {
            }
        }
        throw new ProjectException("'" + file.toString() + "' does not belong to the current workspace");
    }

    @Override
    public Optional<Path> documentPath(DocumentId documentId) {
        for (Project project : this.projectList) {
            if (!project.documentPath(documentId).isPresent()) continue;
            return project.documentPath(documentId);
        }
        return Optional.empty();
    }

    @Override
    public void save() {
        this.projectList.forEach(Project::save);
    }

    @Override
    public ProjectEnvironment projectEnvironmentContext() {
        return this.projectList.iterator().next().projectEnvironmentContext();
    }

    public WorkspaceResolution getResolution() {
        if (this.workspaceResolution == null) {
            this.workspaceResolution = WorkspaceResolution.from(this);
        }
        return this.workspaceResolution;
    }

    public WorkspaceResolution getResolution(ResolutionOptions resolutionOptions) {
        return WorkspaceResolution.from(this, resolutionOptions);
    }

    public List<BuildProject> projects() {
        return Collections.unmodifiableList(this.projectList);
    }

    public WorkspaceManifest manifest() {
        return this.workspaceManifest;
    }

    public WorkspaceBallerinaToml ballerinaToml() {
        return this.workspaceBallerinaToml;
    }

    public ProjectLoadResult reload(TomlDocument tomlDocument) {
        this.workspaceBallerinaToml = WorkspaceBallerinaToml.from(tomlDocument, this);
        this.workspaceManifest = WorkspaceManifestBuilder.from(tomlDocument, this.sourceRoot).manifest();
        this.projectList.clear();
        this.workspaceResolution = null;
        Environment environment = EnvironmentBuilder.getBuilder().setWorkspace(this).build();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        String org = null;
        for (Path pkgPath : this.workspaceManifest.packages()) {
            ProjectLoadResult buildProjectLoadResult = WorkspaceProject.loadBuildProject(environment, pkgPath, this, org);
            if (org == null) {
                org = buildProjectLoadResult.project().currentPackage().packageOrg().toString();
            }
            if (buildProjectLoadResult.diagnostics().hasErrors()) {
                diagnostics.addAll(buildProjectLoadResult.diagnostics().diagnostics());
                continue;
            }
            this.projectList.add((BuildProject)buildProjectLoadResult.project());
            diagnostics.addAll(buildProjectLoadResult.diagnostics().diagnostics());
        }
        return new ProjectLoadResult(this, new DefaultDiagnosticResult(diagnostics));
    }

    private static ProjectLoadResult loadBuildProject(Environment environment, Path packagePath, WorkspaceProject workspaceProject, String org) {
        ProjectEnvironmentBuilder projectEnvironmentBuilder = ProjectEnvironmentBuilder.getBuilder(environment);
        return BuildProject.loadProject(packagePath, projectEnvironmentBuilder, workspaceProject.buildOptions, workspaceProject, org);
    }
}

