/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.environment;

import io.ballerina.projects.CompilerPluginCache;
import io.ballerina.projects.directory.WorkspaceProject;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.PackageRepository;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.internal.environment.BallerinaDistribution;
import io.ballerina.projects.internal.environment.BallerinaUserHome;
import io.ballerina.projects.internal.environment.DefaultEnvironment;
import io.ballerina.projects.internal.environment.DefaultPackageResolver;
import io.ballerina.projects.internal.environment.EnvironmentPackageCache;
import io.ballerina.projects.internal.repositories.BallerinaDistributionRepository;
import io.ballerina.projects.internal.repositories.CustomPkgRepositoryContainer;
import io.ballerina.projects.internal.repositories.LocalPackageRepository;
import io.ballerina.projects.internal.repositories.RemotePackageRepository;
import io.ballerina.projects.internal.repositories.WorkspaceRepository;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class EnvironmentBuilder {
    private Path ballerinaHome;
    private Path userHome;
    private WorkspaceProject workspaceProject;

    public static EnvironmentBuilder getBuilder() {
        return new EnvironmentBuilder();
    }

    public static Environment buildDefault() {
        return new EnvironmentBuilder().build();
    }

    public EnvironmentBuilder setUserHome(Path userHome) {
        this.userHome = userHome;
        return this;
    }

    public EnvironmentBuilder setBallerinaHome(Path ballerinaHome) {
        this.ballerinaHome = ballerinaHome;
        return this;
    }

    public EnvironmentBuilder setWorkspace(WorkspaceProject workspaceProject) {
        this.workspaceProject = workspaceProject;
        return this;
    }

    public Environment build() {
        DefaultEnvironment environment = new DefaultEnvironment();
        BallerinaDistribution ballerinaDistribution = this.getBallerinaDistribution(environment);
        BallerinaDistributionRepository distributionRepository = ballerinaDistribution.packageRepository();
        environment.addService(PackageRepository.class, distributionRepository);
        EnvironmentPackageCache packageCache = new EnvironmentPackageCache();
        environment.addService(PackageCache.class, packageCache);
        BallerinaUserHome ballerinaUserHome = this.getBallerinaUserHome(environment);
        RemotePackageRepository ballerinaCentralRepo = ballerinaUserHome.remotePackageRepository();
        environment.addService(LocalPackageRepository.class, ballerinaUserHome.localPackageRepository());
        environment.addService(CustomPkgRepositoryContainer.class, ballerinaUserHome.customPkgRepositoryContainer());
        Map<String, PackageRepository> customRepositories = ballerinaUserHome.customRepositories().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        WorkspaceRepository workspaceRepository = null;
        if (this.workspaceProject != null) {
            workspaceRepository = new WorkspaceRepository(this.workspaceProject);
            environment.addService(WorkspaceRepository.class, workspaceRepository);
        }
        DefaultPackageResolver packageResolver = new DefaultPackageResolver(distributionRepository, ballerinaCentralRepo, ballerinaUserHome.localPackageRepository(), customRepositories, workspaceRepository, packageCache);
        environment.addService(PackageResolver.class, packageResolver);
        CompilerContext compilerContext = EnvironmentBuilder.populateCompilerContext();
        environment.addService(CompilerContext.class, compilerContext);
        ballerinaDistribution.loadLangLibPackages(compilerContext, packageResolver);
        environment.addService(CompilerPluginCache.class, new CompilerPluginCache());
        return environment;
    }

    private BallerinaDistribution getBallerinaDistribution(DefaultEnvironment environment) {
        return this.ballerinaHome != null ? BallerinaDistribution.from(environment, this.ballerinaHome) : BallerinaDistribution.from(environment);
    }

    private BallerinaUserHome getBallerinaUserHome(DefaultEnvironment environment) {
        return this.userHome != null ? BallerinaUserHome.from(environment, this.userHome) : BallerinaUserHome.from(environment);
    }

    private static CompilerContext populateCompilerContext() {
        CompilerContext compilerContext = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance(compilerContext);
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        return compilerContext;
    }
}

