/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.environment;

import io.ballerina.projects.environment.PackageLockingMode;

public class ResolutionOptions {
    private final boolean offline;
    private final boolean sticky;
    private final boolean dumpGraph;
    private final boolean dumpRawGraphs;
    private final PackageLockingMode packageLockingMode;

    private ResolutionOptions(boolean offline, boolean sticky, boolean dumpGraph, boolean dumpRawGraphs, PackageLockingMode packageLockingMode) {
        this.offline = offline;
        this.sticky = sticky;
        this.dumpGraph = dumpGraph;
        this.dumpRawGraphs = dumpRawGraphs;
        this.packageLockingMode = packageLockingMode;
    }

    public boolean offline() {
        return this.offline;
    }

    @Deprecated
    public boolean sticky() {
        return this.sticky;
    }

    public boolean dumpGraph() {
        return this.dumpGraph;
    }

    public boolean dumpRawGraphs() {
        return this.dumpRawGraphs;
    }

    public PackageLockingMode packageLockingMode() {
        return this.packageLockingMode;
    }

    public static ResolutionOptionBuilder builder() {
        return new ResolutionOptionBuilder();
    }

    public static class ResolutionOptionBuilder {
        private boolean offline = false;
        private boolean sticky = false;
        private boolean dumpGraph = false;
        private boolean dumpRawGraphs = false;
        private PackageLockingMode packageLockingMode = PackageLockingMode.SOFT;

        public ResolutionOptionBuilder setOffline(boolean value) {
            this.offline = value;
            return this;
        }

        @Deprecated(forRemoval=true, since="2201.13.0")
        public ResolutionOptionBuilder setSticky(boolean value) {
            this.sticky = value;
            return this;
        }

        public ResolutionOptionBuilder setDumpGraph(boolean value) {
            this.dumpGraph = value;
            return this;
        }

        public ResolutionOptionBuilder setDumpRawGraphs(boolean value) {
            this.dumpRawGraphs = value;
            return this;
        }

        public ResolutionOptionBuilder setPackageLockingMode(PackageLockingMode value) {
            this.packageLockingMode = value;
            return this;
        }

        public ResolutionOptions build() {
            return new ResolutionOptions(this.offline, this.sticky, this.dumpGraph, this.dumpRawGraphs, this.packageLockingMode);
        }
    }
}

