/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.internal.ManifestUtils;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlBooleanValueNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.validator.TomlValidator;
import io.ballerina.toml.validator.schema.Schema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BalToolsManifestBuilder {
    private final Optional<TomlDocument> balToolsToml;
    private final BalToolsManifest balToolsManifest;
    private final Map<String, OldTool> oldTools = new HashMap<String, OldTool>();

    private BalToolsManifestBuilder(TomlDocument balToolsToml) {
        this.balToolsToml = Optional.ofNullable(balToolsToml);
        this.balToolsManifest = this.parseAsBalToolsManifest();
    }

    public static BalToolsManifestBuilder from(TomlDocument balToolsToml) {
        return new BalToolsManifestBuilder(balToolsToml);
    }

    public static BalToolsManifestBuilder from(BalToolsToml balToolsToml) {
        return new BalToolsManifestBuilder(balToolsToml.tomlDocument());
    }

    public BalToolsManifest getBalToolsManifest() {
        return this.balToolsManifest;
    }

    public Map<String, OldTool> getOldTools() {
        return this.oldTools;
    }

    public BalToolsManifestBuilder removeTool(String id) {
        this.balToolsManifest.removeTool(id);
        return this;
    }

    private BalToolsManifest parseAsBalToolsManifest() {
        if (this.balToolsToml.isEmpty() || this.balToolsToml.get().toml().rootNode().entries().isEmpty()) {
            return BalToolsManifest.from();
        }
        this.validateBalToolsTomlAgainstSchema();
        Map<String, Map<String, Map<String, BalToolsManifest.Tool>>> tools = this.getTools();
        return BalToolsManifest.from(tools);
    }

    private void validateBalToolsTomlAgainstSchema() {
        TomlValidator balToolsTomlValidator;
        if (this.balToolsToml.isEmpty()) {
            return;
        }
        try {
            balToolsTomlValidator = new TomlValidator(Schema.from((String)FileUtils.readFileAsString("bal-tools-toml-schema.json")));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the bal-tools.toml validator schema file.");
        }
        balToolsTomlValidator.validate(this.balToolsToml.get().toml());
    }

    private Map<String, Map<String, Map<String, BalToolsManifest.Tool>>> getTools() {
        if (this.balToolsToml.isEmpty()) {
            return new HashMap<String, Map<String, Map<String, BalToolsManifest.Tool>>>();
        }
        TomlTableNode tomlTableNode = this.balToolsToml.get().toml().rootNode();
        if (tomlTableNode.entries().isEmpty()) {
            return new HashMap<String, Map<String, Map<String, BalToolsManifest.Tool>>>();
        }
        TopLevelNode toolEntries = (TopLevelNode)tomlTableNode.entries().get("tool");
        if (toolEntries == null || toolEntries.kind() == TomlType.NONE) {
            return new HashMap<String, Map<String, Map<String, BalToolsManifest.Tool>>>();
        }
        HashMap<String, Map<String, Map<String, BalToolsManifest.Tool>>> tools = new HashMap<String, Map<String, Map<String, BalToolsManifest.Tool>>>();
        if (toolEntries.kind() == TomlType.TABLE_ARRAY) {
            TomlTableArrayNode toolTableArray = (TomlTableArrayNode)toolEntries;
            for (TomlTableNode toolNode : toolTableArray.children()) {
                String id = this.getStringValueFromToolNode(toolNode, "id");
                String org = this.getStringValueFromToolNode(toolNode, "org");
                String name = this.getStringValueFromToolNode(toolNode, "name");
                String version = this.getStringValueFromToolNode(toolNode, "version");
                Optional<Boolean> active = this.getBooleanFromToolNode(toolNode, "active");
                String repository = this.getStringValueFromToolNode(toolNode, "repository");
                boolean force = this.getBooleanFromToolNode(toolNode, "force").orElse(false);
                if (id == null || org == null || name == null) continue;
                if (version == null || active.isEmpty()) {
                    this.oldTools.put(id, new OldTool(id, org, name));
                    continue;
                }
                try {
                    PackageVersion.from(version);
                }
                catch (ProjectException ignore) {
                    continue;
                }
                if (!tools.containsKey(id)) {
                    tools.put(id, new HashMap());
                }
                if (!((Map)tools.get(id)).containsKey(version)) {
                    ((Map)tools.get(id)).put(version, new HashMap());
                }
                ((Map)((Map)tools.get(id)).get(version)).put(repository, new BalToolsManifest.Tool(id, org, name, version, active.get(), repository, force));
            }
        }
        return tools;
    }

    private String getStringValueFromToolNode(TomlTableNode pkgNode, String key) {
        TopLevelNode topLevelNode = (TopLevelNode)pkgNode.entries().get(key);
        if (topLevelNode == null) {
            return null;
        }
        return ManifestUtils.getStringFromTomlTableNode(topLevelNode);
    }

    Optional<Boolean> getBooleanFromToolNode(TomlTableNode tableNode, String key) {
        TomlKeyValueNode keyValueNode;
        TomlValueNode value;
        TopLevelNode topLevelNode = (TopLevelNode)tableNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return Optional.empty();
        }
        if (topLevelNode.kind() == TomlType.KEY_VALUE && (value = (keyValueNode = (TomlKeyValueNode)topLevelNode).value()).kind() == TomlType.BOOLEAN) {
            TomlBooleanValueNode tomlBooleanValueNode = (TomlBooleanValueNode)value;
            return Optional.ofNullable((Boolean)tomlBooleanValueNode.getValue());
        }
        return Optional.empty();
    }

    public BalToolsManifest build() {
        return this.balToolsManifest;
    }

    public record OldTool(String id, String org, String name) {
    }
}

