/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DependencyManifest;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.internal.DocumentData;
import io.ballerina.projects.internal.ModuleData;
import io.ballerina.projects.internal.PackageData;
import io.ballerina.projects.internal.ProjectFiles;
import io.ballerina.projects.internal.bala.BalToolJson;
import io.ballerina.projects.internal.bala.BalaJson;
import io.ballerina.projects.internal.bala.CompilerPluginJson;
import io.ballerina.projects.internal.bala.DependencyGraphJson;
import io.ballerina.projects.internal.bala.ModuleDependency;
import io.ballerina.projects.internal.model.BalToolDescriptor;
import io.ballerina.projects.internal.model.CompilerPluginDescriptor;
import io.ballerina.projects.internal.model.Dependency;
import io.ballerina.projects.internal.model.PackageJson;
import io.ballerina.projects.util.ProjectUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class BalaFiles {
    private static final Gson gson = new Gson();

    private BalaFiles() {
    }

    static PackageData loadPackageData(Path balaPath, PackageJson packageJson) {
        if (balaPath.toFile().isDirectory()) {
            return BalaFiles.loadPackageDataFromBalaDir(balaPath, packageJson);
        }
        return BalaFiles.loadPackageDataFromBalaFile(balaPath, packageJson);
    }

    private static PackageData loadPackageDataFromBalaDir(Path balaPath, PackageJson packageJson) {
        String pkgName = packageJson.getName();
        ModuleData defaultModule = BalaFiles.loadModule(pkgName, pkgName, balaPath, packageJson);
        List<ModuleData> otherModules = BalaFiles.loadOtherModules(pkgName, balaPath, packageJson);
        List<Path> resources = ProjectFiles.loadResources(balaPath);
        if (resources.isEmpty()) {
            resources = ProjectFiles.loadResources(balaPath.resolve("modules").resolve(pkgName));
        }
        DocumentData readmeMd = packageJson.getReadme() == null ? BalaFiles.loadDocument(balaPath.resolve("docs").resolve("Package.md")) : BalaFiles.loadDocument(balaPath.resolve(packageJson.getReadme()));
        return PackageData.from(balaPath, defaultModule, otherModules, null, null, null, null, null, readmeMd, resources, Collections.emptyList());
    }

    private static PackageData loadPackageDataFromBalaFile(Path balaPath, PackageJson packageJson) {
        PackageData packageData;
        block9: {
            URI zipURI = BalaFiles.getZipURI(balaPath);
            FileSystem zipFileSystem = FileSystems.newFileSystem(zipURI, new HashMap());
            try {
                String pkgName = packageJson.getName();
                Path packageRoot = zipFileSystem.getPath("/", new String[0]);
                ModuleData defaultModule = BalaFiles.loadModule(pkgName, pkgName, packageRoot, packageJson);
                List<ModuleData> otherModules = BalaFiles.loadOtherModules(pkgName, packageRoot, packageJson);
                List<Path> resources = ProjectFiles.loadResources(packageRoot);
                if (resources.isEmpty()) {
                    resources = ProjectFiles.loadResources(packageRoot.resolve("modules").resolve(pkgName));
                }
                DocumentData readmeMd = packageJson.getReadme() == null ? BalaFiles.loadDocument(packageRoot.resolve("docs").resolve("Package.md")) : BalaFiles.loadDocument(packageRoot.resolve(packageJson.getReadme()));
                packageData = PackageData.from(balaPath, defaultModule, otherModules, null, null, null, null, null, readmeMd, resources, Collections.emptyList());
                if (zipFileSystem == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFileSystem != null) {
                        try {
                            zipFileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to read bala file:" + String.valueOf(balaPath));
                }
            }
            zipFileSystem.close();
        }
        return packageData;
    }

    private static void validatePackageJson(PackageJson packageJson, Path balaPath) {
        if (packageJson.getOrganization() == null || "".equals(packageJson.getOrganization())) {
            throw new ProjectException("'organization' does not exists in 'package.json': " + String.valueOf(balaPath));
        }
        if (packageJson.getName() == null || "".equals(packageJson.getName())) {
            throw new ProjectException("'name' does not exists in 'package.json': " + String.valueOf(balaPath));
        }
        if (packageJson.getVersion() == null || "".equals(packageJson.getVersion())) {
            throw new ProjectException("'version' does not exists in 'package.json': " + String.valueOf(balaPath));
        }
    }

    public static DocumentData loadDocument(Path documentFilePath) {
        if (Files.notExists(documentFilePath, new LinkOption[0])) {
            return null;
        }
        return ProjectFiles.getDocumentData(documentFilePath, false, Charset.defaultCharset());
    }

    private static ModuleData loadModule(String pkgName, String fullModuleName, Path packagePath, PackageJson packageJson) {
        Optional<PackageManifest.Module> module;
        Path modulePath = packagePath.resolve("modules").resolve(fullModuleName);
        Path moduleDocPath = packagePath.resolve("docs").resolve("modules").resolve(fullModuleName);
        if (Files.notExists(modulePath, new LinkOption[0])) {
            throw new ProjectException("The 'modules' directory does not exists in '" + String.valueOf(modulePath) + "'");
        }
        String moduleName = fullModuleName;
        if (!pkgName.equals(moduleName)) {
            moduleName = fullModuleName.substring(pkgName.length() + 1);
        }
        if (!ProjectUtils.validateModuleName(moduleName)) {
            throw new ProjectException("Invalid module name : '" + moduleName + "' :\nModule name can only contain alphanumerics, underscores and periods: " + String.valueOf(modulePath));
        }
        if (!ProjectUtils.validateNameLength(moduleName)) {
            throw new ProjectException("Invalid module name : '" + moduleName + "' :\nMaximum length of module name is 256 characters: " + String.valueOf(modulePath));
        }
        List<DocumentData> srcDocs = ProjectFiles.loadDocuments(modulePath);
        List<DocumentData> testSrcDocs = Collections.emptyList();
        DocumentData readmeMd = null;
        if (packageJson.getReadme() == null) {
            readmeMd = BalaFiles.loadDocument(moduleDocPath.resolve("Module.md"));
        } else if (packageJson.getModules() != null && (module = packageJson.getModules().stream().filter(mod -> fullModuleName.equals(mod.name())).findAny()).isPresent() && module.get().readme() != null && !module.get().readme().isEmpty()) {
            readmeMd = BalaFiles.loadDocument(packagePath.resolve(module.get().readme()));
        }
        return ModuleData.from(modulePath, moduleName, srcDocs, testSrcDocs, readmeMd);
    }

    private static List<ModuleData> loadOtherModules(String pkgName, Path packagePath, PackageJson packageJson) {
        List<ModuleData> list;
        block8: {
            Path modulesDirPath = packagePath.resolve("modules");
            Stream<Path> pathStream = Files.walk(modulesDirPath, 1, new FileVisitOption[0]);
            try {
                list = pathStream.filter(path -> !path.equals(modulesDirPath)).filter(path -> path.getFileName() != null && !path.getFileName().toString().equals(pkgName)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(modulePath -> modulePath.getFileName().toString()).map(fullModuleName -> BalaFiles.loadModule(pkgName, fullModuleName, packagePath, packageJson)).toList();
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to read modules from directory: " + String.valueOf(modulesDirPath), e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    public static PackageManifest createPackageManifest(Path balaPath) {
        if (balaPath.toFile().isDirectory()) {
            return BalaFiles.createPackageManifestFromBalaDir(balaPath);
        }
        return BalaFiles.createPackageManifestFromBalaFile(balaPath);
    }

    public static DependencyManifest createDependencyManifest(Path balaPath) {
        if (balaPath.toFile().isDirectory()) {
            return BalaFiles.createDependencyManifestFromBalaDir(balaPath);
        }
        return BalaFiles.createDependencyManifestFromBalaFile(balaPath);
    }

    public static DependencyGraphResult createPackageDependencyGraph(Path balaPath) {
        DependencyGraphResult dependencyGraphResult;
        if (balaPath.toFile().isDirectory()) {
            Path dependencyGraphJsonPath = balaPath.resolve("dependency-graph.json");
            dependencyGraphResult = BalaFiles.createPackageDependencyGraphFromJson(dependencyGraphJsonPath);
        } else {
            URI zipURI = BalaFiles.getZipURI(balaPath);
            try (FileSystem zipFileSystem = FileSystems.newFileSystem(zipURI, new HashMap());){
                Path dependencyGraphJsonPath = zipFileSystem.getPath("dependency-graph.json", new String[0]);
                dependencyGraphResult = BalaFiles.createPackageDependencyGraphFromJson(dependencyGraphJsonPath);
            }
            catch (IOException e) {
                throw new ProjectException("Failed to read balr file:" + String.valueOf(balaPath));
            }
        }
        return dependencyGraphResult;
    }

    static DependencyGraphResult createPackageDependencyGraphFromJson(Path dependencyGraphJsonPath) {
        if (Files.notExists(dependencyGraphJsonPath, new LinkOption[0])) {
            throw new ProjectException(String.valueOf(dependencyGraphJsonPath) + " does not exist.'");
        }
        DependencyGraphJson dependencyGraphJson = BalaFiles.readDependencyGraphJson(dependencyGraphJsonPath);
        DependencyGraph<PackageDescriptor> packageDependencyGraph = BalaFiles.createPackageDependencyGraph(dependencyGraphJson.getPackageDependencyGraph());
        Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDescriptorListMap = BalaFiles.createModuleDescDependencies(dependencyGraphJson.getModuleDependencies());
        return new DependencyGraphResult(packageDependencyGraph, moduleDescriptorListMap);
    }

    private static PackageManifest createPackageManifestFromBalaFile(Path balrPath) {
        PackageManifest packageManifest;
        block11: {
            URI zipURI = BalaFiles.getZipURI(balrPath);
            FileSystem zipFileSystem = FileSystems.newFileSystem(zipURI, new HashMap());
            try {
                Path packageJsonPath = zipFileSystem.getPath("package.json", new String[0]);
                if (Files.notExists(packageJsonPath, new LinkOption[0])) {
                    throw new ProjectException("package.json does not exists in '" + String.valueOf(balrPath) + "'");
                }
                PackageJson packageJson = BalaFiles.readPackageJson(balrPath, packageJsonPath);
                BalaFiles.validatePackageJson(packageJson, balrPath);
                BalaFiles.extractPlatformLibraries(packageJson, balrPath, zipFileSystem);
                Optional<Object> compilerPluginJson = Optional.empty();
                Path compilerPluginJsonPath = zipFileSystem.getPath("compiler-plugin", "compiler-plugin.json");
                if (!Files.notExists(compilerPluginJsonPath, new LinkOption[0])) {
                    compilerPluginJson = Optional.of(BalaFiles.readCompilerPluginJson(balrPath, compilerPluginJsonPath));
                    BalaFiles.extractCompilerPluginLibraries((CompilerPluginJson)compilerPluginJson.get(), balrPath, zipFileSystem);
                }
                Optional<BalToolJson> balToolJson = Optional.empty();
                Path balToolJsonPath = zipFileSystem.getPath("tool", "bal-tool.json");
                if (!Files.notExists(balToolJsonPath, new LinkOption[0])) {
                    balToolJson = Optional.of(BalaFiles.readBalToolJson(balrPath, balToolJsonPath));
                    BalaFiles.extractBalToolLibraries(balToolJson, balrPath, zipFileSystem);
                }
                packageManifest = BalaFiles.getPackageManifest(packageJson, compilerPluginJson, balToolJson, null);
                if (zipFileSystem == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFileSystem != null) {
                        try {
                            zipFileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to read balr file:" + String.valueOf(balrPath));
                }
            }
            zipFileSystem.close();
        }
        return packageManifest;
    }

    private static PackageManifest createPackageManifestFromBalaDir(Path balrPath) {
        Path packageJsonPath = balrPath.resolve("package.json");
        if (Files.notExists(packageJsonPath, new LinkOption[0])) {
            throw new ProjectException("package.json does not exists in '" + String.valueOf(balrPath) + "'");
        }
        PackageJson packageJson = BalaFiles.readPackageJson(balrPath, packageJsonPath);
        BalaFiles.validatePackageJson(packageJson, balrPath);
        Optional<Object> compilerPluginJson = Optional.empty();
        Path compilerPluginJsonPath = balrPath.resolve("compiler-plugin").resolve("compiler-plugin.json");
        if (!Files.notExists(compilerPluginJsonPath, new LinkOption[0])) {
            compilerPluginJson = Optional.of(BalaFiles.readCompilerPluginJson(balrPath, compilerPluginJsonPath));
            BalaFiles.setCompilerPluginDependencyPaths((CompilerPluginJson)compilerPluginJson.get(), balrPath);
        }
        Optional<BalToolJson> balToolJson = Optional.empty();
        Path balToolJsonPath = balrPath.resolve("tool").resolve("bal-tool.json");
        if (Files.exists(balToolJsonPath, new LinkOption[0])) {
            balToolJson = Optional.of(BalaFiles.readBalToolJson(balrPath, balToolJsonPath));
            BalaFiles.setBalToolDependencyPaths(balToolJson.get(), balrPath);
        }
        return BalaFiles.getPackageManifest(packageJson, compilerPluginJson, balToolJson, BalaFiles.getDeprecationMsg(balrPath));
    }

    private static String getDeprecationMsg(Path balaPath) {
        Path deprecateFilePath = balaPath.resolve("deprecated.txt");
        if (Files.exists(deprecateFilePath, new LinkOption[0])) {
            StringBuilder fileContents = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new FileReader(deprecateFilePath.toString(), Charset.defaultCharset()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    fileContents.append(line).append("\n");
                }
            }
            catch (IOException e) {
                throw new ProjectException("unable to read content from the file 'deprecated.txt'", e);
            }
            if (fileContents.isEmpty()) {
                return "";
            }
            return fileContents.substring(0, fileContents.length() - 1);
        }
        return null;
    }

    private static DependencyManifest createDependencyManifestFromBalaFile(Path balrPath) {
        DependencyManifest dependencyManifest;
        block9: {
            URI zipURI = URI.create("jar:" + String.valueOf(balrPath.toAbsolutePath().toUri()));
            FileSystem zipFileSystem = FileSystems.newFileSystem(zipURI, new HashMap());
            try {
                Path depsGraphJsonPath = zipFileSystem.getPath("dependency-graph.json", new String[0]);
                if (Files.notExists(depsGraphJsonPath, new LinkOption[0])) {
                    throw new ProjectException("dependency-graph.json does not exists in '" + String.valueOf(balrPath) + "'");
                }
                DependencyGraphJson dependencyGraphJson = BalaFiles.readDependencyGraphJson(balrPath, depsGraphJsonPath);
                dependencyManifest = BalaFiles.getDependencyManifest(dependencyGraphJson);
                if (zipFileSystem == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFileSystem != null) {
                        try {
                            zipFileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to read balr file:" + String.valueOf(balrPath));
                }
            }
            zipFileSystem.close();
        }
        return dependencyManifest;
    }

    private static DependencyManifest createDependencyManifestFromBalaDir(Path balrPath) {
        Path depsGraphJsonPath = balrPath.resolve("dependency-graph.json");
        if (Files.notExists(depsGraphJsonPath, new LinkOption[0])) {
            throw new ProjectException("dependency-graph.json does not exists in '" + String.valueOf(balrPath) + "'");
        }
        DependencyGraphJson dependencyGraphJson = BalaFiles.readDependencyGraphJson(balrPath, depsGraphJsonPath);
        return BalaFiles.getDependencyManifest(dependencyGraphJson);
    }

    private static void extractPlatformLibraries(PackageJson packageJson, Path balaPath, FileSystem zipFileSystem) {
        if (packageJson.getPlatformDependencies() == null) {
            return;
        }
        packageJson.getPlatformDependencies().forEach(dependency -> {
            if (!Objects.equals(PlatformLibraryScope.PROVIDED.getStringValue(), dependency.getScope())) {
                Path libPath = balaPath.getParent().resolve(dependency.getPath());
                if (!Files.exists(libPath, new LinkOption[0])) {
                    try {
                        Files.createDirectories(libPath.getParent(), new FileAttribute[0]);
                        Files.copy(zipFileSystem.getPath(dependency.getPath(), new String[0]), libPath, new CopyOption[0]);
                    }
                    catch (IOException e) {
                        throw new ProjectException("Failed to extract platform dependency:" + String.valueOf(libPath.getFileName()), e);
                    }
                }
                dependency.setPath(libPath.toString());
            }
        });
    }

    private static void extractCompilerPluginLibraries(CompilerPluginJson compilerPluginJson, Path balaPath, FileSystem zipFileSystem) {
        if (compilerPluginJson.dependencyPaths() == null) {
            return;
        }
        ArrayList<String> dependencyLibPaths = new ArrayList<String>();
        compilerPluginJson.dependencyPaths().forEach(dependencyPath -> {
            Path libPath = balaPath.getParent().resolve((String)dependencyPath).normalize();
            if (!Files.exists(libPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(libPath.getParent(), new FileAttribute[0]);
                    Path libPathInZip = Path.of(dependencyPath, new String[0]);
                    if (!dependencyPath.contains("compiler-plugin")) {
                        libPathInZip = Path.of("compiler-plugin", String.valueOf(libPathInZip));
                    }
                    Files.copy(zipFileSystem.getPath(String.valueOf(libPathInZip), new String[0]), libPath, new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to extract compiler plugin dependency:" + String.valueOf(libPath.getFileName()), e);
                }
            }
            dependencyLibPaths.add(libPath.toString());
        });
        compilerPluginJson.setDependencyPaths(dependencyLibPaths);
    }

    private static void extractBalToolLibraries(Optional<BalToolJson> balToolJson, Path balaPath, FileSystem zipFileSystem) {
        if (balToolJson.isEmpty() || balToolJson.get().dependencyPaths() == null) {
            return;
        }
        ArrayList<String> dependencyLibPaths = new ArrayList<String>();
        balToolJson.get().dependencyPaths().forEach(dependencyPath -> {
            Path libPath = balaPath.getParent().resolve((String)dependencyPath).normalize();
            if (!Files.exists(libPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(libPath.getParent(), new FileAttribute[0]);
                    Path libPathInZip = Path.of(dependencyPath, new String[0]);
                    if (!dependencyPath.contains("tool")) {
                        libPathInZip = Path.of("tool", String.valueOf(libPathInZip));
                    }
                    Files.copy(zipFileSystem.getPath(String.valueOf(libPathInZip), new String[0]), libPath, new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to extract bal tool dependency:" + String.valueOf(libPath.getFileName()), e);
                }
            }
            dependencyLibPaths.add(libPath.toString());
        });
        balToolJson.get().setDependencyPaths(dependencyLibPaths);
    }

    private static void setCompilerPluginDependencyPaths(CompilerPluginJson compilerPluginJson, Path balaPath) {
        if (compilerPluginJson.dependencyPaths() == null) {
            return;
        }
        ArrayList<String> dependencyLibPaths = new ArrayList<String>();
        compilerPluginJson.dependencyPaths().forEach(dependencyPath -> {
            Path libPath = balaPath.resolve((String)dependencyPath);
            dependencyLibPaths.add(libPath.toString());
        });
        compilerPluginJson.setDependencyPaths(dependencyLibPaths);
    }

    private static void setBalToolDependencyPaths(BalToolJson balToolJson, Path balaPath) {
        if (balToolJson.dependencyPaths() == null) {
            return;
        }
        ArrayList<String> dependencyLibPaths = new ArrayList<String>();
        balToolJson.dependencyPaths().forEach(dependencyPath -> {
            Path libPath = balaPath.resolve((String)dependencyPath);
            dependencyLibPaths.add(libPath.toString());
        });
        balToolJson.setDependencyPaths(dependencyLibPaths);
    }

    private static PackageManifest getPackageManifest(PackageJson packageJson, Optional<CompilerPluginJson> compilerPluginJson, Optional<BalToolJson> balToolJson, String deprecationMsg) {
        PackageDescriptor pkgDesc = deprecationMsg != null ? PackageDescriptor.from(PackageOrg.from(packageJson.getOrganization()), PackageName.from(packageJson.getName()), PackageVersion.from(packageJson.getVersion()), true, deprecationMsg) : PackageDescriptor.from(PackageOrg.from(packageJson.getOrganization()), PackageName.from(packageJson.getName()), PackageVersion.from(packageJson.getVersion()));
        Map<String, PackageManifest.Platform> platforms = BalaFiles.getPlatforms(packageJson);
        ArrayList<PackageManifest.Dependency> dependencies = new ArrayList<PackageManifest.Dependency>();
        if (packageJson.getLocalDependencies() != null) {
            packageJson.getLocalDependencies().forEach(localDependency -> {
                PackageManifest.Dependency dependency = new PackageManifest.Dependency(PackageName.from(localDependency.getName()), PackageOrg.from(localDependency.getOrg()), PackageVersion.from(localDependency.getVersion()), localDependency.getRepository());
                dependencies.add(dependency);
            });
        }
        CompilerPluginDescriptor compilerPluginDescriptor = compilerPluginJson.map(CompilerPluginDescriptor::from).orElse(null);
        BalToolDescriptor balToolDescriptor = balToolJson.map(BalToolDescriptor::from).orElse(null);
        List<Object> exports = new ArrayList<String>();
        if (packageJson.getExport() == null) {
            exports.add(packageJson.getName());
            if (packageJson.getModules() != null) {
                exports.addAll(packageJson.getModules().stream().filter(PackageManifest.Module::export).map(PackageManifest.Module::name).toList());
            }
        } else {
            exports = packageJson.getExport();
        }
        return PackageManifest.from(pkgDesc, compilerPluginDescriptor, balToolDescriptor, platforms, dependencies, packageJson.getLicenses(), packageJson.getAuthors(), packageJson.getKeywords(), exports, packageJson.getInclude(), packageJson.getSourceRepository(), packageJson.getBallerinaVersion(), packageJson.getVisibility(), packageJson.getTemplate(), packageJson.getReadme(), packageJson.getDescription(), packageJson.getModules());
    }

    private static Map<String, PackageManifest.Platform> getPlatforms(PackageJson packageJson) {
        ArrayList<Map<String, Object>> platformDependencies = new ArrayList<Map<String, Object>>();
        Boolean graalvmCompatible = null;
        HashMap<String, PackageManifest.Platform> platforms = new HashMap<String, PackageManifest.Platform>();
        if (packageJson.getPlatformDependencies() != null) {
            packageJson.getPlatformDependencies().forEach(dependency -> {
                String jsonStr = gson.toJson(dependency);
                platformDependencies.add((Map)gson.fromJson(jsonStr, Map.class));
            });
        }
        if (packageJson.getGraalvmCompatible() != null) {
            graalvmCompatible = packageJson.getGraalvmCompatible();
        }
        PackageManifest.Platform platform = new PackageManifest.Platform(platformDependencies, Collections.emptyList(), graalvmCompatible);
        platforms.put(packageJson.getPlatform(), platform);
        return platforms;
    }

    private static DependencyManifest getDependencyManifest(DependencyGraphJson dependencyGraphJson) {
        ArrayList<DependencyManifest.Package> packages = new ArrayList<DependencyManifest.Package>();
        for (Dependency dependency : dependencyGraphJson.getPackageDependencyGraph()) {
            ArrayList<DependencyManifest.Dependency> dependencies = new ArrayList<DependencyManifest.Dependency>();
            ArrayList<DependencyManifest.Module> modules = new ArrayList<DependencyManifest.Module>();
            for (Dependency transDependency : dependency.getDependencies()) {
                DependencyManifest.Dependency dep = new DependencyManifest.Dependency(PackageName.from(transDependency.getName()), PackageOrg.from(transDependency.getOrg()));
                dependencies.add(dep);
            }
            if (dependency.getModules() != null && !dependency.getModules().isEmpty()) {
                for (Dependency.Module depModule : dependency.getModules()) {
                    DependencyManifest.Module module = new DependencyManifest.Module(depModule.org(), depModule.packageName(), depModule.moduleName());
                    modules.add(module);
                }
            }
            DependencyManifest.Package pkg = new DependencyManifest.Package(PackageName.from(dependency.getName()), PackageOrg.from(dependency.getOrg()), PackageVersion.from(dependency.getVersion()), dependency.getScope() != null ? dependency.getScope().name() : null, dependency.isTransitive(), dependencies, modules);
            packages.add(pkg);
        }
        return DependencyManifest.from(null, null, packages, Collections.emptyList());
    }

    private static PackageJson readPackageJson(Path balaPath, Path packageJsonPath) {
        PackageJson packageJson;
        try (BufferedReader bufferedReader = Files.newBufferedReader(packageJsonPath);){
            packageJson = (PackageJson)gson.fromJson((Reader)bufferedReader, PackageJson.class);
        }
        catch (JsonSyntaxException e) {
            throw new ProjectException("Invalid package.json format in '" + String.valueOf(balaPath) + "'");
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the package.json in '" + String.valueOf(balaPath) + "'");
        }
        return packageJson;
    }

    public static PackageJson readPkgJson(Path packageJsonPath) {
        PackageJson packageJson;
        try (BufferedReader bufferedReader = Files.newBufferedReader(packageJsonPath);){
            packageJson = (PackageJson)gson.fromJson((Reader)bufferedReader, PackageJson.class);
        }
        catch (JsonSyntaxException e) {
            throw new ProjectException("Invalid package.json format");
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the package.json");
        }
        return packageJson;
    }

    private static DependencyGraphJson readDependencyGraphJson(Path balaPath, Path depsGraphJsonPath) {
        DependencyGraphJson dependencyGraphJson;
        try (BufferedReader bufferedReader = Files.newBufferedReader(depsGraphJsonPath);){
            dependencyGraphJson = (DependencyGraphJson)gson.fromJson((Reader)bufferedReader, DependencyGraphJson.class);
        }
        catch (JsonSyntaxException e) {
            throw new ProjectException("Invalid dependency-graph.json format in '" + String.valueOf(balaPath) + "'");
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the dependency-graph.json in '" + String.valueOf(balaPath) + "'");
        }
        return dependencyGraphJson;
    }

    private static CompilerPluginJson readCompilerPluginJson(Path balaPath, Path compilerPluginJsonPath) {
        CompilerPluginJson pluginJson;
        try (BufferedReader bufferedReader = Files.newBufferedReader(compilerPluginJsonPath);){
            pluginJson = (CompilerPluginJson)gson.fromJson((Reader)bufferedReader, CompilerPluginJson.class);
        }
        catch (JsonSyntaxException e) {
            throw new ProjectException("Invalid compiler-plugin.json format in '" + String.valueOf(balaPath) + "'");
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the compiler-plugin.json in '" + String.valueOf(balaPath) + "'");
        }
        return pluginJson;
    }

    private static BalToolJson readBalToolJson(Path balaPath, Path balToolJsonPath) {
        BalToolJson balToolJson;
        try (BufferedReader bufferedReader = Files.newBufferedReader(balToolJsonPath);){
            balToolJson = (BalToolJson)gson.fromJson((Reader)bufferedReader, BalToolJson.class);
        }
        catch (JsonSyntaxException e) {
            throw new ProjectException("Invalid bal-tool.json format in '" + String.valueOf(balaPath) + "'");
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the bal-tool.json in '" + String.valueOf(balaPath) + "'");
        }
        return balToolJson;
    }

    private static DependencyGraph<PackageDescriptor> createPackageDependencyGraph(List<Dependency> packageDependencyGraph) {
        DependencyGraph.DependencyGraphBuilder<PackageDescriptor> graphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder();
        for (Dependency dependency : packageDependencyGraph) {
            PackageDescriptor pkg = PackageDescriptor.from(PackageOrg.from(dependency.getOrg()), PackageName.from(dependency.getName()), PackageVersion.from(dependency.getVersion()));
            HashSet<PackageDescriptor> dependentPackages = new HashSet<PackageDescriptor>();
            for (Dependency dependencyPkg : dependency.getDependencies()) {
                dependentPackages.add(PackageDescriptor.from(PackageOrg.from(dependencyPkg.getOrg()), PackageName.from(dependencyPkg.getName()), PackageVersion.from(dependencyPkg.getVersion())));
            }
            graphBuilder.addDependencies(pkg, dependentPackages);
        }
        return graphBuilder.build();
    }

    private static Map<ModuleDescriptor, List<ModuleDescriptor>> createModuleDescDependencies(List<ModuleDependency> modDepEntries) {
        return modDepEntries.stream().collect(Collectors.toMap(BalaFiles::getModuleDescriptorFromDependencyEntry, modDepEntry -> BalaFiles.createModDescriptorList(modDepEntry.getDependencies())));
    }

    private static ModuleDescriptor getModuleDescriptorFromDependencyEntry(ModuleDependency modDepEntry) {
        ModuleName moduleName;
        PackageDescriptor pkgDesc = PackageDescriptor.from(PackageOrg.from(modDepEntry.getOrg()), PackageName.from(modDepEntry.getPackageName()), PackageVersion.from(modDepEntry.getVersion()));
        if (modDepEntry.getModuleName().equals(pkgDesc.name().toString())) {
            moduleName = ModuleName.from(pkgDesc.name());
        } else {
            String moduleNamePart = modDepEntry.getModuleName().split(modDepEntry.getPackageName() + ".", 2)[1];
            moduleName = ModuleName.from(pkgDesc.name(), moduleNamePart);
        }
        return ModuleDescriptor.from(moduleName, pkgDesc);
    }

    private static List<ModuleDescriptor> createModDescriptorList(List<ModuleDependency> modDepEntries) {
        return modDepEntries.stream().map(BalaFiles::getModuleDescriptorFromDependencyEntry).toList();
    }

    private static DependencyGraphJson readDependencyGraphJson(Path dependencyGraphJsonPath) {
        DependencyGraphJson dependencyGraphJson;
        try (BufferedReader bufferedReader = Files.newBufferedReader(dependencyGraphJsonPath);){
            dependencyGraphJson = (DependencyGraphJson)gson.fromJson((Reader)bufferedReader, DependencyGraphJson.class);
        }
        catch (JsonSyntaxException e) {
            throw new ProjectException("Invalid dependency-graph.json format in '" + String.valueOf(dependencyGraphJsonPath) + "'");
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the dependency-graph.json in '" + String.valueOf(dependencyGraphJsonPath) + "'");
        }
        return dependencyGraphJson;
    }

    public static PackageJson readPackageJson(Path balaPath) {
        PackageJson packageJson;
        if (balaPath.toFile().isDirectory()) {
            Path packageJsonPath = balaPath.resolve("package.json");
            if (Files.notExists(packageJsonPath, new LinkOption[0])) {
                throw new ProjectException("package.json does not exists in '" + String.valueOf(balaPath) + "'");
            }
            packageJson = BalaFiles.readPackageJson(balaPath, packageJsonPath);
        } else {
            URI zipURI = BalaFiles.getZipURI(balaPath);
            try (FileSystem zipFileSystem = FileSystems.newFileSystem(zipURI, new HashMap());){
                Path packageJsonPath = zipFileSystem.getPath("package.json", new String[0]);
                if (Files.notExists(packageJsonPath, new LinkOption[0])) {
                    throw new ProjectException("package.json does not exists in '" + String.valueOf(balaPath) + "'");
                }
                packageJson = BalaFiles.readPackageJson(balaPath, packageJsonPath);
            }
            catch (IOException e) {
                throw new ProjectException("Failed to read balr file:" + String.valueOf(balaPath));
            }
        }
        return packageJson;
    }

    public static BalaJson readBalaJson(Path balaPath) {
        BalaJson balaJson;
        block29: {
            if (balaPath.toFile().isDirectory()) {
                Path balaJsonPath = balaPath.resolve("bala.json");
                if (Files.notExists(balaJsonPath, new LinkOption[0])) {
                    throw new ProjectException("bala.json does not exists in '" + String.valueOf(balaPath) + "'");
                }
                try (BufferedReader bufferedReader = Files.newBufferedReader(balaJsonPath);){
                    balaJson = (BalaJson)gson.fromJson((Reader)bufferedReader, BalaJson.class);
                    break block29;
                }
                catch (JsonSyntaxException e) {
                    throw new ProjectException("Invalid bala.json format in '" + String.valueOf(balaPath) + "'");
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to read the bala.json in '" + String.valueOf(balaPath) + "'");
                }
            }
            URI zipURI = BalaFiles.getZipURI(balaPath);
            try (FileSystem zipFileSystem = FileSystems.newFileSystem(zipURI, new HashMap());){
                Path balaJsonPath = zipFileSystem.getPath("bala.json", new String[0]);
                if (Files.notExists(balaJsonPath, new LinkOption[0])) {
                    throw new ProjectException("package.json does not exists in '" + String.valueOf(balaPath) + "'");
                }
                try (BufferedReader bufferedReader = Files.newBufferedReader(balaJsonPath);){
                    balaJson = (BalaJson)gson.fromJson((Reader)bufferedReader, BalaJson.class);
                }
                catch (JsonSyntaxException e) {
                    throw new ProjectException("Invalid package.json format in '" + String.valueOf(balaPath) + "'");
                }
                catch (IOException e) {
                    throw new ProjectException("Failed to read the package.json in '" + String.valueOf(balaPath) + "'");
                }
            }
            catch (IOException e) {
                throw new ProjectException("Failed to read bala file:" + String.valueOf(balaPath));
            }
        }
        return balaJson;
    }

    private static URI getZipURI(Path balaPath) {
        return URI.create("jar:" + String.valueOf(balaPath.toAbsolutePath().toUri()));
    }

    public static class DependencyGraphResult {
        private final DependencyGraph<PackageDescriptor> packageDependencyGraph;
        private final Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDependencies;

        DependencyGraphResult(DependencyGraph<PackageDescriptor> packageDependencyGraph, Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDependencies) {
            this.packageDependencyGraph = packageDependencyGraph;
            this.moduleDependencies = moduleDependencies;
        }

        public DependencyGraph<PackageDescriptor> packageDependencyGraph() {
            return this.packageDependencyGraph;
        }

        public Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDependencies() {
            return this.moduleDependencies;
        }
    }
}

