/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.DependencyManifest;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.PackageContainer;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.internal.repositories.AbstractPackageRepository;
import io.ballerina.projects.internal.repositories.MavenPackageRepository;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BlendedManifest {
    private final PackageContainer<Dependency> depContainer;
    private final DiagnosticResult diagnosticResult;
    private static final Repository REPOSITORY_LOCAL = new Repository("local");
    private static final Repository REPOSITORY_NOT_SPECIFIED = new Repository("not_specified");

    private BlendedManifest(PackageContainer<Dependency> pkgContainer, DiagnosticResult diagnosticResult) {
        this.depContainer = pkgContainer;
        this.diagnosticResult = diagnosticResult;
    }

    public static BlendedManifest from(DependencyManifest dependencyManifest, PackageManifest packageManifest, AbstractPackageRepository localPackageRepository, Map<String, MavenPackageRepository> mavenPackageRepositoryMap, boolean offline) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        PackageContainer<Dependency> depContainer = new PackageContainer<Dependency>();
        for (DependencyManifest.Package pkgInDepManifest : dependencyManifest.packages()) {
            PackageName pkgName;
            PackageOrg pkgOrg = pkgInDepManifest.org();
            PackageVersion pkgVersion = ProjectUtils.isBuiltInPackage(pkgOrg, (pkgName = pkgInDepManifest.name()).toString()) ? PackageVersion.BUILTIN_PACKAGE_VERSION : pkgInDepManifest.version();
            depContainer.add(pkgOrg, pkgName, new Dependency(pkgOrg, pkgName, pkgVersion, BlendedManifest.getRelation(pkgInDepManifest.isTransitive()), REPOSITORY_NOT_SPECIFIED, BlendedManifest.moduleNames(pkgInDepManifest), DependencyOrigin.LOCKED, false));
        }
        for (PackageManifest.Dependency depInPkgManifest : packageManifest.dependencies()) {
            Repository depInPkgManifestRepo;
            AbstractPackageRepository targetRepository = localPackageRepository;
            Optional<Dependency> existingDepOptional = depContainer.get(depInPkgManifest.org(), depInPkgManifest.name());
            Repository repository = depInPkgManifestRepo = depInPkgManifest.repository() != null && depInPkgManifest.repository().equals("local") ? REPOSITORY_LOCAL : new Repository(depInPkgManifest.repository());
            if (depInPkgManifest.repository() != null) {
                PackageDiagnostic diagnostic;
                DiagnosticInfo diagnosticInfo;
                if (!depInPkgManifest.repository().equals("local") && !mavenPackageRepositoryMap.containsKey(depInPkgManifest.repository())) {
                    diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.CUSTOM_REPOSITORY_NOT_FOUND.diagnosticId(), "Provided custom repository (" + depInPkgManifest.repository() + ") cannot be found in the Settings.toml. ", DiagnosticSeverity.WARNING);
                    diagnostic = new PackageDiagnostic(diagnosticInfo, depInPkgManifest.location().orElseThrow());
                    diagnostics.add(diagnostic);
                    continue;
                }
                if (depInPkgManifest.repository().equals("local") && !localPackageRepository.isPackageExists(depInPkgManifest.org(), depInPkgManifest.name(), depInPkgManifest.version())) {
                    diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.PACKAGE_NOT_FOUND.diagnosticId(), "Dependency version (" + String.valueOf(depInPkgManifest.version()) + ") cannot be found in the local repository. org: `" + String.valueOf(depInPkgManifest.org()) + "` name: " + String.valueOf(depInPkgManifest.name()), DiagnosticSeverity.WARNING);
                    diagnostic = new PackageDiagnostic(diagnosticInfo, depInPkgManifest.location().orElseThrow());
                    diagnostics.add(diagnostic);
                    continue;
                }
                if (!depInPkgManifest.repository().equals("local") && !((MavenPackageRepository)(targetRepository = (AbstractPackageRepository)mavenPackageRepositoryMap.get(depInPkgManifest.repository()))).isPackageExists(depInPkgManifest.org(), depInPkgManifest.name(), depInPkgManifest.version(), offline)) {
                    diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.PACKAGE_NOT_FOUND.diagnosticId(), "Dependency version (" + String.valueOf(depInPkgManifest.version()) + ") cannot be found in the custom repository (" + depInPkgManifest.repository() + "). org: `" + String.valueOf(depInPkgManifest.org()) + "` name: " + String.valueOf(depInPkgManifest.name()), DiagnosticSeverity.WARNING);
                    diagnostic = new PackageDiagnostic(diagnosticInfo, depInPkgManifest.location().orElseThrow());
                    diagnostics.add(diagnostic);
                    continue;
                }
            } else {
                List<String> moduleNames = existingDepOptional.isPresent() ? existingDepOptional.get().modules : Collections.emptyList();
                Optional<Dependency> dependency = depContainer.get(depInPkgManifest.org(), depInPkgManifest.name());
                if (dependency.isPresent() && dependency.get().version().compareTo(depInPkgManifest.version()) == SemanticVersion.VersionCompatibilityResult.GREATER_THAN) continue;
                depContainer.add(depInPkgManifest.org(), depInPkgManifest.name(), new Dependency(depInPkgManifest.org(), depInPkgManifest.name(), depInPkgManifest.version(), DependencyRelation.UNKNOWN, REPOSITORY_NOT_SPECIFIED, moduleNames, DependencyOrigin.USER_SPECIFIED, depInPkgManifest.skipWorkspace()));
                continue;
            }
            if (existingDepOptional.isEmpty()) {
                depContainer.add(depInPkgManifest.org(), depInPkgManifest.name(), new Dependency(depInPkgManifest.org(), depInPkgManifest.name(), depInPkgManifest.version(), DependencyRelation.UNKNOWN, depInPkgManifestRepo, BlendedManifest.moduleNames(depInPkgManifest, targetRepository), DependencyOrigin.USER_SPECIFIED, depInPkgManifest.skipWorkspace()));
                continue;
            }
            Dependency existingDep = existingDepOptional.get();
            SemanticVersion.VersionCompatibilityResult compatibilityResult = depInPkgManifest.version().compareTo(existingDep.version());
            if (compatibilityResult == SemanticVersion.VersionCompatibilityResult.EQUAL || compatibilityResult == SemanticVersion.VersionCompatibilityResult.GREATER_THAN) {
                Dependency newDep = new Dependency(depInPkgManifest.org(), depInPkgManifest.name(), depInPkgManifest.version(), DependencyRelation.UNKNOWN, depInPkgManifestRepo, BlendedManifest.moduleNames(depInPkgManifest, targetRepository), DependencyOrigin.USER_SPECIFIED, depInPkgManifest.skipWorkspace());
                depContainer.add(depInPkgManifest.org(), depInPkgManifest.name(), newDep);
                continue;
            }
            if (compatibilityResult != SemanticVersion.VersionCompatibilityResult.INCOMPATIBLE) continue;
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.INCOMPATIBLE_DEPENDENCY_VERSIONS.diagnosticId(), "Dependency version (" + String.valueOf(depInPkgManifest.version()) + ") is incompatible with the version locked in Dependencies.toml (" + String.valueOf(existingDep.version) + "). org: `" + String.valueOf(existingDep.org()) + "` name: " + String.valueOf(existingDep.name()), DiagnosticSeverity.ERROR);
            PackageDiagnostic diagnostic = new PackageDiagnostic(diagnosticInfo, depInPkgManifest.location().orElseThrow());
            diagnostics.add(diagnostic);
            Dependency newDep = new Dependency(existingDep.org(), existingDep.name(), existingDep.version(), existingDep.relation, existingDep.repository, existingDep.modules, existingDep.origin, true, existingDep.skipWorkspace);
            depContainer.add(depInPkgManifest.org(), depInPkgManifest.name(), newDep);
        }
        return new BlendedManifest(depContainer, new DefaultDiagnosticResult(diagnostics));
    }

    private static DependencyRelation getRelation(boolean isTransitive) {
        return isTransitive ? DependencyRelation.TRANSITIVE : DependencyRelation.DIRECT;
    }

    private static Collection<String> moduleNames(DependencyManifest.Package dependency) {
        return dependency.modules().stream().map(DependencyManifest.Module::moduleName).toList();
    }

    private static Collection<String> moduleNames(PackageManifest.Dependency dependency, AbstractPackageRepository localPackageRepository) {
        Collection<ModuleDescriptor> moduleDescriptors = localPackageRepository.getModules(dependency.org(), dependency.name(), dependency.version());
        return moduleDescriptors.stream().map(moduleDesc -> moduleDesc.name().toString()).toList();
    }

    public Optional<Dependency> lockedDependency(PackageOrg org, PackageName name) {
        return this.dependency(org, name, DependencyOrigin.LOCKED);
    }

    public Collection<Dependency> lockedDependencies() {
        return this.dependencies(DependencyOrigin.LOCKED);
    }

    public Optional<Dependency> userSpecifiedDependency(PackageOrg org, PackageName name) {
        return this.dependency(org, name, DependencyOrigin.USER_SPECIFIED);
    }

    public Collection<Dependency> userSpecifiedDependencies() {
        return this.dependencies(DependencyOrigin.USER_SPECIFIED);
    }

    public Optional<Dependency> dependency(PackageOrg org, PackageName name) {
        return this.depContainer.get(org, name);
    }

    public Collection<Dependency> dependencies() {
        return this.depContainer.getAll();
    }

    public Dependency dependencyOrThrow(PackageOrg org, PackageName name) {
        return this.depContainer.get(org, name).orElseThrow(() -> new IllegalStateException("Dependency with org `" + String.valueOf(org) + "` and name `" + String.valueOf(name) + "` must exists."));
    }

    private Optional<Dependency> dependency(PackageOrg org, PackageName name, DependencyOrigin origin) {
        return this.depContainer.get(org, name).filter(dep -> dep.origin == origin);
    }

    private Collection<Dependency> dependencies(DependencyOrigin origin) {
        return this.depContainer.getAll().stream().filter(dep -> dep.origin == origin).toList();
    }

    public DiagnosticResult diagnosticResult() {
        return this.diagnosticResult;
    }

    public static class Dependency {
        private final PackageOrg org;
        private final PackageName name;
        private final PackageVersion version;
        private final DependencyRelation relation;
        private final Repository repository;
        private final Collection<String> modules;
        private final DependencyOrigin origin;
        private final boolean isError;
        private final boolean skipWorkspace;

        private Dependency(PackageOrg org, PackageName name, PackageVersion version, DependencyRelation relation, Repository repository, Collection<String> modules, DependencyOrigin origin, boolean skipWorkspace) {
            this.org = org;
            this.name = name;
            this.version = version;
            this.repository = repository;
            this.relation = relation;
            this.modules = modules;
            this.origin = origin;
            this.isError = false;
            this.skipWorkspace = skipWorkspace;
        }

        private Dependency(PackageOrg org, PackageName name, PackageVersion version, DependencyRelation relation, Repository repository, Collection<String> modules, DependencyOrigin origin, boolean isError, boolean skipWorkspace) {
            this.org = org;
            this.name = name;
            this.version = version;
            this.repository = repository;
            this.relation = relation;
            this.modules = modules;
            this.origin = origin;
            this.isError = isError;
            this.skipWorkspace = skipWorkspace;
        }

        public PackageName name() {
            return this.name;
        }

        public PackageOrg org() {
            return this.org;
        }

        public PackageVersion version() {
            return this.version;
        }

        public boolean isFromLocalRepository() {
            return BlendedManifest.REPOSITORY_LOCAL.repositoryName.equals(this.repository.repositoryName);
        }

        public boolean isFromCustomRepository() {
            return this.repository() != null && !BlendedManifest.REPOSITORY_LOCAL.repositoryName.equals(this.repository.repositoryName);
        }

        public String repository() {
            return !BlendedManifest.REPOSITORY_NOT_SPECIFIED.repositoryName.equals(this.repository.repositoryName) ? this.repository.repositoryName : null;
        }

        public DependencyRelation relation() {
            return this.relation;
        }

        public DependencyOrigin origin() {
            return this.origin;
        }

        public Collection<String> moduleNames() {
            return this.modules;
        }

        public boolean isError() {
            return this.isError;
        }

        public boolean skipWorkspace() {
            return this.skipWorkspace;
        }
    }

    public static enum DependencyRelation {
        DIRECT,
        TRANSITIVE,
        UNKNOWN;

    }

    private static class Repository {
        private final String repositoryName;

        Repository(String repository) {
            this.repositoryName = repository;
        }
    }

    public static enum DependencyOrigin {
        USER_SPECIFIED,
        LOCKED;

    }
}

