/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.BuildToolId;
import io.ballerina.projects.DependencyManifest;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.exceptions.CorruptedDependenciesTomlException;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.ManifestUtils;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlArrayValueNode;
import io.ballerina.toml.semantic.ast.TomlInlineTableValueNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.validator.TomlValidator;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DependencyManifestBuilder {
    private final Optional<TomlDocument> dependenciesToml;
    private final PackageDescriptor packageDescriptor;
    private DiagnosticResult diagnostics;
    private final List<Diagnostic> diagnosticList;
    private final DependencyManifest dependencyManifest;
    private static final String LATEST_DEPS_TOML_VERSION = "2";
    private static final String DEPENDENCIES_TOML_VERSION_NAME = "dependencies-toml-version";
    private static final String DISTRIBUTION_VERSION_NAME = "distribution-version";
    private static final String BALLERINA = "ballerina";
    private static final String TOOL = "tool";
    private static final String ID = "id";
    private static final String ORG = "org";
    private static final String NAME = "name";
    private static final String VERSION = "version";

    private DependencyManifestBuilder(TomlDocument dependenciesToml, PackageDescriptor packageDescriptor) {
        this.dependenciesToml = Optional.ofNullable(dependenciesToml);
        this.packageDescriptor = packageDescriptor;
        this.diagnosticList = new ArrayList<Diagnostic>();
        DependencyManifest parsedDependecyManifest = this.parseAsDependencyManifest();
        if (parsedDependecyManifest.diagnostics().hasErrors()) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.CORRUPTED_DEPENDENCIES_TOML.diagnosticId(), "Detected corrupted 'Dependencies.toml' file. Dependencies will be updated to the latest versions.", DiagnosticSeverity.WARNING);
            Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)this.dependenciesToml.get().toml().rootNode().location(), (Object[])new Object[0]);
            this.dependencyManifest = DependencyManifest.from(null, null, Collections.emptyList(), Collections.emptyList(), new DefaultDiagnosticResult(List.of(diagnostic)));
        } else {
            this.dependencyManifest = parsedDependecyManifest;
        }
    }

    public static DependencyManifestBuilder from(TomlDocument dependenciesToml, PackageDescriptor packageDescriptor) {
        return new DependencyManifestBuilder(dependenciesToml, packageDescriptor);
    }

    public DiagnosticResult diagnostics() {
        if (this.diagnostics != null) {
            return this.diagnostics;
        }
        this.dependenciesToml.ifPresent(tomlDocument -> this.diagnosticList.addAll(tomlDocument.toml().diagnostics()));
        this.diagnostics = new DefaultDiagnosticResult(this.diagnosticList);
        return this.diagnostics;
    }

    public String getErrorMessage() {
        StringBuilder message = new StringBuilder();
        message.append("Dependencies.toml contains errors\n");
        for (Diagnostic diagnostic : this.diagnostics().errors()) {
            message.append(ManifestUtils.convertDiagnosticToString(diagnostic));
            message.append("\n");
        }
        return message.toString();
    }

    public DependencyManifest dependencyManifest() {
        return this.dependencyManifest;
    }

    private DependencyManifest parseAsDependencyManifest() {
        if (this.dependenciesToml.isEmpty() || this.dependenciesToml.get().toml().rootNode().entries().isEmpty()) {
            return DependencyManifest.from(null, null, Collections.emptyList(), Collections.emptyList(), this.diagnostics());
        }
        String dependenciesTomlVersion = this.getDependenciesTomlVersion();
        SemanticVersion distributionVersion = this.getDistributionVersion();
        try {
            if (dependenciesTomlVersion != null) {
                this.validateDependenciesTomlAgainstSchema("dependencies-toml-schema.json");
                List<DependencyManifest.Package> packages = this.getPackages();
                List<DependencyManifest.Tool> tools = this.getTools();
                return DependencyManifest.from(dependenciesTomlVersion, distributionVersion, packages, tools, this.diagnostics());
            }
        }
        catch (CorruptedDependenciesTomlException e) {
            this.reportDiagnostic("Detected corrupted 'Dependencies.toml' file. This will be updated to latest dependencies.", ProjectDiagnosticErrorCode.CORRUPTED_DEPENDENCIES_TOML.diagnosticId(), DiagnosticSeverity.WARNING, (Location)this.dependenciesToml.get().toml().rootNode().location());
            return DependencyManifest.from(null, null, Collections.emptyList(), Collections.emptyList(), this.diagnostics());
        }
        this.reportDiagnostic("Detected an old version of 'Dependencies.toml' file. This will be updated to v2 format.", ProjectDiagnosticErrorCode.OLD_DEPENDENCIES_TOML.diagnosticId(), DiagnosticSeverity.WARNING, (Location)this.dependenciesToml.get().toml().rootNode().location());
        this.validateDependenciesTomlAgainstSchema("old-dependencies-toml-schema.json");
        List<DependencyManifest.Package> packages = this.getPackagesFromOldBallerinaToml();
        return DependencyManifest.from(null, null, packages, Collections.emptyList(), this.diagnostics());
    }

    private void validateDependenciesTomlAgainstSchema(String schemaName) {
        if (this.dependenciesToml.isPresent()) {
            TomlValidator dependenciesTomlValidator;
            try {
                dependenciesTomlValidator = new TomlValidator(Schema.from((String)FileUtils.readFileAsString(schemaName)));
            }
            catch (IOException e) {
                throw new ProjectException("Failed to read the Dependencies.toml validator schema file:" + schemaName);
            }
            dependenciesTomlValidator.validate(this.dependenciesToml.get().toml());
        }
    }

    private String getDependenciesTomlVersion() {
        if (this.dependenciesToml.isEmpty()) {
            return LATEST_DEPS_TOML_VERSION;
        }
        TomlTableNode tomlTableNode = this.dependenciesToml.get().toml().rootNode();
        if (tomlTableNode.entries().isEmpty()) {
            return null;
        }
        TopLevelNode ballerinaEntries = (TopLevelNode)tomlTableNode.entries().get(BALLERINA);
        if (ballerinaEntries == null || ballerinaEntries.kind() == TomlType.NONE) {
            return null;
        }
        if (ballerinaEntries.kind() == TomlType.TABLE) {
            TomlTableNode ballerinaTableNode = (TomlTableNode)ballerinaEntries;
            return this.getStringValueFromDependencyNode(ballerinaTableNode, DEPENDENCIES_TOML_VERSION_NAME);
        }
        return null;
    }

    private SemanticVersion getDistributionVersion() {
        if (this.dependenciesToml.isEmpty()) {
            return null;
        }
        TomlTableNode tomlTableNode = this.dependenciesToml.get().toml().rootNode();
        if (tomlTableNode.entries().isEmpty()) {
            return null;
        }
        TopLevelNode ballerinaEntries = (TopLevelNode)tomlTableNode.entries().get(BALLERINA);
        if (ballerinaEntries == null || ballerinaEntries.kind() == TomlType.NONE) {
            return null;
        }
        if (ballerinaEntries.kind() == TomlType.TABLE) {
            TomlTableNode ballerinaTableNode = (TomlTableNode)ballerinaEntries;
            String distributionVersionString = this.getStringValueFromDependencyNode(ballerinaTableNode, DISTRIBUTION_VERSION_NAME);
            if (distributionVersionString == null) {
                return null;
            }
            try {
                return SemanticVersion.from(distributionVersionString);
            }
            catch (ProjectException ignore) {
                return null;
            }
        }
        return null;
    }

    private List<DependencyManifest.Package> getPackages() {
        if (this.dependenciesToml.isEmpty()) {
            return Collections.emptyList();
        }
        TomlTableNode tomlTableNode = this.dependenciesToml.get().toml().rootNode();
        if (tomlTableNode.entries().isEmpty()) {
            return Collections.emptyList();
        }
        TopLevelNode packageEntries = (TopLevelNode)tomlTableNode.entries().get("package");
        if (packageEntries == null || packageEntries.kind() == TomlType.NONE) {
            return Collections.emptyList();
        }
        ArrayList<DependencyManifest.Package> dependencies = new ArrayList<DependencyManifest.Package>();
        if (packageEntries.kind() == TomlType.TABLE_ARRAY) {
            TomlTableArrayNode dependencyTableArray = (TomlTableArrayNode)packageEntries;
            List<DependencyManifest.Dependency> directDependencies = this.getRootPackageDependencies(dependencyTableArray);
            for (TomlTableNode dependencyNode : dependencyTableArray.children()) {
                PackageVersion depVersion;
                String name = this.getStringValueFromDependencyNode(dependencyNode, NAME);
                String org = this.getStringValueFromDependencyNode(dependencyNode, ORG);
                String version = this.getStringValueFromDependencyNode(dependencyNode, VERSION);
                if (name == null || org == null || version == null) continue;
                String scope = this.getStringValueFromDependencyNode(dependencyNode, "scope");
                boolean transitive = this.isTransitive(directDependencies, this.packageDescriptor, org, name);
                List<DependencyManifest.Dependency> transDependencies = this.getDependenciesFromDependencyNode(dependencyNode);
                List<DependencyManifest.Module> modules = this.getModulesFromDependencyNode(dependencyNode);
                PackageName depName = PackageName.from(name);
                PackageOrg depOrg = PackageOrg.from(org);
                try {
                    depVersion = PackageVersion.from(version);
                }
                catch (ProjectException e) {
                    continue;
                }
                dependencies.add(new DependencyManifest.Package(depName, depOrg, depVersion, scope, transitive, transDependencies, modules, (Location)dependencyNode.location()));
            }
        }
        return dependencies;
    }

    private List<DependencyManifest.Tool> getTools() {
        if (this.dependenciesToml.isEmpty()) {
            return Collections.emptyList();
        }
        TomlTableNode tomlTableNode = this.dependenciesToml.get().toml().rootNode();
        if (tomlTableNode.entries().isEmpty()) {
            return Collections.emptyList();
        }
        TopLevelNode toolEntries = (TopLevelNode)tomlTableNode.entries().get(TOOL);
        if (toolEntries == null || toolEntries.kind() == TomlType.NONE) {
            return Collections.emptyList();
        }
        ArrayList<DependencyManifest.Tool> tools = new ArrayList<DependencyManifest.Tool>();
        if (toolEntries.kind() == TomlType.TABLE_ARRAY) {
            TomlTableArrayNode toolTableArray = (TomlTableArrayNode)toolEntries;
            for (TomlTableNode toolNode : toolTableArray.children()) {
                PackageVersion toolVersion;
                String id = this.getStringValueFromDependencyNode(toolNode, ID);
                String org = this.getStringValueFromDependencyNode(toolNode, ORG);
                String name = this.getStringValueFromDependencyNode(toolNode, NAME);
                String version = this.getStringValueFromDependencyNode(toolNode, VERSION);
                if (id == null || org == null || name == null || version == null) continue;
                BuildToolId toolId = BuildToolId.from(id);
                PackageOrg toolOrg = PackageOrg.from(org);
                PackageName toolName = PackageName.from(name);
                try {
                    toolVersion = PackageVersion.from(version);
                }
                catch (ProjectException e) {
                    continue;
                }
                tools.add(new DependencyManifest.Tool(toolId, toolOrg, toolName, toolVersion, (Location)toolNode.location()));
            }
        }
        return tools;
    }

    private List<DependencyManifest.Package> getPackagesFromOldBallerinaToml() {
        if (this.dependenciesToml.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DependencyManifest.Package> packages = new ArrayList<DependencyManifest.Package>();
        TomlTableNode tomlTableNode = this.dependenciesToml.get().toml().rootNode();
        if (tomlTableNode.entries().isEmpty()) {
            return Collections.emptyList();
        }
        TopLevelNode dependencyEntries = (TopLevelNode)tomlTableNode.entries().get("dependency");
        if (dependencyEntries == null || dependencyEntries.kind() == TomlType.NONE) {
            return Collections.emptyList();
        }
        if (dependencyEntries.kind() == TomlType.TABLE_ARRAY) {
            TomlTableArrayNode dependencyTableArray = (TomlTableArrayNode)dependencyEntries;
            for (TomlTableNode dependencyNode : dependencyTableArray.children()) {
                PackageVersion depVersion;
                String name = this.getStringValueFromDependencyNode(dependencyNode, NAME);
                String org = this.getStringValueFromDependencyNode(dependencyNode, ORG);
                String version = this.getStringValueFromDependencyNode(dependencyNode, VERSION);
                if (name == null || org == null || version == null) continue;
                PackageName depName = PackageName.from(name);
                PackageOrg depOrg = PackageOrg.from(org);
                try {
                    depVersion = PackageVersion.from(version);
                }
                catch (ProjectException e) {
                    continue;
                }
                if (dependencyNode.entries().containsKey("repository")) {
                    String repository = this.getStringValueFromDependencyNode(dependencyNode, "repository");
                    String message = "Detected local dependency declarations in 'Dependencies.toml' file. Add them to 'Ballerina.toml' using following syntax:\n[[dependency]]\norg = \"" + String.valueOf(depOrg) + "\"\nname = \"" + String.valueOf(depName) + "\"\nversion = \"" + String.valueOf(depVersion) + "\"\nrepository = \"" + repository + "\"\n";
                    this.reportDiagnostic(message, ProjectDiagnosticErrorCode.LOCAL_PACKAGES_IN_DEPENDENCIES_TOML.diagnosticId(), DiagnosticSeverity.WARNING, (Location)dependencyNode.location());
                    continue;
                }
                packages.add(new DependencyManifest.Package(depName, depOrg, depVersion, (Location)dependencyNode.location()));
            }
        }
        return packages;
    }

    private String getStringValueFromDependencyNode(TomlTableNode pkgNode, String key) {
        TopLevelNode topLevelNode = (TopLevelNode)pkgNode.entries().get(key);
        if (topLevelNode == null) {
            return null;
        }
        return ManifestUtils.getStringFromTomlTableNode(topLevelNode);
    }

    private List<DependencyManifest.Dependency> getDependenciesFromDependencyNode(TomlTableNode pkgNode) {
        TomlValueNode transDepsValueNode;
        ArrayList<DependencyManifest.Dependency> transDependencies = new ArrayList<DependencyManifest.Dependency>();
        TopLevelNode topLevelNode = (TopLevelNode)pkgNode.entries().get("dependencies");
        if (topLevelNode == null) {
            return transDependencies;
        }
        if (topLevelNode.kind() != null && topLevelNode.kind() == TomlType.KEY_VALUE && (transDepsValueNode = ((TomlKeyValueNode)topLevelNode).value()) != null && transDepsValueNode.kind() == TomlType.ARRAY) {
            TomlArrayValueNode transDepsArrayValueNode = (TomlArrayValueNode)transDepsValueNode;
            for (TomlValueNode transDepValueNode : transDepsArrayValueNode.elements()) {
                if (transDepValueNode == null || transDepValueNode.kind() != TomlType.INLINE_TABLE) continue;
                String orgValue = null;
                String nameValue = null;
                TomlInlineTableValueNode inlineTableNode = (TomlInlineTableValueNode)transDepValueNode;
                for (TopLevelNode inlineTableEntry : inlineTableNode.elements()) {
                    if (inlineTableEntry == null || inlineTableEntry.kind() != TomlType.KEY_VALUE) continue;
                    TomlKeyValueNode inlineTableKeyValue = (TomlKeyValueNode)inlineTableEntry;
                    if (inlineTableKeyValue.key().name().equals(ORG)) {
                        orgValue = inlineTableKeyValue.value().toString();
                        continue;
                    }
                    if (!inlineTableKeyValue.key().name().equals(NAME)) continue;
                    nameValue = inlineTableKeyValue.value().toString();
                }
                if (orgValue == null || nameValue == null) continue;
                transDependencies.add(new DependencyManifest.Dependency(PackageName.from(nameValue), PackageOrg.from(orgValue)));
            }
        }
        return transDependencies;
    }

    private List<DependencyManifest.Module> getModulesFromDependencyNode(TomlTableNode pkgNode) {
        TomlValueNode transDepsValueNode;
        ArrayList<DependencyManifest.Module> modules = new ArrayList<DependencyManifest.Module>();
        TopLevelNode topLevelNode = (TopLevelNode)pkgNode.entries().get("modules");
        if (topLevelNode == null) {
            return modules;
        }
        if (topLevelNode.kind() != null && topLevelNode.kind() == TomlType.KEY_VALUE && (transDepsValueNode = ((TomlKeyValueNode)topLevelNode).value()) != null && transDepsValueNode.kind() == TomlType.ARRAY) {
            TomlArrayValueNode transDepsArrayValueNode = (TomlArrayValueNode)transDepsValueNode;
            for (TomlValueNode transDepValueNode : transDepsArrayValueNode.elements()) {
                if (transDepValueNode == null || transDepValueNode.kind() != TomlType.INLINE_TABLE) continue;
                String orgValue = null;
                String pkgNameValue = null;
                String moduleNameValue = null;
                TomlInlineTableValueNode inlineTableNode = (TomlInlineTableValueNode)transDepValueNode;
                for (TopLevelNode inlineTableEntry : inlineTableNode.elements()) {
                    if (inlineTableEntry == null || inlineTableEntry.kind() != TomlType.KEY_VALUE) continue;
                    TomlKeyValueNode inlineTableKeyValue = (TomlKeyValueNode)inlineTableEntry;
                    if (ORG.equals(inlineTableKeyValue.key().name())) {
                        orgValue = inlineTableKeyValue.value().toString();
                        continue;
                    }
                    if ("packageName".equals(inlineTableKeyValue.key().name())) {
                        pkgNameValue = inlineTableKeyValue.value().toString();
                        continue;
                    }
                    if (!"moduleName".equals(inlineTableKeyValue.key().name())) continue;
                    moduleNameValue = inlineTableKeyValue.value().toString();
                }
                if (orgValue == null || pkgNameValue == null || moduleNameValue == null) continue;
                modules.add(new DependencyManifest.Module(orgValue, pkgNameValue, moduleNameValue));
            }
        }
        return modules;
    }

    void reportDiagnostic(String message, String diagnosticErrorCode, DiagnosticSeverity severity, Location location) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticErrorCode, message, severity);
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]);
        this.diagnosticList.add(diagnostic);
    }

    private List<DependencyManifest.Dependency> getRootPackageDependencies(TomlTableArrayNode dependencyTableArray) {
        for (TomlTableNode dependencyNode : dependencyTableArray.children()) {
            String name = this.getStringValueFromDependencyNode(dependencyNode, NAME);
            String org = this.getStringValueFromDependencyNode(dependencyNode, ORG);
            if (name == null || org == null || !this.packageDescriptor.org().value().equals(org) || !this.packageDescriptor.name().value().equals(name)) continue;
            return this.getDependenciesFromDependencyNode(dependencyNode);
        }
        throw new CorruptedDependenciesTomlException("Cannot find root package in the Dependencies.toml");
    }

    private boolean isTransitive(List<DependencyManifest.Dependency> directDependencies, PackageDescriptor packageDescriptor, String org, String name) {
        if (packageDescriptor.org().value().equals(org) && packageDescriptor.name().value().equals(name)) {
            return false;
        }
        for (DependencyManifest.Dependency dependency : directDependencies) {
            if (!dependency.org().value().equals(org) || !dependency.name().value().equals(name)) continue;
            return false;
        }
        return true;
    }
}

