/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import java.util.function.Supplier;

public abstract class DocumentData {
    private final String name;

    private DocumentData(String name) {
        this.name = name;
    }

    public static DocumentData from(String name, String content) {
        return new EagerDocumentData(name, content);
    }

    public static DocumentData from(String name, Supplier<String> content) {
        return new LazyDocumentData(name, content);
    }

    public abstract String content();

    public String name() {
        return this.name;
    }

    private static class EagerDocumentData
    extends DocumentData {
        private final String content;

        private EagerDocumentData(String name, String content) {
            super(name);
            this.content = content;
        }

        @Override
        public String content() {
            return this.content;
        }
    }

    private static class LazyDocumentData
    extends DocumentData {
        private final Supplier<String> contentSupplier;

        public LazyDocumentData(String name, Supplier<String> content) {
            super(name);
            this.contentSupplier = content;
        }

        @Override
        public String content() {
            String s = this.contentSupplier.get();
            assert (s != null) : "LazyDocumentData content supplier should not return null";
            return s;
        }
    }
}

