/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.compiler.syntax.tree.ExternalFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NaturalExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import java.util.Optional;

public class NaturalProgrammingImportAnalyzer
extends NodeVisitor {
    private boolean shouldImportNaturalProgrammingModule = false;
    private Optional<String> naturalLangLibPrefix = Optional.of("'natural");
    private static final String BALLERINA = "ballerina";
    private static final String LANG = "lang";
    private static final String NATURAL = "natural";
    private static final String NATURAL_WITH_QUOTE = "'natural";
    private static final String CODE_ANNOTATION = "code";

    public boolean shouldImportNaturalProgrammingModule(ModulePartNode modulePartNode) {
        modulePartNode.accept((NodeVisitor)this);
        return this.shouldImportNaturalProgrammingModule;
    }

    public void visit(ImportDeclarationNode importDeclarationNode) {
        Optional<Object> prefixStr = Optional.empty();
        boolean isNaturalPrefix = false;
        Optional prefix = importDeclarationNode.prefix();
        if (prefix.isPresent()) {
            String prefixValue = ((ImportPrefixNode)prefix.get()).prefix().text();
            if (NATURAL_WITH_QUOTE.equals(prefixValue)) {
                isNaturalPrefix = true;
            }
            prefixStr = Optional.of(prefixValue);
        }
        if (this.isNaturalLangLibImport(importDeclarationNode)) {
            if (prefixStr.isPresent() && !isNaturalPrefix) {
                this.naturalLangLibPrefix = prefixStr;
            }
            return;
        }
        if (isNaturalPrefix && this.naturalLangLibPrefix.isPresent() && NATURAL_WITH_QUOTE.equals(this.naturalLangLibPrefix.get())) {
            this.naturalLangLibPrefix = Optional.empty();
        }
    }

    public void visit(NaturalExpressionNode naturalExpressionNode) {
        this.shouldImportNaturalProgrammingModule = true;
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        if (this.shouldImportNaturalProgrammingModule) {
            return;
        }
        if (this.isExternalFunctionWithCodeAnnotation(functionDefinitionNode)) {
            this.shouldImportNaturalProgrammingModule = true;
            return;
        }
        super.visit(functionDefinitionNode);
    }

    private boolean isExternalFunctionWithCodeAnnotation(FunctionDefinitionNode functionDefinitionNode) {
        FunctionBodyNode functionBodyNode = functionDefinitionNode.functionBody();
        if (!(functionBodyNode instanceof ExternalFunctionBodyNode)) {
            return false;
        }
        ExternalFunctionBodyNode externalFunctionBodyNode = (ExternalFunctionBodyNode)functionBodyNode;
        if (this.naturalLangLibPrefix.isEmpty()) {
            return false;
        }
        return externalFunctionBodyNode.annotations().stream().anyMatch(annotation -> {
            Node patt0$temp = annotation.annotReference();
            if (!(patt0$temp instanceof QualifiedNameReferenceNode)) return false;
            QualifiedNameReferenceNode qualifiedNameReferenceNode = (QualifiedNameReferenceNode)patt0$temp;
            if (!this.isNaturalPrefix(this.naturalLangLibPrefix.get())) return false;
            if (!this.isNaturalPrefix(qualifiedNameReferenceNode.modulePrefix().text())) return false;
            if (!CODE_ANNOTATION.equals(qualifiedNameReferenceNode.identifier().text())) return false;
            return true;
        });
    }

    protected void visitSyntaxNode(Node node) {
        if (this.shouldImportNaturalProgrammingModule) {
            return;
        }
        super.visitSyntaxNode(node);
    }

    private boolean isNaturalLangLibImport(ImportDeclarationNode importDeclarationNode) {
        Optional importOrgNameNode = importDeclarationNode.orgName();
        if (importOrgNameNode.isEmpty() || !BALLERINA.equals(((ImportOrgNameNode)importOrgNameNode.get()).orgName().text())) {
            return false;
        }
        SeparatedNodeList moduleName = importDeclarationNode.moduleName();
        return moduleName.size() == 2 && ((IdentifierToken)moduleName.get(0)).text().equals(LANG) && ((IdentifierToken)moduleName.get(1)).text().equals(NATURAL_WITH_QUOTE);
    }

    private boolean isNaturalPrefix(String prefix) {
        return NATURAL.equals(prefix) || NATURAL_WITH_QUOTE.equals(prefix);
    }
}

