/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DependencyManifest;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleConfig;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageConfig;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ResourceConfig;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.internal.BalaFiles;
import io.ballerina.projects.internal.DependencyManifestBuilder;
import io.ballerina.projects.internal.DocumentData;
import io.ballerina.projects.internal.ManifestBuilder;
import io.ballerina.projects.internal.ModuleData;
import io.ballerina.projects.internal.PackageData;
import io.ballerina.projects.internal.ProjectFiles;
import io.ballerina.projects.internal.ProvidedResourceConfig;
import io.ballerina.projects.internal.model.PackageJson;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public final class PackageConfigCreator {
    private PackageConfigCreator() {
    }

    public static PackageConfig createBuildProjectConfig(Path projectDirPath, boolean disableSyntaxTree) {
        return PackageConfigCreator.createBuildProjectConfig(projectDirPath, disableSyntaxTree, null);
    }

    public static PackageConfig createBuildProjectConfig(Path projectDirPath, boolean disableSyntaxTree, String org) {
        ProjectFiles.validateBuildProjectDirPath(projectDirPath);
        PackageData packageData = ProjectFiles.loadBuildProjectPackageData(projectDirPath);
        if (packageData.ballerinaToml().isEmpty()) {
            throw new ProjectException("Ballerina.toml not found");
        }
        TomlDocument ballerinaToml = packageData.ballerinaToml().map(d -> TomlDocument.from("Ballerina.toml", d.content())).orElse(null);
        TomlDocument dependenciesToml = packageData.dependenciesToml().map(d -> TomlDocument.from("Dependencies.toml", d.content())).orElse(null);
        TomlDocument pluginToml = packageData.compilerPluginToml().map(d -> TomlDocument.from("CompilerPlugin.toml", d.content())).orElse(null);
        TomlDocument balToolToml = packageData.balToolToml().map(d -> TomlDocument.from("BalTool.toml", d.content())).orElse(null);
        ManifestBuilder manifestBuilder = ManifestBuilder.from(ballerinaToml, pluginToml, balToolToml, projectDirPath, org);
        PackageManifest packageManifest = manifestBuilder.packageManifest();
        DependencyManifestBuilder dependencyManifestBuilder = DependencyManifestBuilder.from(dependenciesToml, packageManifest.descriptor());
        DependencyManifest dependencyManifest = dependencyManifestBuilder.dependencyManifest();
        return PackageConfigCreator.createPackageConfig(packageData, packageManifest, dependencyManifest, DependencyGraph.emptyGraph(), Collections.emptyMap(), disableSyntaxTree);
    }

    public static PackageConfig createBuildProjectConfig(Path projectDirPath) {
        return PackageConfigCreator.createBuildProjectConfig(projectDirPath, false, null);
    }

    public static PackageConfig createSingleFileProjectConfig(Path filePath, Boolean disableSyntaxTree) {
        ProjectFiles.validateSingleFileProjectFilePath(filePath);
        PackageDescriptor packageDesc = PackageDescriptor.from(PackageOrg.from("$anon"), PackageName.from("."), PackageVersion.from("0.0.0"));
        PackageManifest packageManifest = PackageManifest.from(packageDesc);
        DependencyManifest dependencyManifest = DependencyManifest.from(null, null, Collections.emptyList(), Collections.emptyList());
        PackageData packageData = ProjectFiles.loadSingleFileProjectPackageData(filePath);
        return PackageConfigCreator.createPackageConfig(packageData, packageManifest, dependencyManifest, DependencyGraph.emptyGraph(), Collections.emptyMap(), disableSyntaxTree);
    }

    public static PackageConfig createSingleFileProjectConfig(Path filePath) {
        return PackageConfigCreator.createSingleFileProjectConfig(filePath, false);
    }

    public static PackageConfig createBalaProjectConfig(Path balaPath) {
        ProjectFiles.validateBalaProjectPath(balaPath);
        PackageManifest packageManifest = BalaFiles.createPackageManifest(balaPath);
        DependencyManifest dependencyManifest = BalaFiles.createDependencyManifest(balaPath);
        PackageJson packageJson = BalaFiles.readPackageJson(balaPath);
        PackageData packageData = BalaFiles.loadPackageData(balaPath, packageJson);
        BalaFiles.DependencyGraphResult packageDependencyGraph = BalaFiles.createPackageDependencyGraph(balaPath);
        return PackageConfigCreator.createPackageConfig(packageData, packageManifest, dependencyManifest, packageDependencyGraph.packageDependencyGraph(), packageDependencyGraph.moduleDependencies());
    }

    public static PackageConfig createPackageConfig(PackageData packageData, PackageManifest packageManifest, DependencyManifest dependencyManifest) {
        return PackageConfigCreator.createPackageConfig(packageData, packageManifest, dependencyManifest, DependencyGraph.emptyGraph(), Collections.emptyMap(), false);
    }

    private static PackageConfig createPackageConfig(PackageData packageData, PackageManifest packageManifest, DependencyManifest dependencyManifest, DependencyGraph<PackageDescriptor> packageDependencyGraph, Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDependencyGraph, boolean disableSyntaxTree) {
        PackageName packageName = packageManifest.name();
        PackageId packageId = PackageId.create(packageName.value());
        List<ModuleConfig> moduleConfigs = Stream.concat(packageData.otherModules().stream().map(moduleData -> PackageConfigCreator.createModuleConfig(packageManifest.descriptor(), moduleData, packageId, moduleDependencyGraph)), Stream.of(PackageConfigCreator.createDefaultModuleConfig(packageManifest.descriptor(), packageData.defaultModule(), packageId, moduleDependencyGraph))).toList();
        DocumentConfig ballerinaToml = packageData.ballerinaToml().map(data -> PackageConfigCreator.createDocumentConfig(data, null)).orElse(null);
        DocumentConfig dependenciesToml = packageData.dependenciesToml().map(data -> PackageConfigCreator.createDocumentConfig(data, null)).orElse(null);
        DocumentConfig cloudToml = packageData.cloudToml().map(data -> PackageConfigCreator.createDocumentConfig(data, null)).orElse(null);
        DocumentConfig compilerPluginToml = packageData.compilerPluginToml().map(data -> PackageConfigCreator.createDocumentConfig(data, null)).orElse(null);
        DocumentConfig balToolToml = packageData.balToolToml().map(data -> PackageConfigCreator.createDocumentConfig(data, null)).orElse(null);
        ArrayList<ResourceConfig> resources = new ArrayList();
        ArrayList<ResourceConfig> testResources = new ArrayList();
        if (!packageData.resources().isEmpty()) {
            resources = PackageConfigCreator.getResourceConfigs(packageData.resources(), packageData.packagePath());
        }
        if (!packageData.testResources().isEmpty()) {
            testResources = PackageConfigCreator.getResourceConfigs(packageData.testResources(), packageData.packagePath());
        }
        DocumentConfig readmeMd = packageData.readmeMd().map(data -> PackageConfigCreator.createDocumentConfig(data, null)).orElse(null);
        return PackageConfig.from(packageId, packageData.packagePath(), packageManifest, dependencyManifest, ballerinaToml, dependenciesToml, cloudToml, compilerPluginToml, balToolToml, readmeMd, moduleConfigs, packageDependencyGraph, disableSyntaxTree, resources, testResources);
    }

    public static PackageConfig createPackageConfig(PackageData packageData, PackageManifest packageManifest, DependencyManifest dependencyManifest, DependencyGraph<PackageDescriptor> packageDependencyGraph, Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDependencyGraph) {
        return PackageConfigCreator.createPackageConfig(packageData, packageManifest, dependencyManifest, packageDependencyGraph, moduleDependencyGraph, true);
    }

    private static ModuleConfig createDefaultModuleConfig(PackageDescriptor pkgDesc, ModuleData moduleData, PackageId packageId, Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDepGraph) {
        ModuleName moduleName = ModuleName.from(pkgDesc.name());
        ModuleDescriptor moduleDescriptor = PackageConfigCreator.createModuleDescriptor(pkgDesc, moduleName);
        List<ModuleDescriptor> dependencies = PackageConfigCreator.getModuleDependencies(moduleDepGraph, moduleDescriptor);
        return PackageConfigCreator.createModuleConfig(moduleDescriptor, moduleData, packageId, dependencies);
    }

    private static ModuleDescriptor createModuleDescriptor(PackageDescriptor pkgDesc, ModuleName moduleName) {
        return ModuleDescriptor.from(moduleName, pkgDesc);
    }

    private static ModuleConfig createModuleConfig(PackageDescriptor pkgDesc, ModuleData moduleData, PackageId packageId, Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDepGraph) {
        Path fileName = moduleData.moduleDirectoryPath().getFileName();
        if (fileName == null) {
            throw new IllegalStateException("This branch cannot be reached");
        }
        ModuleName moduleName = ModuleName.from(pkgDesc.name(), moduleData.moduleName());
        ModuleDescriptor moduleDescriptor = PackageConfigCreator.createModuleDescriptor(pkgDesc, moduleName);
        List<ModuleDescriptor> dependencies = PackageConfigCreator.getModuleDependencies(moduleDepGraph, moduleDescriptor);
        return PackageConfigCreator.createModuleConfig(moduleDescriptor, moduleData, packageId, dependencies);
    }

    private static ModuleConfig createModuleConfig(ModuleDescriptor moduleDescriptor, ModuleData moduleData, PackageId packageId, List<ModuleDescriptor> dependencies) {
        ModuleId moduleId = ModuleId.create(moduleDescriptor.name().toString(), packageId);
        List<DocumentConfig> srcDocs = PackageConfigCreator.getDocumentConfigs(moduleId, moduleData.sourceDocs());
        List<DocumentConfig> testSrcDocs = PackageConfigCreator.getDocumentConfigs(moduleId, moduleData.testSourceDocs());
        DocumentConfig readmeMd = moduleData.readmeMd().map(data -> PackageConfigCreator.createDocumentConfig(data, null)).orElse(null);
        return ModuleConfig.from(moduleId, moduleDescriptor, srcDocs, testSrcDocs, readmeMd, dependencies);
    }

    private static List<ResourceConfig> getResourceConfigs(List<Path> resources, Path packagePath) {
        HashSet<Path> distinctResources = new HashSet<Path>(resources);
        return distinctResources.stream().map(distinctResource -> PackageConfigCreator.createResourceConfig(distinctResource, packagePath)).toList();
    }

    private static ResourceConfig createResourceConfig(Path path, Path packagePath) {
        DocumentId documentId = DocumentId.create(path.toString(), null);
        return ProvidedResourceConfig.from(documentId, path, packagePath);
    }

    private static List<DocumentConfig> getDocumentConfigs(ModuleId moduleId, List<DocumentData> documentData) {
        return documentData.stream().sorted(Comparator.comparing(DocumentData::name)).map(srcDoc -> PackageConfigCreator.createDocumentConfig(srcDoc, moduleId)).toList();
    }

    static DocumentConfig createDocumentConfig(DocumentData documentData, ModuleId moduleId) {
        DocumentId documentId = DocumentId.create(documentData.name(), moduleId);
        return DocumentConfig.from(documentId, documentData::content, documentData.name());
    }

    private static List<ModuleDescriptor> getModuleDependencies(Map<ModuleDescriptor, List<ModuleDescriptor>> moduleDepGraph, ModuleDescriptor moduleDescriptor) {
        List<ModuleDescriptor> moduleDependencies = moduleDepGraph.get(moduleDescriptor);
        return Objects.requireNonNullElse(moduleDependencies, Collections.emptyList());
    }
}

