/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

public class PackageContainer<T> {
    private final Map<PackageOrg, Map<PackageName, T>> pkgOrgMap = new HashMap<PackageOrg, Map<PackageName, T>>();

    public void add(PackageOrg pkgOrg, PackageName pkgName, T t) {
        Map pkgNameMap = this.pkgOrgMap.computeIfAbsent(pkgOrg, orgName -> new HashMap());
        pkgNameMap.put(pkgName, t);
        this.pkgOrgMap.put(pkgOrg, pkgNameMap);
    }

    public Optional<T> get(PackageOrg pkgOrg, PackageName pkgName) {
        Map<PackageName, T> pkgNameMap = this.pkgOrgMap.get(pkgOrg);
        if (pkgNameMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(pkgNameMap.get(pkgName));
    }

    public T getOrElseThrow(PackageOrg pkgOrg, PackageName pkgName) {
        T value = null;
        Map<PackageName, T> pkgNameMap = this.pkgOrgMap.get(pkgOrg);
        if (pkgNameMap != null) {
            value = pkgNameMap.get(pkgName);
        }
        if (value == null) {
            throw new NoSuchElementException("No value present");
        }
        return value;
    }

    public boolean contains(PackageOrg pkgOrg, PackageName pkgName) {
        Map<PackageName, T> pkgNameMap = this.pkgOrgMap.get(pkgOrg);
        if (pkgNameMap == null) {
            return false;
        }
        return pkgNameMap.containsKey(pkgName);
    }

    public Collection<T> getAll() {
        return this.pkgOrgMap.values().stream().map(Map::values).flatMap(Collection::stream).toList();
    }
}

