/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;

public enum ProjectDiagnosticErrorCode implements DiagnosticCode
{
    MISSING_PKG_INFO_IN_BALLERINA_TOML("BCE5001", "missing.package.info"),
    INVALID_PATH("BCE5002", "error.invalid.path"),
    INVALID_FILE_FORMAT("BCE5003", "error.invalid.file.format"),
    INVALID_PROVIDED_DEPENDENCY("BCE5004", "invalid.provided.dependency"),
    INVALID_PROVIDED_SCOPE_IN_BUILD("BCE5005", "invalid.provided.scope"),
    MISSING_PACKAGES_IN_WORKSPACE_BALLERINA_TOML("BCE5006", "missing.packages.in.ballerina.toml"),
    ORG_NAME_MISMATCH_IN_WORKSPACE("BCE5007", "org.name.mismatch.in.workspace"),
    INVALID_LOCKING_MODE("BCE5008", "invalid.locking.mode"),
    OLD_DEPENDENCIES_TOML("BCE5101", "old.dependencies.toml"),
    LOCAL_PACKAGES_IN_DEPENDENCIES_TOML("BCE5102", "local.packages.in.dependencies.toml"),
    CORRUPTED_DEPENDENCIES_TOML("BCE5103", "corrupted.dependencies.toml"),
    DEPRECATED_BALLERINA_TOML_ENTRY("BCE5104", "deprecated.ballerina.toml.entry"),
    INVALID_MODULE("BCE5105", "invalid.module"),
    DEPRECATED_DOC_FILE("BCE5106", "deprecated.doc.file"),
    INCOMPATIBLE_DEPENDENCY_VERSIONS("BCE5201", "incompatible.dependency.versions"),
    PACKAGE_NOT_FOUND("BCE5202", "package.not.found"),
    DEPRECATED_PACKAGE("BCE5203", "deprecated.package"),
    BUILT_WITH_OLDER_SL_UPDATE_DISTRIBUTION("BCE5204", "built.with.older.sl.update.distribution"),
    CUSTOM_REPOSITORY_NOT_FOUND("BCE5205", "custom.repository.not.found"),
    NEW_IMPORTS_WITH_LOCKED_MODE("BCE5206", "new.imports.with.locked.mode"),
    MISSING_DEPENDENCIES_TOML_WITH_LOCKED_MODE("BCE5207", "missing.dependencies.toml.with.locked.mode"),
    OLD_IMPORTS("BCE5208", "old.imports"),
    MISSING_TOOL_PROPERTIES_IN_BALLERINA_TOML("BCE5301", "missing.tool.properties"),
    INCOMPATIBLE_TYPE_FOR_TOOL_PROPERTY("BCE5302", "incompatible.tool.properties"),
    EMPTY_TOOL_PROPERTY("BCE5303", "empty.tool.properties"),
    TOOL_OPTIONS_VALIDATION_SKIPPED("BCE5304", "tool.options.validation.skipped"),
    RECURRING_TOOL_PROPERTIES("BCE5305", "recurring.tool.properties"),
    BUILD_TOOL_NOT_FOUND("BCE5306", "build.tool.not.found"),
    TOOL_OPTIONS_VALIDATION_FAILED("BCE5307", "tool.options.validation.failed"),
    UNSUPPORTED_COMPILER_PLUGIN_TYPE("BCE5401", "unsupported.compiler.plugin.type"),
    CONFLICTING_PLATFORM_JAR_FILES("BCE5501", "conflicting.platform.jars.type"),
    PROVIDED_PLATFORM_JAR_IN_EXECUTABLE("BCE5502", "provided.platform.jars"),
    CONFLICTING_RESOURCE_FILE("BCE5601", "conflicting.resources.type"),
    DEPRECATED_RESOURCES_STRUCTURE("BCE5602", "deprecated.resources.structure"),
    CENTRAL_CONNECTION_ERROR("BCE5701", "central.connection.error");

    private final String diagnosticId;
    private final String messageKey;

    private ProjectDiagnosticErrorCode(String diagnosticId, String messageKey) {
        this.diagnosticId = diagnosticId;
        this.messageKey = messageKey;
    }

    public DiagnosticSeverity severity() {
        return DiagnosticSeverity.ERROR;
    }

    public String diagnosticId() {
        return this.diagnosticId;
    }

    public String messageKey() {
        return this.messageKey;
    }

    public boolean equals(DiagnosticCode code) {
        return this.messageKey.equals(code.messageKey());
    }
}

