/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.Settings;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.model.Central;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.internal.model.Repository;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlLongValueNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.validator.TomlValidator;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SettingsBuilder {
    public static final String NAME = "name";
    public static final String MAVEN = "maven";
    private static final String CONNECT_TIMEOUT = "connectTimeout";
    private static final String READ_TIMEOUT = "readTimeout";
    private static final String WRITE_TIMEOUT = "writeTimeout";
    private static final String CALL_TIMEOUT = "callTimeout";
    private static final String MAX_RETRIES = "maxRetries";
    private final TomlDocument settingsToml;
    private final Settings settings;
    private DiagnosticResult diagnostics;
    private final List<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();
    private static final String PROXY = "proxy";
    private static final String CENTRAL = "central";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String ACCESS_TOKEN = "accesstoken";
    private static final String REPOSITORY = "repository";
    private static final String ID = "id";
    private static final String URL = "url";
    private static final int DEFAULT_CONNECT_TIMEOUT = 60;
    private static final int DEFAULT_READ_TIMEOUT = 60;
    private static final int DEFAULT_WRITE_TIMEOUT = 60;
    private static final int DEFAULT_CALL_TIMEOUT = 0;
    public static final int DEFAULT_MAX_RETRY = 1;

    private SettingsBuilder(TomlDocument settingsToml) {
        this.settingsToml = settingsToml;
        this.settings = this.parseAsSettings();
    }

    public static SettingsBuilder from(TomlDocument settingsToml) {
        return new SettingsBuilder(settingsToml);
    }

    public Settings settings() {
        return this.settings;
    }

    public DiagnosticResult diagnostics() {
        if (this.diagnostics != null) {
            return this.diagnostics;
        }
        this.diagnosticList.addAll(this.settingsToml.toml().diagnostics());
        this.diagnostics = new DefaultDiagnosticResult(this.diagnosticList);
        return this.diagnostics;
    }

    private Settings parseAsSettings() {
        TomlValidator settingsTomlValidator;
        try {
            settingsTomlValidator = new TomlValidator(Schema.from((String)FileUtils.readFileAsString("settings-toml-schema.json")));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the Settings.toml validator schema file.");
        }
        settingsTomlValidator.validate(this.settingsToml.toml());
        TomlTableNode tomlAstNode = this.settingsToml.toml().rootNode();
        String host = "";
        int port = 0;
        String proxyUsername = "";
        String proxyPassword = "";
        String accessToken = "";
        int connectTimeout = 60;
        int readTimeout = 60;
        int writeTimeout = 60;
        int callTimeout = 0;
        int maxRetries = 1;
        String url = "";
        String id = "";
        String repoName = "";
        String repositoryUsername = "";
        String repositoryPassword = "";
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        if (!tomlAstNode.entries().isEmpty()) {
            TomlTableNode repository;
            TomlTableNode centralNode;
            TomlTableNode proxyNode = (TomlTableNode)tomlAstNode.entries().get(PROXY);
            if (proxyNode != null && proxyNode.kind() != TomlType.NONE && proxyNode.kind() == TomlType.TABLE) {
                host = this.getStringOrDefaultFromTomlTableNode(proxyNode, HOST, "");
                port = this.getIntValueFromProxyNode(proxyNode, PORT, 0);
                proxyUsername = this.getStringOrDefaultFromTomlTableNode(proxyNode, USERNAME, "");
                proxyPassword = this.getStringOrDefaultFromTomlTableNode(proxyNode, PASSWORD, "");
            }
            if ((centralNode = (TomlTableNode)tomlAstNode.entries().get(CENTRAL)) != null && centralNode.kind() != TomlType.NONE && centralNode.kind() == TomlType.TABLE) {
                accessToken = this.getStringOrDefaultFromTomlTableNode(centralNode, ACCESS_TOKEN, "");
                connectTimeout = this.getIntValueFromProxyNode(centralNode, CONNECT_TIMEOUT, 60);
                readTimeout = this.getIntValueFromProxyNode(centralNode, READ_TIMEOUT, 60);
                writeTimeout = this.getIntValueFromProxyNode(centralNode, WRITE_TIMEOUT, 60);
                callTimeout = this.getIntValueFromProxyNode(centralNode, CALL_TIMEOUT, 0);
                maxRetries = this.getIntValueFromProxyNode(centralNode, MAX_RETRIES, 1);
                if (maxRetries < 0) {
                    maxRetries = 1;
                }
            }
            if ((repository = (TomlTableNode)tomlAstNode.entries().get(REPOSITORY)) != null && repository.kind() != TomlType.NONE && repository.kind() == TomlType.TABLE) {
                Map repoEntries = repository.entries();
                for (Map.Entry entry : repoEntries.entrySet()) {
                    String repoKey = (String)entry.getKey();
                    TopLevelNode repoValue = (TopLevelNode)entry.getValue();
                    if (!MAVEN.equals(repoKey)) continue;
                    List repositoryNodes = ((TomlTableArrayNode)repoValue).children();
                    for (TomlTableNode repositoryNode : repositoryNodes) {
                        url = this.getStringOrDefaultFromTomlTableNode(repositoryNode, URL, "");
                        id = this.getStringOrDefaultFromTomlTableNode(repositoryNode, ID, "");
                        repositoryUsername = this.getStringOrDefaultFromTomlTableNode(repositoryNode, USERNAME, "");
                        repositoryPassword = this.getStringOrDefaultFromTomlTableNode(repositoryNode, ACCESS_TOKEN, "");
                        repositories.add(Repository.from(id, url, repositoryUsername, repositoryPassword));
                    }
                }
            }
        }
        return Settings.from(Proxy.from(host, port, proxyUsername, proxyPassword), Central.from(accessToken, connectTimeout, readTimeout, writeTimeout, callTimeout, maxRetries), this.diagnostics(), repositories.toArray(new Repository[0]));
    }

    private String getStringOrDefaultFromTomlTableNode(TomlTableNode pkgNode, String key, String defaultValue) {
        TopLevelNode topLevelNode = (TopLevelNode)pkgNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return defaultValue;
        }
        String value = this.getStringFromTomlTableNode(topLevelNode);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private int getIntValueFromProxyNode(TomlTableNode pkgNode, String key, int defaultValue) {
        TopLevelNode topLevelNode = (TopLevelNode)pkgNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return defaultValue;
        }
        int value = this.getIntFromTomlTableNode(topLevelNode);
        if (value == 0) {
            return defaultValue;
        }
        return value;
    }

    private String getStringFromTomlTableNode(TopLevelNode topLevelNode) {
        TomlKeyValueNode keyValueNode;
        TomlValueNode value;
        if (topLevelNode.kind() == TomlType.KEY_VALUE && (value = (keyValueNode = (TomlKeyValueNode)topLevelNode).value()).kind() == TomlType.STRING) {
            TomlStringValueNode stringValueNode = (TomlStringValueNode)value;
            return (String)stringValueNode.getValue();
        }
        return null;
    }

    private int getIntFromTomlTableNode(TopLevelNode topLevelNode) {
        TomlKeyValueNode keyValueNode;
        TomlValueNode value;
        if (topLevelNode.kind() == TomlType.KEY_VALUE && (value = (keyValueNode = (TomlKeyValueNode)topLevelNode).value()).kind() == TomlType.INTEGER) {
            TomlLongValueNode longValueNode = (TomlLongValueNode)value;
            return Math.toIntExact((Long)longValueNode.getValue());
        }
        return 0;
    }
}

