/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.directory.BuildProject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WorkspaceDependencyGraphBuilder {
    private final Map<BuildProject, Set<BuildProject>> depGraph = new HashMap<BuildProject, Set<BuildProject>>();
    private final DependencyGraph.DependencyGraphBuilder<BuildProject> rawGraphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder(null);

    public DependencyGraph<BuildProject> buildGraph() {
        DependencyGraph.DependencyGraphBuilder<Object> graphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder(null);
        for (Map.Entry<BuildProject, Set<BuildProject>> entry : this.depGraph.entrySet()) {
            graphBuilder.addDependencies(entry.getKey(), (Collection<Object>)entry.getValue());
        }
        return graphBuilder.build();
    }

    public void addPackage(BuildProject project) {
        if (!this.depGraph.containsKey(project)) {
            this.depGraph.put(project, new HashSet());
        }
    }

    public void addDependency(BuildProject dependent, BuildProject dependency) {
        if (!this.depGraph.containsKey(dependent)) {
            throw new IllegalStateException("Dependent package does not exist in the graph: " + String.valueOf(dependent));
        }
        this.depGraph.get(dependent).add(dependency);
        this.rawGraphBuilder.addDependency(dependent, dependency);
    }
}

