/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.ProjectException;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.WorkspaceManifest;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.projects.util.TomlUtil;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.validator.TomlValidator;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class WorkspaceManifestBuilder {
    private final TomlDocument workspaceBallerinaToml;
    private final Path workspaceRoot;
    private final List<Path> packages;
    private final List<Diagnostic> diagnosticList;

    private WorkspaceManifestBuilder(TomlDocument tomlDocument, Path workspaceRoot) {
        this.workspaceBallerinaToml = tomlDocument;
        this.workspaceRoot = workspaceRoot;
        this.diagnosticList = new ArrayList<Diagnostic>();
        this.packages = this.extractPackages(this.validateAndGetBallerinaToml());
    }

    private TomlTableNode validateAndGetBallerinaToml() {
        TomlValidator wpBallerinaTomlValidator;
        try {
            wpBallerinaTomlValidator = new TomlValidator(Schema.from((String)FileUtils.readFileAsString("workspace-ballerina-toml-schema.json")));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to read the workspace Ballerina.toml validator schema file.");
        }
        Toml toml = this.workspaceBallerinaToml.toml();
        wpBallerinaTomlValidator.validate(toml);
        return toml.rootNode();
    }

    private List<Path> extractPackages(TomlTableNode tomlAstNode) {
        TopLevelNode topLevelPkgNode;
        ArrayList<Path> packageList = new ArrayList<Path>();
        if (!tomlAstNode.entries().isEmpty() && (topLevelPkgNode = (TopLevelNode)tomlAstNode.entries().get("workspace")) != null && topLevelPkgNode.kind() == TomlType.TABLE) {
            TomlTableNode pkgNode = (TomlTableNode)topLevelPkgNode;
            List<String> packages = TomlUtil.getStringArrayFromTableNode(pkgNode, "packages");
            if (packages.isEmpty()) {
                this.diagnosticList.add(TomlUtil.createDiagnostic((TopLevelNode)pkgNode, "no packages found in the workspace Ballerina.toml file", ProjectDiagnosticErrorCode.MISSING_PACKAGES_IN_WORKSPACE_BALLERINA_TOML, DiagnosticSeverity.ERROR));
            }
            for (String packagePath : packages) {
                Path projectRoot = this.workspaceRoot.resolve(packagePath);
                Path ballerinaTomlPath = projectRoot.resolve("Ballerina.toml");
                if (!Files.exists(ballerinaTomlPath, new LinkOption[0])) {
                    Diagnostic diagnostic = TomlUtil.createDiagnostic((TopLevelNode)pkgNode, "could not locate the package path '" + packagePath + "'", ProjectDiagnosticErrorCode.INVALID_PATH, DiagnosticSeverity.ERROR);
                    this.diagnosticList.add(diagnostic);
                    continue;
                }
                if (!Files.isDirectory(projectRoot, new LinkOption[0])) {
                    String message = "invalid package path '" + packagePath + "'. Expected a directory";
                    Diagnostic diagnostic = TomlUtil.createDiagnostic((TopLevelNode)pkgNode, message, ProjectDiagnosticErrorCode.INVALID_PATH, DiagnosticSeverity.ERROR);
                    this.diagnosticList.add(diagnostic);
                    continue;
                }
                packageList.add(this.workspaceRoot.resolve(packagePath).toAbsolutePath().normalize());
            }
        }
        return packageList;
    }

    public static WorkspaceManifestBuilder from(TomlDocument tomlDocument, Path workspaceRoot) {
        return new WorkspaceManifestBuilder(tomlDocument, workspaceRoot);
    }

    public WorkspaceManifest manifest() {
        return new WorkspaceManifest(this.packages, new DefaultDiagnosticResult(this.diagnosticList));
    }
}

