/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.environment;

import io.ballerina.projects.DependencyResolutionType;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.environment.PackageMetadataResponse;
import io.ballerina.projects.environment.PackageRepository;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import io.ballerina.projects.internal.ImportModuleRequest;
import io.ballerina.projects.internal.ImportModuleResponse;
import io.ballerina.projects.internal.environment.WritablePackageCache;
import io.ballerina.projects.util.ProjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultPackageResolver
implements PackageResolver {
    private final PackageRepository distributionRepo;
    private final PackageRepository centralRepo;
    private final PackageRepository localRepo;
    private final Map<String, PackageRepository> customRepos;
    private final PackageRepository workspaceRepo;
    private final WritablePackageCache packageCache;

    public DefaultPackageResolver(PackageRepository distributionRepo, PackageRepository centralRepo, PackageRepository localRepo, PackageCache packageCache) {
        this(distributionRepo, centralRepo, localRepo, Collections.emptyMap(), null, packageCache);
    }

    public DefaultPackageResolver(PackageRepository distributionRepo, PackageRepository centralRepo, PackageRepository localRepo, Map<String, PackageRepository> customRepos, PackageRepository workspaceRepo, PackageCache packageCache) {
        this.distributionRepo = distributionRepo;
        this.centralRepo = centralRepo;
        this.customRepos = customRepos;
        this.localRepo = localRepo;
        this.workspaceRepo = workspaceRepo;
        this.packageCache = (WritablePackageCache)packageCache;
    }

    @Override
    public Collection<ImportModuleResponse> resolvePackageNames(Collection<ImportModuleRequest> requests, ResolutionOptions options) {
        Collection<ImportModuleResponse> responseListInDist = this.distributionRepo.getPackageNames(requests, options);
        Collection<ImportModuleResponse> responseListInCentral = this.centralRepo.getPackageNames(requests, options);
        return new ArrayList<ImportModuleResponse>(Stream.of(responseListInDist, responseListInCentral).flatMap(Collection::stream).collect(Collectors.toMap(ImportModuleResponse::importModuleRequest, Function.identity(), (x, y) -> {
            ResolutionRequest resolutionRequest;
            Collection<PackageVersion> packageVersions;
            if (y.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.UNRESOLVED)) {
                return x;
            }
            if (x.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.UNRESOLVED)) {
                return y;
            }
            if (!x.packageDescriptor().name().equals(y.packageDescriptor().name()) && (packageVersions = this.distributionRepo.getPackageVersions(resolutionRequest = ResolutionRequest.from(y.packageDescriptor(), PackageDependencyScope.DEFAULT, DependencyResolutionType.SOURCE, options.packageLockingMode()), options)).isEmpty()) {
                return y;
            }
            return x;
        })).values());
    }

    @Override
    public Collection<PackageMetadataResponse> resolvePackageMetadata(Collection<ResolutionRequest> requests, ResolutionOptions options) {
        ArrayList<ResolutionRequest> localRepoRequests = new ArrayList<ResolutionRequest>();
        HashMap customRepoRequestMap = new HashMap();
        ArrayList<ResolutionRequest> workspaceRequests = new ArrayList<ResolutionRequest>();
        for (ResolutionRequest request : requests) {
            Optional<String> repository = request.packageDescriptor().repository();
            if (repository.isPresent() && repository.get().equals("local")) {
                localRepoRequests.add(request);
                continue;
            }
            if (repository.isPresent() && this.customRepos.containsKey(repository.get())) {
                PackageRepository packageRepository = this.customRepos.get(repository.get());
                if (customRepoRequestMap.containsKey(packageRepository)) {
                    ((ArrayList)customRepoRequestMap.get(packageRepository)).add(request);
                    continue;
                }
                ArrayList<ResolutionRequest> requestList = new ArrayList<ResolutionRequest>();
                requestList.add(request);
                customRepoRequestMap.put(packageRepository, requestList);
                continue;
            }
            if (this.workspaceRepo == null || ProjectUtils.isBuiltInPackage(request.orgName(), request.packageName().toString()) || request.skipWorkspace()) continue;
            workspaceRequests.add(request);
        }
        List localRepoPackages = localRepoRequests.isEmpty() ? Collections.emptyList() : this.localRepo.getPackageMetadata(localRepoRequests, options);
        ArrayList allCustomRepoPackages = new ArrayList();
        for (Map.Entry entry : customRepoRequestMap.entrySet()) {
            PackageRepository customRepository = (PackageRepository)entry.getKey();
            ArrayList customRepoRequests = (ArrayList)entry.getValue();
            List customRepoPackages = customRepoRequests.isEmpty() ? Collections.emptyList() : customRepository.getPackageMetadata(customRepoRequests, options);
            allCustomRepoPackages.addAll(customRepoPackages);
        }
        List workspacePackages = workspaceRequests.isEmpty() ? Collections.emptyList() : this.workspaceRepo.getPackageMetadata(workspaceRequests, options);
        Collection<PackageMetadataResponse> collection = this.distributionRepo.getPackageMetadata(requests, options);
        ArrayList<PackageMetadataResponse> resolvedRequests = new ArrayList<PackageMetadataResponse>(workspacePackages.stream().filter(r -> r.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.RESOLVED)).toList());
        if (options.packageLockingMode().equals((Object)PackageLockingMode.HARD) || options.sticky()) {
            resolvedRequests.addAll(collection.stream().filter(r -> r.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.RESOLVED)).toList());
        }
        List<ResolutionRequest> centralLoadRequests = requests.stream().filter(r -> resolvedRequests.stream().noneMatch(resolvedReq -> resolvedReq.packageLoadRequest().equals(r))).toList();
        centralLoadRequests = centralLoadRequests.stream().filter(r -> !r.packageDescriptor().isBuiltInPackage()).toList();
        Collection<PackageMetadataResponse> latestVersionsInCentral = this.centralRepo.getPackageMetadata(centralLoadRequests, options);
        ArrayList<PackageMetadataResponse> responseDescriptors = new ArrayList<PackageMetadataResponse>(Stream.of(localRepoPackages, allCustomRepoPackages, collection, workspacePackages, latestVersionsInCentral).flatMap(Collection::stream).collect(Collectors.toMap(PackageMetadataResponse::packageLoadRequest, Function.identity(), (x, y) -> {
            if (y.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.UNRESOLVED)) {
                return x;
            }
            if (x.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.UNRESOLVED)) {
                return y;
            }
            if (x.resolvedDescriptor().version().equals(y.resolvedDescriptor().version())) {
                return x;
            }
            if (ProjectUtils.getLatest(x.resolvedDescriptor().version(), y.resolvedDescriptor().version()).equals(y.resolvedDescriptor().version())) {
                return y;
            }
            return x;
        })).values());
        return responseDescriptors;
    }

    @Override
    public Collection<ResolutionResponse> resolvePackages(Collection<ResolutionRequest> requests, ResolutionOptions options) {
        if (requests.isEmpty()) {
            return Collections.emptyList();
        }
        return requests.stream().map(request -> this.resolvePackage((ResolutionRequest)request, options)).toList();
    }

    private ResolutionResponse resolvePackage(ResolutionRequest resolutionReq, ResolutionOptions options) {
        Optional<Package> resolvedPackage = this.loadFromCache(resolutionReq);
        if (resolvedPackage.isEmpty()) {
            resolvedPackage = this.resolveFromRepository(resolutionReq, options);
            resolvedPackage.ifPresent(this.packageCache::cache);
        }
        ResolutionResponse.ResolutionStatus resolutionStatus = resolvedPackage.isPresent() ? ResolutionResponse.ResolutionStatus.RESOLVED : ResolutionResponse.ResolutionStatus.UNRESOLVED;
        return ResolutionResponse.from(resolutionStatus, resolvedPackage.orElse(null), resolutionReq);
    }

    private Optional<Package> loadFromCache(ResolutionRequest resolutionReq) {
        PackageDescriptor pkgDesc = resolutionReq.packageDescriptor();
        return this.packageCache.getPackage(pkgDesc.org(), pkgDesc.name(), pkgDesc.version());
    }

    private Optional<Package> resolveFromRepository(ResolutionRequest resolutionReq, ResolutionOptions options) {
        Optional<Package> resolvedPackage;
        PackageDescriptor pkgDesc = resolutionReq.packageDescriptor();
        if (pkgDesc.isBuiltInPackage()) {
            return this.distributionRepo.getPackage(resolutionReq, options);
        }
        if (pkgDesc.repository().isPresent()) {
            String repository = pkgDesc.repository().get();
            if (!"local".equals(repository) && this.customRepos.containsKey(repository)) {
                return this.customRepos.get(repository).getPackage(resolutionReq, options);
            }
            if (!"local".equals(repository)) {
                return Optional.empty();
            }
            return this.localRepo.getPackage(resolutionReq, options);
        }
        if (this.workspaceRepo != null && (resolvedPackage = this.workspaceRepo.getPackage(resolutionReq, options)).isPresent()) {
            return resolvedPackage;
        }
        resolvedPackage = this.distributionRepo.getPackage(resolutionReq, options);
        if (resolvedPackage.isEmpty()) {
            resolvedPackage = this.centralRepo.getPackage(resolutionReq, options);
        }
        return resolvedPackage;
    }
}

