/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.model;

import com.google.gson.annotations.SerializedName;
import io.ballerina.projects.BuildOptions;
import java.util.List;
import java.util.Map;

public class BuildJson {
    public static final String SERIALIZED_NAME_LAST_BUILD_TIME = "last_build_time";
    @SerializedName(value="last_build_time")
    private long lastBuildTime;
    public static final String SERIALIZED_NAME_LAST_UPDATE_TIME = "last_update_time";
    @SerializedName(value="last_update_time")
    private long lastUpdateTime;
    public static final String SERIALIZED_NAME_LAST_BAL_TOML_UPDATE_TIME = "last_bal_toml_update_time";
    @SerializedName(value="last_bal_toml_update_time")
    private long lastBalTomlUpdateTime;
    public static final String SERIALIZED_NAME_DISTRIBUTION_VERSION = "distribution_version";
    @SerializedName(value="distribution_version")
    private String distributionVersion;
    public static final String SERIALIZED_NAME_LAST_MODIFIED_TIME = "last_modified_time";
    @SerializedName(value="last_modified_time")
    private Map<String, Long> lastModifiedTime;
    public static final String LAST_BUILD_OPTIONS = "last_build_options";
    @SerializedName(value="last_build_options")
    private BuildOptions buildOptions;
    public static final String SRC_META_INFO = "src_meta_info";
    @SerializedName(value="src_meta_info")
    private FileMetaInfo[] srcMetaInfo;
    public static final String TEST_SRC_META_INFO = "test_src_meta_info";
    @SerializedName(value="test_src_meta_info")
    private FileMetaInfo[] testSrcMetaInfo;
    public static final String TARGET_EXEC_META_INFO = "target_exec_meta_info";
    @SerializedName(value="target_exec_meta_info")
    private FileMetaInfo targetExecMetaInfo;
    public static final String SETTINGS_META_INFO = "settings_meta_info";
    @SerializedName(value="settings_meta_info")
    private FileMetaInfo settingsMetaInfo;
    public static final String BALLERINA_TOML_META_INFO = "ballerina_toml_meta_info";
    @SerializedName(value="ballerina_toml_meta_info")
    private FileMetaInfo ballerinaTomlMetaInfo;
    public static final String TEST_ARTIFACT_META_INFO = "test_artifact_meta_info";
    @SerializedName(value="test_artifact_meta_info")
    private FileMetaInfo[] testArtifactMetaInfo;
    public static final String TEST_CLASS_PATH = "test_class_path";
    @SerializedName(value="test_class_path")
    private String testClassPath;
    public static final String SERIALIZED_NAME_IMPORTS = "imports";
    @SerializedName(value="imports")
    private List<String> imports;
    private static final long ONE_DAY = 86400000L;

    public BuildJson(long lastBuildTime, long lastUpdateTime, String distributionVersion, Map<String, Long> lastModifiedTime, List<String> imports, long lastBalTomlUpdateTime) {
        this.lastBuildTime = lastBuildTime;
        this.lastUpdateTime = lastUpdateTime;
        this.distributionVersion = distributionVersion;
        this.lastModifiedTime = lastModifiedTime;
        this.imports = imports;
        this.lastBalTomlUpdateTime = lastBalTomlUpdateTime;
    }

    public BuildOptions getBuildOptions() {
        return this.buildOptions;
    }

    public void setBuildOptions(BuildOptions buildOptions) {
        this.buildOptions = buildOptions;
    }

    public long lastBuildTime() {
        return this.lastBuildTime;
    }

    public void setLastBuildTime(long lastBuildTime) {
        this.lastBuildTime = lastBuildTime;
    }

    public long lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastBalTomlUpdateTime(long lastBalTomlUpdateTime) {
        this.lastBalTomlUpdateTime = lastBalTomlUpdateTime;
    }

    public long lastBalTomlUpdateTime() {
        return this.lastBalTomlUpdateTime;
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public List<String> imports() {
        return this.imports;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String distributionVersion() {
        return this.distributionVersion;
    }

    public void setDistributionVersion(String distributionVersion) {
        this.distributionVersion = distributionVersion;
    }

    public Map<String, Long> getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Map<String, Long> lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public boolean isExpiredLastUpdateTime() {
        long oneDayAgo = System.currentTimeMillis() - 86400000L;
        return this.lastUpdateTime() < oneDayAgo;
    }

    public FileMetaInfo[] getSrcMetaInfo() {
        return this.srcMetaInfo;
    }

    public void setSrcMetaInfo(FileMetaInfo[] srcMetaInfo) {
        this.srcMetaInfo = srcMetaInfo;
    }

    public FileMetaInfo getTargetExecMetaInfo() {
        return this.targetExecMetaInfo;
    }

    public void setTargetExecMetaInfo(FileMetaInfo targetExecMetaInfo) {
        this.targetExecMetaInfo = targetExecMetaInfo;
    }

    public FileMetaInfo getSettingsMetaInfo() {
        return this.settingsMetaInfo;
    }

    public void setSettingsMetaInfo(FileMetaInfo settingsMetaInfo) {
        this.settingsMetaInfo = settingsMetaInfo;
    }

    public FileMetaInfo[] getTestArtifactMetaInfo() {
        return this.testArtifactMetaInfo;
    }

    public void setTestArtifactMetaInfo(FileMetaInfo[] testArtifactMetaInfo) {
        this.testArtifactMetaInfo = testArtifactMetaInfo;
    }

    public FileMetaInfo[] getTestSrcMetaInfo() {
        return this.testSrcMetaInfo;
    }

    public void setTestSrcMetaInfo(FileMetaInfo[] testSrcMetaInfo) {
        this.testSrcMetaInfo = testSrcMetaInfo;
    }

    public FileMetaInfo getBallerinaTomlMetaInfo() {
        return this.ballerinaTomlMetaInfo;
    }

    public void setBallerinaTomlMetaInfo(FileMetaInfo ballerinaTomlMetaInfo) {
        this.ballerinaTomlMetaInfo = ballerinaTomlMetaInfo;
    }

    public String getTestClassPath() {
        return this.testClassPath;
    }

    public void setTestClassPath(String testClassPath) {
        this.testClassPath = testClassPath;
    }

    public static class FileMetaInfo {
        private String file;
        private String hash;
        private long size;
        private long lastModifiedTime;

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public void setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }
    }
}

