/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.model;

import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class Target {
    private final Path targetPath;
    private Path outputPath = null;
    private final Path cache;
    private final Path jarCachePath;
    private final Path balaCachePath;
    private final Path birCachePath;
    private final Path testsCachePath;
    private final Path binPath;
    private final Path reportPath;
    private final Path docPath;
    private final Path nativePath;
    private final Path nativeConfigPath;
    private final Path profilerPath;
    private final Path resourcesPath;
    private final Path execBackupPath;

    public Target(Path targetPath) throws IOException {
        this.targetPath = targetPath;
        this.cache = this.targetPath.resolve("cache");
        this.balaCachePath = this.targetPath.resolve("bala");
        this.jarCachePath = this.cache.resolve("jar_cache");
        this.birCachePath = this.cache.resolve("bir_cache");
        this.testsCachePath = this.cache.resolve("tests_cache");
        this.binPath = this.targetPath.resolve("bin");
        this.reportPath = this.targetPath.resolve("report");
        this.docPath = this.targetPath.resolve("apidocs");
        this.nativePath = this.targetPath.resolve("native");
        this.nativeConfigPath = this.testsCachePath.resolve("native-config");
        this.profilerPath = this.targetPath.resolve("profiler");
        this.resourcesPath = this.targetPath.resolve("resources");
        this.execBackupPath = this.targetPath.resolve("backup");
        if (Files.exists(this.targetPath, new LinkOption[0])) {
            ProjectUtils.checkWritePermission(this.targetPath);
        } else {
            Files.createDirectories(this.targetPath, new FileAttribute[0]);
        }
        if (Files.exists(this.cache, new LinkOption[0])) {
            ProjectUtils.checkWritePermission(this.cache);
        }
        if (Files.exists(this.binPath, new LinkOption[0])) {
            ProjectUtils.checkWritePermission(this.binPath);
        }
        if (Files.exists(this.balaCachePath, new LinkOption[0])) {
            ProjectUtils.checkWritePermission(this.balaCachePath);
        }
        if (Files.exists(this.docPath, new LinkOption[0])) {
            ProjectUtils.checkWritePermission(this.docPath);
        }
        if (Files.exists(this.reportPath, new LinkOption[0])) {
            ProjectUtils.checkWritePermission(this.reportPath);
        }
        if (Files.exists(this.profilerPath, new LinkOption[0])) {
            ProjectUtils.checkWritePermission(this.profilerPath);
        }
        if (Files.exists(this.resourcesPath, new LinkOption[0])) {
            ProjectUtils.checkWritePermission(this.resourcesPath);
        }
    }

    public Path getDocPath() throws IOException {
        Files.createDirectories(this.docPath, new FileAttribute[0]);
        return this.docPath;
    }

    public Path getBalaPath() throws IOException {
        Files.createDirectories(this.balaCachePath, new FileAttribute[0]);
        return this.balaCachePath;
    }

    public Path getJarCachePath() throws IOException {
        Files.createDirectories(this.jarCachePath, new FileAttribute[0]);
        return this.jarCachePath;
    }

    public Path getExecutablePath(Package pkg) throws IOException {
        if (this.outputPath != null) {
            return this.outputPath;
        }
        return this.getBinPath().resolve(ProjectUtils.getExecutableName(pkg));
    }

    public Path getTestExecutablePath(Module module) throws IOException {
        if (this.outputPath != null) {
            return this.outputPath;
        }
        String name = module.moduleName().toString();
        return this.getTestBinPath().resolve(name + "-testable.jar");
    }

    public Path getTestExecutableBasePath() throws IOException {
        if (this.outputPath != null) {
            return this.outputPath.getParent();
        }
        return this.getTestBinPath();
    }

    public Path getBinPath() throws IOException {
        Files.createDirectories(this.binPath, new FileAttribute[0]);
        return this.binPath;
    }

    public Path getTestBinPath() throws IOException {
        Files.createDirectories(this.binPath.resolve("tests"), new FileAttribute[0]);
        return this.binPath.resolve("tests");
    }

    public Path getReportPath() throws IOException {
        Files.createDirectories(this.reportPath, new FileAttribute[0]);
        return this.reportPath;
    }

    public Path getProfilerPath() throws IOException {
        Files.createDirectories(this.profilerPath, new FileAttribute[0]);
        return this.profilerPath;
    }

    public Path cachesPath() {
        return this.targetPath.resolve("cache");
    }

    public Path getBirCachePath() throws IOException {
        Files.createDirectories(this.birCachePath, new FileAttribute[0]);
        return this.birCachePath;
    }

    public Path getTestsCachePath() throws IOException {
        Files.createDirectories(this.testsCachePath, new FileAttribute[0]);
        return this.testsCachePath;
    }

    public Path path() {
        return this.targetPath;
    }

    public void setOutputPath(Path outputPath) throws IOException {
        Path parent;
        if (Files.exists(outputPath, new LinkOption[0])) {
            ProjectUtils.checkWritePermission(outputPath);
            Files.delete(outputPath);
        }
        if ((parent = outputPath.getParent()) != null) {
            if (Files.exists(parent, new LinkOption[0])) {
                ProjectUtils.checkWritePermission(parent);
            }
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        this.outputPath = outputPath;
    }

    public void clean() {
        ProjectUtils.deleteDirectory(this.cache);
        ProjectUtils.deleteDirectory(this.balaCachePath);
        ProjectUtils.deleteDirectory(this.binPath);
        ProjectUtils.deleteDirectory(this.docPath);
        ProjectUtils.deleteDirectory(this.reportPath);
        ProjectUtils.deleteDirectory(this.resourcesPath);
        ProjectUtils.deleteDirectory(this.execBackupPath);
    }

    @Deprecated(forRemoval=true)
    public void clean(boolean isModified, boolean cacheEnabled) {
        if (isModified || !cacheEnabled) {
            ProjectUtils.deleteDirectory(this.cache);
        }
        ProjectUtils.deleteDirectory(this.balaCachePath);
        ProjectUtils.deleteDirectory(this.binPath);
        ProjectUtils.deleteDirectory(this.docPath);
        ProjectUtils.deleteDirectory(this.reportPath);
        ProjectUtils.deleteDirectory(this.resourcesPath);
    }

    public void cleanCache() {
        ProjectUtils.deleteDirectory(this.cache);
    }

    public Path getNativePath() throws IOException {
        Files.createDirectories(this.nativePath, new FileAttribute[0]);
        return this.nativePath;
    }

    public Path getNativeConfigPath() throws IOException {
        Files.createDirectories(this.nativeConfigPath, new FileAttribute[0]);
        return this.nativeConfigPath;
    }

    public void cleanBinTests() {
        ProjectUtils.deleteDirectory(this.binPath.resolve("tests"));
    }
}

