/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.repositories;

import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.environment.PackageMetadataResponse;
import io.ballerina.projects.environment.PackageRepository;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.internal.ImportModuleRequest;
import io.ballerina.projects.internal.ImportModuleResponse;
import io.ballerina.projects.util.ProjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractPackageRepository
implements PackageRepository {
    @Override
    public Collection<PackageMetadataResponse> getPackageMetadata(Collection<ResolutionRequest> requests, ResolutionOptions options) {
        ArrayList<PackageMetadataResponse> descriptorSet = new ArrayList<PackageMetadataResponse>();
        for (ResolutionRequest request : requests) {
            List<PackageVersion> versions = this.getCompatiblePackageVersions(request.packageDescriptor(), request.packageLockingMode());
            PackageVersion latest = this.findLatest(versions);
            if (latest != null) {
                descriptorSet.add(this.createMetadataResponse(request, latest));
                continue;
            }
            descriptorSet.add(PackageMetadataResponse.createUnresolvedResponse(request));
        }
        return descriptorSet;
    }

    @Override
    public Collection<ImportModuleResponse> getPackageNames(Collection<ImportModuleRequest> requests, ResolutionOptions options) {
        ArrayList<ImportModuleResponse> importModuleResponseList = new ArrayList<ImportModuleResponse>();
        for (ImportModuleRequest importModuleRequest : requests) {
            ImportModuleResponse importModuleLoadResponse = this.getImportModuleLoadResponse(importModuleRequest);
            importModuleResponseList.add(importModuleLoadResponse);
        }
        return importModuleResponseList;
    }

    protected abstract List<PackageVersion> getPackageVersions(PackageOrg var1, PackageName var2, PackageVersion var3);

    protected abstract DependencyGraph<PackageDescriptor> getDependencyGraph(PackageOrg var1, PackageName var2, PackageVersion var3);

    public abstract boolean isPackageExists(PackageOrg var1, PackageName var2, PackageVersion var3);

    public abstract Collection<ModuleDescriptor> getModules(PackageOrg var1, PackageName var2, PackageVersion var3);

    protected List<PackageVersion> getCompatiblePackageVersions(PackageDescriptor packageDescriptor, PackageLockingMode packageLockingMode) {
        List<PackageVersion> packageVersions = this.getPackageVersions(packageDescriptor.org(), packageDescriptor.name(), packageDescriptor.version());
        if (packageDescriptor.isBuiltInPackage()) {
            return packageVersions;
        }
        SemanticVersion minSemVer = null;
        PackageVersion packageVersion = packageDescriptor.version();
        if (packageVersion != null) {
            minSemVer = SemanticVersion.from(packageVersion.toString());
        }
        List<SemanticVersion> semVers = packageVersions.stream().map(version -> SemanticVersion.from(version.toString())).toList();
        ProjectUtils.CompatibleRange compatibilityRange = ProjectUtils.getCompatibleRange(minSemVer, packageLockingMode);
        List<SemanticVersion> compatibleVersions = ProjectUtils.getVersionsInCompatibleRange(minSemVer, semVers, compatibilityRange);
        return compatibleVersions.stream().map(PackageVersion::from).collect(Collectors.toList());
    }

    private ImportModuleResponse getImportModuleLoadResponse(ImportModuleRequest importModuleRequest) {
        for (PackageDescriptor possiblePackage : importModuleRequest.possiblePackages()) {
            List<PackageVersion> packageVersions = this.getCompatiblePackageVersions(possiblePackage, PackageLockingMode.SOFT);
            ImportModuleResponse importModuleResponse = this.getImportModuleResponse(importModuleRequest, possiblePackage.name(), packageVersions);
            if (importModuleResponse == null) continue;
            return importModuleResponse;
        }
        List<PackageName> existing = importModuleRequest.possiblePackages().stream().map(PackageDescriptor::name).toList();
        List<PackageName> remainingPackageNames = ProjectUtils.getPossiblePackageNames(importModuleRequest.packageOrg(), importModuleRequest.moduleName()).stream().filter(o -> !existing.contains(o)).toList();
        for (PackageName possiblePackageName : remainingPackageNames) {
            List<PackageVersion> packageVersions;
            ImportModuleResponse importModuleResponse = this.getImportModuleResponse(importModuleRequest, possiblePackageName, packageVersions = this.getPackageVersions(importModuleRequest.packageOrg(), possiblePackageName, null));
            if (importModuleResponse == null) continue;
            return importModuleResponse;
        }
        return ImportModuleResponse.createUnresolvedResponse(importModuleRequest);
    }

    private ImportModuleResponse getImportModuleResponse(ImportModuleRequest importModuleRequest, PackageName packageName, List<PackageVersion> packageVersions) {
        packageVersions.sort((v1, v2) -> {
            if (v1.equals(v2)) {
                return 0;
            }
            PackageVersion latest = ProjectUtils.getLatest(v1, v2);
            if (v1 == latest) {
                return -1;
            }
            return 1;
        });
        for (PackageVersion packageVersion : packageVersions) {
            Collection<ModuleDescriptor> moduleDescriptors = this.getModules(importModuleRequest.packageOrg(), packageName, packageVersion);
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                if (!importModuleRequest.moduleName().equals(moduleDescriptor.name().toString())) continue;
                PackageDescriptor packageDescriptor = PackageDescriptor.from(importModuleRequest.packageOrg(), packageName, packageVersion);
                return new ImportModuleResponse(packageDescriptor, importModuleRequest);
            }
        }
        return null;
    }

    private PackageMetadataResponse createMetadataResponse(ResolutionRequest resolutionRequest, PackageVersion latest) {
        PackageDescriptor resolvedDescriptor = PackageDescriptor.from(resolutionRequest.orgName(), resolutionRequest.packageName(), latest, resolutionRequest.repositoryName().orElse(null));
        DependencyGraph<PackageDescriptor> dependencyGraph = this.getDependencyGraph(resolutionRequest.orgName(), resolutionRequest.packageName(), latest);
        return PackageMetadataResponse.from(resolutionRequest, resolvedDescriptor, dependencyGraph);
    }

    protected PackageVersion findLatest(List<PackageVersion> packageVersions) {
        if (packageVersions.isEmpty()) {
            return null;
        }
        PackageVersion latestVersion = packageVersions.get(0);
        for (PackageVersion pkgVersion : packageVersions) {
            latestVersion = ProjectUtils.getLatest(latestVersion, pkgVersion);
        }
        return latestVersion;
    }
}

