/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.repositories;

import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.Settings;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.environment.PackageMetadataResponse;
import io.ballerina.projects.environment.PackageRepository;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import io.ballerina.projects.internal.ImportModuleRequest;
import io.ballerina.projects.internal.ImportModuleResponse;
import io.ballerina.projects.internal.repositories.FileSystemRepository;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.ConnectionErrorException;
import org.ballerinalang.central.client.model.PackageNameResolutionRequest;
import org.ballerinalang.central.client.model.PackageNameResolutionResponse;
import org.ballerinalang.central.client.model.PackageResolutionRequest;
import org.ballerinalang.central.client.model.PackageResolutionResponse;
import org.wso2.ballerinalang.util.RepoUtils;

public class RemotePackageRepository
implements PackageRepository {
    private final FileSystemRepository fileSystemRepo;
    private final CentralAPIClient client;

    public RemotePackageRepository(FileSystemRepository fileSystemRepo, CentralAPIClient client) {
        this.fileSystemRepo = fileSystemRepo;
        this.client = client;
    }

    public static RemotePackageRepository from(Environment environment, Path cacheDirectory, String repoUrl, Settings settings) {
        if (Files.notExists(cacheDirectory, new LinkOption[0])) {
            throw new ProjectException("cache directory does not exists: " + String.valueOf(cacheDirectory));
        }
        String ballerinaShortVersion = RepoUtils.getBallerinaShortVersion();
        FileSystemRepository fileSystemRepository = new FileSystemRepository(environment, cacheDirectory, ballerinaShortVersion);
        Proxy proxy = ProjectUtils.initializeProxy(settings.getProxy());
        CentralAPIClient client = new CentralAPIClient(repoUrl, proxy, settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI(settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
        return new RemotePackageRepository(fileSystemRepository, client);
    }

    public static RemotePackageRepository from(Environment environment, Path cacheDirectory, Settings settings) {
        String repoUrl = RepoUtils.getRemoteRepoURL();
        if ("".equals(repoUrl)) {
            throw new ProjectException("remote repo url is empty");
        }
        return RemotePackageRepository.from(environment, cacheDirectory, repoUrl, settings);
    }

    @Override
    public Optional<Package> getPackage(ResolutionRequest request, ResolutionOptions options) {
        block4: {
            Optional<Package> cachedPackage = this.fileSystemRepo.getPackage(request, options);
            if (cachedPackage.isPresent()) {
                return cachedPackage;
            }
            String packageName = request.packageName().value();
            String orgName = request.orgName().value();
            String version = request.version().isPresent() ? request.version().get().toString() : null;
            Path packagePathInBalaCache = this.fileSystemRepo.bala.resolve(orgName).resolve(packageName);
            if (!options.offline()) {
                String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
                try {
                    this.client.pullPackage(orgName, packageName, version, packagePathInBalaCache, supportedPlatform, RepoUtils.getBallerinaVersion(), true);
                }
                catch (CentralClientException e) {
                    boolean enableOutputStream = Boolean.parseBoolean(System.getProperty("enableOutputStream"));
                    if (!enableOutputStream) break block4;
                    PrintStream out = System.out;
                    out.println("Error while pulling package [" + orgName + "/" + packageName + ":" + version + "]: " + e.getMessage());
                }
            }
        }
        return this.fileSystemRepo.getPackage(request, options);
    }

    @Override
    public Collection<PackageVersion> getPackageVersions(ResolutionRequest request, ResolutionOptions options) {
        String langRepoBuild = System.getProperty("LANG_REPO_BUILD");
        if (langRepoBuild != null) {
            return Collections.emptyList();
        }
        String orgName = request.orgName().value();
        String packageName = request.packageName().value();
        HashSet<PackageVersion> packageVersions = new HashSet<PackageVersion>(this.fileSystemRepo.getPackageVersions(request, options));
        if (options.offline()) {
            return new ArrayList<PackageVersion>(packageVersions);
        }
        try {
            String supportedPlatform = Arrays.stream(JvmTarget.values()).map(target -> target.code()).collect(Collectors.joining(","));
            for (String version : this.client.getPackageVersions(orgName, packageName, supportedPlatform, RepoUtils.getBallerinaVersion())) {
                packageVersions.add(PackageVersion.from(version));
            }
        }
        catch (ConnectionErrorException e) {
            return new ArrayList<PackageVersion>(packageVersions);
        }
        catch (CentralClientException e) {
            throw new ProjectException(e.getMessage());
        }
        return new ArrayList<PackageVersion>(packageVersions);
    }

    @Override
    public Map<String, List<String>> getPackages() {
        return this.fileSystemRepo.getPackages();
    }

    @Override
    public Collection<ImportModuleResponse> getPackageNames(Collection<ImportModuleRequest> requests, ResolutionOptions options) {
        Collection<ImportModuleResponse> filesystem = this.fileSystemRepo.getPackageNames(requests, options);
        if (options.offline()) {
            return filesystem;
        }
        try {
            ArrayList<ImportModuleResponse> remote = new ArrayList<ImportModuleResponse>();
            PackageNameResolutionRequest resolutionRequest = this.toPackageNameResolutionRequest(requests);
            String supportedPlatform = Arrays.stream(JvmTarget.values()).map(target -> target.code()).collect(Collectors.joining(","));
            PackageNameResolutionResponse response = this.client.resolvePackageNames(resolutionRequest, supportedPlatform, RepoUtils.getBallerinaVersion());
            remote.addAll(this.toImportModuleResponses(requests, response));
            return this.mergeNameResolution(filesystem, remote);
        }
        catch (ConnectionErrorException remote) {
        }
        catch (CentralClientException e) {
            throw new ProjectException(e.getMessage());
        }
        return filesystem;
    }

    private List<ImportModuleResponse> mergeNameResolution(Collection<ImportModuleResponse> filesystem, Collection<ImportModuleResponse> remote) {
        return new ArrayList<ImportModuleResponse>(Stream.of(filesystem, remote).flatMap(Collection::stream).collect(Collectors.toMap(ImportModuleResponse::importModuleRequest, Function.identity(), (x, y) -> {
            if (y.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.UNRESOLVED)) {
                return x;
            }
            if (x.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.UNRESOLVED)) {
                return y;
            }
            if (ProjectUtils.getLatest(x.packageDescriptor().version(), y.packageDescriptor().version()).equals(y.packageDescriptor().version())) {
                return y;
            }
            return x;
        })).values());
    }

    private List<ImportModuleResponse> toImportModuleResponses(Collection<ImportModuleRequest> requests, PackageNameResolutionResponse response) {
        ArrayList<ImportModuleResponse> result = new ArrayList<ImportModuleResponse>();
        for (ImportModuleRequest module : requests) {
            PackageOrg packageOrg = module.packageOrg();
            String moduleName = module.moduleName();
            Optional<PackageNameResolutionResponse.Module> resolvedModule = response.resolvedModules().stream().filter(m -> m.getModuleName().equals(moduleName) && m.getOrganization().equals(packageOrg.value())).findFirst();
            if (resolvedModule.isPresent()) {
                PackageDescriptor packageDescriptor = PackageDescriptor.from(packageOrg, PackageName.from(resolvedModule.get().getPackageName()), PackageVersion.from(resolvedModule.get().getVersion()));
                ImportModuleResponse importModuleResponse = new ImportModuleResponse(packageDescriptor, module);
                result.add(importModuleResponse);
                continue;
            }
            result.add(new ImportModuleResponse(module));
        }
        return result;
    }

    private PackageNameResolutionRequest toPackageNameResolutionRequest(Collection<ImportModuleRequest> unresolved) {
        PackageNameResolutionRequest request = new PackageNameResolutionRequest();
        for (ImportModuleRequest module : unresolved) {
            if (module.possiblePackages().isEmpty()) {
                request.addModule(module.packageOrg().value(), module.moduleName());
                continue;
            }
            ArrayList<PackageNameResolutionRequest.Module.PossiblePackage> possiblePackages = new ArrayList<PackageNameResolutionRequest.Module.PossiblePackage>();
            for (PackageDescriptor possiblePackage : module.possiblePackages()) {
                possiblePackages.add(new PackageNameResolutionRequest.Module.PossiblePackage(possiblePackage.org().toString(), possiblePackage.name().toString(), possiblePackage.version().toString()));
            }
            request.addModule(module.packageOrg().value(), module.moduleName(), possiblePackages, PackageResolutionRequest.Mode.MEDIUM);
        }
        return request;
    }

    @Override
    public Collection<PackageMetadataResponse> getPackageMetadata(Collection<ResolutionRequest> requests, ResolutionOptions options) {
        if (requests.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<PackageMetadataResponse> cachedPackages = this.fileSystemRepo.getPackageMetadata(requests, options);
        ArrayList<PackageMetadataResponse> deprecatedPackages = new ArrayList<PackageMetadataResponse>();
        if (options.offline()) {
            return cachedPackages;
        }
        ArrayList<ResolutionRequest> updatedRequests = new ArrayList<ResolutionRequest>(requests);
        for (PackageMetadataResponse response : cachedPackages) {
            Optional<Package> pkg;
            if (response.packageLoadRequest().version().isPresent() && response.packageLoadRequest().packageLockingMode().equals((Object)PackageLockingMode.HARD) && response.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.RESOLVED)) {
                updatedRequests.remove(response.packageLoadRequest());
            }
            if (!response.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.RESOLVED) || !(pkg = this.fileSystemRepo.getPackage(response.packageLoadRequest(), options)).isPresent() || !pkg.get().descriptor().getDeprecated().booleanValue()) continue;
            deprecatedPackages.add(response);
        }
        if (!updatedRequests.isEmpty()) {
            try {
                PackageResolutionRequest packageResolutionRequest = this.toPackageResolutionRequest(updatedRequests);
                Collection<PackageMetadataResponse> remotePackages = this.fromPackageResolutionResponse(updatedRequests, packageResolutionRequest);
                return this.mergeResolution(remotePackages, cachedPackages, deprecatedPackages);
            }
            catch (ConnectionErrorException packageResolutionRequest) {
            }
            catch (CentralClientException e) {
                throw new ProjectException(e.getMessage());
            }
        }
        return cachedPackages;
    }

    private Collection<PackageMetadataResponse> mergeResolution(Collection<PackageMetadataResponse> remoteResolution, Collection<PackageMetadataResponse> filesystem, List<PackageMetadataResponse> deprecatedPackages) {
        ArrayList<PackageMetadataResponse> mergedResults = new ArrayList<PackageMetadataResponse>(Stream.of(filesystem, remoteResolution).flatMap(Collection::stream).collect(Collectors.toMap(PackageMetadataResponse::packageLoadRequest, Function.identity(), (x, y) -> {
            if (y.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.UNRESOLVED)) {
                return x;
            }
            if (x.resolutionStatus().equals((Object)ResolutionResponse.ResolutionStatus.UNRESOLVED)) {
                return y;
            }
            if (x.resolvedDescriptor().version().equals(y.resolvedDescriptor().version())) {
                if (deprecatedPackages != null && y.resolvedDescriptor() != null && deprecatedPackages.contains(x) ^ y.resolvedDescriptor().getDeprecated()) {
                    this.fileSystemRepo.updateDeprecatedStatusForPackage(y.resolvedDescriptor());
                }
                return x;
            }
            this.fileSystemRepo.updateDeprecatedStatusForPackage(y.resolvedDescriptor());
            return y;
        })).values());
        return mergedResults;
    }

    private Collection<PackageMetadataResponse> fromPackageResolutionResponse(Collection<ResolutionRequest> packageLoadRequests, PackageResolutionRequest packageResolutionRequest) throws CentralClientException {
        ArrayList<PackageMetadataResponse> response = new ArrayList<PackageMetadataResponse>();
        HashSet<ResolutionRequest> resolvedRequests = new HashSet<ResolutionRequest>();
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(target -> target.code()).collect(Collectors.joining(","));
        PackageResolutionResponse packageResolutionResponse = this.client.resolveDependencies(packageResolutionRequest, supportedPlatform, RepoUtils.getBallerinaVersion());
        for (ResolutionRequest resolutionRequest : packageLoadRequests) {
            if (resolvedRequests.contains(resolutionRequest)) continue;
            Optional<PackageResolutionResponse.Package> match = packageResolutionResponse.resolved().stream().filter(p -> p.name().equals(resolutionRequest.packageName().value()) && p.org().equals(resolutionRequest.orgName().value())).findFirst();
            if (match.isPresent()) {
                PackageVersion version = PackageVersion.from(match.get().version());
                DependencyGraph<PackageDescriptor> dependencies = RemotePackageRepository.createPackageDependencyGraph(match.get());
                PackageDescriptor packageDescriptor = PackageDescriptor.from(resolutionRequest.orgName(), resolutionRequest.packageName(), version, match.get().getDeprecated(), match.get().getDeprecateMessage());
                PackageMetadataResponse responseDescriptor = PackageMetadataResponse.from(resolutionRequest, packageDescriptor, dependencies);
                response.add(responseDescriptor);
                resolvedRequests.add(resolutionRequest);
                continue;
            }
            response.add(PackageMetadataResponse.createUnresolvedResponse(resolutionRequest));
        }
        return response;
    }

    private static DependencyGraph<PackageDescriptor> createPackageDependencyGraph(PackageResolutionResponse.Package aPackage) {
        DependencyGraph.DependencyGraphBuilder<PackageDescriptor> graphBuilder = DependencyGraph.DependencyGraphBuilder.getBuilder();
        for (PackageResolutionResponse.Dependency dependency : aPackage.dependencyGraph()) {
            PackageDescriptor pkg = PackageDescriptor.from(PackageOrg.from(dependency.org()), PackageName.from(dependency.name()), PackageVersion.from(dependency.version()));
            HashSet<PackageDescriptor> dependentPackages = new HashSet<PackageDescriptor>();
            for (PackageResolutionResponse.Dependency dependencyPkg : dependency.dependencies()) {
                dependentPackages.add(PackageDescriptor.from(PackageOrg.from(dependencyPkg.org()), PackageName.from(dependencyPkg.name()), PackageVersion.from(dependencyPkg.version())));
            }
            graphBuilder.addDependencies(pkg, dependentPackages);
        }
        return graphBuilder.build();
    }

    private PackageResolutionRequest toPackageResolutionRequest(Collection<ResolutionRequest> resolutionRequests) {
        PackageResolutionRequest packageResolutionRequest = new PackageResolutionRequest();
        for (ResolutionRequest resolutionRequest : resolutionRequests) {
            PackageResolutionRequest.Mode mode = switch (resolutionRequest.packageLockingMode()) {
                default -> throw new MatchException(null, null);
                case PackageLockingMode.HARD, PackageLockingMode.LOCKED -> PackageResolutionRequest.Mode.HARD;
                case PackageLockingMode.MEDIUM -> PackageResolutionRequest.Mode.MEDIUM;
                case PackageLockingMode.SOFT -> PackageResolutionRequest.Mode.SOFT;
            };
            String version = resolutionRequest.version().map(v -> v.value().toString()).orElse("");
            packageResolutionRequest.addPackage(resolutionRequest.orgName().value(), resolutionRequest.packageName().value(), version, mode);
        }
        return packageResolutionRequest;
    }
}

