/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.repos;

import io.ballerina.projects.CompilationCache;
import io.ballerina.projects.CompilationCacheFactory;
import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.Project;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class FileSystemCache
extends CompilationCache {
    private final Path cacheDirPath;
    private Path birPath;
    private Path packageCacheDirPath;

    public FileSystemCache(Project project, Path cacheDirPath) {
        super(project);
        this.cacheDirPath = cacheDirPath;
    }

    @Override
    public byte[] getBir(ModuleName moduleName) {
        Path birFilePath = this.getBirPath().resolve(moduleName.toString() + ".bir");
        if (Files.exists(birFilePath, new LinkOption[0])) {
            try {
                return FileUtils.readFileToByteArray((File)birFilePath.toFile());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read the cached bir of module: " + String.valueOf(moduleName), e);
            }
        }
        return new byte[0];
    }

    @Override
    public void cacheBir(ModuleName moduleName, ByteArrayOutputStream birContent) {
        Path birFilePath = this.getBirPath().resolve(moduleName.toString() + ".bir");
        if (!Files.exists(birFilePath, new LinkOption[0])) {
            try {
                File tempBirFile = this.birPath.resolve(".tmp").toFile();
                FileUtils.writeByteArrayToFile((File)tempBirFile, (byte[])birContent.toByteArray());
                FileUtils.moveFile((File)tempBirFile, (File)birFilePath.toFile());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to cache the bir of module: " + String.valueOf(moduleName), e);
            }
        }
    }

    @Override
    public Optional<Path> getPlatformSpecificLibrary(CompilerBackend compilerBackend, String libraryName) {
        String libraryFileName = libraryName + compilerBackend.libraryFileExtension();
        Path targetPlatformCacheDirPath = this.getTargetPlatformCacheDirPath(compilerBackend);
        Path jarFilePath = targetPlatformCacheDirPath.resolve(libraryFileName);
        return Files.exists(jarFilePath, new LinkOption[0]) ? Optional.of(jarFilePath) : Optional.empty();
    }

    @Override
    public void cachePlatformSpecificLibrary(CompilerBackend compilerBackend, String libraryName, ByteArrayOutputStream libraryContent) {
        String libraryFileName = libraryName + compilerBackend.libraryFileExtension();
        Path targetPlatformCacheDirPath = this.getTargetPlatformCacheDirPath(compilerBackend);
        this.createDirectories(targetPlatformCacheDirPath);
        Path jarFilePath = targetPlatformCacheDirPath.resolve(libraryFileName);
        try {
            FileUtils.writeByteArrayToFile((File)jarFilePath.toFile(), (byte[])libraryContent.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write library: " + String.valueOf(jarFilePath), e);
        }
    }

    public Path cachePath() {
        return this.getBirPath().getParent();
    }

    private Path getTargetPlatformCacheDirPath(CompilerBackend compilerBackend) {
        String targetPlatformCode = compilerBackend.targetPlatform().code();
        return this.packageCacheDirPath().resolve(targetPlatformCode);
    }

    private void createDirectories(Path dirPath) {
        if (Files.exists(dirPath, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create directory: " + String.valueOf(dirPath), e);
        }
    }

    private Path getBirPath() {
        if (this.birPath != null) {
            return this.birPath;
        }
        this.birPath = this.packageCacheDirPath().resolve("bir");
        return this.birPath;
    }

    private Path packageCacheDirPath() {
        if (this.packageCacheDirPath != null) {
            return this.packageCacheDirPath;
        }
        Package currentPkg = this.project.currentPackage();
        PackageManifest pkgDescriptor = currentPkg.manifest();
        this.packageCacheDirPath = this.cacheDirPath.resolve(pkgDescriptor.org().value()).resolve(pkgDescriptor.name().value()).resolve(pkgDescriptor.version().toString());
        return this.packageCacheDirPath;
    }

    public static class FileSystemCacheFactory
    implements CompilationCacheFactory {
        private final Path cacheDirPath;

        public FileSystemCacheFactory(Path cacheDirPath) {
            this.cacheDirPath = cacheDirPath;
        }

        @Override
        public CompilationCache createCompilationCache(Project project) {
            return new FileSystemCache(project, this.cacheDirPath);
        }
    }
}

