/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.util;

import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.Settings;
import io.ballerina.projects.internal.BalaFiles;
import io.ballerina.projects.internal.model.PackageJson;
import io.ballerina.projects.util.BuildToolsUtil;
import io.ballerina.projects.util.ProjectUtils;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.model.ToolResolutionCentralRequest;
import org.ballerinalang.central.client.model.ToolResolutionCentralResponse;
import org.wso2.ballerinalang.util.RepoUtils;

public class BalToolsUtil {
    public static final Path BAL_TOOLS_TOML_PATH = RepoUtils.createAndGetHomeReposPath().resolve(Path.of(".config", "bal-tools.toml"));
    public static final Path DIST_BAL_TOOLS_TOML_PATH = ProjectUtils.getBalHomePath().resolve("resources").resolve("bal-tools.toml");

    private BalToolsUtil() {
    }

    public static boolean isCompatibleWithDistVersion(SemanticVersion distVersion, SemanticVersion toolDistVersion) {
        return distVersion.major() == toolDistVersion.major() && distVersion.minor() >= toolDistVersion.minor();
    }

    public static boolean isCompatibleWithPlatform(String org, String name, String version, String repository) {
        SemanticVersion currentDistVersion = SemanticVersion.from(RepoUtils.getBallerinaShortVersion());
        Optional<SemanticVersion> toolDistVersion = BalToolsUtil.getToolDistVersionFromCache(org, name, version, repository);
        return toolDistVersion.filter(semanticVersion -> BalToolsUtil.isCompatibleWithDistVersion(currentDistVersion, semanticVersion)).isPresent();
    }

    public static boolean isCompatibleWithPlatform(String org, String name, String version) {
        return BalToolsUtil.isCompatibleWithPlatform(org, name, version, "central.ballerina.io");
    }

    public static SemanticVersion.VersionCompatibilityResult compareToolDistWithCurrentDist(String org, String name, String versions, String repository) {
        SemanticVersion currentDistVersion = SemanticVersion.from(RepoUtils.getBallerinaShortVersion());
        Optional<SemanticVersion> toolDistVersion = BalToolsUtil.getToolDistVersionFromCache(org, name, versions, repository);
        if (toolDistVersion.isEmpty()) {
            return SemanticVersion.VersionCompatibilityResult.INCOMPATIBLE;
        }
        return toolDistVersion.get().compareTo(currentDistVersion);
    }

    public static Set<String> getInBuiltToolCommands(BalToolsManifest distBalToolsManifest) {
        return distBalToolsManifest.tools().keySet();
    }

    public static Path getRepoPath(String repoName) {
        if ("local".equals(repoName)) {
            return ProjectUtils.createAndGetHomeReposPath().resolve(Path.of("repositories", "local", "bala"));
        }
        if ("distribution".equals(repoName)) {
            return ProjectUtils.getBalHomePath().resolve(Path.of("repo", "bala"));
        }
        return BuildToolsUtil.getCentralBalaDirPath();
    }

    public static ToolResolutionCentralResponse getLatestVersionsInCentral(ToolResolutionCentralRequest toolResolutionRequest) throws CentralClientException {
        Settings settings = RepoUtils.readSettings();
        CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy(settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI(settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
        ToolResolutionCentralResponse packageResolutionResponse = client.resolveToolDependencies(toolResolutionRequest, supportedPlatform, RepoUtils.getBallerinaVersion());
        return packageResolutionResponse;
    }

    public static BalToolsManifest.Tool pullToolPackageFromRemote(String toolId, String version) throws CentralClientException {
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
        Path balaCacheDirPath = BuildToolsUtil.getCentralBalaDirPath();
        Settings settings = RepoUtils.readSettings();
        System.setProperty("enableOutputStream", Boolean.TRUE.toString());
        CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy(settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI(settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
        String[] toolInfo = client.pullTool(toolId, version, balaCacheDirPath, supportedPlatform, RepoUtils.getBallerinaVersion(), false);
        return new BalToolsManifest.Tool(toolId, toolInfo[0], toolInfo[1], toolInfo[2], true, null);
    }

    private static Optional<SemanticVersion> getToolDistVersionFromCache(String org, String name, String version, String repository) {
        PackageJson packageJson;
        Path balaPath = ProjectUtils.getPackagePath(BalToolsUtil.getRepoPath(repository), org, name, version);
        try {
            packageJson = BalaFiles.readPackageJson(balaPath);
        }
        catch (ProjectException e) {
            return Optional.empty();
        }
        return Optional.of(SemanticVersion.from(packageJson.getBallerinaVersion()));
    }
}

