/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.util;

import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.BlendedBalToolsManifest;
import io.ballerina.projects.BuildTool;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.buildtools.CodeGeneratorTool;
import io.ballerina.projects.buildtools.ToolConfig;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.util.BalToolsUtil;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.wso2.ballerinalang.util.RepoUtils;

public final class BuildToolsUtil {
    private BuildToolsUtil() {
    }

    public static TomlDiagnostic getBuildToolCommandNotFoundDiagnostic(String commandName, TomlNodeLocation location) {
        String message = "Build tool command '" + commandName + "' not found";
        ProjectDiagnosticErrorCode diagnosticCode = ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND;
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticCode.diagnosticId(), diagnosticCode.messageKey(), DiagnosticSeverity.ERROR);
        return new TomlDiagnostic(location, diagnosticInfo, message);
    }

    public static TomlDiagnostic getCannotResolveBuildToolDiagnostic(String toolId, TomlNodeLocation location) {
        String message = "Build tool '" + toolId + "' cannot be resolved";
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND.diagnosticId(), ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND.messageKey(), DiagnosticSeverity.ERROR);
        return new TomlDiagnostic(location, diagnosticInfo, message);
    }

    public static Optional<CodeGeneratorTool> getTargetTool(String commandName, ServiceLoader<CodeGeneratorTool> buildRunners) {
        String[] subcommandNames = commandName.split("\\.");
        CodeGeneratorTool[] subcommands = (CodeGeneratorTool[])buildRunners.stream().map(ServiceLoader.Provider::get).toArray(CodeGeneratorTool[]::new);
        return BuildToolsUtil.getTargetToolRec(subcommandNames, 0, subcommands);
    }

    public static Optional<TomlDiagnostic> getDiagnosticIfInvalidCommandName(String fullCommandName, TomlNodeLocation location) {
        String[] subcommandNames;
        for (String subcommandName : subcommandNames = fullCommandName.split("\\.")) {
            ValidationStatus validationStatus = BuildToolsUtil.validateCommandName(subcommandName);
            if (validationStatus == ValidationStatus.VALID) continue;
            return Optional.of(BuildToolsUtil.getInvalidCommandNameDiagnostic(fullCommandName, validationStatus.message(), location));
        }
        return Optional.empty();
    }

    private static TomlDiagnostic getInvalidCommandNameDiagnostic(String cmdName, String reason, TomlNodeLocation location) {
        String message = "Command name '" + cmdName + "' is invalid because " + reason;
        ProjectDiagnosticErrorCode diagnosticCode = ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND;
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticCode.diagnosticId(), diagnosticCode.messageKey(), DiagnosticSeverity.ERROR);
        return new TomlDiagnostic(location, diagnosticInfo, message);
    }

    private static Optional<CodeGeneratorTool> getTargetToolRec(String[] subcommandNames, int level, CodeGeneratorTool[] commands) {
        for (CodeGeneratorTool buildRunner : commands) {
            ToolConfig toolConfig;
            Class<?> codeGeneratorToolClass = buildRunner.getClass();
            if (!codeGeneratorToolClass.isAnnotationPresent(ToolConfig.class) || !(toolConfig = codeGeneratorToolClass.getAnnotation(ToolConfig.class)).name().equals(subcommandNames[level])) continue;
            if (level + 1 == subcommandNames.length) {
                if (toolConfig.hidden()) {
                    return Optional.empty();
                }
                return Optional.of(buildRunner);
            }
            CodeGeneratorTool[] subcommands = (CodeGeneratorTool[])Arrays.stream(toolConfig.subcommands()).map(cmdClz -> {
                try {
                    return (CodeGeneratorTool)cmdClz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new ProjectException("Error while fetching target tool: " + String.valueOf(e));
                }
            }).toArray(CodeGeneratorTool[]::new);
            return BuildToolsUtil.getTargetToolRec(subcommandNames, level + 1, subcommands);
        }
        return Optional.empty();
    }

    private static ValidationStatus validateCommandName(String cmdName) {
        ValidationStatus status = ValidationStatus.VALID;
        if (cmdName == null || cmdName.isEmpty()) {
            status = ValidationStatus.EMPTY;
        } else if (!cmdName.matches("^[\\w-]+$")) {
            status = ValidationStatus.NON_ALPHANUMERIC;
        } else if (cmdName.startsWith("_")) {
            status = ValidationStatus.LEADING_UNDERSCORE;
        } else if (cmdName.endsWith("_")) {
            status = ValidationStatus.TRAILING_UNDERSCORE;
        } else if (cmdName.contains("__")) {
            status = ValidationStatus.CONSECUTIVE_UNDERSCORES;
        }
        return status;
    }

    public static Path getCentralBalaDirPath() {
        Path userHomeDirPath = RepoUtils.createAndGetHomeReposPath();
        return userHomeDirPath.resolve(Path.of("repositories", "central.ballerina.io", "bala"));
    }

    public static TomlNodeLocation getFirstToolEntryLocation(String toolId, List<PackageManifest.Tool> toolEntries) {
        for (PackageManifest.Tool toolEntry : toolEntries) {
            if (!toolEntry.type().value().equals(toolId)) continue;
            return toolEntry.type().location();
        }
        return null;
    }

    public static Optional<BalToolsManifest.Tool> getCompatibleToolVersionsAvailableLocally(BuildTool tool, PackageVersion minVersion, PackageLockingMode packageLockingMode) {
        ProjectUtils.CompatibleRange compatibleRange;
        List<SemanticVersion> compatibleSemVers;
        BalToolsToml distBalToolsToml;
        BalToolsManifest distBalToolsManifest;
        String toolId = tool.id().toString();
        BalToolsToml balToolsToml = BalToolsToml.from(BalToolsUtil.BAL_TOOLS_TOML_PATH);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from(balToolsToml).build();
        BlendedBalToolsManifest blendedBalToolsManifest = BlendedBalToolsManifest.from(balToolsManifest, distBalToolsManifest = BalToolsManifestBuilder.from(distBalToolsToml = BalToolsToml.from(BalToolsUtil.DIST_BAL_TOOLS_TOML_PATH)).build());
        Map<String, Map<String, BalToolsManifest.Tool>> allCompatibleVersions = blendedBalToolsManifest.compatibleVersions(toolId);
        if (allCompatibleVersions.isEmpty()) {
            return Optional.empty();
        }
        SemanticVersion minSemVer = minVersion == null ? null : minVersion.value();
        List<SemanticVersion> versionsInCompatibleRange = ProjectUtils.getVersionsInCompatibleRange(minSemVer, compatibleSemVers = allCompatibleVersions.keySet().stream().map(SemanticVersion::from).toList(), compatibleRange = ProjectUtils.getCompatibleRange(minSemVer, packageLockingMode));
        Optional<SemanticVersion> latestVersion = BuildToolsUtil.getLatestVersion(versionsInCompatibleRange);
        if (latestVersion.isPresent()) {
            for (Map.Entry<String, Map<String, BalToolsManifest.Tool>> entry : allCompatibleVersions.entrySet()) {
                if (!latestVersion.get().equals(SemanticVersion.from(entry.getKey()))) continue;
                return Optional.of(entry.getValue().entrySet().iterator().next().getValue());
            }
        }
        return Optional.empty();
    }

    public static void addToolToBalToolsToml(BuildTool tool) {
        BalToolsToml balToolsToml = BalToolsToml.from(BalToolsUtil.BAL_TOOLS_TOML_PATH);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from(balToolsToml).build();
        balToolsManifest.addTool(tool.id().toString(), tool.org().toString(), tool.name().toString(), tool.version().toString(), false, null);
        balToolsToml.modify(balToolsManifest);
    }

    private static Optional<SemanticVersion> getLatestVersion(List<SemanticVersion> versions) {
        if (versions.isEmpty()) {
            return Optional.empty();
        }
        SemanticVersion latestVersion = versions.get(0);
        for (SemanticVersion version : versions) {
            if (!version.greaterThan(latestVersion)) continue;
            latestVersion = version;
        }
        return Optional.of(latestVersion);
    }

    private static enum ValidationStatus {
        EMPTY("command name should not be empty."),
        NON_ALPHANUMERIC("command name should only contain alphanumeric characters and underscores."),
        LEADING_UNDERSCORE("command name should not start with an underscore."),
        TRAILING_UNDERSCORE("command name should not end with an underscore."),
        CONSECUTIVE_UNDERSCORES("command name should not contain consecutive underscores."),
        VALID("Valid command name.");

        private final String message;

        private ValidationStatus(String message) {
            this.message = message;
        }

        public String message() {
            return this.message;
        }
    }
}

