/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.util;

import io.ballerina.projects.ProjectException;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.projects.util.TomlUtil;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public final class ProjectPaths {
    public static final String WORKSPACE_KEY = "workspace";
    public static final String PACKAGE_KEY = "package";

    private ProjectPaths() {
    }

    public static Path packageRoot(Path filepath) throws ProjectException {
        if (!Files.exists(filepath, new LinkOption[0])) {
            throw new ProjectException("'" + String.valueOf(filepath) + "' does not exist");
        }
        if (Files.isDirectory(filepath, new LinkOption[0])) {
            if (ProjectPaths.isBuildProjectRoot(filepath) || ProjectPaths.hasPackageJson(filepath)) {
                return filepath;
            }
            if (ProjectPaths.isModulesRoot(filepath) || ProjectPaths.isGeneratedModulesRoot(filepath) || ProjectPaths.isAModuleRoot(filepath) || ProjectPaths.isAGeneratedModuleRoot(filepath) || ProjectPaths.isAModuleTestsRoot(filepath) || ProjectPaths.isAGeneratedModuleTestsRoot(filepath)) {
                return ProjectPaths.findProjectRoot(filepath).orElseThrow();
            }
            throw new ProjectException("provided directory does not belong to a Ballerina package: " + String.valueOf(filepath));
        }
        if (!Files.isRegularFile(filepath, new LinkOption[0])) {
            throw new ProjectException("'" + String.valueOf(filepath) + "' is not a regular file");
        }
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(filepath);
        if (projectRoot.isEmpty()) {
            throw new ProjectException("provided file path does not belong to a Ballerina package: " + String.valueOf(filepath));
        }
        Path absFilePath = filepath.toAbsolutePath().normalize();
        if (ProjectPaths.isBuildProjectRoot(projectRoot.get())) {
            if (ProjectPaths.isBallerinaRelatedToml(filepath)) {
                return filepath.getParent();
            }
            if (!ProjectPaths.isBalFile(filepath)) {
                throw new ProjectException("'" + String.valueOf(filepath) + "' is not a valid Ballerina source file");
            }
            if (ProjectPaths.isDefaultModuleSrcFile(absFilePath)) {
                Path parentPath = absFilePath.getParent();
                if ("generated".equals(Optional.of(parentPath).get().toFile().getName())) {
                    parentPath = parentPath.getParent();
                }
                return parentPath;
            }
            if (ProjectPaths.isDefaultModuleTestFile(absFilePath)) {
                Path testsRoot = Optional.of(absFilePath.getParent()).get();
                Path parentPath = testsRoot.getParent();
                if ("generated".equals(Optional.of(parentPath).get().toFile().getName())) {
                    parentPath = parentPath.getParent();
                }
                return parentPath;
            }
            if (ProjectPaths.isNonDefaultModuleSrcFile(filepath)) {
                Path modulesRoot = Optional.of(Optional.of(absFilePath.getParent()).get().getParent()).get();
                return modulesRoot.getParent();
            }
            if (ProjectPaths.isNonDefaultModuleTestFile(filepath)) {
                Path testsRoot = Optional.of(absFilePath.getParent()).get();
                Path modulesRoot = Optional.of(Optional.of(testsRoot.getParent()).get().getParent()).get();
                return modulesRoot.getParent();
            }
        } else if (ProjectPaths.isBalaProjectSrcFile(filepath)) {
            Path modulesRoot = Optional.of(Optional.of(absFilePath.getParent()).get().getParent()).get();
            return modulesRoot.getParent();
        }
        throw new ProjectException("provided file path does not belong to a Ballerina package: " + String.valueOf(filepath));
    }

    private static boolean isAGeneratedModuleRoot(Path filepath) {
        Path fileName;
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(absFilePath);
        if (projectRoot.isPresent() && (fileName = absFilePath.getFileName()) != null) {
            Path generatedModuleRoot = projectRoot.get().resolve("generated").resolve(fileName);
            return generatedModuleRoot.toAbsolutePath().normalize().toString().equals(absFilePath.toString());
        }
        return false;
    }

    private static boolean isAGeneratedModuleTestsRoot(Path filepath) {
        Path parent;
        Path fileName;
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(absFilePath);
        if (projectRoot.isPresent() && (fileName = absFilePath.getFileName()) != null && fileName.toString().equals("tests") && (parent = filepath.getParent()) != null) {
            if (projectRoot.get().resolve("generated").resolve("tests").toString().equals(absFilePath.toString())) {
                return true;
            }
            Path generatedModuleRoot = projectRoot.get().resolve("generated").resolve(Optional.of(parent.getFileName()).get());
            return generatedModuleRoot.toAbsolutePath().normalize().toString().equals(parent.toString());
        }
        return false;
    }

    private static boolean isModulesRoot(Path filepath) {
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(absFilePath);
        if (projectRoot.isPresent()) {
            Path modulesRoot = projectRoot.get().resolve("modules");
            return modulesRoot.toAbsolutePath().normalize().toString().equals(absFilePath.toString());
        }
        return false;
    }

    private static boolean isGeneratedModulesRoot(Path filepath) {
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(absFilePath);
        if (projectRoot.isPresent()) {
            Path generatedModulesRoot = projectRoot.get().resolve("generated");
            return generatedModulesRoot.toAbsolutePath().normalize().toString().equals(absFilePath.toString());
        }
        return false;
    }

    private static boolean isAModuleTestsRoot(Path filepath) {
        Path parent;
        Path fileName;
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(filepath);
        if (projectRoot.isPresent() && (fileName = absFilePath.getFileName()) != null && fileName.toString().equals("tests") && (parent = filepath.getParent()) != null) {
            if (projectRoot.get().resolve("tests").toString().equals(absFilePath.toString())) {
                return true;
            }
            Path moduleRoot = projectRoot.get().resolve("modules").resolve(Optional.of(parent.getFileName()).get());
            return moduleRoot.toAbsolutePath().normalize().toString().equals(parent.toString());
        }
        return false;
    }

    private static boolean isAModuleRoot(Path filepath) {
        Path fileName;
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(absFilePath);
        if (projectRoot.isPresent() && (fileName = absFilePath.getFileName()) != null) {
            Path moduleRoot = projectRoot.get().resolve("modules").resolve(fileName);
            return moduleRoot.toAbsolutePath().normalize().toString().equals(absFilePath.toString());
        }
        return false;
    }

    public static boolean isBalFile(Path filepath) {
        return Files.exists(filepath, new LinkOption[0]) && Files.isRegularFile(filepath, new LinkOption[0]) && filepath.toString().endsWith(".bal");
    }

    private static boolean isBallerinaRelatedToml(Path filepath) {
        String fileName;
        return switch (fileName = Optional.of(filepath.getFileName()).get().toString()) {
            case "Ballerina.toml", "Cloud.toml", "Config.toml", "Dependencies.toml" -> true;
            default -> false;
        };
    }

    public static boolean isStandaloneBalFile(Path filepath) {
        if (!ProjectPaths.isBalFile(filepath)) {
            return false;
        }
        if (ProjectPaths.findProjectRoot(filepath).isEmpty()) {
            return true;
        }
        if (ProjectPaths.isDefaultModuleSrcFile(filepath)) {
            return false;
        }
        if (ProjectPaths.isDefaultModuleTestFile(filepath)) {
            return false;
        }
        if (ProjectPaths.isNonDefaultModuleSrcFile(filepath)) {
            return false;
        }
        if (ProjectPaths.isNonDefaultModuleTestFile(filepath)) {
            return false;
        }
        return !ProjectPaths.isBalaProjectSrcFile(filepath);
    }

    static boolean isDefaultModuleSrcFile(Path filePath) {
        Path parentPath = filePath.toAbsolutePath().normalize().getParent();
        if ("generated".equals(Optional.of(parentPath).get().toFile().getName())) {
            parentPath = parentPath.getParent();
        }
        return ProjectPaths.isBuildProjectRoot(Optional.of(parentPath).get());
    }

    static boolean isDefaultModuleTestFile(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        Path testsRoot = Optional.of(absFilePath.getParent()).get();
        if (!"tests".equals(testsRoot.toFile().getName())) {
            return false;
        }
        Path projectRoot = Optional.of(testsRoot.getParent()).get();
        if ("generated".equals(projectRoot.toFile().getName())) {
            projectRoot = projectRoot.getParent();
        }
        return projectRoot != null && ProjectPaths.isBuildProjectRoot(projectRoot);
    }

    static boolean isNonDefaultModuleSrcFile(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        Path modulesRoot = Optional.of(Optional.of(absFilePath.getParent()).get().getParent()).get();
        Path projectRoot = modulesRoot.getParent();
        return ("modules".equals(modulesRoot.toFile().getName()) || "generated".equals(modulesRoot.toFile().getName())) && ProjectPaths.isBuildProjectRoot(projectRoot);
    }

    static boolean isBalaProjectSrcFile(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        Path modulesRoot = Optional.of(Optional.of(absFilePath.getParent()).get().getParent()).get();
        Path projectRoot = modulesRoot.getParent();
        return "modules".equals(modulesRoot.toFile().getName()) && ProjectPaths.hasPackageJson(projectRoot);
    }

    static boolean isNonDefaultModuleTestFile(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        Path testsRoot = Optional.of(absFilePath.getParent()).get();
        if (!"tests".equals(testsRoot.toFile().getName())) {
            return false;
        }
        Path modulesRoot = Optional.of(Optional.of(testsRoot.getParent()).get().getParent()).get();
        Path projectRoot = modulesRoot.getParent();
        return ("modules".equals(modulesRoot.toFile().getName()) || "generated".equals(modulesRoot.toFile().getName())) && ProjectPaths.isBuildProjectRoot(projectRoot);
    }

    private static boolean hasPackageJson(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        return absFilePath.resolve("package.json").toFile().exists();
    }

    private static Optional<Path> findProjectRoot(Path filePath) {
        if (filePath != null) {
            if ((filePath = filePath.toAbsolutePath().normalize()).toFile().isDirectory() && (ProjectPaths.isBuildProjectRoot(filePath) || ProjectPaths.hasPackageJson(filePath))) {
                return Optional.of(filePath);
            }
            return ProjectPaths.findProjectRoot(filePath.getParent());
        }
        return Optional.empty();
    }

    private static Optional<Path> findWorkspaceRoot(Path filePath) {
        if (filePath != null) {
            if ((filePath = filePath.toAbsolutePath().normalize()).toFile().isDirectory() && ProjectPaths.isWorkspaceProjectRoot(filePath)) {
                return Optional.of(filePath);
            }
            return ProjectPaths.findWorkspaceRoot(filePath.getParent());
        }
        return Optional.empty();
    }

    public static Optional<Path> workspaceRoot(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        if (ProjectPaths.isWorkspaceProjectRoot(absFilePath)) {
            return Optional.of(absFilePath);
        }
        Optional<Path> workspaceRoot = ProjectPaths.findWorkspaceRoot(absFilePath);
        if (workspaceRoot.isPresent()) {
            try {
                TomlDocument tomlDocument = TomlDocument.from("Ballerina.toml", Files.readString(workspaceRoot.get().resolve("Ballerina.toml")));
                TomlTableNode tomlAstNode = tomlDocument.toml().rootNode();
                TopLevelNode topLevelPkgNode = (TopLevelNode)tomlAstNode.entries().get(WORKSPACE_KEY);
                if (topLevelPkgNode != null && topLevelPkgNode.kind() == TomlType.TABLE) {
                    if (absFilePath.equals(workspaceRoot.get().resolve("Ballerina.toml"))) {
                        return workspaceRoot;
                    }
                    Path packageRoot = ProjectPaths.packageRoot(filePath);
                    TomlTableNode pkgNode = (TomlTableNode)topLevelPkgNode;
                    List<String> packages = TomlUtil.getStringArrayFromTableNode(pkgNode, "packages");
                    for (String pkgEntry : packages) {
                        if (!workspaceRoot.get().resolve(pkgEntry).toAbsolutePath().normalize().equals(packageRoot.toAbsolutePath().normalize())) continue;
                        return workspaceRoot;
                    }
                    return Optional.empty();
                }
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static boolean isBuildProjectRoot(Path filePath) {
        if (!filePath.toFile().isDirectory()) {
            return false;
        }
        Path absFilePath = filePath.resolve("Ballerina.toml").toAbsolutePath().normalize();
        if (absFilePath.toFile().exists()) {
            try {
                TomlDocument tomlDocument = TomlDocument.from("Ballerina.toml", Files.readString(absFilePath));
                if (tomlDocument.toml().getTable(PACKAGE_KEY).isPresent()) {
                    return true;
                }
                return tomlDocument.toml().getTable(WORKSPACE_KEY).isEmpty();
            }
            catch (IOException e) {
                throw new ProjectException("error while validating workspace root: " + String.valueOf(e));
            }
        }
        return false;
    }

    public static boolean isBalaProjectRoot(Path filePath) {
        if (FileUtils.hasExtension(filePath)) {
            return filePath.toAbsolutePath().normalize().endsWith(".bala");
        }
        return ProjectPaths.hasPackageJson(filePath);
    }

    public static boolean isWorkspaceProjectRoot(Path filePath) {
        if (!filePath.toFile().isDirectory()) {
            return false;
        }
        Path absFilePath = filePath.resolve("Ballerina.toml").toAbsolutePath().normalize();
        if (absFilePath.toFile().exists()) {
            try {
                TomlDocument tomlDocument = TomlDocument.from("Ballerina.toml", Files.readString(absFilePath));
                return tomlDocument.toml().getTable(WORKSPACE_KEY).isPresent();
            }
            catch (IOException e) {
                throw new ProjectException("error while validating workspace root: " + String.valueOf(e));
            }
        }
        return false;
    }
}

