/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.util;

import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlArrayValueNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.List;

public class TomlUtil {
    private TomlUtil() {
    }

    public static List<String> getStringArrayFromTableNode(TomlTableNode pkgNode, String key) {
        ArrayList<String> elements = new ArrayList<String>();
        TopLevelNode topLevelNode = (TopLevelNode)pkgNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() == TomlType.NONE) {
            return elements;
        }
        TomlValueNode valueNode = ((TomlKeyValueNode)topLevelNode).value();
        if (valueNode.kind() == TomlType.NONE) {
            return elements;
        }
        if (valueNode.kind() == TomlType.ARRAY) {
            TomlArrayValueNode arrayValueNode = (TomlArrayValueNode)valueNode;
            for (TomlValueNode value : arrayValueNode.elements()) {
                if (value.kind() != TomlType.STRING) continue;
                elements.add((String)((TomlStringValueNode)value).getValue());
            }
        }
        return elements;
    }

    public static Diagnostic createDiagnostic(TopLevelNode tomlTableNode, String message, ProjectDiagnosticErrorCode errorCode, DiagnosticSeverity severity) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(errorCode.diagnosticId(), errorCode.messageKey(), severity);
        return new TomlDiagnostic(tomlTableNode.location(), diagnosticInfo, message);
    }
}

