/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.tree.BlockNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

class BIRGenEnv {
    BIRNode.BIRPackage enclPkg;
    BIRNode.BIRFunction enclFunc;
    boolean isInitFunc;
    List<BIRNode.BIRBasicBlock> enclBasicBlocks;
    Map<BSymbol, BIRNode.BIRVariableDcl> symbolVarMap = new HashMap<BSymbol, BIRNode.BIRVariableDcl>();
    private int currentBBId = -1;
    private int currentLocalVarId = -1;
    private int currentLambdaVarId = -1;
    BIRNode.BIRBasicBlock enclBB;
    BIROperand targetOperand;
    BIRNode.BIRBasicBlock enclLoopBB;
    BIRNode.BIRBasicBlock enclLoopEndBB;
    BIRNode.BIRBasicBlock enclOnFailEndBB;
    BIRNode.BIRBasicBlock enclInnerOnFailEndBB;
    Deque<List<BIRNode.BIRBasicBlock>> trapBlocks = new ArrayDeque<List<BIRNode.BIRBasicBlock>>();
    Map<BlockNode, List<BIRNode.BIRVariableDcl>> varDclsByBlock = new HashMap<BlockNode, List<BIRNode.BIRVariableDcl>>();
    Deque<BIRNode.BIRLockDetailsHolder> unlockVars = new ArrayDeque<BIRNode.BIRLockDetailsHolder>();
    BIRNode.BIRBasicBlock returnBB;
    int isInArrayOrStructure = 0;

    BIRGenEnv(BIRNode.BIRPackage birPkg) {
        this.enclPkg = birPkg;
    }

    int nextBBId() {
        return ++this.currentBBId;
    }

    Name nextLocalVarId(Names names) {
        ++this.currentLocalVarId;
        return names.merge(Names.BIR_LOCAL_VAR_PREFIX, Names.fromString(Integer.toString(this.currentLocalVarId)));
    }

    Name nextLambdaVarId(Names names) {
        ++this.currentLambdaVarId;
        return names.merge(Names.BIR_LOCAL_VAR_PREFIX, Names.fromString(Integer.toString(this.currentLambdaVarId)));
    }

    void clear() {
        this.symbolVarMap.clear();
        this.currentLocalVarId = -1;
        this.currentBBId = -1;
        this.targetOperand = null;
        this.enclBB = null;
        this.returnBB = null;
        this.enclFunc = null;
        this.isInitFunc = false;
        this.varDclsByBlock.clear();
        this.unlockVars.clear();
    }
}

