/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir;

import java.util.Comparator;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.util.Name;

public final class BIRGenUtils {
    private BIRGenUtils() {
    }

    public static void rearrangeBasicBlocks(BIRNode.BIRPackage birPackage) {
        for (BIRNode.BIRTypeDefinition tDef : birPackage.typeDefs) {
            for (BIRNode.BIRFunction birFunction : tDef.attachedFuncs) {
                BIRGenUtils.rearrangeBasicBlocks(birFunction);
            }
        }
        for (BIRNode.BIRFunction birFunction : birPackage.functions) {
            BIRGenUtils.rearrangeBasicBlocks(birFunction);
        }
    }

    public static void rearrangeBasicBlocks(BIRNode.BIRFunction birFunction) {
        int currentBBId = 0;
        for (BIRNode.BIRBasicBlock bb : birFunction.basicBlocks) {
            currentBBId = BIRGenUtils.renumberBasicBlock(currentBBId, bb);
        }
        birFunction.errorTable.sort(Comparator.comparingInt(o -> o.trapBB.number));
    }

    public static int renumberBasicBlock(int newBBNum, BIRNode.BIRBasicBlock bb) {
        bb.number = newBBNum;
        bb.id = new Name("bb" + newBBNum);
        return newBBNum + 1;
    }
}

