/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.types.Env;
import org.ballerinalang.compiler.BLangCompilerException;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JType;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmCastGen {
    private final SymbolTable symbolTable;
    private final JvmTypeGen jvmTypeGen;
    private final Types types;

    public JvmCastGen(SymbolTable symbolTable, JvmTypeGen jvmTypeGen, Types types) {
        this.symbolTable = symbolTable;
        this.jvmTypeGen = jvmTypeGen;
        this.types = types;
    }

    void generatePlatformCheckCast(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, BType sourceType, BType targetType) {
        if (sourceType.tag == Integer.MAX_VALUE) {
            this.generateJToBCheckCast(mv, indexMap, (JType)sourceType, targetType);
        } else {
            this.generateBToJCheckCast(mv, sourceType, (JType)targetType);
        }
    }

    public void generateBToJCheckCast(MethodVisitor mv, BType sourceType, JType targetType) {
        sourceType = JvmCodeGenUtil.getImpliedType(sourceType);
        switch (targetType.jTag) {
            case 1: {
                this.generateCheckCastBToJByte(mv, sourceType);
                break;
            }
            case 2: {
                this.generateCheckCastBToJChar(mv, sourceType);
                break;
            }
            case 3: {
                this.generateCheckCastBToJShort(mv, sourceType);
                break;
            }
            case 4: {
                this.generateCheckCastBToJInt(mv, sourceType);
                break;
            }
            case 5: {
                this.generateCheckCastBToJLong(mv, sourceType);
                break;
            }
            case 6: {
                this.generateCheckCastBToJFloat(mv, sourceType);
                break;
            }
            case 7: {
                this.generateCheckCastBToJDouble(mv, sourceType);
                break;
            }
            case 8: {
                this.generateCheckCastBToJBoolean(mv, sourceType);
                break;
            }
            case 9: 
            case 10: {
                this.generateCheckCastBToJRef(mv, sourceType, targetType);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'java " + String.valueOf(targetType) + "'");
            }
        }
    }

    private void generateCheckCastBToJByte(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
            mv.visitInsn(145);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                break;
            }
            case 3: {
                mv.visitInsn(142);
                mv.visitInsn(145);
                break;
            }
            case 37: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
                break;
            }
            case 33: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToByte", "(Ljava/lang/Object;)I", false);
                mv.visitInsn(145);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'java byte'");
            }
        }
    }

    private void generateCheckCastBToJChar(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
            mv.visitInsn(146);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(146);
                break;
            }
            case 3: {
                mv.visitInsn(142);
                mv.visitInsn(146);
                break;
            }
            case 37: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
                break;
            }
            case 33: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", "(Ljava/lang/Object;)J", false);
                mv.visitInsn(136);
                mv.visitInsn(146);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'java char'");
            }
        }
    }

    private void generateCheckCastBToJShort(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
            mv.visitInsn(147);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(147);
                break;
            }
            case 3: {
                mv.visitInsn(142);
                mv.visitInsn(147);
                break;
            }
            case 37: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
                break;
            }
            case 33: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", "(Ljava/lang/Object;)J", false);
                mv.visitInsn(136);
                mv.visitInsn(147);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'java short'");
            }
        }
    }

    private void generateCheckCastBToJInt(MethodVisitor mv, BType sourceType) {
        sourceType = JvmCodeGenUtil.getImpliedType(sourceType);
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                break;
            }
            case 3: {
                mv.visitInsn(142);
                break;
            }
            case 37: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
                break;
            }
            case 33: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", "(Ljava/lang/Object;)J", false);
                mv.visitInsn(136);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'java int'");
            }
        }
    }

    private void generateCheckCastBToJLong(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitInsn(143);
                break;
            }
            case 37: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
                mv.visitTypeInsn(192, "java/lang/Long");
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                break;
            }
            case 33: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", "(Ljava/lang/Object;)J", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'java long'");
            }
        }
    }

    private void generateCheckCastBToJFloat(MethodVisitor mv, BType sourceType) {
        sourceType = JvmCodeGenUtil.getImpliedType(sourceType);
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(137);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(134);
                break;
            }
            case 3: {
                mv.visitInsn(144);
                break;
            }
            case 37: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
                break;
            }
            case 33: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToFloat", "(Ljava/lang/Object;)D", false);
                mv.visitInsn(144);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'java float'");
            }
        }
    }

    private void generateCheckCastBToJDouble(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(138);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(135);
                break;
            }
            case 3: {
                break;
            }
            case 37: {
                mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
                break;
            }
            case 33: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToFloat", "(Ljava/lang/Object;)D", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'java double'");
            }
        }
    }

    private void generateCheckCastBToJBoolean(MethodVisitor mv, BType sourceType) {
        sourceType = JvmCodeGenUtil.getImpliedType(sourceType);
        switch (sourceType.tag) {
            case 6: {
                break;
            }
            case 33: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToBoolean", "(Ljava/lang/Object;)Z", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'java boolean'");
            }
        }
    }

    private void generateCheckCastBToJRef(MethodVisitor mv, BType sourceType, JType targetType) {
        if (sourceType.tag == 4) {
            return;
        }
        if (sourceType.tag == 37) {
            if (targetType.jTag == 10) {
                JType.JRefType jRefType = (JType.JRefType)targetType;
                if (jRefType.typeValue.equals("io/ballerina/runtime/internal/values/HandleValue") || jRefType.typeValue.equals("io/ballerina/runtime/api/values/BHandle")) {
                    return;
                }
            }
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
            String sig = InteropMethodGen.getSignatureForJType(targetType);
            mv.visitTypeInsn(192, sig);
        } else if (targetType.jTag == 10) {
            this.addBoxInsn(mv, sourceType);
            mv.visitTypeInsn(192, ((JType.JRefType)targetType).typeValue);
        } else {
            throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to '" + String.valueOf(targetType) + "'");
        }
    }

    private void generateJToBCheckCast(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType, BType targetType) {
        targetType = JvmCodeGenUtil.getImpliedType(targetType);
        if (TypeTags.isIntegerTypeTag(targetType.tag)) {
            this.generateCheckCastJToBInt(mv, sourceType);
            return;
        }
        switch (targetType.tag) {
            case 3: {
                this.generateCheckCastJToBFloat(mv, sourceType);
                break;
            }
            case 4: {
                this.generateCheckCastJToBDecimal(mv, sourceType);
                break;
            }
            case 6: {
                this.generateCheckCastJToBBoolean(mv, sourceType);
                break;
            }
            case 2: {
                this.generateCheckCastJToBByte(mv, sourceType);
                break;
            }
            case 10: 
            case 50: {
                break;
            }
            default: {
                switch (targetType.tag) {
                    case 21: {
                        this.generateCheckCastJToBUnionType(mv, indexMap, sourceType, (BUnionType)targetType);
                        break;
                    }
                    case 11: {
                        this.generateCheckCastJToBAnyData(mv, indexMap, sourceType);
                        break;
                    }
                    case 37: {
                        this.generateJCastToBHandle(mv);
                        break;
                    }
                    case 18: {
                        this.generateJCastToBAny(mv, indexMap, sourceType, targetType);
                        break;
                    }
                    case 7: {
                        this.generateCheckCastJToBJSON(mv, indexMap, sourceType);
                        break;
                    }
                    case 38: {
                        this.generateCheckCastJToBReadOnly(mv, indexMap, sourceType);
                        break;
                    }
                    case 33: {
                        this.generateCheckCastJToBFiniteType(mv, indexMap, sourceType, targetType);
                        break;
                    }
                }
                this.jvmTypeGen.loadType(mv, targetType);
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkCast", "(Ljava/lang/Object;Lio/ballerina/runtime/api/types/Type;)Ljava/lang/Object;", false);
                String targetTypeClass = JvmCastGen.getTargetClass(targetType);
                if (targetTypeClass == null) break;
                mv.visitTypeInsn(192, targetTypeClass);
            }
        }
    }

    private void generateCheckCastJToBInt(MethodVisitor mv, JType sourceType) {
        switch (sourceType.jTag) {
            case 1: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                mv.visitInsn(133);
                break;
            }
            case 5: {
                break;
            }
            case 10: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJLong", "(Ljava/lang/Object;)J", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'int'");
            }
        }
    }

    private void generateCheckCastJToBFloat(MethodVisitor mv, JType sourceType) {
        switch (sourceType.jTag) {
            case 1: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(135);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                mv.visitInsn(135);
                break;
            }
            case 5: {
                mv.visitInsn(138);
                break;
            }
            case 6: {
                mv.visitInsn(141);
                break;
            }
            case 7: {
                break;
            }
            case 10: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToJDouble", "(Ljava/lang/Object;)D", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'float'");
            }
        }
    }

    private void generateCheckCastJToBDecimal(MethodVisitor mv, JType sourceType) {
        switch (sourceType.jTag) {
            case 1: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", "(B)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", "(C)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", "(S)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", "(I)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", "(J)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", "(F)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOfJ", "(D)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            case 10: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToDecimal", "(Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'decimal'");
            }
        }
    }

    private void generateCheckCastJToBBoolean(MethodVisitor mv, JType sourceType) {
        if (sourceType.jTag == 8) {
            return;
        }
        if (sourceType.jTag != 10) {
            throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'boolean'");
        }
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToBoolean", "(Ljava/lang/Object;)Z", false);
    }

    private void generateCheckCastJToBByte(MethodVisitor mv, JType sourceType) {
        if (sourceType.jTag == 1) {
            return;
        }
        if (sourceType.jTag != 10) {
            throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'byte'");
        }
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToByte", "(Ljava/lang/Object;)I", false);
    }

    private void generateCheckCastJToBUnionType(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType, BUnionType targetType) {
        this.generateJCastToBAny(mv, indexMap, sourceType, targetType);
    }

    private void generateCheckCastJToBAnyData(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType) {
        if (sourceType.jTag != 10 && sourceType.jTag != 9) {
            this.generateJCastToBAny(mv, indexMap, sourceType, this.symbolTable.anydataType);
        } else {
            this.jvmTypeGen.loadType(mv, this.symbolTable.anydataType);
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "handleAnydataValues", "(Ljava/lang/Object;Lio/ballerina/runtime/api/types/Type;)Ljava/lang/Object;", false);
        }
    }

    private void generateJCastToBHandle(MethodVisitor mv) {
        LabelGenerator labelGen = new LabelGenerator();
        Label afterHandle = labelGen.getLabel("after_handle");
        mv.visitInsn(89);
        mv.visitTypeInsn(193, "io/ballerina/runtime/api/values/BHandle");
        mv.visitJumpInsn(154, afterHandle);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/HandleValue", "valueOfJ", "(Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/HandleValue;", false);
        mv.visitLabel(afterHandle);
    }

    private void generateJCastToBAny(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType, BType targetType) {
        switch (sourceType.jTag) {
            case 8: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case 1: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                mv.visitInsn(133);
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 6: {
                mv.visitInsn(141);
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                break;
            }
            case 10: {
                Label afterHandle = new Label();
                if (((JType.JRefType)sourceType).typeValue.equals("java/lang/Object")) {
                    mv.visitInsn(89);
                    mv.visitTypeInsn(193, "io/ballerina/runtime/api/values/BError");
                    mv.visitJumpInsn(154, afterHandle);
                    mv.visitInsn(89);
                    mv.visitTypeInsn(193, "java/lang/Number");
                    mv.visitJumpInsn(154, afterHandle);
                    mv.visitInsn(89);
                    mv.visitTypeInsn(193, "java/lang/Boolean");
                    mv.visitJumpInsn(154, afterHandle);
                    mv.visitInsn(89);
                    mv.visitTypeInsn(193, "io/ballerina/runtime/internal/values/SimpleValue");
                    mv.visitJumpInsn(154, afterHandle);
                }
                if (targetType.isNullable()) {
                    mv.visitInsn(89);
                    mv.visitJumpInsn(198, afterHandle);
                }
                mv.visitInsn(89);
                mv.visitTypeInsn(193, "io/ballerina/runtime/api/values/BRefValue");
                mv.visitJumpInsn(154, afterHandle);
                int returnJObjectVarRefIndex = indexMap.addIfNotExists("$_ret_jobject_val_$", this.symbolTable.anyType);
                mv.visitVarInsn(58, returnJObjectVarRefIndex);
                mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/HandleValue");
                mv.visitInsn(89);
                mv.visitVarInsn(25, returnJObjectVarRefIndex);
                mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/HandleValue", "<init>", "(Ljava/lang/Object;)V", false);
                mv.visitLabel(afterHandle);
                break;
            }
            case 9: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/HandleValue", "valueOfJ", "(Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/HandleValue;", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'any'");
            }
        }
    }

    private void generateCheckCastJToBJSON(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType) {
        if (sourceType.jTag == 10 || sourceType.jTag == 9) {
            return;
        }
        this.generateJCastToBAny(mv, indexMap, sourceType, this.symbolTable.jsonType);
    }

    private void generateCheckCastJToBReadOnly(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType) {
        if (sourceType.jTag == 10 || sourceType.jTag == 9) {
            return;
        }
        this.generateJCastToBAny(mv, indexMap, sourceType, this.symbolTable.readonlyType);
    }

    private void generateCheckCastJToBFiniteType(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JType sourceType, BType targetType) {
        if (sourceType.jTag != 10 && sourceType.jTag != 9) {
            this.generateJCastToBAny(mv, indexMap, sourceType, targetType);
        }
    }

    void generateCheckCast(MethodVisitor mv, BType source, BType target, BIRVarToJVMIndexMap indexMap) {
        BType sourceType = JvmCodeGenUtil.getImpliedType(source);
        BType targetType = JvmCodeGenUtil.getImpliedType(target);
        if (TypeTags.isXMLTypeTag(sourceType.tag) && targetType.tag == 16) {
            this.generateXMLToAttributesMap(mv);
            return;
        }
        if (sourceType.tag != 12 || targetType.tag != 16 || ((BMapType)targetType).constraint.tag != 18) {
            switch (targetType.tag) {
                case 1: {
                    this.generateCheckCastToInt(mv, sourceType);
                    return;
                }
                case 39: {
                    this.generateCheckCastToSigned32(mv, sourceType);
                    return;
                }
                case 40: {
                    this.generateCheckCastToSigned16(mv, sourceType);
                    return;
                }
                case 41: {
                    this.generateCheckCastToSigned8(mv, sourceType);
                    return;
                }
                case 42: {
                    this.generateCheckCastToUnsigned32(mv, sourceType);
                    return;
                }
                case 43: {
                    this.generateCheckCastToUnsigned16(mv, sourceType);
                    return;
                }
                case 44: {
                    this.generateCheckCastToUnsigned8(mv, sourceType);
                    return;
                }
                case 3: {
                    this.generateCheckCastToFloat(mv, sourceType);
                    return;
                }
                case 5: {
                    this.generateCheckCastToString(mv, sourceType, indexMap);
                    return;
                }
                case 45: {
                    this.generateCheckCastToChar(mv, sourceType);
                    return;
                }
                case 4: {
                    this.generateCheckCastToDecimal(mv, sourceType);
                    return;
                }
                case 6: {
                    this.generateCheckCastToBoolean(mv, sourceType);
                    return;
                }
                case 2: {
                    this.generateCheckCastToByte(mv, sourceType);
                    return;
                }
                case 10: 
                case 50: {
                    this.checkCast(mv, sourceType, targetType);
                    return;
                }
                case 21: {
                    this.generateCheckCastToUnionType(mv, sourceType, (BUnionType)targetType);
                    return;
                }
                case 11: {
                    this.generateCheckCastToAnyData(mv, sourceType);
                    return;
                }
                case 18: {
                    this.generateCastToAny(mv, sourceType);
                    return;
                }
                case 7: {
                    this.generateCheckCastToJSON(mv, sourceType);
                    return;
                }
                case 38: {
                    this.generateCheckCastToReadonlyType(mv, sourceType, targetType);
                    return;
                }
                case 33: {
                    this.generateCheckCastToFiniteType(mv, sourceType, (BFiniteType)targetType);
                    return;
                }
            }
            this.checkCast(mv, sourceType, targetType);
        }
        String targetTypeClass = JvmCastGen.getTargetClass(targetType);
        if (targetTypeClass != null) {
            mv.visitTypeInsn(192, targetTypeClass);
        }
    }

    private void generateCheckCastToInt(MethodVisitor mv, BType sourceType) {
        sourceType = JvmCodeGenUtil.getImpliedType(sourceType);
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToInt", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 33: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", "(Ljava/lang/Object;)J", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'int'");
            }
        }
    }

    private void generateCheckCastToSigned32(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToSigned32", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToSigned32", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 33: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToSigned32", "(Ljava/lang/Object;)J", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'int:Signed32'");
            }
        }
    }

    private void generateCheckCastToSigned16(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToSigned16", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToSigned16", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 33: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToSigned16", "(Ljava/lang/Object;)J", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'int:Signed16'");
            }
        }
    }

    private void generateCheckCastToSigned8(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToSigned8", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToSigned8", "(J)J", false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToSigned8", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 33: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToSigned8", "(Ljava/lang/Object;)J", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'int:Signed8'");
            }
        }
    }

    private void generateCheckCastToUnsigned32(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToUnsigned32", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToUnsigned32", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 33: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToUnsigned32", "(Ljava/lang/Object;)J", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'int:Unsigned32'");
            }
        }
    }

    private void generateCheckCastToUnsigned16(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToUnsigned16", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToUnsigned16", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 33: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToUnsigned16", "(Ljava/lang/Object;)J", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'int:Unsigned16'");
            }
        }
    }

    private void generateCheckCastToUnsigned8(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToUnsigned8", "(J)J", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(145);
                mv.visitMethodInsn(184, "java/lang/Byte", "toUnsignedInt", "(B)I", false);
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToUnsigned8", "(D)J", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 33: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToUnsigned8", "(Ljava/lang/Object;)J", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'int:Unsigned8'");
            }
        }
    }

    private void generateCheckCastToFloat(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(138);
            return;
        }
        switch (sourceType.tag) {
            case 3: {
                break;
            }
            case 2: {
                mv.visitInsn(135);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 33: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToFloat", "(Ljava/lang/Object;)D", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'float'");
            }
        }
    }

    private void generateCheckCastToDecimal(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOf", "(J)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
            return;
        }
        switch (sourceType.tag) {
            case 4: {
                break;
            }
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 33: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToDecimal", "(Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOf", "(D)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOf", "(I)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'decimal'");
            }
        }
    }

    private void generateCheckCastToString(MethodVisitor mv, BType sourceType, BIRVarToJVMIndexMap indexMap) {
        sourceType = JvmCodeGenUtil.getImpliedType(sourceType);
        if (TypeTags.isStringTypeTag(sourceType.tag)) {
            return;
        }
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "java/lang/Long", "toString", "(J)Ljava/lang/String;", false);
        } else {
            switch (sourceType.tag) {
                case 7: 
                case 11: 
                case 18: 
                case 21: 
                case 33: 
                case 38: {
                    this.checkCast(mv, sourceType, this.symbolTable.stringType);
                    mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
                    return;
                }
                case 3: {
                    mv.visitMethodInsn(184, "java/lang/Double", "toString", "(D)Ljava/lang/String;", false);
                    break;
                }
                case 6: {
                    mv.visitMethodInsn(184, "java/lang/Boolean", "toString", "(Z)Ljava/lang/String;", false);
                    break;
                }
                case 4: {
                    mv.visitMethodInsn(184, "java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;", false);
                    break;
                }
                default: {
                    throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'string'");
                }
            }
        }
        this.generateNonBMPStringValue(mv, indexMap);
    }

    private void generateNonBMPStringValue(MethodVisitor mv, BIRVarToJVMIndexMap indexMap) {
        int tmpVarIndex = indexMap.addIfNotExists("str", this.symbolTable.anyType);
        mv.visitVarInsn(58, tmpVarIndex);
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/BmpStringValue");
        mv.visitInsn(89);
        mv.visitVarInsn(25, tmpVarIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/BmpStringValue", "<init>", "(Ljava/lang/String;)V", false);
    }

    private void generateCheckCastToChar(MethodVisitor mv, BType type) {
        BType sourceType = JvmCodeGenUtil.getImpliedType(type);
        if (TypeTags.isStringTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "stringToChar", "(Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BString;", false);
        } else if (sourceType.tag == 18 || sourceType.tag == 11 || sourceType.tag == 21 || sourceType.tag == 7 || sourceType.tag == 38 || sourceType.tag == 33 || TypeTags.isIntegerTypeTag(sourceType.tag) || sourceType.tag == 3 || sourceType.tag == 6 || sourceType.tag == 4) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "anyToChar", "(Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BString;", false);
        } else {
            throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'char'");
        }
    }

    private void generateCheckCastToBoolean(MethodVisitor mv, BType sourceType) {
        if (sourceType.tag == 6) {
            return;
        }
        if (sourceType.tag != 18 && sourceType.tag != 11 && sourceType.tag != 21 && sourceType.tag != 7 && sourceType.tag != 38 && sourceType.tag != 33) {
            throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'boolean'");
        }
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToBoolean", "(Ljava/lang/Object;)Z", false);
    }

    void generateCheckCastToByte(MethodVisitor mv, BType sourceType) {
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "intToByte", "(J)I", false);
            return;
        }
        switch (sourceType.tag) {
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeConverter", "floatToByte", "(D)I", false);
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 33: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToByte", "(Ljava/lang/Object;)I", false);
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'byte'");
            }
        }
    }

    public void generateCheckCastToAnyData(MethodVisitor mv, BType type) {
        BType sourceType = JvmCodeGenUtil.getImpliedType(type);
        if (sourceType.tag == 21 || this.types.isAssignable(sourceType, this.symbolTable.anyType) && !Symbols.isFlagOn(sourceType.getFlags(), 32L)) {
            this.checkCast(mv, sourceType, this.symbolTable.anydataType);
        } else {
            this.generateCastToAny(mv, sourceType);
        }
    }

    private void generateCheckCastToJSON(MethodVisitor mv, BType type) {
        BType sourceType = JvmCodeGenUtil.getImpliedType(type);
        switch (sourceType.tag) {
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 38: {
                this.checkCast(mv, sourceType, this.symbolTable.jsonType);
                break;
            }
            default: {
                this.generateCastToAny(mv, sourceType);
            }
        }
    }

    private void generateCheckCastToUnionType(MethodVisitor mv, BType sourceType, BUnionType targetType) {
        this.generateCastToAny(mv, sourceType);
        this.checkCast(mv, sourceType, targetType);
    }

    private void checkCast(MethodVisitor mv, BType sourceType, BType targetType) {
        if (this.types.isAssignable(sourceType, targetType)) {
            return;
        }
        this.jvmTypeGen.loadType(mv, targetType);
        mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkCast", "(Ljava/lang/Object;Lio/ballerina/runtime/api/types/Type;)Ljava/lang/Object;", false);
    }

    static String getTargetClass(BType targetType) {
        String targetTypeClass;
        targetType = JvmCodeGenUtil.getImpliedType(targetType);
        if (TypeTags.isXMLTypeTag(targetType.tag)) {
            return "io/ballerina/runtime/internal/values/XmlValue";
        }
        if (53 == targetType.tag) {
            return "io/ballerina/runtime/internal/values/RegExpValue";
        }
        switch (targetType.tag) {
            case 20: 
            case 31: {
                targetTypeClass = "io/ballerina/runtime/internal/values/ArrayValue";
                break;
            }
            case 12: 
            case 16: {
                targetTypeClass = "io/ballerina/runtime/internal/values/MapValueImpl";
                break;
            }
            case 9: {
                targetTypeClass = "io/ballerina/runtime/internal/values/TableValue";
                break;
            }
            case 15: {
                targetTypeClass = "io/ballerina/runtime/internal/values/StreamValue";
                break;
            }
            case 34: {
                targetTypeClass = "io/ballerina/runtime/api/values/BObject";
                break;
            }
            case 29: {
                targetTypeClass = "io/ballerina/runtime/internal/values/ErrorValue";
                break;
            }
            case 13: {
                targetTypeClass = "io/ballerina/runtime/internal/values/TypedescValue";
                break;
            }
            case 17: {
                targetTypeClass = "io/ballerina/runtime/internal/values/FPValue";
                break;
            }
            case 32: {
                targetTypeClass = "io/ballerina/runtime/internal/values/FutureValue";
                break;
            }
            case 37: {
                targetTypeClass = "io/ballerina/runtime/internal/values/HandleValue";
                break;
            }
            default: {
                return null;
            }
        }
        return targetTypeClass;
    }

    private void generateCheckCastToFiniteType(MethodVisitor mv, BType sourceType, BFiniteType targetType) {
        this.generateCastToAny(mv, sourceType);
        this.checkCast(mv, sourceType, targetType);
    }

    private void generateCheckCastToReadonlyType(MethodVisitor mv, BType sourceType, BType targetType) {
        this.generateCastToAny(mv, sourceType);
        this.checkCast(mv, sourceType, targetType);
    }

    public void addBoxInsn(MethodVisitor mv, BType bType) {
        if (bType != null) {
            this.generateCast(mv, bType, JvmInstructionGen.anyType);
        }
    }

    public void addUnboxInsn(MethodVisitor mv, BType bType) {
        if (bType != null) {
            this.generateCast(mv, JvmInstructionGen.anyType, bType);
        }
    }

    void generateCast(MethodVisitor mv, BType sourceType, BType targetType) {
        targetType = JvmCodeGenUtil.getImpliedType(targetType);
        if (TypeTags.isIntegerTypeTag(targetType.tag)) {
            this.generateCastToInt(mv, sourceType);
            return;
        }
        if (TypeTags.isStringTypeTag(targetType.tag)) {
            this.generateCastToString(mv, sourceType);
            return;
        }
        switch (targetType.tag) {
            case 3: {
                this.generateCastToFloat(mv, sourceType);
                return;
            }
            case 6: {
                this.generateCastToBoolean(mv, sourceType);
                return;
            }
            case 2: {
                this.generateCastToByte(mv, sourceType);
                return;
            }
            case 4: {
                this.generateCastToDecimal(mv, sourceType);
                return;
            }
            case 10: 
            case 50: {
                return;
            }
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 33: 
            case 38: {
                this.generateCastToAny(mv, sourceType);
                return;
            }
        }
        String targetTypeClass = JvmCastGen.getTargetClass(targetType);
        if (targetTypeClass != null) {
            mv.visitTypeInsn(192, targetTypeClass);
        }
    }

    private void generateCastToInt(MethodVisitor mv, BType sourceType) {
        sourceType = JvmCodeGenUtil.getImpliedType(sourceType);
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitInsn(133);
                break;
            }
            case 3: {
                mv.visitInsn(143);
                break;
            }
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToInt", "(Ljava/lang/Object;)J", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'int'");
            }
        }
    }

    private void generateCastToFloat(MethodVisitor mv, BType type) {
        BType sourceType = JvmCodeGenUtil.getImpliedType(type);
        if (sourceType.tag == 3) {
            return;
        }
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(138);
        } else if (sourceType.tag == 18 || sourceType.tag == 11 || sourceType.tag == 21 || sourceType.tag == 7 || sourceType.tag == 38) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToFloat", "(Ljava/lang/Object;)D", false);
        } else {
            throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'float'");
        }
    }

    private void generateCastToString(MethodVisitor mv, BType type) {
        BType sourceType = JvmCodeGenUtil.getImpliedType(type);
        if (TypeTags.isStringTypeTag(sourceType.tag)) {
            return;
        }
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "java/lang/Long", "toString", "(J)Ljava/lang/String;", false);
            return;
        }
        switch (sourceType.tag) {
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Double", "toString", "(D)Ljava/lang/String;", false);
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "toString", "(Z)Ljava/lang/String;", false);
                break;
            }
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 38: {
                mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BString");
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'string'");
            }
        }
    }

    private void generateCastToDecimal(MethodVisitor mv, BType type) {
        BType sourceType = JvmCodeGenUtil.getImpliedType(type);
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOf", "(J)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
            return;
        }
        switch (sourceType.tag) {
            case 4: {
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/DecimalValue", "valueOf", "(D)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            case 7: 
            case 11: 
            case 18: 
            case 21: 
            case 38: {
                mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToDecimal", "(Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/DecimalValue;", false);
                break;
            }
            default: {
                throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'decimal'");
            }
        }
    }

    private void generateCastToBoolean(MethodVisitor mv, BType type) {
        BType sourceType = JvmCodeGenUtil.getImpliedType(type);
        if (sourceType.tag == 6) {
            return;
        }
        if (sourceType.tag != 18 && sourceType.tag != 11 && sourceType.tag != 21 && sourceType.tag != 7 && sourceType.tag != 38) {
            throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'boolean'");
        }
        mv.visitTypeInsn(192, "java/lang/Boolean");
        mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
    }

    private void generateCastToByte(MethodVisitor mv, BType type) {
        BType sourceType = JvmCodeGenUtil.getImpliedType(type);
        if (sourceType.tag == 2) {
            return;
        }
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitInsn(136);
        } else if (sourceType.tag == 18 || sourceType.tag == 11 || sourceType.tag == 21 || sourceType.tag == 7 || sourceType.tag == 38) {
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "anyToByte", "(Ljava/lang/Object;)I", false);
        } else {
            throw new BLangCompilerException("Casting is not supported from '" + String.valueOf(sourceType) + "' to 'byte'");
        }
    }

    private void generateCastToAny(MethodVisitor mv, BType type) {
        BType sourceType = JvmCodeGenUtil.getImpliedType(type);
        if (TypeTags.isIntegerTypeTag(sourceType.tag)) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
            return;
        }
        switch (sourceType.tag) {
            case 2: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
            }
        }
    }

    private void generateXMLToAttributesMap(MethodVisitor mv) {
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/XmlValue", "getAttributesMap", "()Lio/ballerina/runtime/internal/values/MapValue;", false);
    }

    public Env typeEnv() {
        assert (this.types.typeEnv() != null);
        return this.types.typeEnv();
    }
}

