/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.model.CatchIns;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JErrorEntry;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;

public class JvmErrorGen {
    private final MethodVisitor mv;
    private final BIRVarToJVMIndexMap indexMap;
    private final JvmInstructionGen jvmInstructionGen;

    public JvmErrorGen(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, JvmInstructionGen jvmInstructionGen) {
        this.mv = mv;
        this.indexMap = indexMap;
        this.jvmInstructionGen = jvmInstructionGen;
    }

    private BIRNode.BIRErrorEntry findErrorEntry(List<BIRNode.BIRErrorEntry> errors, BIRNode.BIRBasicBlock currentBB) {
        for (BIRNode.BIRErrorEntry err : errors) {
            if (err == null || !err.endBB.id.value.equals(currentBB.id.value)) continue;
            return err;
        }
        return null;
    }

    void genPanic(BIRTerminator.Panic panicTerm) {
        BIRNode.BIRVariableDcl varDcl = panicTerm.errorOp.variableDcl;
        this.jvmInstructionGen.generateVarLoad(this.mv, varDcl);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BError");
        this.mv.visitInsn(191);
    }

    public void generateTryCatch(BIRNode.BIRFunction func, String funcName, BIRNode.BIRBasicBlock currentBB, JvmTerminatorGen termGen, LabelGenerator labelGen, int channelMapVarIndex, int sendWorkerChannelNamesVar, int receiveWorkerChannelNamesVar, int localVarOffset) {
        BIRNode.BIRErrorEntry currentEE = this.findErrorEntry(func.errorTable, currentBB);
        if (currentEE == null) {
            return;
        }
        Label startLabel = labelGen.getLabel(funcName + currentEE.trapBB.id.value);
        Label endLabel = new Label();
        Label jumpLabel = new Label();
        this.mv.visitLabel(endLabel);
        this.mv.visitJumpInsn(167, jumpLabel);
        if (currentEE instanceof JErrorEntry) {
            JErrorEntry jCurrentEE = (JErrorEntry)currentEE;
            BIRNode.BIRVariableDcl retVarDcl = currentEE.errorOp.variableDcl;
            boolean exeptionExist = false;
            if (!jCurrentEE.catchIns.isEmpty()) {
                int retIndex = this.indexMap.addIfNotExists(retVarDcl.name.value, retVarDcl.type);
                for (CatchIns catchIns : jCurrentEE.catchIns) {
                    if ("io/ballerina/runtime/internal/values/ErrorValue".equals(catchIns.errorClass)) {
                        exeptionExist = true;
                    }
                    Label errorValueLabel = new Label();
                    this.mv.visitTryCatchBlock(startLabel, endLabel, errorValueLabel, catchIns.errorClass);
                    this.mv.visitLabel(errorValueLabel);
                    this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/ErrorUtils", "createInteropError", "(Ljava/lang/Throwable;)Lio/ballerina/runtime/internal/values/ErrorValue;", false);
                    this.jvmInstructionGen.generateVarStore(this.mv, retVarDcl);
                    termGen.genReturnTerm(retIndex, func, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
                    this.mv.visitJumpInsn(167, jumpLabel);
                }
            }
            if (!exeptionExist) {
                Label errorValErrorLabel = new Label();
                this.mv.visitTryCatchBlock(startLabel, endLabel, errorValErrorLabel, "io/ballerina/runtime/internal/values/ErrorValue");
                this.mv.visitLabel(errorValErrorLabel);
                this.mv.visitInsn(191);
                this.mv.visitJumpInsn(167, jumpLabel);
            }
            Label otherErrorLabel = new Label();
            Label sOErrorlabel = new Label();
            this.mv.visitTryCatchBlock(startLabel, endLabel, sOErrorlabel, "java/lang/StackOverflowError");
            this.mv.visitTryCatchBlock(startLabel, endLabel, otherErrorLabel, "java/lang/Throwable");
            this.mv.visitLabel(sOErrorlabel);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/ErrorUtils", "trapError", "(Ljava/lang/Throwable;)Lio/ballerina/runtime/internal/values/ErrorValue;", false);
            this.mv.visitInsn(191);
            this.mv.visitJumpInsn(167, jumpLabel);
            this.mv.visitLabel(otherErrorLabel);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/ErrorUtils", "createInteropError", "(Ljava/lang/Throwable;)Lio/ballerina/runtime/internal/values/ErrorValue;", false);
            this.mv.visitInsn(191);
            this.mv.visitLabel(jumpLabel);
            return;
        }
        Label errorValueLabel = new Label();
        Label otherErrorLabel = new Label();
        this.mv.visitTryCatchBlock(startLabel, endLabel, errorValueLabel, "io/ballerina/runtime/internal/values/ErrorValue");
        this.mv.visitTryCatchBlock(startLabel, endLabel, otherErrorLabel, "java/lang/StackOverflowError");
        this.mv.visitLabel(errorValueLabel);
        BIRNode.BIRVariableDcl varDcl = currentEE.errorOp.variableDcl;
        int lhsIndex = this.indexMap.addIfNotExists(varDcl.name.value, varDcl.type);
        this.jvmInstructionGen.generateVarStore(this.mv, varDcl);
        this.mv.visitJumpInsn(167, jumpLabel);
        this.mv.visitLabel(otherErrorLabel);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/utils/ErrorUtils", "trapError", "(Ljava/lang/Throwable;)Lio/ballerina/runtime/internal/values/ErrorValue;", false);
        this.mv.visitVarInsn(58, lhsIndex);
        this.mv.visitLabel(jumpLabel);
    }
}

