/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.identifier.Utils;
import io.ballerina.types.Env;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.objectweb.asm.ClassTooLargeException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodTooLargeException;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.ShutDownListenerGen;
import org.wso2.ballerinalang.compiler.bir.codegen.desugar.BirDesugar;
import org.wso2.ballerinalang.compiler.bir.codegen.desugar.LazyLoadingDesugar;
import org.wso2.ballerinalang.compiler.bir.codegen.exceptions.JInteropException;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.CompiledJarFile;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JavaClass;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LazyLoadingDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ExternalMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.ConfigMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.InitMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.LambdaGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MainMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.ModuleStopMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.model.BIRFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmMethodsSplitter;
import org.wso2.ballerinalang.compiler.bir.codegen.split.identifiers.JvmBallerinaConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.identifiers.JvmGlobalVariablesGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeHashVisitor;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.Unifier;

public class JvmPackageGen {
    private static final Unifier unifier = new Unifier();
    public final SymbolTable symbolTable;
    public final PackageCache packageCache;
    private final MethodGen methodGen;
    private final InitMethodGen initMethodGen;
    private final ConfigMethodGen configMethodGen;
    private final Map<String, BIRFunctionWrapper> birFunctionMap = new HashMap<String, BIRFunctionWrapper>();
    private final BLangDiagnosticLog dlog;
    public final Types types;
    private final boolean isRemoteMgtEnabled;
    private final Env typeEnv;
    public final BIRNode.BIRPackage currentModule;
    public final String globalVarsPkgName;

    JvmPackageGen(BIRNode.BIRPackage currentModule, SymbolTable symbolTable, PackageCache packageCache, BLangDiagnosticLog dlog, Types types, boolean isRemoteMgtEnabled) {
        this.symbolTable = symbolTable;
        this.packageCache = packageCache;
        this.dlog = dlog;
        this.types = types;
        this.isRemoteMgtEnabled = isRemoteMgtEnabled;
        this.globalVarsPkgName = JvmModuleUtils.getModuleLevelClassName(currentModule.packageID, "identifiers/global_vars/");
        this.methodGen = new MethodGen(this, types);
        this.initMethodGen = new InitMethodGen(symbolTable, this.globalVarsPkgName);
        this.configMethodGen = new ConfigMethodGen();
        JvmInstructionGen.anyType = symbolTable.anyType;
        this.typeEnv = symbolTable.typeEnv();
        this.currentModule = currentModule;
    }

    private static String getBvmAlias(String orgName, String moduleName) {
        if (Names.ANON_ORG.value.equals(orgName)) {
            return moduleName;
        }
        return orgName + "/" + moduleName;
    }

    private static void addBuiltinImports(BIRNode.BIRPackage birPackage, Set<PackageID> dependentModuleArray) {
        PackageID currentModule = birPackage.packageID;
        if (JvmModuleUtils.isSameModule(currentModule, PackageID.ANNOTATIONS)) {
            return;
        }
        dependentModuleArray.add(PackageID.ANNOTATIONS);
        if (JvmModuleUtils.isSameModule(currentModule, PackageID.JAVA)) {
            return;
        }
        if (JvmPackageGen.isLangModule(currentModule) || JvmPackageGen.hasNonLangLibImports(birPackage.importModules)) {
            return;
        }
        dependentModuleArray.add(PackageID.JAVA);
        dependentModuleArray.add(PackageID.INTERNAL);
        dependentModuleArray.add(PackageID.ARRAY);
        dependentModuleArray.add(PackageID.DECIMAL);
        dependentModuleArray.add(PackageID.VALUE);
        dependentModuleArray.add(PackageID.ERROR);
        dependentModuleArray.add(PackageID.FLOAT);
        dependentModuleArray.add(PackageID.FUNCTION);
        dependentModuleArray.add(PackageID.FUTURE);
        dependentModuleArray.add(PackageID.INT);
        dependentModuleArray.add(PackageID.MAP);
        dependentModuleArray.add(PackageID.OBJECT);
        dependentModuleArray.add(PackageID.STREAM);
        dependentModuleArray.add(PackageID.REGEXP);
        dependentModuleArray.add(PackageID.STRING);
        dependentModuleArray.add(PackageID.TABLE);
        dependentModuleArray.add(PackageID.XML);
        dependentModuleArray.add(PackageID.TYPEDESC);
        dependentModuleArray.add(PackageID.BOOLEAN);
        dependentModuleArray.add(PackageID.QUERY);
        dependentModuleArray.add(PackageID.TRANSACTION);
    }

    private static boolean hasNonLangLibImports(Set<BIRNode.BIRImportModule> importModules) {
        for (BIRNode.BIRImportModule importModule : importModules) {
            if ("ballerina".equals(importModule.packageID.orgName.value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLangModule(PackageID moduleId) {
        if (!"ballerina".equals(moduleId.orgName.value)) {
            return false;
        }
        return moduleId.name.value.startsWith("lang&0046") || moduleId.name.value.equals("jballerina&0046java");
    }

    private static void generateLockStoreVariable(ClassWriter cw) {
        FieldVisitor fv = cw.visitField(9, "$lockStore", "Lio/ballerina/runtime/internal/lock/BLockStore;", null, null);
        fv.visitEnd();
    }

    private static void generateStaticInitializer(ClassWriter cw, String className, BIRNode.BIRPackage birPackage, boolean isInitClass, boolean serviceEPAvailable, JvmConstantsGen jvmConstantsGen) {
        if (!isInitClass) {
            return;
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        JvmPackageGen.setLockStoreField(mv, className);
        JvmPackageGen.setServiceEPAvailableField(cw, mv, serviceEPAvailable, className);
        JvmPackageGen.setModuleStatusField(cw, mv, className);
        JvmPackageGen.setCurrentModuleField(cw, mv, jvmConstantsGen, birPackage.packageID, className);
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "<clinit>", className);
        mv.visitEnd();
    }

    private static void setLockStoreField(MethodVisitor mv, String className) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/lock/BLockStore");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/lock/BLockStore", "<init>", "()V", false);
        mv.visitFieldInsn(179, className, "$lockStore", "Lio/ballerina/runtime/internal/lock/BLockStore;");
    }

    private static void setServiceEPAvailableField(ClassWriter cw, MethodVisitor mv, boolean serviceEPAvailable, String initClass) {
        FieldVisitor fv = cw.visitField(9, "$serviceEPAvailable", "Z", null, null);
        fv.visitEnd();
        if (serviceEPAvailable) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitFieldInsn(179, initClass, "$serviceEPAvailable", "Z");
    }

    private static void setModuleStatusField(ClassWriter cw, MethodVisitor mv, String initClass) {
        FieldVisitor fv = cw.visitField(9, "$moduleStartAttempted", "Z", null, null);
        fv.visitEnd();
        mv.visitInsn(3);
        mv.visitFieldInsn(179, initClass, "$moduleStartAttempted", "Z");
        fv = cw.visitField(9, "$moduleStarted", "Z", null, null);
        fv.visitEnd();
        mv.visitInsn(3);
        mv.visitFieldInsn(179, initClass, "$moduleStarted", "Z");
        fv = cw.visitField(9, "$parentModuleStartAttempted", "Z", null, null);
        fv.visitEnd();
        mv.visitInsn(3);
        mv.visitFieldInsn(179, initClass, "$parentModuleStartAttempted", "Z");
        fv = cw.visitField(9, "$noOfDependantModules", "I", null, null);
        fv.visitEnd();
        mv.visitInsn(3);
        mv.visitFieldInsn(179, initClass, "$noOfDependantModules", "I");
    }

    private static void setCurrentModuleField(ClassWriter cw, MethodVisitor mv, JvmConstantsGen jvmConstantsGen, PackageID packageID, String moduleInitClass) {
        FieldVisitor fv = cw.visitField(9, "$currentModule", "Lio/ballerina/runtime/api/Module;", null, null);
        fv.visitEnd();
        String moduleVar = jvmConstantsGen.getModuleConstantVar(packageID);
        mv.visitFieldInsn(178, jvmConstantsGen.getModuleConstantClass(moduleVar), moduleVar, "Lio/ballerina/runtime/api/Module;");
        mv.visitFieldInsn(179, moduleInitClass, "$currentModule", "Lio/ballerina/runtime/api/Module;");
    }

    public static BIRFunctionWrapper getFunctionWrapper(Env typeEnv, BIRNode.BIRFunction currentFunc, PackageID packageID, String moduleClass) {
        BInvokableType functionTypeDesc = currentFunc.type;
        BIRNode.BIRVariableDcl receiver = currentFunc.receiver;
        BType retType = functionTypeDesc.retType;
        if (JvmCodeGenUtil.isExternFunc(currentFunc) && Symbols.isFlagOn(retType.getFlags(), 0x4000000L)) {
            retType = unifier.build(typeEnv, retType);
        }
        String jvmMethodDescription = receiver == null ? JvmCodeGenUtil.getMethodDesc(typeEnv, functionTypeDesc.paramTypes, retType) : JvmCodeGenUtil.getMethodDesc(typeEnv, functionTypeDesc.paramTypes, retType, receiver.type);
        return new BIRFunctionWrapper(packageID, currentFunc, moduleClass, jvmMethodDescription);
    }

    private static BIRNode.BIRFunction findFunction(BIRNode parentNode, String funcName) {
        BIRNode.BIRFunction func;
        if (parentNode instanceof BIRNode.BIRTypeDefinition) {
            BIRNode.BIRTypeDefinition typeDef = (BIRNode.BIRTypeDefinition)parentNode;
            func = JvmPackageGen.findFunction(typeDef.attachedFuncs, funcName);
        } else if (parentNode instanceof BIRNode.BIRPackage) {
            BIRNode.BIRPackage pkg = (BIRNode.BIRPackage)parentNode;
            func = JvmPackageGen.findFunction(pkg.functions, funcName);
        } else {
            return null;
        }
        return func;
    }

    private static BIRNode.BIRFunction findFunction(List<BIRNode.BIRFunction> functions, String funcName) {
        for (BIRNode.BIRFunction func : functions) {
            if (!func.name.value.equals(funcName)) continue;
            return func;
        }
        return null;
    }

    private void generateModuleClasses(JarEntries jarEntries, String moduleInitClass, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, JvmConstantsGen jvmConstantsGen, Map<String, JavaClass> jvmClassMapping, boolean serviceEPAvailable, BIRNode.BIRFunction mainFunc, BIRNode.BIRFunction testExecuteFunc, AsyncDataCollector asyncDataCollector, Set<PackageID> immediateImports) {
        jvmClassMapping.forEach((moduleClass, javaClass) -> {
            boolean isTestable;
            BallerinaClassWriter cw = new BallerinaClassWriter(2);
            asyncDataCollector.setCurrentSourceFileName(javaClass.sourceFileName);
            asyncDataCollector.setCurrentSourceFileWithoutExt(javaClass.cleanedBalFileName);
            boolean isInitClass = Objects.equals(moduleClass, moduleInitClass);
            boolean bl = isTestable = testExecuteFunc != null;
            if (isInitClass) {
                cw.visit(65, 33, (String)moduleClass, null, "io/ballerina/runtime/internal/values/ValueCreator", null);
                JvmCodeGenUtil.generateInitClassConstructor(cw, "io/ballerina/runtime/internal/values/ValueCreator");
                jvmTypeGen.generateGetTypeMethod(cw, (String)moduleClass);
                jvmTypeGen.generateValueCreatorMethods(cw, (String)moduleClass);
                MainMethodGen mainMethodGen = new MainMethodGen(this.symbolTable, jvmTypeGen, this.isRemoteMgtEnabled, this.globalVarsPkgName);
                mainMethodGen.generateMainMethod(mainFunc, cw, this.currentModule, (String)moduleClass, serviceEPAvailable, isTestable);
                this.initMethodGen.generateLambdaForModuleExecuteFunction(cw, (String)moduleClass, jvmCastGen, mainFunc, testExecuteFunc);
                this.initMethodGen.generateLambdaForPackageInit(cw, this.currentModule, (String)moduleClass);
                if (isTestable) {
                    this.initMethodGen.generateGetTestExecutionState(cw);
                }
                JvmPackageGen.generateLockStoreVariable(cw);
                this.initMethodGen.generateModuleInitializer(cw, this.currentModule, moduleInitClass);
                this.initMethodGen.generateModuleStop(cw, moduleInitClass);
                this.initMethodGen.genInitLoadDebugVariablesMethod(cw, jvmConstantsGen);
                ModuleStopMethodGen stopMethodGen = new ModuleStopMethodGen(jvmTypeGen, jvmConstantsGen);
                stopMethodGen.generateExecutionStopMethod(cw, moduleInitClass, this.currentModule, asyncDataCollector, immediateImports);
            } else {
                cw.visit(65, 33, (String)moduleClass, null, "java/lang/Object", null);
                JvmCodeGenUtil.generateDefaultConstructor(cw, "java/lang/Object");
            }
            cw.visitSource(javaClass.sourceFileName, null);
            for (BIRNode.BIRFunction func : javaClass.functions) {
                this.methodGen.generateMethod(func, cw, this.currentModule, null, (String)moduleClass, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector);
            }
            JvmPackageGen.generateStaticInitializer(cw, moduleClass, this.currentModule, isInitClass, serviceEPAvailable, jvmConstantsGen);
            cw.visitEnd();
            byte[] bytes = this.getBytes(cw, this.currentModule);
            jarEntries.put(moduleClass + ".class", bytes);
        });
    }

    private Map<String, JavaClass> generateClassNameLinking(BIRNode.BIRPackage module, String initClass, boolean isEntry) {
        HashMap<String, JavaClass> jvmClassMap = new HashMap<String, JavaClass>();
        this.linkModuleFunctions(module, initClass, isEntry, jvmClassMap);
        this.linkModuleFunction(module.packageID, initClass, "$moduleStop");
        this.linkModuleFunction(module.packageID, initClass, "$moduleExecute");
        this.linkTypeDefinitions(module, isEntry);
        return jvmClassMap;
    }

    private void linkTypeDefinitions(BIRNode.BIRPackage module, boolean isEntry) {
        List<BIRNode.BIRTypeDefinition> typeDefs = module.typeDefs;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BType bType = JvmCodeGenUtil.getImpliedType(optionalTypeDef.type);
            if (bType.tag != 34 || !Symbols.isFlagOn(bType.tsymbol.flags, 0x10000000L)) continue;
            List<BIRNode.BIRFunction> attachedFuncs = optionalTypeDef.attachedFuncs;
            String typeName = JvmCodeGenUtil.toNameString(bType);
            for (BIRNode.BIRFunction func : attachedFuncs) {
                String functionName = func.name.value;
                String lookupKey = typeName + "." + functionName;
                String pkgName = JvmModuleUtils.getPackageName(module.packageID);
                String className = JvmValueGen.getTypeValueClassName(pkgName, typeName);
                try {
                    BIRFunctionWrapper birFuncWrapperOrError = this.getBirFunctionWrapper(isEntry, module.packageID, func, className);
                    this.birFunctionMap.put(pkgName + lookupKey, birFuncWrapperOrError);
                }
                catch (JInteropException e) {
                    this.dlog.error(func.pos, e.getCode(), e.getMessage());
                }
            }
        }
    }

    private void linkModuleFunction(PackageID packageID, String initClass, String funcName) {
        BInvokableType funcType = new BInvokableType(this.typeEnv, Collections.emptyList(), null, this.symbolTable.nilType, null);
        BIRNode.BIRFunction moduleStopFunction = new BIRNode.BIRFunction(null, new Name(funcName), 0L, funcType, new Name(""), 0, SymbolOrigin.VIRTUAL);
        this.birFunctionMap.put(JvmModuleUtils.getPackageName(packageID) + funcName, JvmPackageGen.getFunctionWrapper(this.typeEnv, moduleStopFunction, packageID, initClass));
    }

    private void linkModuleFunctions(BIRNode.BIRPackage birPackage, String initClass, boolean isEntry, Map<String, JavaClass> jvmClassMap) {
        List<BIRNode.BIRFunction> functions = birPackage.functions;
        if (functions.isEmpty()) {
            return;
        }
        int funcSize = functions.size();
        int count = 0;
        BIRNode.BIRFunction initFunc = functions.getFirst();
        String functionName = Utils.encodeFunctionIdentifier((String)initFunc.name.value);
        String fileName = initFunc.pos.lineRange().fileName();
        JavaClass klass = new JavaClass(fileName, fileName);
        klass.functions.addFirst(initFunc);
        PackageID packageID = birPackage.packageID;
        jvmClassMap.put(initClass, klass);
        String pkgName = JvmModuleUtils.getPackageName(packageID);
        this.birFunctionMap.put(pkgName + functionName, JvmPackageGen.getFunctionWrapper(this.typeEnv, initFunc, packageID, initClass));
        ++count;
        BIRNode.BIRFunction startFunc = functions.get(1);
        functionName = Utils.encodeFunctionIdentifier((String)startFunc.name.value);
        this.birFunctionMap.put(pkgName + functionName, JvmPackageGen.getFunctionWrapper(this.typeEnv, startFunc, packageID, initClass));
        klass.functions.add(1, startFunc);
        ++count;
        BIRNode.BIRFunction stopFunc = functions.get(2);
        functionName = Utils.encodeFunctionIdentifier((String)stopFunc.name.value);
        this.birFunctionMap.put(pkgName + functionName, JvmPackageGen.getFunctionWrapper(this.typeEnv, stopFunc, packageID, initClass));
        klass.functions.add(2, stopFunc);
        ++count;
        int genMethodsCount = 0;
        int genClassNum = 0;
        while (count < funcSize) {
            Object balFileName;
            BIRNode.BIRFunction birFunc = functions.get(count);
            ++count;
            String birFuncName = birFunc.name.value;
            if (birFunc.pos == this.symbolTable.builtinPos) {
                balFileName = "$_init";
            } else if (birFunc.pos == null) {
                balFileName = "functions/$generated" + genClassNum;
                if (genMethodsCount > 1000) {
                    genMethodsCount = 0;
                    ++genClassNum;
                } else {
                    ++genMethodsCount;
                }
            } else {
                balFileName = birFunc.pos.lineRange().fileName();
            }
            String cleanedBalFileName = balFileName;
            if (!birFunc.name.value.startsWith(MethodGenUtils.encodeModuleSpecialFuncName(".<test"))) {
                cleanedBalFileName = JvmCodeGenUtil.cleanupPathSeparators((String)balFileName);
            }
            String birModuleClassName = JvmModuleUtils.getModuleLevelClassName(packageID, cleanedBalFileName);
            if (!JvmModuleUtils.isBallerinaBuiltinModule(packageID.orgName.value, packageID.name.value)) {
                JavaClass javaClass = jvmClassMap.get(birModuleClassName);
                if (javaClass != null) {
                    javaClass.functions.add(birFunc);
                } else {
                    klass = new JavaClass((String)balFileName, cleanedBalFileName);
                    klass.functions.addFirst(birFunc);
                    jvmClassMap.put(birModuleClassName, klass);
                }
            }
            try {
                BIRFunctionWrapper birFuncWrapperOrError = this.getBirFunctionWrapper(isEntry, packageID, birFunc, birModuleClassName);
                this.birFunctionMap.put(pkgName + birFuncName, birFuncWrapperOrError);
            }
            catch (JInteropException e) {
                this.dlog.error(birFunc.pos, e.getCode(), e.getMessage());
            }
        }
    }

    private BIRFunctionWrapper getBirFunctionWrapper(boolean isEntry, PackageID packageID, BIRNode.BIRFunction birFunc, String birModuleClassName) {
        BIRFunctionWrapper birFuncWrapperOrError;
        if (JvmCodeGenUtil.isExternFunc(birFunc) && isEntry) {
            birFuncWrapperOrError = ExternalMethodGen.createExternalFunctionWrapper(this.typeEnv, true, birFunc, packageID, birModuleClassName);
        } else {
            if (isEntry && birFunc.receiver == null) {
                BirDesugar.addDefaultBooleanVarsToSignature(birFunc);
            }
            birFuncWrapperOrError = JvmPackageGen.getFunctionWrapper(this.typeEnv, birFunc, packageID, birModuleClassName);
        }
        return birFuncWrapperOrError;
    }

    public byte[] getBytes(ClassWriter cw, BIRNode node) {
        byte[] result;
        try {
            return cw.toByteArray();
        }
        catch (MethodTooLargeException e) {
            String funcName = e.getMethodName();
            BIRNode.BIRFunction func = JvmPackageGen.findFunction(node, funcName);
            if (func != null && func.pos != null) {
                this.dlog.error(func.pos, DiagnosticErrorCode.METHOD_TOO_LARGE, Utils.decodeIdentifier((String)func.name.value));
            } else {
                this.dlog.error(node.pos, DiagnosticErrorCode.METHOD_TOO_LARGE, Utils.decodeIdentifier((String)funcName));
            }
            result = new byte[]{};
        }
        catch (ClassTooLargeException e) {
            this.dlog.error(node.pos, DiagnosticErrorCode.FILE_TOO_LARGE, Utils.decodeIdentifier((String)e.getClassName()));
            result = new byte[]{};
        }
        catch (Throwable e) {
            throw new BLangCompilerException(e.getMessage(), e);
        }
        return result;
    }

    private void clearPackageGenInfo() {
        this.birFunctionMap.clear();
    }

    public BIRFunctionWrapper lookupBIRFunctionWrapper(String lookupKey) {
        return this.birFunctionMap.get(lookupKey);
    }

    BType lookupTypeDef(BIRNonTerminator.NewInstance objectNewIns) {
        if (!objectNewIns.isExternalDef) {
            return objectNewIns.def.type;
        }
        PackageID id = objectNewIns.externalPackageId;
        assert (id != null);
        BPackageSymbol symbol = this.packageCache.getSymbol(String.valueOf(id.orgName) + "/" + String.valueOf(id.name));
        if (symbol != null) {
            Name lookupKey = new Name(Utils.decodeIdentifier((String)objectNewIns.objectName));
            BSymbol typeSymbol = symbol.scope.lookup((Name)lookupKey).symbol;
            BObjectTypeSymbol objectTypeSymbol = typeSymbol.kind == SymbolKind.TYPE_DEF ? (BObjectTypeSymbol)typeSymbol.type.tsymbol : (BObjectTypeSymbol)typeSymbol;
            if (objectTypeSymbol != null) {
                return objectTypeSymbol.type;
            }
        }
        throw new BLangCompilerException("Reference to unknown type " + String.valueOf(objectNewIns.externalPackageId) + "/" + objectNewIns.objectName);
    }

    CompiledJarFile generate() {
        boolean serviceEPAvailable = this.currentModule.isListenerAvailable;
        for (BIRNode.BIRImportModule importModule : this.currentModule.importModules) {
            BPackageSymbol pkgSymbol = this.packageCache.getSymbol(JvmPackageGen.getBvmAlias(importModule.packageID.orgName.value, importModule.packageID.name.value));
            if (pkgSymbol.bir != null) {
                String moduleInitClass = JvmModuleUtils.getModuleLevelClassName(pkgSymbol.bir.packageID, "$_init");
                this.generateClassNameLinking(pkgSymbol.bir, moduleInitClass, false);
            }
            serviceEPAvailable |= this.listenerDeclarationFound(pkgSymbol);
        }
        String moduleInitClass = JvmModuleUtils.getModuleLevelClassName(this.currentModule.packageID, "$_init");
        Map<String, JavaClass> jvmClassMapping = this.generateClassNameLinking(this.currentModule, moduleInitClass, true);
        CompiledJarFile compiledJarFile = new CompiledJarFile(JvmModuleUtils.getModuleLevelClassName(this.currentModule.packageID, "$_init", "."));
        JarEntries jarEntries = compiledJarFile.jarEntries;
        ExternalMethodGen.injectDefaultParamInits(this.typeEnv, this.currentModule, this.initMethodGen);
        JvmValueGen.injectDefaultParamInitsToAttachedFuncs(this.typeEnv, this.currentModule, this.initMethodGen);
        BIRNode.BIRFunction mainFunc = this.getMainFunction(this.currentModule);
        BIRNode.BIRFunction testExecuteFunc = this.getTestExecuteFunction(this.currentModule);
        LinkedHashSet<PackageID> immediateImports = new LinkedHashSet<PackageID>();
        JvmPackageGen.addBuiltinImports(this.currentModule, immediateImports);
        for (BIRNode.BIRImportModule immediateImport : this.currentModule.importModules) {
            BPackageSymbol pkgSymbol = this.packageCache.getSymbol(JvmPackageGen.getBvmAlias(immediateImport.packageID.orgName.value, immediateImport.packageID.name.value));
            immediateImports.add(pkgSymbol.pkgID);
        }
        this.initMethodGen.enrichPkgWithInitializers(this.birFunctionMap, jvmClassMapping, moduleInitClass, this.currentModule, immediateImports, mainFunc, testExecuteFunc);
        TypeHashVisitor typeHashVisitor = new TypeHashVisitor();
        AsyncDataCollector asyncDataCollector = new AsyncDataCollector(this.currentModule);
        JvmConstantsGen jvmConstantsGen = new JvmConstantsGen(this.currentModule, this.types, typeHashVisitor, jarEntries);
        JvmTypeGen jvmTypeGen = new JvmTypeGen(jvmConstantsGen, this.currentModule.packageID, typeHashVisitor, this.symbolTable);
        JvmMethodsSplitter jvmMethodsSplitter = new JvmMethodsSplitter(this, jvmConstantsGen, this.currentModule, typeHashVisitor, jvmTypeGen);
        this.configMethodGen.generateConfigMapper(immediateImports, this.currentModule, moduleInitClass, jvmConstantsGen, typeHashVisitor, jarEntries, this.symbolTable);
        new ShutDownListenerGen().generateShutdownSignalListener(moduleInitClass, jarEntries);
        this.removeSourceAnnotationTypeDefs(this.currentModule.typeDefs);
        BirDesugar.rewriteRecordInits(this.typeEnv, this.currentModule.typeDefs);
        LazyLoadingDataCollector lazyLoadingDataCollector = new LazyLoadingDataCollector();
        LazyLoadingDesugar lazyLoadingDesugar = new LazyLoadingDesugar(lazyLoadingDataCollector);
        lazyLoadingDesugar.lazyLoadInitFunctions(this.currentModule.functions);
        JvmValueGen valueGen = new JvmValueGen(this.currentModule, this, this.methodGen, typeHashVisitor, this.types);
        JvmCastGen jvmCastGen = new JvmCastGen(this.symbolTable, jvmTypeGen, this.types);
        LambdaGen lambdaGen = new LambdaGen(this, jvmCastGen, this.currentModule);
        valueGen.generateValueClasses(jarEntries, jvmConstantsGen, jvmTypeGen, asyncDataCollector);
        this.generateModuleClasses(jarEntries, moduleInitClass, jvmTypeGen, jvmCastGen, jvmConstantsGen, jvmClassMapping, serviceEPAvailable, mainFunc, testExecuteFunc, asyncDataCollector, immediateImports);
        JvmGlobalVariablesGen jvmGlobalVariablesGen = new JvmGlobalVariablesGen(this.currentModule, lazyLoadingDataCollector);
        JvmBallerinaConstantsGen jvmBallerinaConstantsGen = new JvmBallerinaConstantsGen(this.currentModule, jvmConstantsGen, lazyLoadingDataCollector);
        jvmGlobalVariablesGen.generateGlobalVarClasses(this, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector, jarEntries);
        jvmBallerinaConstantsGen.generateConstantsClasses(this, jvmTypeGen, jvmCastGen, asyncDataCollector, jarEntries);
        List<BIRNode.BIRFunction> sortedFunctions = this.filterUserDefinedFunctions(this.currentModule.functions);
        sortedFunctions.sort(JvmCodeGenUtil.NAME_HASH_COMPARATOR);
        List<BIRNode.BIRTypeDefinition> recordTypeDefList = this.filterRecordTypes();
        recordTypeDefList.sort(JvmCodeGenUtil.NAME_HASH_COMPARATOR);
        jvmMethodsSplitter.generateMethods(jarEntries, jvmCastGen, recordTypeDefList, sortedFunctions, asyncDataCollector, lazyLoadingDataCollector);
        jvmConstantsGen.generateConstants(this, jvmCastGen, sortedFunctions, asyncDataCollector, lazyLoadingDataCollector, jarEntries);
        lambdaGen.generateLambdaClasses(asyncDataCollector, jarEntries);
        this.clearPackageGenInfo();
        return compiledJarFile;
    }

    private List<BIRNode.BIRTypeDefinition> filterRecordTypes() {
        ArrayList<BIRNode.BIRTypeDefinition> recordTypes = new ArrayList<BIRNode.BIRTypeDefinition>();
        for (BIRNode.BIRTypeDefinition typeDef : this.currentModule.typeDefs) {
            if (typeDef.type.tag != 12 || Symbols.isFlagOn(typeDef.type.tsymbol.flags, 2048L)) continue;
            recordTypes.add(typeDef);
        }
        return recordTypes;
    }

    private List<BIRNode.BIRFunction> filterUserDefinedFunctions(List<BIRNode.BIRFunction> functions) {
        ArrayList<BIRNode.BIRFunction> filteredFunctions = new ArrayList<BIRNode.BIRFunction>();
        for (BIRNode.BIRFunction func : functions) {
            String funcName = func.name.value;
            if (JvmCodeGenUtil.canSkipFromCallByFunctionName(funcName)) continue;
            filteredFunctions.add(func);
        }
        return filteredFunctions;
    }

    private void removeSourceAnnotationTypeDefs(List<BIRNode.BIRTypeDefinition> typeDefs) {
        typeDefs.removeIf(def -> Symbols.isFlagOn(def.flags, 0x100000000000L));
    }

    private BIRNode.BIRFunction getMainFunction(BIRNode.BIRPackage module) {
        BIRNode.BIRFunction mainFunc = null;
        if (module.packageID.skipTests) {
            mainFunc = this.getFunction(module, "main");
        }
        return mainFunc;
    }

    private BIRNode.BIRFunction getTestExecuteFunction(BIRNode.BIRPackage module) {
        BIRNode.BIRFunction testExecuteFunc = null;
        if (!module.packageID.skipTests) {
            testExecuteFunc = this.getFunction(module, "__execute__");
        }
        return testExecuteFunc;
    }

    private BIRNode.BIRFunction getFunction(BIRNode.BIRPackage module, String funcName) {
        BIRNode.BIRFunction function = null;
        for (BIRNode.BIRFunction birFunc : module.functions) {
            if (!birFunc.name.value.equals(funcName)) continue;
            function = birFunc;
            break;
        }
        return function;
    }

    private boolean listenerDeclarationFound(BPackageSymbol packageSymbol) {
        if (packageSymbol.bir == null) {
            for (Scope.ScopeEntry entry : packageSymbol.scope.entries.values()) {
                BSymbol symbol = entry.symbol;
                if (symbol == null || !Symbols.isFlagOn(symbol.flags, 524288L)) continue;
                return true;
            }
        } else {
            return packageSymbol.bir.isListenerAvailable;
        }
        for (BPackageSymbol importPkgSymbol : packageSymbol.imports) {
            if (importPkgSymbol == null || !this.listenerDeclarationFound(importPkgSymbol)) continue;
            return true;
        }
        return false;
    }
}

