/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.identifier.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmErrorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BIRVarToJVMIndexMap;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LabelGenerator;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.LambdaFunction;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.model.BIRFunctionWrapper;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JIConstructorCall;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JIMethodCLICall;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JIMethodCall;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JTerminator;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JavaMethodCall;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.TypeTags;
import org.wso2.ballerinalang.compiler.util.Unifier;

public class JvmTerminatorGen {
    private final MethodVisitor mv;
    private final BIRVarToJVMIndexMap indexMap;
    private final LabelGenerator labelGen;
    private final JvmErrorGen errorGen;
    private final String moduleInitClass;
    private final JvmPackageGen jvmPackageGen;
    private final JvmInstructionGen jvmInstructionGen;
    private final PackageCache packageCache;
    private final SymbolTable symbolTable;
    private final Unifier unifier;
    private final JvmTypeGen jvmTypeGen;
    private final JvmCastGen jvmCastGen;
    private final AsyncDataCollector asyncDataCollector;

    public JvmTerminatorGen(MethodVisitor mv, BIRVarToJVMIndexMap indexMap, LabelGenerator labelGen, JvmErrorGen errorGen, PackageID packageID, JvmInstructionGen jvmInstructionGen, JvmPackageGen jvmPackageGen, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, AsyncDataCollector asyncDataCollector) {
        this.mv = mv;
        this.indexMap = indexMap;
        this.labelGen = labelGen;
        this.errorGen = errorGen;
        this.jvmPackageGen = jvmPackageGen;
        this.jvmTypeGen = jvmTypeGen;
        this.jvmCastGen = jvmCastGen;
        this.packageCache = jvmPackageGen.packageCache;
        this.jvmInstructionGen = jvmInstructionGen;
        this.symbolTable = jvmPackageGen.symbolTable;
        this.moduleInitClass = JvmModuleUtils.getModuleLevelClassName(packageID, "$_init");
        this.unifier = new Unifier();
        this.asyncDataCollector = asyncDataCollector;
    }

    public void genTerminator(BIRTerminator terminator, String moduleClassName, BIRNode.BIRFunction func, String funcName, int localVarOffset, int returnVarRefIndex, BType attachedType, int channelMapVarIndex, int sendWorkerChannelNamesVar, int receiveWorkerChannelNamesVar) {
        switch (terminator.kind) {
            case GOTO: {
                this.genGoToTerm((BIRTerminator.GOTO)terminator, funcName);
                return;
            }
            case RETURN: {
                this.genReturnTerm(returnVarRefIndex, func, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
                return;
            }
            case BRANCH: {
                this.genBranchTerm((BIRTerminator.Branch)terminator, funcName);
                return;
            }
            case CALL: {
                this.genCallTerm((BIRTerminator.Call)terminator, localVarOffset, funcName);
                return;
            }
            case FP_CALL: {
                this.genFPCallIns((BIRTerminator.FPCall)terminator, localVarOffset, func.hasWorkers, channelMapVarIndex);
                return;
            }
            case ASYNC_CALL: {
                this.genAsyncCallTerm((BIRTerminator.AsyncCall)terminator, localVarOffset, func.hasWorkers, channelMapVarIndex);
                return;
            }
            case PLATFORM: {
                this.genPlatformIns((JTerminator)terminator, attachedType, localVarOffset, func);
                return;
            }
            case PANIC: {
                this.errorGen.genPanic((BIRTerminator.Panic)terminator);
                return;
            }
            case WAIT: {
                this.generateWaitIns((BIRTerminator.Wait)terminator, localVarOffset);
                return;
            }
            case WAIT_ALL: {
                this.genWaitAllIns((BIRTerminator.WaitAll)terminator, localVarOffset);
                return;
            }
            case LOCK: {
                this.genLockTerm((BIRTerminator.Lock)terminator, moduleClassName, func, funcName, localVarOffset);
                return;
            }
            case UNLOCK: {
                this.genUnlockTerm((BIRTerminator.Unlock)terminator, moduleClassName, func, funcName, localVarOffset);
                return;
            }
            case WK_SEND: {
                this.genWorkerSendIns((BIRTerminator.WorkerSend)terminator, func, channelMapVarIndex, localVarOffset);
                return;
            }
            case WK_RECEIVE: {
                this.genWorkerReceiveIns((BIRTerminator.WorkerReceive)terminator, func, channelMapVarIndex, localVarOffset);
                return;
            }
            case WK_ALT_RECEIVE: {
                this.genWorkerAlternateReceiveIns((BIRTerminator.WorkerAlternateReceive)terminator, func, channelMapVarIndex, localVarOffset);
                return;
            }
            case WK_MULTIPLE_RECEIVE: {
                this.genWorkerMultipleReceiveIns((BIRTerminator.WorkerMultipleReceive)terminator, func, channelMapVarIndex, localVarOffset);
                return;
            }
            case FLUSH: {
                this.genFlushIns((BIRTerminator.Flush)terminator, func, channelMapVarIndex, localVarOffset);
                return;
            }
        }
        throw new BLangCompilerException("JVM generation is not supported for terminator instruction " + String.valueOf(terminator));
    }

    private void genGoToTerm(BIRTerminator.GOTO gotoIns, String funcName) {
        Label gotoLabel = this.labelGen.getLabel(funcName + gotoIns.targetBB.id.value);
        this.mv.visitJumpInsn(167, gotoLabel);
    }

    public void genReturnTerm(int returnVarRefIndex, BIRNode.BIRFunction func, int channelMapVarIndex, int sendWorkerChannelNamesVar, int receiveWorkerChannelNamesVar, int localVarOffset) {
        BType bType = this.unifier.build(this.symbolTable.typeEnv(), func.type.retType);
        this.generateReturnTermFromType(bType, func, returnVarRefIndex, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
    }

    private void genBranchTerm(BIRTerminator.Branch branchIns, String funcName) {
        this.loadVar(branchIns.op.variableDcl);
        Label trueBBLabel = this.labelGen.getLabel(funcName + branchIns.trueBB.id.value);
        this.mv.visitJumpInsn(157, trueBBLabel);
        Label falseBBLabel = this.labelGen.getLabel(funcName + branchIns.falseBB.id.value);
        this.mv.visitJumpInsn(167, falseBBLabel);
    }

    public void genCall(BIRTerminator.Call callIns, PackageID packageID, int localVarOffset) {
        if (!callIns.isVirtual) {
            this.genFuncCall(callIns, packageID, localVarOffset);
            return;
        }
        BIRNode.BIRVariableDcl selfArg = callIns.args.getFirst().variableDcl;
        BType selfArgRefType = JvmCodeGenUtil.getImpliedType(selfArg.type);
        if (selfArgRefType.tag == 34 || selfArgRefType.tag == 21) {
            this.genVirtualCall(callIns, localVarOffset);
        } else {
            this.genBuiltinTypeAttachedFuncCall(callIns, packageID, localVarOffset);
        }
    }

    private void genLockTerm(BIRTerminator.Lock lockIns, String moduleClassName, BIRNode.BIRFunction func, String funcName, int localVarOffset) {
        Label gotoLabel = this.labelGen.getLabel(funcName + lockIns.lockedBB.id.value);
        this.mv.visitFieldInsn(178, this.moduleInitClass, "$lockStore", "Lio/ballerina/runtime/internal/lock/BLockStore;");
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        if ((func.flags & 8L) == 8L && lockIns.lockVariables.isEmpty()) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, moduleClassName, "$lock", "Ljava/util/concurrent/locks/ReentrantLock;");
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/lock/BLockStore", "lock", "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/util/concurrent/locks/ReentrantLock;)V", false);
        } else {
            this.mv.visitLdcInsn((Object)("lock" + lockIns.lockId));
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/lock/BLockStore", "lock", "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/lang/String;)V", false);
        }
        this.mv.visitJumpInsn(167, gotoLabel);
    }

    private void genUnlockTerm(BIRTerminator.Unlock unlockIns, String moduleClassName, BIRNode.BIRFunction func, String funcName, int localVarOffset) {
        Label gotoLabel = this.labelGen.getLabel(funcName + unlockIns.unlockBB.id.value);
        this.mv.visitFieldInsn(178, this.moduleInitClass, "$lockStore", "Lio/ballerina/runtime/internal/lock/BLockStore;");
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        if ((func.flags & 8L) == 8L && unlockIns.relatedLock.lockVariables.isEmpty()) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitFieldInsn(180, moduleClassName, "$lock", "Ljava/util/concurrent/locks/ReentrantLock;");
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/lock/BLockStore", "unlock", "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/util/concurrent/locks/ReentrantLock;)V", false);
        } else {
            this.mv.visitLdcInsn((Object)("lock" + unlockIns.relatedLock.lockId));
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/lock/BLockStore", "unlock", "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/lang/String;)V", false);
        }
        this.mv.visitJumpInsn(167, gotoLabel);
    }

    private void genCallTerm(BIRTerminator.Call callIns, int localVarOffset, String funcName) {
        this.genCall(callIns, callIns.calleePkg, localVarOffset);
        this.storeReturnFromCallIns(callIns.lhsOp != null ? callIns.lhsOp.variableDcl : null);
        Label thenBBLabel = this.labelGen.getLabel(funcName + callIns.thenBB.id.value);
        this.mv.visitJumpInsn(167, thenBBLabel);
    }

    private void genPlatformIns(JTerminator terminator, BType attachedType, int localVarOffset, BIRNode.BIRFunction func) {
        switch (terminator.jTermKind) {
            case J_METHOD_CALL: {
                this.genJCallTerm((JavaMethodCall)terminator, attachedType, localVarOffset);
                break;
            }
            case JI_METHOD_CALL: {
                this.genJICallTerm((JIMethodCall)terminator, localVarOffset, func);
                break;
            }
            case JI_CONSTRUCTOR_CALL: {
                this.genJIConstructorTerm((JIConstructorCall)terminator);
                break;
            }
            case JI_METHOD_CLI_CALL: {
                this.genJICLICallTerm((JIMethodCLICall)terminator, localVarOffset);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for terminator instruction " + String.valueOf(terminator));
            }
        }
    }

    private void genJICLICallTerm(JIMethodCLICall terminator, int localVarOffset) {
        this.mv.visitVarInsn(25, localVarOffset + 1);
        this.mv.visitTypeInsn(192, terminator.jClassName);
        this.mv.visitMethodInsn(182, terminator.jClassName, terminator.name, terminator.jMethodVMSig, false);
        BIRNode.BIRVariableDcl tempVar = new BIRNode.BIRVariableDcl(this.symbolTable.anyType, new Name("%arrayResult"), VarScope.FUNCTION, VarKind.TEMP);
        int resultIndex = this.getJVMIndexOfVarRef(tempVar);
        this.mv.visitVarInsn(58, resultIndex);
        int nonDefaultArgsCount = terminator.lhsArgs.size() - terminator.defaultFunctionArgs.size();
        int index = 0;
        for (BIROperand lhsArg : terminator.lhsArgs) {
            this.mv.visitVarInsn(25, resultIndex);
            this.mv.visitIntInsn(16, index + 1);
            this.mv.visitInsn(50);
            if (index < nonDefaultArgsCount) {
                this.jvmCastGen.addUnboxInsn(this.mv, lhsArg.variableDcl.type);
            } else {
                lhsArg = terminator.defaultFunctionArgs.get(index - nonDefaultArgsCount);
            }
            ++index;
            this.storeToVar(lhsArg.variableDcl);
        }
    }

    private void genJCallTerm(JavaMethodCall callIns, BType attachedType, int localVarOffset) {
        int argIndex = 0;
        if (attachedType == null) {
            JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        } else {
            JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
            BIRNode.BIRVariableDcl selfArg = callIns.args.getFirst().variableDcl;
            this.loadVar(selfArg);
            this.mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BObject");
            ++argIndex;
        }
        int argsCount = callIns.args.size();
        while (argIndex < argsCount) {
            BIROperand arg = callIns.args.get(argIndex);
            this.loadVar(arg.variableDcl);
            ++argIndex;
        }
        String jClassName = callIns.jClassName;
        this.mv.visitMethodInsn(184, jClassName, callIns.name, callIns.jMethodVMSig, false);
        if (callIns.lhsOp != null && callIns.lhsOp.variableDcl != null) {
            this.storeToVar(callIns.lhsOp.variableDcl);
        }
    }

    private void genJICallTerm(JIMethodCall callIns, int localVarOffset, BIRNode.BIRFunction func) {
        BIROperand arg;
        int argsCount;
        List<BIROperand> functionArgs;
        List<BIROperand> resourcePathArgs;
        String jMethodVMSig;
        boolean hasBalEnvParam;
        boolean isInterface = callIns.invocationType == 185;
        int argIndex = 0;
        if (callIns.invocationType == 182 || isInterface) {
            BIRNode.BIRVariableDcl selfArg = callIns.args.getFirst().variableDcl;
            this.loadVar(selfArg);
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/HandleValue", "getValue", "()Ljava/lang/Object;", false);
            this.mv.visitTypeInsn(192, callIns.jClassName);
            Label ifNonNullLabel = this.labelGen.getLabel("receiver_null_check");
            this.mv.visitLabel(ifNonNullLabel);
            this.mv.visitInsn(89);
            Label elseBlockLabel = this.labelGen.getLabel("receiver_null_check_else");
            this.mv.visitJumpInsn(199, elseBlockLabel);
            Label thenBlockLabel = this.labelGen.getLabel("receiver_null_check_then");
            this.mv.visitLabel(thenBlockLabel);
            this.mv.visitFieldInsn(178, "io/ballerina/runtime/internal/errors/ErrorReasons", "JAVA_NULL_REFERENCE_ERROR", "Ljava/lang/String;");
            this.mv.visitFieldInsn(178, "io/ballerina/runtime/internal/errors/ErrorCodes", "JAVA_NULL_REFERENCE", "Lio/ballerina/runtime/internal/errors/ErrorCodes;");
            this.mv.visitInsn(3);
            this.mv.visitTypeInsn(189, "java/lang/Object");
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/errors/ErrorHelper", "getRuntimeException", "(Ljava/lang/String;Lio/ballerina/runtime/internal/errors/ErrorCodes;[Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/ErrorValue;", false);
            this.mv.visitInsn(191);
            this.mv.visitLabel(elseBlockLabel);
            ++argIndex;
        }
        if (hasBalEnvParam = (jMethodVMSig = callIns.jMethodVMSig).startsWith("(Lio/ballerina/runtime/api/Environment;")) {
            this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/BalEnvironment");
            this.mv.visitInsn(89);
            JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
            this.mv.visitFieldInsn(178, this.moduleInitClass, "$currentModule", "Lio/ballerina/runtime/api/Module;");
            this.mv.visitLdcInsn((Object)func.name.getValue());
            this.jvmTypeGen.loadFunctionPathParameters(this.mv, (BInvokableTypeSymbol)func.type.tsymbol);
            this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/BalEnvironment", "<init>", "(Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/api/Module;Ljava/lang/String;[Lio/ballerina/runtime/api/types/Parameter;)V", false);
        }
        if (callIns.receiver != null) {
            this.loadVar(callIns.receiver.variableDcl);
        }
        if ((resourcePathArgs = callIns.resourcePathArgs) != null && !resourcePathArgs.isEmpty()) {
            this.genResourcePathArgs(resourcePathArgs);
        }
        if ((functionArgs = callIns.functionArgs) != null && !functionArgs.isEmpty()) {
            this.genBundledFunctionArgs(functionArgs);
        }
        if (callIns.isInternal) {
            JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        }
        int n = argsCount = callIns.varArgExist ? callIns.args.size() - 1 : callIns.args.size();
        while (argIndex < argsCount) {
            arg = callIns.args.get(argIndex);
            this.loadVar(arg.variableDcl);
            ++argIndex;
        }
        if (callIns.varArgExist) {
            arg = callIns.args.get(argIndex);
            int localVarIndex = this.indexMap.addIfNotExists(arg.variableDcl.name.value, arg.variableDcl.type);
            InteropMethodGen.genVarArg(this.mv, this.indexMap, arg.variableDcl.type, callIns.varArgType, localVarIndex, this.symbolTable, this.jvmCastGen);
        }
        String jClassName = callIns.jClassName;
        String jMethodName = callIns.name;
        this.mv.visitMethodInsn(callIns.invocationType, jClassName, jMethodName, jMethodVMSig, isInterface);
        if (callIns.lhsOp != null && callIns.lhsOp.variableDcl != null) {
            this.storeToVar(callIns.lhsOp.variableDcl);
        }
    }

    private void genJIConstructorTerm(JIConstructorCall callIns) {
        this.mv.visitTypeInsn(187, callIns.jClassName);
        this.mv.visitInsn(89);
        int argsCount = callIns.args.size();
        for (int argIndex = 0; argIndex < argsCount; ++argIndex) {
            BIROperand arg = callIns.args.get(argIndex);
            this.loadVar(arg.variableDcl);
        }
        String jClassName = callIns.jClassName;
        String jMethodName = callIns.name;
        String jMethodVMSig = callIns.jMethodVMSig;
        this.mv.visitMethodInsn(183, jClassName, jMethodName, jMethodVMSig, false);
        BIRNode.BIRVariableDcl lhsOpVarDcl = callIns.lhsOp.variableDcl;
        if (lhsOpVarDcl != null) {
            this.storeToVar(lhsOpVarDcl);
        }
    }

    public void storeReturnFromCallIns(BIRNode.BIRVariableDcl lhsOpVarDcl) {
        if (lhsOpVarDcl != null) {
            this.storeToVar(lhsOpVarDcl);
        } else {
            this.mv.visitInsn(87);
        }
    }

    private void genFuncCall(BIRTerminator.Call callIns, PackageID packageID, int localVarOffset) {
        String methodName = callIns.name.value;
        this.genStaticCall(callIns, packageID, localVarOffset, methodName, methodName);
    }

    private void genBuiltinTypeAttachedFuncCall(BIRTerminator.Call callIns, PackageID packageID, int localVarOffset) {
        String methodLookupName = callIns.name.value;
        int optionalIndex = methodLookupName.indexOf(".");
        int index = optionalIndex != -1 ? optionalIndex + 1 : 0;
        String methodName = methodLookupName.substring(index);
        this.genStaticCall(callIns, packageID, localVarOffset, methodName, methodLookupName);
    }

    private void genStaticCall(BIRTerminator.Call callIns, PackageID packageID, int localVarOffset, String methodName, String methodLookupName) {
        String methodDesc;
        String jvmClass;
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        String encodedMethodName = Utils.encodeFunctionIdentifier((String)methodLookupName);
        String packageName = JvmModuleUtils.getPackageName(callIns.calleePkg);
        int argsCount = callIns.args.size();
        for (int i = 0; i < argsCount; ++i) {
            BIROperand arg = callIns.args.get(i);
            this.loadVar(arg.variableDcl);
        }
        BIRFunctionWrapper functionWrapper = this.jvmPackageGen.lookupBIRFunctionWrapper(packageName + encodedMethodName);
        if (functionWrapper == null) {
            functionWrapper = this.jvmPackageGen.lookupBIRFunctionWrapper(packageName + Utils.decodeIdentifier((String)methodLookupName));
        }
        if (functionWrapper != null) {
            jvmClass = functionWrapper.fullQualifiedClassName();
            methodDesc = functionWrapper.jvmMethodDescription();
        } else {
            String balFileName;
            BPackageSymbol symbol = this.packageCache.getSymbol(packageID.orgName.getValue() + "/" + packageID.name.getValue());
            Name decodedMethodName = new Name(Utils.decodeIdentifier((String)methodName));
            BInvokableSymbol funcSymbol = (BInvokableSymbol)symbol.scope.lookup((Name)decodedMethodName).symbol;
            if (funcSymbol == null && JvmCodeGenUtil.isModuleInitializerMethod(decodedMethodName.value)) {
                String jvmClass2 = JvmModuleUtils.getModuleLevelClassName(packageID, JvmCodeGenUtil.cleanupPathSeparators("$_init"));
                this.mv.visitMethodInsn(184, jvmClass2, encodedMethodName, "(Lio/ballerina/runtime/internal/scheduling/Strand;)Ljava/lang/Object;", false);
                return;
            }
            assert (funcSymbol != null);
            BInvokableType type = (BInvokableType)funcSymbol.type;
            ArrayList<BType> params = new ArrayList<BType>(type.paramTypes);
            if (type.restType != null) {
                params.add(type.restType);
            }
            if ((balFileName = funcSymbol.source) == null || !balFileName.endsWith(".bal")) {
                balFileName = "$_init";
            }
            jvmClass = JvmModuleUtils.getModuleLevelClassName(packageID, JvmCodeGenUtil.cleanupPathSeparators(balFileName));
            BType retType = this.unifier.build(this.symbolTable.typeEnv(), type.retType);
            methodDesc = JvmCodeGenUtil.getMethodDesc(this.symbolTable.typeEnv(), params, retType);
        }
        this.mv.visitMethodInsn(184, jvmClass, encodedMethodName, methodDesc, false);
    }

    private void genVirtualCall(BIRTerminator.Call callIns, int localVarOffset) {
        BIRNode.BIRVariableDcl selfArg = callIns.args.getFirst().variableDcl;
        this.loadVar(selfArg);
        this.mv.visitTypeInsn(192, "io/ballerina/runtime/api/values/BObject");
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        this.mv.visitLdcInsn((Object)JvmCodeGenUtil.rewriteVirtualCallTypeName(callIns.name.value, selfArg.type));
        int argsCount = callIns.args.size() - 1;
        this.mv.visitLdcInsn((Object)argsCount);
        this.mv.visitInsn(136);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        int j = 0;
        for (int i = 0; i < argsCount; ++i) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn((Object)j);
            this.mv.visitInsn(136);
            ++j;
            BIROperand arg = callIns.args.get(i + 1);
            this.loadVar(arg.variableDcl);
            this.jvmCastGen.addBoxInsn(this.mv, arg.variableDcl.type);
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(185, "io/ballerina/runtime/api/values/BObject", "call", "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", true);
        BType returnType = callIns.lhsOp.variableDcl.type;
        this.jvmCastGen.addUnboxInsn(this.mv, returnType);
    }

    private void genAsyncCallTerm(BIRTerminator.AsyncCall callIns, int localVarOffset, boolean hasWorkers, int channelMapVarIndex) {
        this.genPanicIfInLock(localVarOffset);
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "scheduler", "Lio/ballerina/runtime/internal/scheduling/Scheduler;");
        LambdaFunction lambdaFunction = this.asyncDataCollector.addAndGetLambda(callIns.name.value, callIns, true);
        JvmCodeGenUtil.createFunctionPointer(this.mv, lambdaFunction.enclosingClass, lambdaFunction.lambdaName);
        boolean isIsolated = false;
        String strandName = null;
        if (!callIns.annotAttachments.isEmpty()) {
            for (BIRNode.BIRAnnotationAttachment annotationAttachment : callIns.annotAttachments) {
                BIRNode.ConstValue constValue;
                if (annotationAttachment == null || !"strand".equals(annotationAttachment.annotTagRef.value) || !JvmModuleUtils.isBuiltInPackage(annotationAttachment.annotPkgId)) continue;
                Object strandAnnot = ((BIRNode.BIRConstAnnotationAttachment)annotationAttachment).annotValue.value;
                if (!(strandAnnot instanceof Map)) break;
                Map recordValue = (Map)strandAnnot;
                if (recordValue.containsKey("thread")) {
                    constValue = (BIRNode.ConstValue)recordValue.get("thread");
                    if ("any".equals(constValue.value)) {
                        isIsolated = true;
                    }
                }
                if (recordValue.containsKey("name")) {
                    constValue = (BIRNode.ConstValue)recordValue.get("name");
                    strandName = (String)constValue.value;
                }
                if (!recordValue.containsKey("policy")) break;
                constValue = (BIRNode.ConstValue)recordValue.get("policy");
                if ("DEFAULT".equals(constValue.value)) break;
                throw new BLangCompilerException("Unsupported policy. Only 'DEFAULT' policy is supported by jBallerina runtime.");
            }
        }
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        this.loadFpReturnType(callIns.lhsOp);
        String workerName = strandName;
        this.mv.visitLdcInsn((Object)Objects.requireNonNullElseGet(workerName, () -> Objects.requireNonNullElse(callIns.lhsOp.variableDcl.metaVarName, "anon")));
        this.submitToScheduler(callIns.lhsOp, isIsolated, callIns, hasWorkers, channelMapVarIndex);
    }

    private void genPanicIfInLock(int localVarOffset) {
        String lockStore = "Lio/ballerina/runtime/internal/lock/BLockStore;";
        this.mv.visitFieldInsn(178, this.moduleInitClass, "$lockStore", lockStore);
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/lock/BLockStore", "panicIfInLock", "(Lio/ballerina/runtime/internal/scheduling/Strand;)V", false);
    }

    private void genAsyncCallArgs(BIRTerminator.AsyncCall callIns) {
        int argsCount = callIns.args.size();
        this.mv.visitLdcInsn((Object)(argsCount + 1));
        this.mv.visitInsn(136);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        int paramIndex = 1;
        for (BIROperand arg : callIns.args) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn((Object)paramIndex);
            this.mv.visitInsn(136);
            this.loadVar(arg.variableDcl);
            this.jvmCastGen.addBoxInsn(this.mv, arg.variableDcl.type);
            this.mv.visitInsn(83);
            ++paramIndex;
        }
    }

    private void generateWaitIns(BIRTerminator.Wait waitInst, int localVarOffset) {
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        if (waitInst.exprList.size() == 1) {
            BIROperand futureVal = waitInst.exprList.getFirst();
            this.loadVar(futureVal.variableDcl);
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/AsyncUtils", "handleWait", "(Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/internal/values/FutureValue;)Ljava/lang/Object;", false);
        } else {
            this.mv.visitTypeInsn(187, "java/util/ArrayList");
            this.mv.visitInsn(89);
            this.mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
            for (int i = 0; i < waitInst.exprList.size(); ++i) {
                this.mv.visitInsn(89);
                BIROperand futureVal = waitInst.exprList.get(i);
                this.loadVar(futureVal.variableDcl);
                this.mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
                this.mv.visitInsn(87);
            }
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/AsyncUtils", "handleWaitAny", "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/util/List;)Ljava/lang/Object;", false);
        }
        this.jvmCastGen.addUnboxInsn(this.mv, waitInst.lhsOp.variableDcl.type);
        this.storeToVar(waitInst.lhsOp.variableDcl);
    }

    private void genWaitAllIns(BIRTerminator.WaitAll waitAll, int localVarOffset) {
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        this.mv.visitTypeInsn(187, "java/util/HashMap");
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        for (int i = 0; i < waitAll.keys.size(); ++i) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn((Object)waitAll.keys.get(i));
            BIROperand futureRef = waitAll.valueExprs.get(i);
            if (futureRef != null) {
                this.loadVar(futureRef.variableDcl);
            }
            this.mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            this.mv.visitInsn(87);
        }
        this.loadVar(waitAll.lhsOp.variableDcl);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/AsyncUtils", "handleWaitMultiple", "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/util/Map;Lio/ballerina/runtime/internal/values/MapValue;)V", false);
    }

    private void genFPCallIns(BIRTerminator.FPCall fpCall, int localVarOffset, boolean hasWorkers, int channelMapVarIndex) {
        if (fpCall.isAsync) {
            this.genPanicIfInLock(localVarOffset);
            JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
            this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/scheduling/Strand", "scheduler", "Lio/ballerina/runtime/internal/scheduling/Scheduler;");
        } else {
            this.loadVar(fpCall.fp.variableDcl);
            this.mv.visitFieldInsn(180, "io/ballerina/runtime/internal/values/FPValue", "function", "Ljava/util/function/Function;");
        }
        if (fpCall.isAsync) {
            String workerName = fpCall.lhsOp.variableDcl.metaVarName;
            boolean isIsolated = false;
            for (BIRNode.BIRAnnotationAttachment annotationAttachment : fpCall.annotAttachments) {
                BIRNode.ConstValue constValue;
                Object strandAnnot = ((BIRNode.BIRConstAnnotationAttachment)annotationAttachment).annotValue.value;
                if (!(strandAnnot instanceof Map)) continue;
                Map recordValue = (Map)strandAnnot;
                if (recordValue.containsKey("thread")) {
                    constValue = (BIRNode.ConstValue)recordValue.get("thread");
                    if ("any".equals(constValue.value)) {
                        isIsolated = true;
                    }
                }
                if (recordValue.containsKey("name")) {
                    constValue = (BIRNode.ConstValue)recordValue.get("name");
                    workerName = (String)constValue.value;
                }
                if (!recordValue.containsKey("policy")) break;
                constValue = (BIRNode.ConstValue)recordValue.get("policy");
                if ("DEFAULT".equals(constValue.value)) break;
                throw new BLangCompilerException("Unsupported policy. Only 'DEFAULT' policy is supported by jBallerina runtime.");
            }
            this.loadVar(fpCall.fp.variableDcl);
            JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
            this.loadFpReturnType(fpCall.lhsOp);
            this.mv.visitLdcInsn((Object)Objects.requireNonNullElse(workerName, "anon"));
            this.submitToScheduler(fpCall.lhsOp, isIsolated, fpCall, localVarOffset, hasWorkers, channelMapVarIndex);
        } else {
            BIRNode.BIRVariableDcl lhsVar;
            this.genFpCallArgs(fpCall, localVarOffset);
            this.mv.visitMethodInsn(185, "java/util/function/Function", "apply", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            BType lhsType = fpCall.lhsOp.variableDcl.type;
            if (lhsType != null) {
                this.jvmCastGen.addUnboxInsn(this.mv, lhsType);
            }
            if ((lhsVar = fpCall.lhsOp.variableDcl) != null) {
                this.storeToVar(lhsVar);
            } else {
                this.mv.visitInsn(87);
            }
        }
    }

    private void genFpCallArgs(BIRTerminator.FPCall fpCall, int localVarOffset) {
        int argCount = fpCall.args.size() + 1;
        this.mv.visitIntInsn(16, argCount);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        this.mv.visitInsn(89);
        this.mv.visitIntInsn(16, 0);
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        this.mv.visitInsn(83);
        int paramIndex = 1;
        for (BIROperand arg : fpCall.args) {
            this.mv.visitInsn(89);
            this.mv.visitIntInsn(16, paramIndex);
            this.loadVar(arg.variableDcl);
            BType bType = arg.variableDcl.type;
            this.jvmCastGen.addBoxInsn(this.mv, bType);
            this.mv.visitInsn(83);
            ++paramIndex;
        }
    }

    private void genWorkerSendIns(BIRTerminator.WorkerSend ins, BIRNode.BIRFunction func, int channelMapVarIndex, int localVarOffset) {
        if (ins.isSync) {
            JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        }
        JvmCodeGenUtil.loadWorkerChannelMap(this.mv, func, channelMapVarIndex, localVarOffset);
        this.mv.visitLdcInsn((Object)ins.channel.value);
        this.loadVar(ins.data.variableDcl);
        this.jvmCastGen.addBoxInsn(this.mv, ins.data.variableDcl.type);
        if (ins.isSync) {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/WorkerUtils", "syncSend", "(Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", false);
            BIROperand lhsOp = ins.lhsOp;
            if (lhsOp != null) {
                this.storeToVar(lhsOp.variableDcl);
            } else {
                this.mv.visitInsn(87);
            }
        } else {
            this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/WorkerUtils", "asyncSend", "(Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;Ljava/lang/String;Ljava/lang/Object;)V", false);
        }
    }

    private void genWorkerAlternateReceiveIns(BIRTerminator.WorkerAlternateReceive ins, BIRNode.BIRFunction func, int channelMapVarIndex, int localVarOffset) {
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        JvmCodeGenUtil.loadWorkerChannelMap(this.mv, func, channelMapVarIndex, localVarOffset);
        int channelSize = ins.channels.size();
        this.mv.visitIntInsn(16, channelSize);
        this.mv.visitTypeInsn(189, "java/lang/String");
        int count = 0;
        for (String channel : ins.channels) {
            this.mv.visitInsn(89);
            this.mv.visitIntInsn(16, count++);
            this.mv.visitLdcInsn((Object)channel);
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/WorkerUtils", "alternateReceive", "(Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;[Ljava/lang/String;)Ljava/lang/Object;", false);
        this.jvmCastGen.addUnboxInsn(this.mv, ins.lhsOp.variableDcl.type);
        this.storeToVar(ins.lhsOp.variableDcl);
    }

    private void genWorkerMultipleReceiveIns(BIRTerminator.WorkerMultipleReceive ins, BIRNode.BIRFunction func, int channelMapVarIndex, int localVarOffset) {
        BIRNode.BIRVariableDcl mapVar = new BIRNode.BIRVariableDcl(this.symbolTable.anyType, new Name("$channelNamesMap"), VarScope.FUNCTION, VarKind.LOCAL);
        int mapVarIndex = this.getJVMIndexOfVarRef(mapVar);
        this.mv.visitTypeInsn(187, "java/util/HashMap");
        this.mv.visitInsn(89);
        this.mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        this.mv.visitVarInsn(58, mapVarIndex);
        for (BIRTerminator.WorkerMultipleReceive.ReceiveField receiveField : ins.receiveFields) {
            this.mv.visitVarInsn(25, mapVarIndex);
            this.mv.visitLdcInsn((Object)receiveField.key());
            this.mv.visitLdcInsn((Object)receiveField.workerReceive());
            this.mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            this.mv.visitInsn(87);
        }
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        JvmCodeGenUtil.loadWorkerChannelMap(this.mv, func, channelMapVarIndex, localVarOffset);
        this.mv.visitVarInsn(25, mapVarIndex);
        this.jvmTypeGen.loadType(this.mv, ins.targetType);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/WorkerUtils", "multipleReceive", "(Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;Ljava/util/Map;Lio/ballerina/runtime/api/types/Type;)Lio/ballerina/runtime/api/values/BMap;", false);
        this.jvmCastGen.addUnboxInsn(this.mv, ins.lhsOp.variableDcl.type);
        this.storeToVar(ins.lhsOp.variableDcl);
    }

    private void genWorkerReceiveIns(BIRTerminator.WorkerReceive ins, BIRNode.BIRFunction func, int channelMapVarIndex, int localVarOffset) {
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        JvmCodeGenUtil.loadWorkerChannelMap(this.mv, func, channelMapVarIndex, localVarOffset);
        this.mv.visitLdcInsn((Object)ins.workerName.value);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/WorkerUtils", "receive", "(Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;Ljava/lang/String;)Ljava/lang/Object;", false);
        this.jvmCastGen.addUnboxInsn(this.mv, ins.lhsOp.variableDcl.type);
        this.storeToVar(ins.lhsOp.variableDcl);
    }

    private void genFlushIns(BIRTerminator.Flush ins, BIRNode.BIRFunction func, int channelMapVarIndex, int localVarOffset) {
        JvmCodeGenUtil.loadStrand(this.mv, localVarOffset);
        JvmCodeGenUtil.loadWorkerChannelMap(this.mv, func, channelMapVarIndex, localVarOffset);
        int channelSize = ins.channels.length;
        this.mv.visitIntInsn(16, channelSize);
        this.mv.visitTypeInsn(189, "java/lang/String");
        int count = 0;
        for (BIRNode.ChannelDetails channelDetails : ins.channels) {
            this.mv.visitInsn(89);
            this.mv.visitIntInsn(16, count++);
            this.mv.visitLdcInsn((Object)channelDetails.name);
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/WorkerUtils", "flush", "(Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;[Ljava/lang/String;)Ljava/lang/Object;", false);
        this.storeToVar(ins.lhsOp.variableDcl);
    }

    private void submitToScheduler(BIROperand lhsOp, boolean isIsolated, BIRTerminator.AsyncCall callIns, boolean hasWorkers, int channelMapVarIndex) {
        this.genWorkerChannelMapForCall(hasWorkers, channelMapVarIndex);
        this.genAsyncCallArgs(callIns);
        this.genStartFunctionCall(lhsOp, isIsolated);
    }

    private void submitToScheduler(BIROperand lhsOp, boolean isIsolated, BIRTerminator.FPCall fpCall, int localVarOffset, boolean hasWorkers, int channelMapVarIndex) {
        this.genWorkerChannelMapForCall(hasWorkers, channelMapVarIndex);
        this.genFpCallArgs(fpCall, localVarOffset);
        this.genStartFunctionCall(lhsOp, isIsolated);
    }

    private void genStartFunctionCall(BIROperand lhsOp, boolean isIsolated) {
        if (isIsolated) {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "startIsolatedWorker", "(Lio/ballerina/runtime/internal/values/FPValue;Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/api/types/Type;Ljava/lang/String;Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;[Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/FutureValue;", false);
        } else {
            this.mv.visitMethodInsn(182, "io/ballerina/runtime/internal/scheduling/Scheduler", "startNonIsolatedWorker", "(Lio/ballerina/runtime/internal/values/FPValue;Lio/ballerina/runtime/internal/scheduling/Strand;Lio/ballerina/runtime/api/types/Type;Ljava/lang/String;Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;[Ljava/lang/Object;)Lio/ballerina/runtime/internal/values/FutureValue;", false);
        }
        if (lhsOp.variableDcl != null) {
            BIRNode.BIRVariableDcl lhsOpVarDcl = lhsOp.variableDcl;
            this.storeToVar(lhsOpVarDcl);
        }
    }

    private void genWorkerChannelMapForCall(boolean hasWorkers, int channelMapVarIndex) {
        if (hasWorkers) {
            this.mv.visitVarInsn(25, channelMapVarIndex);
        } else {
            this.mv.visitInsn(1);
        }
    }

    private void loadFpReturnType(BIROperand lhsOp) {
        BType futureType = JvmCodeGenUtil.getImpliedType(lhsOp.variableDcl.type);
        BType returnType = this.symbolTable.anyType;
        if (futureType.tag == 32) {
            returnType = ((BFutureType)futureType).constraint;
        }
        this.jvmTypeGen.loadType(this.mv, returnType);
    }

    private int getJVMIndexOfVarRef(BIRNode.BIRVariableDcl varDcl) {
        return this.indexMap.addIfNotExists(varDcl.name.value, varDcl.type);
    }

    private void loadVar(BIRNode.BIRVariableDcl varDcl) {
        this.jvmInstructionGen.generateVarLoad(this.mv, varDcl);
    }

    private void storeToVar(BIRNode.BIRVariableDcl varDcl) {
        this.jvmInstructionGen.generateVarStore(this.mv, varDcl);
    }

    private void genResourcePathArgs(List<BIROperand> pathArgs) {
        int pathVarArrayIndex = this.indexMap.addIfNotExists("$pathVarArray", this.symbolTable.anyType);
        int bundledArrayIndex = this.indexMap.addIfNotExists("$pathArrayArgs", this.symbolTable.anyType);
        this.genBundledArgs(pathArgs, pathVarArrayIndex, bundledArrayIndex, "TYPE_ANYDATA_ARRAY", true);
    }

    private void genBundledFunctionArgs(List<BIROperand> args) {
        int functionArgArrayIndex = this.indexMap.addIfNotExists("$functionArgArray", this.symbolTable.anyType);
        int bundledArrayIndex = this.indexMap.addIfNotExists("$functionArrayArgs", this.symbolTable.anyType);
        this.genBundledArgs(args, functionArgArrayIndex, bundledArrayIndex, "TYPE_ANY_ARRAY", false);
    }

    private void genBundledArgs(List<BIROperand> args, int argsArrayIndex, int bundledArrayIndex, String fieldName, boolean isFromPathArgs) {
        this.mv.visitLdcInsn((Object)args.size());
        this.mv.visitInsn(136);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        this.mv.visitVarInsn(58, argsArrayIndex);
        int i = 0;
        for (BIROperand arg : args) {
            this.mv.visitVarInsn(25, argsArrayIndex);
            this.mv.visitLdcInsn((Object)i);
            this.mv.visitInsn(136);
            this.loadVar(arg.variableDcl);
            if (isFromPathArgs) {
                this.jvmCastGen.generateCheckCastToAnyData(this.mv, arg.variableDcl.type);
            } else {
                this.jvmCastGen.addBoxInsn(this.mv, arg.variableDcl.type);
            }
            this.mv.visitInsn(83);
            ++i;
        }
        this.mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/ArrayValueImpl");
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(25, argsArrayIndex);
        this.mv.visitFieldInsn(178, "io/ballerina/runtime/api/types/PredefinedTypes", fieldName, "Lio/ballerina/runtime/api/types/ArrayType;");
        this.mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/ArrayValueImpl", "<init>", "([Ljava/lang/Object;Lio/ballerina/runtime/api/types/ArrayType;)V", false);
        this.mv.visitVarInsn(58, bundledArrayIndex);
        this.mv.visitVarInsn(25, bundledArrayIndex);
    }

    private void generateReturnTermFromType(BType bType, BIRNode.BIRFunction func, int returnVarRefIndex, int channelMapVarIndex, int sendWorkerChannelNamesVar, int receiveWorkerChannelNamesVar, int localVarOffset) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            this.handleWorkerReturn(func, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
            this.mv.visitVarInsn(22, returnVarRefIndex);
            this.mv.visitInsn(173);
            return;
        }
        if (TypeTags.isStringTypeTag(bType.tag) || TypeTags.isXMLTypeTag(bType.tag) || 53 == bType.tag) {
            this.handleWorkerReturn(func, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
            this.mv.visitVarInsn(25, returnVarRefIndex);
            this.mv.visitInsn(176);
            return;
        }
        switch (bType.tag) {
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 50: {
                this.handleWorkerReturn(func, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
                this.mv.visitVarInsn(25, returnVarRefIndex);
                this.mv.visitInsn(176);
                break;
            }
            case 2: 
            case 6: {
                this.handleWorkerReturn(func, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
                this.mv.visitVarInsn(21, returnVarRefIndex);
                this.mv.visitInsn(172);
                break;
            }
            case 3: {
                this.handleWorkerReturn(func, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
                this.mv.visitVarInsn(24, returnVarRefIndex);
                this.mv.visitInsn(175);
                break;
            }
            case 21: 
            case 29: {
                this.handleWorkerReturnWithError(func, returnVarRefIndex, channelMapVarIndex, sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar, localVarOffset);
                this.mv.visitVarInsn(25, returnVarRefIndex);
                this.mv.visitInsn(176);
                break;
            }
            default: {
                throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(func.type.retType));
            }
        }
    }

    private void handleWorkerReturn(BIRNode.BIRFunction func, int channelMapVarIndex, int sendWorkerChannelNamesVar, int receiveWorkerChannelNamesVar, int localVarOffset) {
        if (func.workerChannels.length == 0) {
            return;
        }
        JvmCodeGenUtil.loadWorkerChannelMap(this.mv, func, channelMapVarIndex, localVarOffset);
        this.mv.visitInsn(1);
        this.handleWorkerReturn(sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar);
    }

    private void handleWorkerReturnWithError(BIRNode.BIRFunction func, int returnVarRefIndex, int channelMapVarIndex, int sendWorkerChannelNamesVar, int receiveWorkerChannelNamesVar, int localVarOffset) {
        if (func.workerChannels.length == 0) {
            return;
        }
        JvmCodeGenUtil.loadWorkerChannelMap(this.mv, func, channelMapVarIndex, localVarOffset);
        this.mv.visitVarInsn(25, returnVarRefIndex);
        this.handleWorkerReturn(sendWorkerChannelNamesVar, receiveWorkerChannelNamesVar);
    }

    private void handleWorkerReturn(int sendWorkerChannelNamesVar, int receiveWorkerChannelNamesVar) {
        this.mv.visitVarInsn(25, sendWorkerChannelNamesVar);
        this.mv.visitVarInsn(25, receiveWorkerChannelNamesVar);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/scheduling/WorkerUtils", "completedWorkerChannels", "(Lio/ballerina/runtime/internal/scheduling/WorkerChannelMap;Ljava/lang/Object;[Ljava/lang/String;[Ljava/lang/String;)V", false);
    }
}

