/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.identifier.Utils;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.BooleanSubtype;
import io.ballerina.types.subtypedata.DecimalSubtype;
import io.ballerina.types.subtypedata.FloatSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.StringSubtype;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.types.SelectivelyImmutableReferenceType;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeHashVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.semantics.model.types.SemNamedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.TypeFlags;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmTypeGen {
    private final JvmConstantsGen jvmConstantsGen;
    private final TypeHashVisitor typeHashVisitor;
    private final SymbolTable symbolTable;
    private final PackageID packageID;
    private final String anonTypesClass;
    private final String recordTypesClass;
    private final String functionTypesClass;
    private final String recordsClass;
    private final String objectsClass;
    private final String errorsClass;
    private final String functionCallsClass;
    private final Context semTypeCtx;
    public final String recordTypesPkgName;
    public final String objectTypesPkgName;
    public final String errorTypesPkgName;
    public final String tupleTypesPkgName;
    public final String unionTypesPkgName;

    public JvmTypeGen(JvmConstantsGen jvmConstantsGen, PackageID packageID, TypeHashVisitor typeHashVisitor, SymbolTable symbolTable) {
        this.jvmConstantsGen = jvmConstantsGen;
        this.packageID = packageID;
        this.typeHashVisitor = typeHashVisitor;
        this.symbolTable = symbolTable;
        this.semTypeCtx = Context.from((Env)symbolTable.typeEnv());
        this.anonTypesClass = JvmModuleUtils.getModuleLevelClassName(packageID, "types/anon_types");
        this.recordTypesClass = JvmModuleUtils.getModuleLevelClassName(packageID, "types/record_types");
        this.functionTypesClass = JvmModuleUtils.getModuleLevelClassName(packageID, "types/function_types");
        this.recordsClass = JvmModuleUtils.getModuleLevelClassName(packageID, "creators/records");
        this.objectsClass = JvmModuleUtils.getModuleLevelClassName(packageID, "creators/objects");
        this.errorsClass = JvmModuleUtils.getModuleLevelClassName(packageID, "creators/errors");
        this.functionCallsClass = JvmModuleUtils.getModuleLevelClassName(packageID, "creators/function_calls");
        this.recordTypesPkgName = JvmModuleUtils.getModuleLevelClassName(packageID, "types/record_types/");
        this.objectTypesPkgName = JvmModuleUtils.getModuleLevelClassName(packageID, "types/object_types/");
        this.errorTypesPkgName = JvmModuleUtils.getModuleLevelClassName(packageID, "types/error_types/");
        this.tupleTypesPkgName = JvmModuleUtils.getModuleLevelClassName(packageID, "types/tuple_types/");
        this.unionTypesPkgName = JvmModuleUtils.getModuleLevelClassName(packageID, "types/union_types/");
    }

    void generateGetTypeMethod(ClassWriter cw, String moduleClass) {
        this.generateGetAnonTypeMethod(cw, moduleClass);
        this.generateGetRecordTypeMethod(cw);
        this.generateGetFunctionTypeMethod(cw);
    }

    void generateGetAnonTypeMethod(ClassWriter cw, String moduleClass) {
        MethodVisitor mv = cw.visitMethod(1, "getAnonType", "(ILjava/lang/String;)Lio/ballerina/runtime/api/types/Type;", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(184, this.anonTypesClass, "getAnonType", "(ILjava/lang/String;)Lio/ballerina/runtime/api/types/Type;", false);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "getAnonType", moduleClass);
        mv.visitEnd();
    }

    void generateGetRecordTypeMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "getRecordType", "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/RecordType;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, this.recordTypesClass, "getRecordType", "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/RecordType;", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    void generateGetFunctionTypeMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "getFunctionType", "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/FunctionType;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, this.functionTypesClass, "getFunctionType", "(Ljava/lang/String;)Lio/ballerina/runtime/api/types/FunctionType;", false);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    void generateValueCreatorMethods(ClassWriter cw, String moduleClass) {
        this.generateRecordValueCreateMethod(cw, moduleClass);
        this.generateObjectValueCreateMethod(cw, moduleClass);
        this.generateErrorValueCreateMethod(cw, moduleClass);
        this.generateFunctionCallMethod(cw, moduleClass);
    }

    private void generateRecordValueCreateMethod(ClassWriter cw, String moduleClass) {
        MethodVisitor mv = cw.visitMethod(1, "createRecordValue", "(Ljava/lang/String;)Lio/ballerina/runtime/internal/values/MapValue;", "(Ljava/lang/String;)Lio/ballerina/runtime/internal/values/MapValue<Ljava/lang/String;Ljava/lang/Object;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, this.recordsClass, "createRecordValue", "(Ljava/lang/String;)Lio/ballerina/runtime/internal/values/MapValue;", false);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "createRecordValue", moduleClass);
        mv.visitEnd();
    }

    private void generateObjectValueCreateMethod(ClassWriter cw, String moduleClass) {
        MethodVisitor mv = cw.visitMethod(1, "createObjectValue", "(Ljava/lang/String;Lio/ballerina/runtime/internal/scheduling/Strand;[Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BObject;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(184, this.objectsClass, "createObjectValue", "(Ljava/lang/String;Lio/ballerina/runtime/internal/scheduling/Strand;[Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BObject;", false);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "createObjectValue", moduleClass);
        mv.visitEnd();
    }

    private void generateErrorValueCreateMethod(ClassWriter cw, String moduleClass) {
        MethodVisitor mv = cw.visitMethod(1, "createErrorValue", "(Ljava/lang/String;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BError;Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BError;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(184, this.errorsClass, "createErrorValue", "(Ljava/lang/String;Lio/ballerina/runtime/api/values/BString;Lio/ballerina/runtime/api/values/BError;Ljava/lang/Object;)Lio/ballerina/runtime/api/values/BError;", false);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "createErrorValue", moduleClass);
        mv.visitEnd();
    }

    private void generateFunctionCallMethod(ClassWriter cw, String moduleClass) {
        MethodVisitor mv = cw.visitMethod(1, "call", "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(184, this.functionCallsClass, "call", "(Lio/ballerina/runtime/internal/scheduling/Strand;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "call", moduleClass);
        mv.visitEnd();
    }

    public int typeFlag(BType type) {
        boolean isAnydata = SemTypeHelper.isSubtype(this.semTypeCtx, type, Core.createAnydata((Context)this.semTypeCtx));
        boolean isPureType = isAnydata || SemTypeHelper.isSubtype(this.semTypeCtx, type, Core.union((SemType)Core.createAnydata((Context)this.semTypeCtx), (SemType)PredefinedType.ERROR));
        return TypeFlags.asMask(type.isNullable(), isAnydata, isPureType);
    }

    public void loadType(MethodVisitor mv, BType bType) {
        String typeFieldName;
        if (bType == null || bType.tag == 10) {
            typeFieldName = "TYPE_NULL";
        } else {
            switch (bType.tag) {
                case 50: {
                    typeFieldName = "TYPE_NEVER";
                    break;
                }
                case 1: {
                    typeFieldName = "TYPE_INT";
                    break;
                }
                case 39: {
                    typeFieldName = "TYPE_INT_SIGNED_32";
                    break;
                }
                case 40: {
                    typeFieldName = "TYPE_INT_SIGNED_16";
                    break;
                }
                case 41: {
                    typeFieldName = "TYPE_INT_SIGNED_8";
                    break;
                }
                case 42: {
                    typeFieldName = "TYPE_INT_UNSIGNED_32";
                    break;
                }
                case 43: {
                    typeFieldName = "TYPE_INT_UNSIGNED_16";
                    break;
                }
                case 44: {
                    typeFieldName = "TYPE_INT_UNSIGNED_8";
                    break;
                }
                case 3: {
                    typeFieldName = "TYPE_FLOAT";
                    break;
                }
                case 5: {
                    typeFieldName = "TYPE_STRING";
                    break;
                }
                case 45: {
                    typeFieldName = "TYPE_STRING_CHAR";
                    break;
                }
                case 4: {
                    typeFieldName = "TYPE_DECIMAL";
                    break;
                }
                case 6: {
                    typeFieldName = "TYPE_BOOLEAN";
                    break;
                }
                case 2: {
                    typeFieldName = "TYPE_BYTE";
                    break;
                }
                case 18: {
                    typeFieldName = Symbols.isFlagOn(bType.getFlags(), 32L) ? "TYPE_READONLY_ANY" : "TYPE_ANY";
                    break;
                }
                case 11: 
                case 53: {
                    typeFieldName = Symbols.isFlagOn(bType.getFlags(), 32L) ? "TYPE_READONLY_ANYDATA" : "TYPE_ANYDATA";
                    break;
                }
                case 7: {
                    typeFieldName = Symbols.isFlagOn(bType.getFlags(), 32L) ? "TYPE_READONLY_JSON" : "TYPE_JSON";
                    break;
                }
                case 8: {
                    this.loadXmlType(mv, (BXMLType)bType);
                    return;
                }
                case 46: {
                    typeFieldName = Symbols.isFlagOn(bType.getFlags(), 32L) ? "TYPE_READONLY_ELEMENT" : "TYPE_ELEMENT";
                    break;
                }
                case 47: {
                    typeFieldName = Symbols.isFlagOn(bType.getFlags(), 32L) ? "TYPE_READONLY_PROCESSING_INSTRUCTION" : "TYPE_PROCESSING_INSTRUCTION";
                    break;
                }
                case 48: {
                    typeFieldName = Symbols.isFlagOn(bType.getFlags(), 32L) ? "TYPE_READONLY_COMMENT" : "TYPE_COMMENT";
                    break;
                }
                case 49: {
                    typeFieldName = "TYPE_TEXT";
                    break;
                }
                case 13: {
                    this.loadTypedescType(mv, (BTypedescType)bType);
                    return;
                }
                case 12: 
                case 34: {
                    this.loadUserDefinedType(mv, bType);
                    return;
                }
                case 37: {
                    typeFieldName = "TYPE_HANDLE";
                    break;
                }
                case 20: {
                    this.jvmConstantsGen.generateGetBArrayType(mv, this.jvmConstantsGen.getArrayTypeConstantsVar(bType));
                    return;
                }
                case 16: {
                    this.loadMapType(mv, (BMapType)bType);
                    return;
                }
                case 15: {
                    this.loadStreamType(mv, (BStreamType)bType);
                    return;
                }
                case 9: {
                    this.loadTableType(mv, (BTableType)bType);
                    return;
                }
                case 29: {
                    this.loadErrorType(mv, (BErrorType)bType);
                    return;
                }
                case 21: {
                    BUnionType unionType = (BUnionType)bType;
                    if (unionType.isCyclic) {
                        this.loadUserDefinedType(mv, bType);
                    } else {
                        this.jvmConstantsGen.generateGetBUnionType(mv, this.jvmConstantsGen.getUnionTypeConstantsVar(bType, this.symbolTable));
                    }
                    return;
                }
                case 22: {
                    this.loadIntersectionType(mv, (BIntersectionType)bType);
                    return;
                }
                case 17: {
                    this.loadInvokableType(mv, (BInvokableType)bType);
                    return;
                }
                case 24: {
                    mv.visitInsn(1);
                    return;
                }
                case 31: {
                    BTupleType tupleType = (BTupleType)bType;
                    if (tupleType.isCyclic) {
                        this.loadUserDefinedType(mv, bType);
                    } else {
                        this.jvmConstantsGen.generateGetBTupleType(mv, this.jvmConstantsGen.getTupleTypeConstantsVar(tupleType, this.symbolTable));
                    }
                    return;
                }
                case 33: {
                    this.loadFiniteType(mv, (BFiniteType)bType);
                    return;
                }
                case 32: {
                    this.loadFutureType(mv, (BFutureType)bType);
                    return;
                }
                case 38: {
                    typeFieldName = "TYPE_READONLY";
                    break;
                }
                case 52: {
                    this.loadParameterizedType(mv, (BParameterizedType)bType);
                    return;
                }
                case 14: {
                    String typeOwner = JvmModuleUtils.getModuleLevelClassName(bType.tsymbol.pkgID, "constants/type_ref_types/");
                    String varName = JvmCodeGenUtil.getRefTypeConstantName((BTypeReferenceType)bType);
                    String typeRefClass = typeOwner + varName;
                    mv.visitMethodInsn(184, typeRefClass, "get", "()Lio/ballerina/runtime/internal/types/BTypeReferenceType;", false);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        mv.visitFieldInsn(178, "io/ballerina/runtime/api/types/PredefinedTypes", typeFieldName, this.loadTypeClass(bType));
    }

    private String loadTypeClass(BType bType) {
        if ((bType = JvmCodeGenUtil.getImpliedType(bType)) == null || bType.tag == 10) {
            return "Lio/ballerina/runtime/api/types/NullType;";
        }
        return switch (bType.tag) {
            case 50 -> "Lio/ballerina/runtime/api/types/NeverType;";
            case 1, 39, 40, 41, 42, 43, 44 -> "Lio/ballerina/runtime/api/types/IntegerType;";
            case 3 -> "Lio/ballerina/runtime/api/types/FloatType;";
            case 5, 45 -> "Lio/ballerina/runtime/api/types/StringType;";
            case 4 -> "Lio/ballerina/runtime/api/types/DecimalType;";
            case 6 -> "Lio/ballerina/runtime/api/types/BooleanType;";
            case 2 -> "Lio/ballerina/runtime/api/types/ByteType;";
            case 18 -> "Lio/ballerina/runtime/api/types/AnyType;";
            case 11, 53 -> "Lio/ballerina/runtime/api/types/AnydataType;";
            case 7 -> "Lio/ballerina/runtime/api/types/JsonType;";
            case 8, 49 -> "Lio/ballerina/runtime/api/types/XmlType;";
            case 46, 47, 48 -> {
                if (Symbols.isFlagOn(bType.getFlags(), 32L)) {
                    yield "Lio/ballerina/runtime/api/types/Type;";
                }
                yield "Lio/ballerina/runtime/api/types/XmlType;";
            }
            case 34 -> {
                if (Symbols.isService(bType.tsymbol)) {
                    yield "Lio/ballerina/runtime/api/types/ServiceType;";
                }
                yield "Lio/ballerina/runtime/api/types/ObjectType;";
            }
            case 37 -> "Lio/ballerina/runtime/api/types/HandleType;";
            case 38 -> "Lio/ballerina/runtime/api/types/ReadonlyType;";
            case 21 -> "Lio/ballerina/runtime/api/types/UnionType;";
            default -> "Lio/ballerina/runtime/api/types/Type;";
        };
    }

    private void loadTypedescType(MethodVisitor mv, BTypedescType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BTypedescType");
        mv.visitInsn(89);
        this.loadType(mv, bType.constraint);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTypedescType", "<init>", "(Lio/ballerina/runtime/api/types/Type;)V", false);
    }

    void loadMapType(MethodVisitor mv, BMapType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BMapType");
        mv.visitInsn(89);
        this.loadType(mv, bType.constraint);
        this.loadReadonlyFlag(mv, bType);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BMapType", "<init>", "(Lio/ballerina/runtime/api/types/Type;Z)V", false);
    }

    public void loadReadonlyFlag(MethodVisitor mv, BType bType) {
        if (Symbols.isFlagOn(bType.getFlags(), 32L)) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
    }

    private void loadXmlType(MethodVisitor mv, BXMLType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BXmlType");
        mv.visitInsn(89);
        this.loadType(mv, bType.constraint);
        this.loadReadonlyFlag(mv, bType);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BXmlType", "<init>", "(Lio/ballerina/runtime/api/types/Type;Z)V", false);
    }

    private void loadTableType(MethodVisitor mv, BTableType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BTableType");
        mv.visitInsn(89);
        this.loadType(mv, bType.constraint);
        if (!bType.fieldNameList.isEmpty()) {
            List<String> fieldNames = bType.fieldNameList;
            mv.visitLdcInsn((Object)fieldNames.size());
            mv.visitInsn(136);
            mv.visitTypeInsn(189, "java/lang/String");
            int i = 0;
            for (String fieldName : fieldNames) {
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)i);
                mv.visitInsn(136);
                mv.visitLdcInsn((Object)Utils.unescapeJava((String)fieldName));
                mv.visitInsn(83);
                ++i;
            }
            this.loadReadonlyFlag(mv, bType);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTableType", "<init>", "(Lio/ballerina/runtime/api/types/Type;[Ljava/lang/String;Z)V", false);
        } else if (bType.keyTypeConstraint != null) {
            this.loadType(mv, bType.keyTypeConstraint);
            this.loadReadonlyFlag(mv, bType);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTableType", "<init>", "(Lio/ballerina/runtime/api/types/Type;Lio/ballerina/runtime/api/types/Type;Z)V", false);
        } else {
            this.loadReadonlyFlag(mv, bType);
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BTableType", "<init>", "(Lio/ballerina/runtime/api/types/Type;Z)V", false);
        }
    }

    private void loadStreamType(MethodVisitor mv, BStreamType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BStreamType");
        mv.visitInsn(89);
        this.loadType(mv, bType.constraint);
        this.loadType(mv, bType.completionType);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BStreamType", "<init>", "(Lio/ballerina/runtime/api/types/Type;Lio/ballerina/runtime/api/types/Type;)V", false);
    }

    private void loadErrorType(MethodVisitor mv, BErrorType errorType) {
        PackageID pkgID = errorType.tsymbol.pkgID;
        if (JvmModuleUtils.isBuiltInPackage(pkgID)) {
            mv.visitFieldInsn(178, "io/ballerina/runtime/api/types/PredefinedTypes", "TYPE_ERROR", "Lio/ballerina/runtime/api/types/ErrorType;");
            return;
        }
        if (Symbols.isFlagOn(errorType.getFlags(), 2048L)) {
            this.jvmConstantsGen.generateGetBErrorType(mv, this.jvmConstantsGen.getErrorTypeConstantsVar(errorType));
        } else {
            String typeName = JvmCodeGenUtil.toNameString(errorType);
            String typeOwner = JvmModuleUtils.getModuleLevelClassName(pkgID, "types/error_types/") + typeName;
            mv.visitMethodInsn(184, typeOwner, "get", "()Lio/ballerina/runtime/internal/types/BErrorType;", false);
        }
    }

    public boolean loadUnionName(MethodVisitor mv, BUnionType unionType) {
        if (unionType.tsymbol != null && unionType.tsymbol.name != null) {
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)unionType.tsymbol.name.getValue()));
        } else if (unionType.name != null) {
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)unionType.name.getValue()));
        } else {
            return false;
        }
        return true;
    }

    public void loadCyclicFlag(MethodVisitor mv, BType valueType) {
        valueType = JvmCodeGenUtil.getImpliedType(valueType);
        switch (valueType.tag) {
            case 21: {
                mv.visitInsn(((BUnionType)valueType).isCyclic ? 4 : 3);
                break;
            }
            case 31: {
                mv.visitInsn(((BTupleType)valueType).isCyclic ? 4 : 3);
            }
        }
    }

    public void createUnionMembersArray(ClassWriter cw, MethodVisitor methodVisitor, Set<BType> members, String className, String name) {
        this.generateCreateNewArray(methodVisitor, members);
        int arrayIndex = 1;
        methodVisitor.visitVarInsn(58, arrayIndex);
        int i = 0;
        MethodVisitor mv = null;
        int methodCount = 0;
        Object curMethodName = "";
        for (BType memberType : members) {
            if (i % 100 == 0) {
                curMethodName = "createMembers$" + name + methodCount++;
                mv = cw.visitMethod(8, (String)curMethodName, "([Lio/ballerina/runtime/api/types/Type;)V", null, null);
            }
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)i++);
            mv.visitInsn(136);
            this.loadType(mv, memberType);
            mv.visitInsn(83);
            if (i % 100 != 0) continue;
            this.generateMethodReturnAndInvoke(methodVisitor, className, arrayIndex, mv, (String)curMethodName);
        }
        if (i % 100 != 0) {
            this.generateMethodReturnAndInvoke(methodVisitor, className, arrayIndex, mv, (String)curMethodName);
        }
        methodVisitor.visitVarInsn(25, arrayIndex);
    }

    private void generateMethodReturnAndInvoke(MethodVisitor methodVisitor, String className, int arrayIndex, MethodVisitor mv, String curMethodName) {
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, curMethodName, className);
        mv.visitEnd();
        methodVisitor.visitVarInsn(25, arrayIndex);
        methodVisitor.visitMethodInsn(184, className, curMethodName, "([Lio/ballerina/runtime/api/types/Type;)V", false);
    }

    private void loadIntersectionType(MethodVisitor mv, BIntersectionType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BIntersectionType");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)bType.tsymbol.name.value));
        String moduleVar = this.jvmConstantsGen.getModuleConstantVar(bType.tsymbol.pkgID);
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(moduleVar), moduleVar, "Lio/ballerina/runtime/api/Module;");
        Set<BType> constituentTypes = bType.getConstituentTypes();
        this.generateCreateNewArray(mv, constituentTypes);
        int i = 0;
        for (BType memberType : constituentTypes) {
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitInsn(136);
            this.loadType(mv, memberType);
            mv.visitInsn(83);
            ++i;
        }
        this.loadType(mv, bType.effectiveType);
        mv.visitLdcInsn((Object)this.typeFlag(bType));
        this.loadReadonlyFlag(mv, bType);
        String effectiveTypeClass = bType.effectiveType instanceof SelectivelyImmutableReferenceType ? "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;[Lio/ballerina/runtime/api/types/Type;Lio/ballerina/runtime/api/types/IntersectableReferenceType;IZ)V" : "(Ljava/lang/String;Lio/ballerina/runtime/api/Module;[Lio/ballerina/runtime/api/types/Type;Lio/ballerina/runtime/api/types/Type;IZ)V";
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BIntersectionType", "<init>", effectiveTypeClass, false);
    }

    private void generateCreateNewArray(MethodVisitor methodVisitor, Set<BType> members) {
        methodVisitor.visitLdcInsn((Object)members.size());
        methodVisitor.visitInsn(136);
        methodVisitor.visitTypeInsn(189, "io/ballerina/runtime/api/types/Type");
    }

    private void loadUserDefinedType(MethodVisitor mv, BType bType) {
        BTypeSymbol typeSymbol = bType.tsymbol.isTypeParamResolved ? bType.tsymbol.typeParamTSymbol : bType.tsymbol;
        BType typeToLoad = bType.tsymbol.isTypeParamResolved ? typeSymbol.type : bType;
        PackageID pkgID = typeSymbol.pkgID;
        String defName = "";
        if ((typeSymbol.kind == SymbolKind.RECORD || typeSymbol.kind == SymbolKind.OBJECT) && typeSymbol.name.value.isEmpty()) {
            defName = Utils.encodeNonFunctionIdentifier((String)((BStructureTypeSymbol)typeSymbol).typeDefinitionSymbol.name.value);
        }
        String fieldName = defName.isEmpty() ? JvmCodeGenUtil.toNameString(typeToLoad) : defName;
        boolean samePackage = JvmModuleUtils.isSameModule(this.packageID, pkgID);
        if (!samePackage && Symbols.isFlagOn(typeToLoad.getFlags(), 2048L)) {
            String moduleVar = this.jvmConstantsGen.getModuleConstantVar(pkgID);
            mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(moduleVar), moduleVar, "Lio/ballerina/runtime/api/Module;");
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/ValueCreator", "getLookupKey", "(Lio/ballerina/runtime/api/Module;)Ljava/lang/String;", false);
            mv.visitMethodInsn(184, "io/ballerina/runtime/internal/values/ValueCreator", "getValueCreator", "(Ljava/lang/String;)Lio/ballerina/runtime/internal/values/ValueCreator;", false);
            Integer hash = this.typeHashVisitor.visit(typeToLoad);
            String shape = typeToLoad.toString();
            this.typeHashVisitor.reset();
            mv.visitLdcInsn((Object)hash);
            mv.visitLdcInsn((Object)("Package: " + JvmModuleUtils.getPackageName(pkgID) + ", TypeName: " + fieldName + ", Shape: " + shape));
            mv.visitMethodInsn(182, "io/ballerina/runtime/internal/values/ValueCreator", "getAnonType", "(ILjava/lang/String;)Lio/ballerina/runtime/api/types/Type;", false);
        } else if (samePackage && this.packageID.isTestPkg == pkgID.isTestPkg) {
            this.getUserDefinedType(mv, bType);
        } else {
            this.getUserDefinedType(mv, pkgID, bType);
        }
    }

    private void loadFutureType(MethodVisitor mv, BFutureType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BFutureType");
        mv.visitInsn(89);
        this.loadType(mv, bType.constraint);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BFutureType", "<init>", "(Lio/ballerina/runtime/api/types/Type;)V", false);
    }

    public void loadInvokableType(MethodVisitor mv, BInvokableType bType) {
        this.loadFunctionType(mv, bType, bType.name.getValue());
    }

    public void loadFunctionType(MethodVisitor mv, BInvokableType bType, String functionName) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BFunctionType");
        mv.visitInsn(89);
        if (bType.tsymbol == null) {
            mv.visitInsn(1);
        } else {
            String moduleVar = this.jvmConstantsGen.getModuleConstantVar(bType.tsymbol.pkgID);
            mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(moduleVar), moduleVar, "Lio/ballerina/runtime/api/Module;");
        }
        if (Symbols.isFlagOn(bType.getFlags(), 0x8000000000L)) {
            mv.visitLdcInsn((Object)bType.getFlags());
            mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BFunctionType", "<init>", "(Lio/ballerina/runtime/api/Module;J)V", false);
            return;
        }
        this.loadFunctionParameters(mv, bType);
        BType restType = bType.restType;
        if (restType == null) {
            mv.visitInsn(1);
        } else {
            this.loadType(mv, restType);
        }
        this.loadType(mv, bType.retType);
        mv.visitLdcInsn((Object)bType.getFlags());
        mv.visitLdcInsn((Object)functionName);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BFunctionType", "<init>", "(Lio/ballerina/runtime/api/Module;[Lio/ballerina/runtime/api/types/Parameter;Lio/ballerina/runtime/api/types/Type;Lio/ballerina/runtime/api/types/Type;JLjava/lang/String;)V", false);
    }

    protected void loadFunctionPathParameters(MethodVisitor mv, BInvokableTypeSymbol invokableSymbol) {
        ArrayList<BVarSymbol> params = new ArrayList<BVarSymbol>();
        if (invokableSymbol != null) {
            BVarSymbol param;
            SymbolKind paramKind;
            Iterator<BVarSymbol> iterator = invokableSymbol.params.iterator();
            while (iterator.hasNext() && ((paramKind = (param = iterator.next()).getKind()) == SymbolKind.PATH_PARAMETER || paramKind == SymbolKind.PATH_REST_PARAMETER)) {
                params.add(param);
            }
        }
        this.populateFunctionParameters(mv, invokableSymbol, params);
    }

    public void populateFunctionParameters(MethodVisitor mv, BInvokableTypeSymbol invokableSymbol, List<BVarSymbol> params) {
        mv.visitLdcInsn((Object)params.size());
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/api/types/Parameter");
        for (int i = 0; i < params.size(); ++i) {
            BVarSymbol paramSymbol = params.get(i);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitInsn(136);
            mv.visitTypeInsn(187, "io/ballerina/runtime/api/types/Parameter");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)paramSymbol.name.value);
            if (paramSymbol.isDefaultable) {
                mv.visitInsn(4);
            } else {
                mv.visitInsn(3);
            }
            BInvokableSymbol bInvokableSymbol = invokableSymbol.defaultValues.get(Utils.decodeIdentifier((String)paramSymbol.name.value));
            if (bInvokableSymbol == null) {
                mv.visitInsn(1);
            } else {
                mv.visitLdcInsn((Object)bInvokableSymbol.name.value);
            }
            this.loadType(mv, paramSymbol.type);
            mv.visitMethodInsn(183, "io/ballerina/runtime/api/types/Parameter", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Lio/ballerina/runtime/api/types/Type;)V", false);
            mv.visitInsn(83);
        }
    }

    private void loadFunctionParameters(MethodVisitor mv, BInvokableType invokableType) {
        BInvokableTypeSymbol invokableSymbol = (BInvokableTypeSymbol)invokableType.tsymbol;
        ArrayList<BVarSymbol> params = new ArrayList();
        if (invokableSymbol == null) {
            if (!invokableType.paramTypes.isEmpty()) {
                this.loadFunctionPointerParameters(mv, invokableType);
                return;
            }
        } else {
            params = invokableSymbol.params;
        }
        this.populateFunctionParameters(mv, invokableSymbol, params);
    }

    private void loadFunctionPointerParameters(MethodVisitor mv, BInvokableType invokableType) {
        List<BType> paramTypes = invokableType.paramTypes;
        mv.visitLdcInsn((Object)paramTypes.size());
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "io/ballerina/runtime/api/types/Parameter");
        for (int i = 0; i < paramTypes.size(); ++i) {
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitInsn(136);
            mv.visitTypeInsn(187, "io/ballerina/runtime/api/types/Parameter");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)"");
            mv.visitInsn(3);
            mv.visitInsn(1);
            this.loadType(mv, paramTypes.get(i));
            mv.visitMethodInsn(183, "io/ballerina/runtime/api/types/Parameter", "<init>", "(Ljava/lang/String;ZLjava/lang/String;Lio/ballerina/runtime/api/types/Type;)V", false);
            mv.visitInsn(83);
        }
    }

    private void loadParameterizedType(MethodVisitor mv, BParameterizedType bType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BParameterizedType");
        mv.visitInsn(89);
        this.loadType(mv, bType.paramValueType);
        mv.visitLdcInsn((Object)bType.paramIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BParameterizedType", "<init>", "(Lio/ballerina/runtime/api/types/Type;I)V", false);
    }

    public static String getTypeDesc(BType bType) {
        bType = JvmCodeGenUtil.getImpliedType(bType);
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return "J";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return "Lio/ballerina/runtime/api/values/BString;";
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return "Lio/ballerina/runtime/internal/values/XmlValue;";
        }
        if (bType.tag == 53) {
            return "Lio/ballerina/runtime/internal/values/RegExpValue;";
        }
        return switch (bType.tag) {
            case 2 -> "I";
            case 3 -> "D";
            case 6 -> "Z";
            case 7, 10, 11, 18, 21, 33, 38, 50 -> "Ljava/lang/Object;";
            case 20, 31 -> "Lio/ballerina/runtime/internal/values/ArrayValue;";
            case 29 -> "Lio/ballerina/runtime/internal/values/ErrorValue;";
            case 32 -> "Lio/ballerina/runtime/internal/values/FutureValue;";
            case 12, 16 -> "Lio/ballerina/runtime/internal/values/MapValue;";
            case 13 -> "Lio/ballerina/runtime/internal/values/TypedescValue;";
            case 15 -> "Lio/ballerina/runtime/internal/values/StreamValue;";
            case 9 -> "Lio/ballerina/runtime/internal/values/TableValue;";
            case 4 -> "Lio/ballerina/runtime/internal/values/DecimalValue;";
            case 34 -> "Lio/ballerina/runtime/api/values/BObject;";
            case 37 -> "Lio/ballerina/runtime/internal/values/HandleValue;";
            case 17 -> "Lio/ballerina/runtime/internal/values/FPValue;";
            default -> throw new BLangCompilerException("JVM generation is not supported for type " + String.valueOf(bType));
        };
    }

    private void loadFiniteType(MethodVisitor mv, BFiniteType finiteType) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BFiniteType");
        mv.visitInsn(89);
        String name = Utils.decodeIdentifier((String)JvmCodeGenUtil.toNameString(finiteType));
        mv.visitLdcInsn((Object)name);
        mv.visitLdcInsn((Object)finiteType.tsymbol.originalName.value);
        mv.visitTypeInsn(187, "java/util/LinkedHashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V", false);
        for (SemNamedType semNamedType : finiteType.valueSpace) {
            mv.visitInsn(89);
            SemType s = semNamedType.semType();
            if (PredefinedType.NIL.equals((Object)s)) {
                mv.visitInsn(1);
            } else if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.BOOLEAN)) {
                JvmTypeGen.loadConstBoolean(mv, (ComplexSemType)s);
            } else if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.INT)) {
                JvmTypeGen.loadConstInteger(mv, (ComplexSemType)s);
            } else if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.FLOAT)) {
                JvmTypeGen.loadConstFloat(mv, (ComplexSemType)s);
            } else if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.DECIMAL)) {
                JvmTypeGen.loadConstDecimal(mv, (ComplexSemType)s);
            } else if (SemTypes.isSubtypeSimple((SemType)s, (BasicTypeBitSet)PredefinedType.STRING)) {
                this.loadConstString(mv, (ComplexSemType)s);
            } else {
                throw new IllegalStateException("Unexpected value space type: " + String.valueOf(s));
            }
            mv.visitMethodInsn(185, "java/util/Set", "add", "(Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
        }
        mv.visitLdcInsn((Object)this.typeFlag(finiteType));
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BFiniteType", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;I)V", false);
    }

    private void loadConstString(MethodVisitor mv, ComplexSemType s) {
        String stringVal = (String)StringSubtype.stringSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)s, (BasicTypeCode)BasicTypeCode.BT_STRING)).orElseThrow();
        this.jvmConstantsGen.loadBStringConstant(mv, stringVal, null, null, false);
    }

    private static void loadConstDecimal(MethodVisitor mv, ComplexSemType s) {
        BigDecimal bVal = (BigDecimal)DecimalSubtype.decimalSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)s, (BasicTypeCode)BasicTypeCode.BT_DECIMAL)).orElseThrow();
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/values/DecimalValue");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)JvmCodeGenUtil.removeDecimalDiscriminator(String.valueOf(bVal)));
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/DecimalValue", "<init>", "(Ljava/lang/String;)V", false);
    }

    private static void loadConstFloat(MethodVisitor mv, ComplexSemType s) {
        double doubleVal = (Double)FloatSubtype.floatSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)s, (BasicTypeCode)BasicTypeCode.BT_FLOAT)).orElseThrow();
        mv.visitLdcInsn((Object)doubleVal);
        mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
    }

    private static void loadConstInteger(MethodVisitor mv, ComplexSemType s) {
        long longVal = (Long)IntSubtype.intSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)s, (BasicTypeCode)BasicTypeCode.BT_INT)).orElseThrow();
        if (0L <= longVal && longVal <= 255L) {
            mv.visitLdcInsn((Object)((int)longVal));
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else {
            mv.visitLdcInsn((Object)longVal);
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
        }
    }

    private static void loadConstBoolean(MethodVisitor mv, ComplexSemType s) {
        boolean boolVal = (Boolean)BooleanSubtype.booleanSubtypeSingleValue((SubtypeData)Core.getComplexSubtypeData((ComplexSemType)s, (BasicTypeCode)BasicTypeCode.BT_BOOLEAN)).orElseThrow();
        mv.visitLdcInsn((Object)boolVal);
        mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
    }

    public void getUserDefinedType(MethodVisitor mv, BType bType) {
        String varName = JvmCodeGenUtil.toNameString(bType);
        switch (bType.tag) {
            case 12: {
                mv.visitMethodInsn(184, this.recordTypesPkgName + varName, "get", "()Lio/ballerina/runtime/internal/types/BRecordType;", false);
                break;
            }
            case 34: {
                mv.visitMethodInsn(184, this.objectTypesPkgName + varName, "get", "()Lio/ballerina/runtime/internal/types/BObjectType;", false);
                break;
            }
            case 29: {
                mv.visitMethodInsn(184, this.errorTypesPkgName + varName, "get", "()Lio/ballerina/runtime/internal/types/BErrorType;", false);
                break;
            }
            case 31: {
                mv.visitMethodInsn(184, this.tupleTypesPkgName + varName, "get", "()Lio/ballerina/runtime/internal/types/BTupleType;", false);
                break;
            }
            default: {
                mv.visitMethodInsn(184, this.unionTypesPkgName + varName, "get", "()Lio/ballerina/runtime/internal/types/BUnionType;", false);
            }
        }
    }

    public void getUserDefinedType(MethodVisitor mv, PackageID pkgId, BType bType) {
        String varName = JvmCodeGenUtil.toNameString(bType);
        switch (bType.tag) {
            case 12: {
                mv.visitMethodInsn(184, JvmModuleUtils.getModuleLevelClassName(pkgId, "types/record_types/") + varName, "get", "()Lio/ballerina/runtime/internal/types/BRecordType;", false);
                break;
            }
            case 34: {
                mv.visitMethodInsn(184, JvmModuleUtils.getModuleLevelClassName(pkgId, "types/object_types/") + varName, "get", "()Lio/ballerina/runtime/internal/types/BObjectType;", false);
                break;
            }
            case 29: {
                mv.visitMethodInsn(184, JvmModuleUtils.getModuleLevelClassName(pkgId, "types/error_types/") + varName, "get", "()Lio/ballerina/runtime/internal/types/BErrorType;", false);
                break;
            }
            case 31: {
                mv.visitMethodInsn(184, JvmModuleUtils.getModuleLevelClassName(pkgId, "types/tuple_types/") + varName, "get", "()Lio/ballerina/runtime/internal/types/BTupleType;", false);
                break;
            }
            default: {
                mv.visitMethodInsn(184, JvmModuleUtils.getModuleLevelClassName(pkgId, "types/union_types/") + varName, "get", "()Lio/ballerina/runtime/internal/types/BUnionType;", false);
            }
        }
    }

    public boolean loadReferredType(MethodVisitor mv, BTypeReferenceType referenceType) {
        BType referredType = referenceType.referredType;
        if (referredType == null || Symbols.isFlagOn(referredType.getFlags(), 2048L)) {
            this.loadType(mv, referredType);
            return false;
        }
        if (JvmModuleUtils.isSameModule(referenceType.tsymbol.pkgID, referredType.tsymbol.pkgID) && referenceType.tsymbol.pkgID.isTestPkg == referredType.tsymbol.pkgID.isTestPkg) {
            return this.loadInternalType(mv, referredType);
        }
        return this.loadInternalType(mv, referredType.tsymbol.pkgID, referredType);
    }

    private boolean loadInternalType(MethodVisitor mv, BType bType) {
        String varName = JvmCodeGenUtil.toNameString(bType);
        switch (bType.tag) {
            case 12: {
                mv.visitFieldInsn(178, this.recordTypesPkgName + varName, "t", "Lio/ballerina/runtime/internal/types/BRecordType;");
                break;
            }
            case 34: {
                mv.visitFieldInsn(178, this.objectTypesPkgName + varName, "t", "Lio/ballerina/runtime/internal/types/BObjectType;");
                break;
            }
            case 29: {
                mv.visitFieldInsn(178, this.errorTypesPkgName + varName, "t", "Lio/ballerina/runtime/internal/types/BErrorType;");
                break;
            }
            case 21: {
                BUnionType unionType = (BUnionType)bType;
                if (unionType.isCyclic) {
                    mv.visitFieldInsn(178, this.unionTypesPkgName + varName, "t", "Lio/ballerina/runtime/internal/types/BUnionType;");
                    break;
                }
                this.jvmConstantsGen.generateGetBUnionType(mv, this.jvmConstantsGen.getUnionTypeConstantsVar(bType, this.symbolTable));
                break;
            }
            default: {
                this.loadType(mv, bType);
                return false;
            }
        }
        return true;
    }

    private boolean loadInternalType(MethodVisitor mv, PackageID pkgId, BType bType) {
        String varName = JvmCodeGenUtil.toNameString(bType);
        switch (bType.tag) {
            case 12: {
                mv.visitFieldInsn(178, JvmModuleUtils.getModuleLevelClassName(pkgId, "types/record_types/") + varName, "t", "Lio/ballerina/runtime/internal/types/BRecordType;");
                break;
            }
            case 34: {
                mv.visitFieldInsn(178, JvmModuleUtils.getModuleLevelClassName(pkgId, "types/object_types/") + varName, "t", "Lio/ballerina/runtime/internal/types/BObjectType;");
                break;
            }
            case 29: {
                mv.visitFieldInsn(178, JvmModuleUtils.getModuleLevelClassName(pkgId, "types/error_types/") + varName, "t", "Lio/ballerina/runtime/internal/types/BErrorType;");
                break;
            }
            case 21: {
                BUnionType unionType = (BUnionType)bType;
                if (unionType.isCyclic) {
                    mv.visitFieldInsn(178, JvmModuleUtils.getModuleLevelClassName(pkgId, "types/union_types/") + varName, "t", "Lio/ballerina/runtime/internal/types/BUnionType;");
                    break;
                }
                this.jvmConstantsGen.generateGetBUnionType(mv, this.jvmConstantsGen.getUnionTypeConstantsVar(bType, this.symbolTable));
                break;
            }
            default: {
                this.loadType(mv, bType);
                return false;
            }
        }
        return true;
    }
}

