/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.types.Env;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.desugar.BirDesugar;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.AsyncDataCollector;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.InitMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.MethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JFieldBIRFunction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethodBIRFunction;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.values.JvmObjectGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.values.JvmRecordGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmModuleUtils;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeHashVisitor;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmValueGen {
    private final BIRNode.BIRPackage module;
    private final JvmPackageGen jvmPackageGen;
    private final MethodGen methodGen;
    private final BType booleanType;
    private final JvmObjectGen jvmObjectGen;
    private final JvmRecordGen jvmRecordGen;
    private final TypeHashVisitor typeHashVisitor;
    private final Types types;

    JvmValueGen(BIRNode.BIRPackage module, JvmPackageGen jvmPackageGen, MethodGen methodGen, TypeHashVisitor typeHashVisitor, Types types) {
        this.module = module;
        this.jvmPackageGen = jvmPackageGen;
        this.methodGen = methodGen;
        this.booleanType = jvmPackageGen.symbolTable.booleanType;
        this.jvmRecordGen = new JvmRecordGen(jvmPackageGen.symbolTable);
        this.jvmObjectGen = new JvmObjectGen();
        this.typeHashVisitor = typeHashVisitor;
        this.types = types;
    }

    static void injectDefaultParamInitsToAttachedFuncs(Env env, BIRNode.BIRPackage module, InitMethodGen initMethodGen) {
        List<BIRNode.BIRTypeDefinition> typeDefs = module.typeDefs;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BType bType = JvmCodeGenUtil.getImpliedType(optionalTypeDef.type);
            if ((bType.tag != 34 || !Symbols.isFlagOn(bType.tsymbol.flags, 0x10000000L)) && bType.tag != 12) continue;
            JvmValueGen.desugarObjectMethods(env, optionalTypeDef.attachedFuncs, initMethodGen);
        }
    }

    private static void desugarObjectMethods(Env env, List<BIRNode.BIRFunction> attachedFuncs, InitMethodGen initMethodGen) {
        for (BIRNode.BIRFunction birFunc : attachedFuncs) {
            if (JvmCodeGenUtil.isExternFunc(birFunc)) {
                if (birFunc instanceof JMethodBIRFunction) {
                    JMethodBIRFunction jMethodBIRFunction = (JMethodBIRFunction)birFunc;
                    InteropMethodGen.desugarInteropFuncs(env, jMethodBIRFunction, initMethodGen);
                    initMethodGen.resetIds();
                    continue;
                }
                if (birFunc instanceof JFieldBIRFunction) continue;
                initMethodGen.resetIds();
                continue;
            }
            BirDesugar.addDefaultBooleanVarsToSignature(birFunc);
            initMethodGen.resetIds();
        }
    }

    public static String getTypeDescClassName(String packageName, String typeName) {
        return packageName + "typedescs/$" + typeName;
    }

    public static String getTypeValueClassName(String packageName, String typeName) {
        return packageName + "values/$" + typeName;
    }

    public static String getFieldIsPresentFlagName(String fieldName) {
        return "$" + fieldName + "$isPresent";
    }

    public static boolean isOptionalRecordField(BField field) {
        return (field.symbol.flags & 0x1000L) == 4096L;
    }

    void generateValueClasses(JarEntries jarEntries, JvmConstantsGen jvmConstantsGen, JvmTypeGen jvmTypeGen, AsyncDataCollector asyncDataCollector) {
        String packageName = JvmModuleUtils.getPackageName(this.module.packageID);
        this.module.typeDefs.forEach(optionalTypeDef -> {
            if (optionalTypeDef.type.tag == 14) {
                return;
            }
            BType bType = optionalTypeDef.type;
            String varName = optionalTypeDef.internalName.value;
            String className = JvmValueGen.getTypeValueClassName(packageName, varName);
            String valueClass = "values/$" + optionalTypeDef.internalName.value;
            asyncDataCollector.setCurrentSourceFileName(valueClass);
            asyncDataCollector.setCurrentSourceFileWithoutExt(valueClass);
            if (optionalTypeDef.type.tag == 34 && Symbols.isFlagOn(optionalTypeDef.type.tsymbol.flags, 0x10000000L)) {
                BObjectType objectType = (BObjectType)optionalTypeDef.type;
                this.createObjectValueClasses(objectType, className, (BIRNode.BIRTypeDefinition)optionalTypeDef, jvmConstantsGen, asyncDataCollector, jarEntries);
            } else if (bType.tag == 12) {
                BRecordType recordType = (BRecordType)bType;
                byte[] bytes = this.createRecordValueClass(recordType, className, (BIRNode.BIRTypeDefinition)optionalTypeDef, jvmTypeGen);
                jarEntries.put(className + ".class", bytes);
                String typedescClass = JvmValueGen.getTypeDescClassName(packageName, varName);
                bytes = this.createRecordTypeDescClass((BIRNode.BIRTypeDefinition)optionalTypeDef, recordType, typedescClass, jvmTypeGen);
                jarEntries.put(typedescClass + ".class", bytes);
            }
        });
    }

    private byte[] createRecordTypeDescClass(BIRNode.BIRTypeDefinition typeDef, BRecordType recordType, String className, JvmTypeGen jvmTypeGen) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        if (typeDef.pos != null) {
            cw.visitSource(typeDef.pos.lineRange().fileName(), null);
        }
        cw.visit(65, 33, className, null, "io/ballerina/runtime/internal/values/TypedescValueImpl", new String[]{"io/ballerina/runtime/internal/values/TypedescValue"});
        FieldVisitor fv = cw.visitField(0, "$annotations", "Lio/ballerina/runtime/internal/values/MapValue;", null, null);
        fv.visitEnd();
        this.createTypedescInstance(cw, recordType, className);
        this.createTypeDescConstructor(cw, className);
        this.createTypeDescConstructorWithAnnotations(cw, className);
        this.createInstantiateMethod(cw, recordType, jvmTypeGen, className);
        this.createInstantiateMethodWithInitialValues(cw, recordType, typeDef, className);
        cw.visitEnd();
        return this.jvmPackageGen.getBytes(cw, typeDef);
    }

    private void createTypedescInstance(ClassWriter cw, BRecordType recordType, String className) {
        String recordTypeClass = JvmModuleUtils.getModuleLevelClassName(recordType.tsymbol.pkgID, "types/record_types/") + JvmCodeGenUtil.toNameString(recordType);
        FieldVisitor fv = cw.visitField(9, "v", "Lio/ballerina/runtime/internal/values/TypedescValue;", null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitTypeInsn(187, className);
        mv.visitInsn(89);
        mv.visitMethodInsn(184, recordTypeClass, "get", "()Lio/ballerina/runtime/internal/types/BRecordType;", false);
        mv.visitMethodInsn(183, className, "<init>", "(Lio/ballerina/runtime/api/types/Type;)V", false);
        mv.visitFieldInsn(179, className, "v", "Lio/ballerina/runtime/internal/values/TypedescValue;");
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "<clinit>", className);
        mv.visitEnd();
    }

    private void createInstantiateMethod(ClassWriter cw, BRecordType recordType, JvmTypeGen jvmTypeGen, String className) {
        MethodVisitor mv = cw.visitMethod(1, "instantiate", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        jvmTypeGen.loadType(mv, recordType);
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BType");
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BType", "getZeroValue", "()Ljava/lang/Object;", false);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "instantiate", className);
        mv.visitEnd();
    }

    private void createInstantiateMethodWithInitialValues(ClassWriter cw, BRecordType recordType, BIRNode.BIRTypeDefinition typeDef, String typeClass) {
        MethodVisitor mv = cw.visitMethod(1, "instantiate", "([Lio/ballerina/runtime/api/values/BInitialValueEntry;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        String className = JvmValueGen.getTypeValueClassName(recordType.tsymbol.pkgID, JvmCodeGenUtil.toNameString(recordType));
        mv.visitTypeInsn(187, className);
        mv.visitInsn(89);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, className, "<init>", "(Lio/ballerina/runtime/internal/values/TypedescValue;)V", false);
        List<BIRNode.BIRFunction> attachedFuncs = typeDef.attachedFuncs;
        String valueClassName = !attachedFuncs.isEmpty() ? className : JvmValueGen.getTypeValueClassName(recordType.tsymbol.pkgID, JvmCodeGenUtil.toNameString(recordType));
        mv.visitInsn(89);
        mv.visitTypeInsn(192, valueClassName);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, "[Lio/ballerina/runtime/api/values/BMapInitialValueEntry;");
        mv.visitMethodInsn(182, valueClassName, "populateInitialValues", "([Lio/ballerina/runtime/api/values/BMapInitialValueEntry;)V", false);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "instantiate", typeClass);
        mv.visitEnd();
    }

    public static String getTypeValueClassName(PackageID packageID, String typeName) {
        return JvmValueGen.getTypeValueClassName(JvmModuleUtils.getPackageName(packageID), typeName);
    }

    private byte[] createRecordValueClass(BRecordType recordType, String className, BIRNode.BIRTypeDefinition typeDef, JvmTypeGen jvmTypeGen) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        if (typeDef.pos != null) {
            cw.visitSource(typeDef.pos.lineRange().fileName(), null);
        }
        JvmCastGen jvmCastGen = new JvmCastGen(this.jvmPackageGen.symbolTable, jvmTypeGen, this.types);
        cw.visit(65, 49, className, "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Lio/ballerina/runtime/internal/values/MapValueImpl<TK;TV;>;Lio/ballerina/runtime/internal/values/MapValue<TK;TV;>;", "io/ballerina/runtime/internal/values/MapValueImpl", new String[]{"io/ballerina/runtime/internal/values/MapValue"});
        LinkedHashMap fields = recordType.fields;
        this.createRecordFields(cw, fields);
        this.jvmRecordGen.createAndSplitGetMethod(cw, fields, className, jvmCastGen);
        this.jvmRecordGen.createAndSplitSetMethod(cw, fields, className, jvmCastGen);
        this.jvmRecordGen.createAndSplitEntrySetMethod(cw, fields, className, jvmCastGen);
        this.jvmRecordGen.createAndSplitContainsKeyMethod(cw, fields, className);
        this.jvmRecordGen.createAndSplitGetValuesMethod(cw, fields, className, jvmCastGen);
        this.createGetSizeMethod(cw, fields, className);
        this.createRecordClearMethod(cw, typeDef.name.value);
        this.jvmRecordGen.createAndSplitRemoveMethod(cw, fields, className, jvmCastGen);
        this.jvmRecordGen.createAndSplitGetKeysMethod(cw, fields, className);
        this.createRecordPopulateInitialValuesMethod(cw, className);
        this.createRecordConstructor(cw, "(Lio/ballerina/runtime/internal/values/TypedescValue;)V", className);
        this.createRecordConstructor(cw, "(Lio/ballerina/runtime/api/types/Type;)V", className);
        cw.visitEnd();
        return this.jvmPackageGen.getBytes(cw, typeDef);
    }

    private void createTypeDescConstructor(ClassWriter cw, String className) {
        String descriptor = "(Lio/ballerina/runtime/api/types/Type;)V";
        MethodVisitor mv = cw.visitMethod(1, "<init>", descriptor, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/TypedescValueImpl", "<init>", descriptor, false);
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "<init>", className);
        mv.visitEnd();
    }

    private void createTypeDescConstructorWithAnnotations(ClassWriter cw, String name) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lio/ballerina/runtime/api/types/Type;Lio/ballerina/runtime/internal/values/MapValue;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, name, "$annotations", "Lio/ballerina/runtime/internal/values/MapValue;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/TypedescValueImpl", "<init>", "(Lio/ballerina/runtime/api/types/Type;Lio/ballerina/runtime/internal/values/MapValue;)V", false);
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "<init>", name);
        mv.visitEnd();
    }

    private void createRecordConstructor(ClassWriter cw, String argumentClass, String className) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", argumentClass, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "<init>", argumentClass, false);
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "$init", className);
        mv.visitEnd();
    }

    private void createRecordFields(ClassWriter cw, Map<String, BField> fields) {
        for (BField field : fields.values()) {
            if (field == null) continue;
            String fieldName = field.name.value;
            FieldVisitor fv = cw.visitField(0, fieldName, JvmTypeGen.getTypeDesc(field.type), null, null);
            fv.visitEnd();
            if (!JvmValueGen.isOptionalRecordField(field)) continue;
            fv = cw.visitField(0, JvmValueGen.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType), null, null);
            fv.visitEnd();
        }
    }

    private void createGetSizeMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(1, "size", "()I", null, null);
        mv.visitCode();
        int sizeVarIndex = 1;
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "size", "()I", false);
        mv.visitVarInsn(54, sizeVarIndex);
        int requiredFieldsCount = 0;
        for (BField optionalField : fields.values()) {
            String fieldName = optionalField.name.value;
            if (JvmValueGen.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, JvmValueGen.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
                Label l3 = new Label();
                mv.visitJumpInsn(153, l3);
                mv.visitIincInsn(sizeVarIndex, 1);
                mv.visitLabel(l3);
                continue;
            }
            ++requiredFieldsCount;
        }
        mv.visitIincInsn(sizeVarIndex, requiredFieldsCount);
        mv.visitVarInsn(21, sizeVarIndex);
        mv.visitInsn(172);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "size", className);
        mv.visitEnd();
    }

    private void createRecordPopulateInitialValuesMethod(ClassWriter cw, String className) {
        MethodVisitor mv = cw.visitMethod(1, "populateInitialValues", "([Lio/ballerina/runtime/api/values/BMapInitialValueEntry;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "populateInitialValues", "([Lio/ballerina/runtime/api/values/BMapInitialValueEntry;)V", false);
        mv.visitInsn(177);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "populateInitialValues", className);
        mv.visitEnd();
    }

    private void createObjectValueClasses(BObjectType objectType, String className, BIRNode.BIRTypeDefinition typeDef, JvmConstantsGen jvmConstantsGen, AsyncDataCollector asyncDataCollector, JarEntries jarEntries) {
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        cw.visitSource(typeDef.pos.lineRange().fileName(), null);
        SymbolTable symbolTable = this.jvmPackageGen.symbolTable;
        JvmTypeGen jvmTypeGen = new JvmTypeGen(jvmConstantsGen, this.module.packageID, this.typeHashVisitor, symbolTable);
        JvmCastGen jvmCastGen = new JvmCastGen(symbolTable, jvmTypeGen, this.types);
        cw.visit(65, 33, className, null, "io/ballerina/runtime/internal/values/AbstractObjectValue", new String[]{"io/ballerina/runtime/api/values/BObject"});
        LinkedHashMap fields = objectType.fields;
        this.createObjectFields(cw, fields);
        List<BIRNode.BIRFunction> attachedFuncs = typeDef.attachedFuncs;
        if (attachedFuncs.size() > 100) {
            this.createObjectMethodsWithSplitClasses(cw, attachedFuncs, className, objectType, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector, typeDef, jarEntries);
        } else {
            this.createObjectMethods(cw, attachedFuncs, className, objectType, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector);
        }
        this.createObjectInit(cw, className);
        this.jvmObjectGen.createAndSplitCallMethod(cw, attachedFuncs, className, jvmCastGen);
        this.jvmObjectGen.createAndSplitGetMethod(cw, fields, className, jvmCastGen);
        this.jvmObjectGen.createAndSplitSetMethod(cw, fields, className, jvmCastGen);
        this.jvmObjectGen.createAndSplitSetOnInitializationMethod(cw, fields, className);
        cw.visitEnd();
        jarEntries.put(className + ".class", this.jvmPackageGen.getBytes(cw, typeDef));
    }

    private void createObjectFields(ClassWriter cw, Map<String, BField> fields) {
        for (BField field : fields.values()) {
            if (field == null) continue;
            FieldVisitor fvb = cw.visitField(0, field.name.value, JvmTypeGen.getTypeDesc(field.type), null, null);
            fvb.visitEnd();
        }
        FieldVisitor fv = cw.visitField(1, "$lock", "Ljava/util/concurrent/locks/ReentrantLock;", null, null);
        fv.visitEnd();
    }

    private void createObjectMethods(ClassWriter cw, List<BIRNode.BIRFunction> attachedFuncs, String moduleClassName, BObjectType currentObjectType, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, JvmConstantsGen jvmConstantsGen, AsyncDataCollector asyncDataCollector) {
        for (BIRNode.BIRFunction func : attachedFuncs) {
            this.methodGen.generateMethod(func, cw, this.module, currentObjectType, moduleClassName, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector);
        }
    }

    private void createObjectMethodsWithSplitClasses(ClassWriter cw, List<BIRNode.BIRFunction> attachedFuncs, String moduleClassName, BObjectType currentObjectType, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen, JvmConstantsGen jvmConstantsGen, AsyncDataCollector asyncDataCollector, BIRNode.BIRTypeDefinition typeDef, JarEntries jarEntries) {
        int splitClassNum = 1;
        BallerinaClassWriter splitCW = new BallerinaClassWriter(2);
        splitCW.visitSource(typeDef.pos.lineRange().fileName(), null);
        String splitClassName = moduleClassName + "$split$" + splitClassNum;
        splitCW.visit(65, 33, splitClassName, null, "java/lang/Object", null);
        JvmCodeGenUtil.generateDefaultConstructor(splitCW, "java/lang/Object");
        int methodCountPerSplitClass = 0;
        for (BIRNode.BIRFunction func : attachedFuncs) {
            if (func.name.value.contains("$init$")) {
                this.methodGen.generateMethod(func, cw, this.module, currentObjectType, moduleClassName, jvmTypeGen, jvmCastGen, jvmConstantsGen, asyncDataCollector);
                continue;
            }
            this.methodGen.genJMethodWithBObjectMethodCall(func, cw, this.module, jvmTypeGen, jvmCastGen, jvmConstantsGen, moduleClassName, asyncDataCollector, splitClassName);
            this.methodGen.genJMethodForBFunc(func, splitCW, this.module, jvmTypeGen, jvmCastGen, jvmConstantsGen, moduleClassName, currentObjectType, asyncDataCollector, true);
            if (++methodCountPerSplitClass != 100) continue;
            splitCW.visitEnd();
            byte[] splitBytes = this.jvmPackageGen.getBytes(splitCW, typeDef);
            jarEntries.put(splitClassName + ".class", splitBytes);
            splitCW = new BallerinaClassWriter(2);
            splitCW.visitSource(typeDef.pos.lineRange().fileName(), null);
            splitClassName = moduleClassName + "$split$" + ++splitClassNum;
            splitCW.visit(65, 33, splitClassName, null, "java/lang/Object", null);
            JvmCodeGenUtil.generateDefaultConstructor(splitCW, "java/lang/Object");
            methodCountPerSplitClass = 0;
        }
        if (methodCountPerSplitClass != 0) {
            splitCW.visitEnd();
            byte[] splitBytes = this.jvmPackageGen.getBytes(splitCW, typeDef);
            jarEntries.put(splitClassName + ".class", splitBytes);
        }
    }

    private void createObjectInit(ClassWriter cw, String className) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lio/ballerina/runtime/api/types/Type;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/AbstractObjectValue", "<init>", "(Lio/ballerina/runtime/api/types/Type;)V", false);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, "java/util/concurrent/locks/ReentrantLock");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/concurrent/locks/ReentrantLock", "<init>", "()V", false);
        mv.visitFieldInsn(181, className, "$lock", "Ljava/util/concurrent/locks/ReentrantLock;");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createRecordClearMethod(ClassWriter cw, String className) {
        MethodVisitor mv = cw.visitMethod(1, "clear", "()V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/UnsupportedOperationException");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/UnsupportedOperationException", "<init>", "()V", false);
        mv.visitInsn(191);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "clear", className);
        mv.visitEnd();
    }
}

