/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.desugar;

import io.ballerina.types.Env;
import java.util.ArrayList;
import java.util.List;
import org.wso2.ballerinalang.compiler.bir.codegen.methodgen.InitMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.utils.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.util.Lists;

public final class BirDesugar {
    private BirDesugar() {
    }

    public static void addDefaultBooleanVarsToSignature(BIRNode.BIRFunction func) {
        func.type.paramTypes = BirDesugar.updateParamTypesWithDefaultableBooleanVar(func.type.paramTypes, func.type.restType);
    }

    public static BIRNode.BIRBasicBlock insertAndGetNextBasicBlock(List<BIRNode.BIRBasicBlock> basicBlocks, InitMethodGen initMethodGen) {
        BIRNode.BIRBasicBlock nextbb = new BIRNode.BIRBasicBlock("wrapperGen", BirDesugar.getNextDesugarBBId(initMethodGen));
        basicBlocks.add(nextbb);
        return nextbb;
    }

    public static int getNextDesugarBBId(InitMethodGen initMethodGen) {
        return initMethodGen.incrementAndGetNextId();
    }

    private static List<BType> updateParamTypesWithDefaultableBooleanVar(List<BType> funcParams, BType restType) {
        int counter;
        int size;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        int n = size = funcParams == null ? 0 : funcParams.size();
        for (counter = 0; counter < size; ++counter) {
            paramTypes.add(counter, funcParams.get(counter));
        }
        if (restType != null) {
            paramTypes.add(counter, restType);
        }
        return paramTypes;
    }

    public static void rewriteRecordInits(Env env, List<BIRNode.BIRTypeDefinition> typeDefs) {
        for (BIRNode.BIRTypeDefinition typeDef : typeDefs) {
            BType recordType = JvmCodeGenUtil.getImpliedType(typeDef.type);
            if (recordType.tag != 12) continue;
            List<BIRNode.BIRFunction> attachFuncs = typeDef.attachedFuncs;
            for (BIRNode.BIRFunction func : attachFuncs) {
                BirDesugar.rewriteRecordInitFunction(env, func, (BRecordType)recordType);
            }
        }
    }

    private static void rewriteRecordInitFunction(Env env, BIRNode.BIRFunction func, BRecordType recordType) {
        BIRNode.BIRVariableDcl receiver = func.receiver;
        func.name = new Name(JvmCodeGenUtil.toNameString(recordType) + func.name.value);
        receiver.kind = VarKind.ARG;
        String paramName = "$_" + receiver.name.value;
        receiver.name = new Name(paramName);
        BIRNode.BIRFunctionParameter selfParam = new BIRNode.BIRFunctionParameter(null, receiver.type, receiver.name, receiver.scope, VarKind.ARG, paramName, false, false);
        List<BType> updatedParamTypes = Lists.of(receiver.type);
        updatedParamTypes.addAll(func.type.paramTypes);
        func.type = new BInvokableType(env, updatedParamTypes, func.type.restType, func.type.retType, null);
        List<BIRNode.BIRVariableDcl> localVars = func.localVars;
        ArrayList<BIRNode.BIRVariableDcl> updatedLocalVars = new ArrayList<BIRNode.BIRVariableDcl>();
        updatedLocalVars.add(localVars.getFirst());
        updatedLocalVars.add(selfParam);
        for (int index = 1; index < localVars.size(); ++index) {
            updatedLocalVars.add(localVars.get(index));
        }
        func.localVars = updatedLocalVars;
    }
}

